/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.misc.IllegalEscapeSequenceException;
import com.sun.appserv.management.util.misc.MalformedUnicodeSequenceException;
import com.sun.appserv.management.util.misc.TokenizerException;
import com.sun.appserv.management.util.misc.TokenizerParams;
import com.sun.appserv.management.util.misc.UnterminatedLiteralStringException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;

final class TokenizerInternal {
    final String mInput;
    final TokenizerParams mParams;
    final StringCharacterIterator mIter;
    static final Delim DELIM = Delim.getInstance();
    private static final char QUOTE_CHAR = '\"';
    private static final char TAB_CHAR = '\t';

    TokenizerInternal(String input, TokenizerParams params) {
        this.mInput = input;
        this.mParams = params;
        this.mIter = new StringCharacterIterator(input);
    }

    private static boolean isSpecialEscapeChar(char theChar) {
        return theChar == 'n' || theChar == 'r' || theChar == 't' || theChar == '\"';
    }

    private boolean isCallerProvidedEscapableChar(char theChar) {
        return this.mParams.mEscapableChars.indexOf(theChar) >= 0 || theChar == this.mParams.mEscapeChar;
    }

    private boolean isEscapableChar(char theChar) {
        return this.isCallerProvidedEscapableChar(theChar) || TokenizerInternal.isSpecialEscapeChar(theChar);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDelim(String delims, char theChar) {
        if (delims.indexOf(theChar) >= 0) return true;
        if (theChar != '\uffff') return false;
        return true;
    }

    private static boolean isDigit(char theChar) {
        return theChar >= '0' && theChar <= '9';
    }

    private static boolean isHexDigit(char theChar) {
        return TokenizerInternal.isDigit(theChar) || theChar >= 'a' && theChar <= 'f' || TokenizerInternal.isUpper(theChar);
    }

    private static boolean isUpper(char c) {
        return c >= 'A' && c <= 'F';
    }

    private boolean hasMoreChars() {
        return this.mIter.current() != '\uffff';
    }

    private int getIndex() {
        return this.mIter.getIndex();
    }

    private char setIndex(int index) {
        return this.mIter.setIndex(index);
    }

    private char nextChar() {
        char theChar = this.mIter.current();
        this.mIter.next();
        return theChar;
    }

    private char decodeUnicodeSequence() throws MalformedUnicodeSequenceException {
        int value = 0;
        try {
            for (int i = 0; i < 4; ++i) {
                value = value << 4 | TokenizerInternal.hexValue(this.nextChar());
            }
        }
        catch (Exception e) {
            throw new MalformedUnicodeSequenceException("");
        }
        return (char)value;
    }

    private static int hexValue(char c) {
        if (!TokenizerInternal.isHexDigit(c)) {
            throw new IllegalArgumentException();
        }
        int value = 0;
        value = TokenizerInternal.isDigit(c) ? c - 48 : (TokenizerInternal.isUpper(c) ? c - 65 : c - 97);
        return value;
    }

    private char getEscapedChar(char inputChar) throws MalformedUnicodeSequenceException, IllegalEscapeSequenceException {
        int outChar = '\u0000';
        if (this.isCallerProvidedEscapableChar((char)inputChar)) {
            outChar = inputChar;
        } else {
            switch (inputChar) {
                default: {
                    throw new IllegalEscapeSequenceException("" + (char)inputChar);
                }
                case 110: {
                    outChar = 10;
                    break;
                }
                case 114: {
                    outChar = 13;
                    break;
                }
                case 116: {
                    outChar = 9;
                    break;
                }
                case 34: {
                    outChar = 34;
                    break;
                }
                case 117: {
                    outChar = this.decodeUnicodeSequence();
                }
            }
        }
        return (char)outChar;
    }

    private String processEscapeSequence() {
        String s = null;
        char theChar = this.nextChar();
        int continuePos = this.mIter.getIndex();
        try {
            s = "" + this.getEscapedChar(theChar);
        }
        catch (TokenizerException e) {
            s = this.mParams.mEscapeChar + "" + theChar;
            this.mIter.setIndex(continuePos);
        }
        return s;
    }

    ArrayList parseTokens() throws UnterminatedLiteralStringException, MalformedUnicodeSequenceException, IllegalEscapeSequenceException {
        StringBuffer tok = new StringBuffer();
        ArrayList<Object> tokens = new ArrayList<Object>();
        boolean insideStringLiteral = false;
        while (this.hasMoreChars()) {
            char theChar = this.nextChar();
            if (theChar == this.mParams.mEscapeChar) {
                if (this.mParams.mEmitInvalidEscapeSequencesLiterally) {
                    tok.append(this.processEscapeSequence());
                    continue;
                }
                tok.append(this.getEscapedChar(this.nextChar()));
                continue;
            }
            if (theChar == '\"') {
                if (insideStringLiteral && tok.length() == 0 && tokens.size() == 0) {
                    tokens.add("");
                }
                insideStringLiteral = !insideStringLiteral;
                continue;
            }
            if (insideStringLiteral) {
                tok.append(theChar);
                continue;
            }
            if (this.isDelim(this.mParams.mDelimiters, theChar)) {
                if (tok.length() != 0) {
                    tokens.add(tok.toString());
                    tok.setLength(0);
                }
                tokens.add(DELIM);
                continue;
            }
            tok.append(theChar);
        }
        if (tok.length() != 0) {
            tokens.add(tok.toString());
        }
        if (insideStringLiteral) {
            throw new UnterminatedLiteralStringException(tok.toString());
        }
        return tokens;
    }

    private static final class Delim {
        private Delim() {
        }

        public static Delim getInstance() {
            return new Delim();
        }

        public String toString() {
            return "<DELIM>";
        }
    }
}

