/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.misc.StringEscaper;
import com.sun.appserv.management.util.stringifier.ArrayStringifier;
import java.util.ArrayList;
import java.util.Iterator;

public class StringifiedList {
    final ArrayList mItems;
    final char mDelim;
    public static final char DEFAULT_DELIM = ',';

    public StringifiedList(String listString) {
        this(listString, ',');
    }

    public StringifiedList(String[] items, char delim) {
        this.mDelim = delim;
        this.mItems = new ArrayList();
        for (int i = 0; i < items.length; ++i) {
            this.append(items[i]);
        }
    }

    public StringifiedList(String listString, char delim) {
        this.mDelim = delim;
        this.mItems = new ArrayList();
        if (listString != null) {
            StringEscaper escaper = new StringEscaper("" + this.mDelim);
            String[] list = listString.trim().split("" + delim);
            for (int i = 0; i < list.length; ++i) {
                this.mItems.add(escaper.unescape(list[i]));
            }
        }
    }

    public String toString() {
        StringEscaper escaper = new StringEscaper("" + this.mDelim);
        Object[] items = this.toArray();
        for (int i = 0; i < items.length; ++i) {
            items[i] = escaper.escape(items[i]);
        }
        return ArrayStringifier.stringify(items, "" + this.mDelim);
    }

    public String[] toArray() {
        return this.mItems.toArray(new String[this.mItems.size()]);
    }

    public boolean exists(String name) {
        return this.mItems.contains(name);
    }

    public Iterator iterator() {
        return this.mItems.iterator();
    }

    public void prepend(String item) {
        this.mItems.add(0, item);
    }

    public void append(String item) {
        this.mItems.add(item);
    }

    public void remove(String item) {
        if (this.exists(item)) {
            this.mItems.remove(item);
        }
    }
}

