/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.stringifier.ArrayStringifier;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static String toString(Collection c, String delim) {
        return ArrayStringifier.stringify(c.toArray(), delim);
    }

    public static Object getSingleton(Collection s) {
        if (s.size() != 1) {
            throw new IllegalArgumentException(s.toString());
        }
        return s.iterator().next();
    }

    public static void addArray(Collection c, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            c.add(array[i]);
        }
    }

    public static String[] toStringArray(Collection c) {
        String[] strings = new String[c.size()];
        Iterator iter = c.iterator();
        int i = 0;
        while (iter.hasNext()) {
            strings[i] = iter.next().toString();
            ++i;
        }
        return strings;
    }

    public static Object[] toArray(Collection c, Class elementClass) {
        Object[] items = (Object[])Array.newInstance(elementClass, c.size());
        c.toArray(items);
        return items;
    }

    public static Object[] toArray(Collection set) {
        Object[] names = new Object[set.size()];
        set.toArray(names);
        return names;
    }
}

