/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx;

import com.sun.appserv.management.util.misc.ArrayConversion;
import com.sun.appserv.management.util.misc.IteratorUtil;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidOpenTypeException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;

public final class OpenMBeanUtil {
    private static Map SIMPLETYPES_MAP = null;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final OpenType[] EMPTY_OPENTYPES = new OpenType[0];

    private OpenMBeanUtil() {
    }

    private static Map getSimpleTypesMap() {
        if (SIMPLETYPES_MAP == null) {
            HashMap<Class, SimpleType<Object>> m = new HashMap<Class, SimpleType<Object>>();
            m.put(Byte.class, SimpleType.BYTE);
            m.put(Short.class, SimpleType.SHORT);
            m.put(Integer.class, SimpleType.INTEGER);
            m.put(Long.class, SimpleType.LONG);
            m.put(BigInteger.class, SimpleType.BIGINTEGER);
            m.put(BigDecimal.class, SimpleType.BIGDECIMAL);
            m.put(Float.class, SimpleType.FLOAT);
            m.put(Character.class, SimpleType.CHARACTER);
            m.put(Boolean.class, SimpleType.BOOLEAN);
            m.put(String.class, SimpleType.STRING);
            m.put(Date.class, SimpleType.DATE);
            m.put(Void.class, SimpleType.VOID);
            m.put(ObjectName.class, SimpleType.OBJECTNAME);
            SIMPLETYPES_MAP = m;
        }
        return SIMPLETYPES_MAP;
    }

    public static SimpleType getSimpleType(Class c) {
        SimpleType type = (SimpleType)OpenMBeanUtil.getSimpleTypesMap().get(c);
        return type;
    }

    private static Object getAnyArrayElement(Object o) {
        Object result = null;
        int length = Array.getLength(o);
        if (length != 0) {
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(o, 0);
                if (element == null) continue;
                if (element.getClass().isArray()) {
                    result = OpenMBeanUtil.getAnyArrayElement(element);
                    if (result == null) continue;
                    break;
                }
                result = element;
                break;
            }
        }
        return result;
    }

    private static int getArrayDimensions(Class theClass) {
        String classname = theClass.getName();
        int dim = 0;
        while (classname.charAt(dim) == '[') {
            ++dim;
        }
        return dim;
    }

    public static OpenType getOpenType(Object o) throws InvalidOpenTypeException, OpenDataException {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        OpenType type = OpenMBeanUtil.getSimpleType(o.getClass());
        if (type == null) {
            Class<?> theClass = o.getClass();
            if (theClass.isArray()) {
                int length = Array.getLength(o);
                int dimensions = OpenMBeanUtil.getArrayDimensions(theClass);
                Class<?> elementClass = theClass.getComponentType();
                SimpleType simpleType = OpenMBeanUtil.getSimpleType(elementClass);
                if (simpleType != null) {
                    type = new ArrayType(dimensions, simpleType);
                } else {
                    Object element = OpenMBeanUtil.getAnyArrayElement(o);
                    if (CompositeData.class.isAssignableFrom(elementClass)) {
                        type = element == null ? SimpleType.VOID : new ArrayType(dimensions, ((CompositeData)element).getCompositeType());
                    } else if (TabularData.class.isAssignableFrom(elementClass)) {
                        type = element == null ? SimpleType.VOID : new ArrayType(dimensions, ((TabularData)element).getTabularType());
                    }
                }
            } else if (o instanceof CompositeData) {
                type = ((CompositeData)o).getCompositeType();
            } else if (o instanceof TabularData) {
                type = ((TabularData)o).getTabularType();
            }
        }
        if (type == null) {
            throw new IllegalArgumentException(o.getClass().getName());
        }
        return type;
    }

    public static Map convertTypes(Map orig) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator iter = orig.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = orig.get(key);
            if (value instanceof Collection) {
                Object[] newValue = IteratorUtil.toArray(((Collection)value).iterator());
                newValue = ArrayConversion.specializeArray(newValue);
                result.put(key, newValue);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    public static CompositeType mapToCompositeType(String typeName, String description, Map map) throws OpenDataException {
        String[] itemNames = new String[map.keySet().size()];
        map.keySet().toArray(itemNames);
        String[] itemDescriptions = new String[itemNames.length];
        OpenType[] itemTypes = new OpenType[itemNames.length];
        for (int i = 0; i < itemNames.length; ++i) {
            Object value = map.get(itemNames[i]);
            itemDescriptions[i] = "value " + itemNames[i];
            itemTypes[i] = value == null ? OpenMBeanUtil.getOpenType("") : OpenMBeanUtil.getOpenType(value);
        }
        CompositeType type = new CompositeType(typeName, description, itemNames, itemDescriptions, itemTypes);
        return type;
    }

    public static CompositeData mapToCompositeData(String typeName, String description, Map map) throws OpenDataException {
        CompositeType type = OpenMBeanUtil.mapToCompositeType(typeName, description, map);
        return new CompositeDataSupport(type, map);
    }

    public static Map compositeDataToMap(CompositeData data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CompositeType type = data.getCompositeType();
        Iterator<String> iter = type.keySet().iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            map.put(name, data.get(name));
        }
        return map;
    }

    public static OpenType getStackTraceElementOpenType() throws OpenDataException {
        String[] itemNames = new String[]{"ClassName", "FileName", "LineNumber", "IsNativeMethod"};
        String[] descriptions = new String[]{"ClassName", "FileName", "LineNumber", "IsNativeMethod"};
        OpenType[] openTypes = new OpenType[itemNames.length];
        openTypes[0] = SimpleType.STRING;
        openTypes[1] = SimpleType.STRING;
        openTypes[2] = SimpleType.INTEGER;
        openTypes[3] = SimpleType.BOOLEAN;
        return new CompositeType(StackTraceElement.class.getName(), "StackTraceElement composite type", itemNames, descriptions, openTypes);
    }

    public static OpenType getThrowableOpenType(Throwable t) throws OpenDataException {
        String[] itemNames = new String[]{"Message", "Cause", "StackTrace"};
        String[] descriptions = new String[]{"The message from the Throwable", "The cause (if any) from the Throwable", "The stack trace from the Throwable"};
        OpenType[] openTypes = new OpenType[itemNames.length];
        openTypes[0] = SimpleType.STRING;
        openTypes[1] = t.getCause() == null ? SimpleType.VOID : OpenMBeanUtil.getThrowableOpenType(t.getCause());
        openTypes[2] = new ArrayType(t.getStackTrace().length, OpenMBeanUtil.getStackTraceElementOpenType());
        return new CompositeType(t.getClass().getName(), "Throwable composite type", itemNames, descriptions, openTypes);
    }
}

