/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.client;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.AMXClientLogger;
import com.sun.appserv.management.client.AMXProxyHandler;
import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.ProxyCache;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.MBeanServerConnectionConnectionSource;
import com.sun.appserv.management.util.jmx.MBeanServerConnectionSource;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.relation.MBeanServerNotificationFilter;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;

public final class ProxyFactory
implements NotificationListener {
    private final ProxyCache mProxyCache;
    private final ConnectionSource mConnectionSource;
    private final ObjectName mDomainRootObjectName;
    private final DomainRoot mDomainRoot;
    private final String mMBeanServerID;
    private static final Map INSTANCES;
    private static final String DOMAIN_ROOT_KEY = "DomainRoot";
    static final /* synthetic */ boolean $assertionsDisabled;

    private ProxyFactory(ConnectionSource connSource) {
        if (!$assertionsDisabled && connSource == null) {
            throw new AssertionError();
        }
        this.mConnectionSource = connSource;
        this.mProxyCache = new ProxyCache();
        try {
            MBeanServerConnection conn = this.getConnection();
            this.mMBeanServerID = JMXUtil.getMBeanServerID(conn);
            this.mDomainRootObjectName = this.initDomainRootObjectName();
            this.mDomainRoot = this.initDomainRoot();
            try {
                MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
                filter.enableAllObjectNames();
                filter.disableAllTypes();
                filter.enableType("JMX.mbean.unregistered");
                JMXUtil.listenToMBeanServerDelegate(conn, this, filter, null);
            }
            catch (Exception e) {
                ProxyFactory.getLogger().fine("ProxyFactory: connection does not support notifications: " + connSource.toString());
            }
            JMXConnector connector = connSource.getJMXConnector(false);
            if (connector != null) {
                try {
                    connector.addConnectionNotificationListener(this, null, null);
                }
                catch (Exception e) {
                    ProxyFactory.getLogger().fine("ProxyFactory: connector does not support addConnectionNotificationListener: " + connSource);
                }
            }
        }
        catch (Exception e) {
            ProxyFactory.getLogger().throwing(this.getClass().getName(), "ProxyFactory", e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionBad() {
        ProxyCache proxyCache = this.mProxyCache;
        synchronized (proxyCache) {
            Iterator iter = this.mProxyCache.keySet().iterator();
            while (iter.hasNext()) {
                ObjectName key = (ObjectName)iter.next();
                AMX proxy = this.mProxyCache.getCachedProxy(key);
                this.mProxyCache.remove(proxy);
                ((AMXProxyHandler)Proxy.getInvocationHandler(proxy)).connectionBad();
            }
        }
    }

    boolean checkConnection() {
        boolean connectionGood = true;
        try {
            this.getConnection().isRegistered(JMXUtil.getMBeanServerDelegateObjectName());
            connectionGood = true;
        }
        catch (Exception e) {
            this.connectionBad();
        }
        return connectionGood;
    }

    void notifsLost() {
    }

    public void handleNotification(Notification notifIn, Object handback) {
        String type = notifIn.getType();
        if (type.equals("JMX.mbean.unregistered")) {
            MBeanServerNotification notif = (MBeanServerNotification)notifIn;
            ObjectName objectName = notif.getMBeanName();
            AMX proxy = this.getProxy(objectName, false);
            this.mProxyCache.removeProxy(objectName);
            ((AMXProxyHandler)Proxy.getInvocationHandler(proxy)).targetUnregistered();
            ProxyFactory.getLogger().fine("ProxyFactory.handleNotification: UNREGISTERED: " + objectName);
        } else if (notifIn instanceof JMXConnectionNotification) {
            if (type.equals("jmx.remote.connection.closed") || type.equals("jmx.remote.connection.failed")) {
                this.connectionBad();
            } else if (type.equals("jmx.remote.connection.notifs.lost")) {
                this.notifsLost();
            }
        } else {
            ProxyFactory.getLogger().fine("ProxyFactory.handleNotification: UNKNOWN notif: " + type);
        }
    }

    private static Logger getLogger() {
        return AMXClientLogger.getInstance();
    }

    private ObjectName initDomainRootObjectName() throws IOException {
        MBeanServerConnection conn = this.mConnectionSource.getMBeanServerConnection(false);
        String patternString = "*:j2eeType=X-DomainRoot,*";
        ObjectName pattern = null;
        try {
            pattern = new ObjectName("*:j2eeType=X-DomainRoot,*");
        }
        catch (MalformedObjectNameException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new RuntimeException(e);
        }
        Set<ObjectName> objectNames = conn.queryNames(pattern, null);
        if (objectNames.size() != 1) {
            throw new IllegalArgumentException(conn.getDefaultDomain());
        }
        ObjectName objectName = (ObjectName)SetUtil.getSingleton(objectNames);
        return objectName;
    }

    public DomainRoot createDomainRoot() throws IOException {
        return this.mDomainRoot;
    }

    public DomainRoot initDomainRoot() throws IOException {
        ObjectName domainRootObjectName = this.getDomainRootObjectName();
        DomainRoot domainRoot = (DomainRoot)this.newProxyInstance(domainRootObjectName, new Class[]{DomainRoot.class});
        return domainRoot;
    }

    public DomainRoot getDomainRoot() {
        return this.mDomainRoot;
    }

    public ConnectionSource getConnectionSource() {
        return this.mConnectionSource;
    }

    public String getMBeanServerID() {
        return this.mMBeanServerID;
    }

    public ObjectName getDomainRootObjectName() throws IOException {
        return this.mDomainRootObjectName;
    }

    public static ProxyFactory getInstance(MBeanServer server) {
        return ProxyFactory.getInstance(new MBeanServerConnectionSource(server), true);
    }

    public static ProxyFactory getInstance(MBeanServerConnection conn) {
        return ProxyFactory.getInstance(new MBeanServerConnectionConnectionSource(conn), true);
    }

    public static ProxyFactory getInstance(ConnectionSource conn) {
        return ProxyFactory.getInstance(conn, true);
    }

    public static synchronized ProxyFactory getInstance(ConnectionSource connSource, boolean useMBeanServerID) {
        ProxyFactory instance = ProxyFactory.findInstance(connSource);
        if (instance == null) {
            try {
                MBeanServerConnection conn = connSource.getMBeanServerConnection(false);
                instance = ProxyFactory.findInstance(conn);
                if (instance == null && (useMBeanServerID || connSource instanceof MBeanServerConnectionSource)) {
                    String id = JMXUtil.getMBeanServerID(conn);
                    instance = ProxyFactory.findInstanceByID(id);
                }
                if (instance == null) {
                    instance = new ProxyFactory(connSource);
                    INSTANCES.put(conn, instance);
                    ProxyFactory.getLogger().fine("\n----------------\nProxyFactory.getInstance: created new factory for: " + instance.getMBeanServerID() + "\n----------------\n");
                }
            }
            catch (Exception e) {
                ProxyFactory.getLogger().severe("ProxyFactory.getInstance: Failure trying to create a new ProxyFactory: " + e.toString());
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    public static synchronized ProxyFactory findInstance(ConnectionSource conn) {
        return (ProxyFactory)INSTANCES.get(conn);
    }

    public static synchronized ProxyFactory findInstance(MBeanServerConnection conn) {
        ProxyFactory instance = null;
        Collection values = INSTANCES.values();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            ProxyFactory factory = (ProxyFactory)iter.next();
            if (factory.getConnectionSource().getExistingMBeanServerConnection() != conn) continue;
            instance = factory;
            break;
        }
        return instance;
    }

    public static synchronized ProxyFactory findInstanceByID(String mbeanServerID) {
        ProxyFactory instance = null;
        Collection values = INSTANCES.values();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            ProxyFactory factory = (ProxyFactory)iter.next();
            if (!factory.getMBeanServerID().equals(mbeanServerID)) continue;
            instance = factory;
            break;
        }
        return instance;
    }

    public synchronized AMX getProxy(ObjectName objectName) {
        AMX proxy = this.mProxyCache.getCachedProxy(objectName);
        if (proxy == null) {
            proxy = this.createProxy(objectName);
        }
        return proxy;
    }

    public synchronized AMX getProxy(ObjectName objectName, boolean create) {
        AMX proxy = this.mProxyCache.getCachedProxy(objectName);
        if (proxy == null && create) {
            proxy = this.createProxy(objectName);
        }
        return proxy;
    }

    protected MBeanServerConnection getConnection() throws IOException {
        return this.getConnectionSource().getMBeanServerConnection(false);
    }

    private AMX createProxy(ObjectName objectName) {
        AMX proxy = null;
        try {
            String proxyInterfaceName = null;
            Class proxyInterface = null;
            proxyInterfaceName = (String)this.getConnection().getAttribute(objectName, "InterfaceName");
            proxyInterface = ClassUtil.getClassFromName(proxyInterfaceName);
            proxy = (AMX)this.newProxyInstance(objectName, new Class[]{proxyInterface});
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return proxy;
    }

    public Object newProxyInstance(ObjectName objectName, Class[] interfaceClasses) throws IOException {
        AMXProxyHandler handler = new AMXProxyHandler(this.mConnectionSource, objectName);
        ClassLoader classLoader = interfaceClasses[0].getClassLoader();
        AMX proxy = (AMX)Proxy.newProxyInstance(classLoader, interfaceClasses, (InvocationHandler)handler);
        if (proxy != null) {
            this.mProxyCache.cacheProxy(proxy);
        }
        return proxy;
    }

    protected static String toString(Object o) {
        return SmartStringifier.toString(o);
    }

    public Set toProxySet(Set objectNames) {
        HashSet<AMX> s = new HashSet<AMX>();
        Iterator iter = objectNames.iterator();
        while (iter.hasNext()) {
            ObjectName next = (ObjectName)iter.next();
            try {
                AMX proxy = this.getProxy(next);
                s.add(proxy);
            }
            catch (Exception e) {}
        }
        return s;
    }

    public Map toProxyMap(Map objectNameMap) {
        Iterator iter = objectNameMap.keySet().iterator();
        HashMap resultMap = new HashMap();
        while (iter.hasNext()) {
            Object key = iter.next();
            ObjectName objectName = (ObjectName)objectNameMap.get(key);
            try {
                AMX proxy = this.getProxy(objectName);
                resultMap.put(key, proxy);
            }
            catch (Exception e) {}
        }
        return resultMap;
    }

    static {
        $assertionsDisabled = !ProxyFactory.class.desiredAssertionStatus();
        INSTANCES = Collections.synchronizedMap(new HashMap());
    }
}

