/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.base;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Extra;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

public final class Util {
    private static final Set PATTERN_PROPS;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Util() {
    }

    public static ObjectName newObjectName(String name) {
        return JMXUtil.newObjectName(name);
    }

    public static ObjectName newObjectName(String domain, String props) {
        return Util.newObjectName(domain + ":" + props);
    }

    public static ObjectName newObjectNamePattern(String domain, String props) {
        return JMXUtil.newObjectNamePattern(domain, props);
    }

    public static ObjectName newObjectNamePattern(ObjectName objectName) {
        String props = objectName.getKeyPropertyListString();
        return Util.newObjectNamePattern(objectName.getDomain(), props);
    }

    public static String makeProp(String name, String value) {
        return JMXUtil.makeProp(name, value);
    }

    public static String makeJ2EETypeProp(String value) {
        return Util.makeProp("j2eeType", value);
    }

    public static String makeNameProp(String value) {
        return Util.makeProp("name", value);
    }

    public static String makeRequiredProps(String j2eeType, String name) {
        String j2eeTypeProp = Util.makeJ2EETypeProp(j2eeType);
        String nameProp = Util.makeNameProp(name);
        String props = Util.concatenateProps(j2eeTypeProp, nameProp);
        return props;
    }

    public static String getSelfProp(ObjectName objectName) {
        String j2eeType = objectName.getKeyProperty("j2eeType");
        String name = objectName.getKeyProperty("name");
        return Util.makeProp(j2eeType, name);
    }

    public static String getFullTypeProps(ObjectName objectName, String fullType) {
        String selfProp = Util.getSelfProp(objectName);
        String ancestorProps = "";
        String[] types = Util.getTypeArray(fullType);
        for (int i = 0; i < types.length - 1; ++i) {
            String key = types[i];
            String value = objectName.getKeyProperty(key);
            String prop = Util.makeProp(key, value);
            ancestorProps = Util.concatenateProps(ancestorProps, prop);
        }
        String props = Util.concatenateProps(selfProp, ancestorProps);
        return props;
    }

    public static String getName(ObjectName objectName) {
        String name = objectName.getKeyProperty("name");
        if (name == null) {
            name = "na";
        }
        return name;
    }

    public static String getJ2EEType(ObjectName objectName) {
        return objectName.getKeyProperty("j2eeType");
    }

    public static String[] getTypeArray(String fullType) {
        if (fullType == null) {
            throw new IllegalArgumentException();
        }
        if (!$assertionsDisabled && !".".equals(".")) {
            throw new AssertionError();
        }
        return fullType.split("\\.");
    }

    public static Set getPatternKeys(String fullType) {
        Set requiredKeys = SetUtil.newSet(PATTERN_PROPS);
        String[] types = Util.getTypeArray(fullType);
        for (int i = 0; i < types.length - 1; ++i) {
            requiredKeys.add(types[i]);
        }
        return requiredKeys;
    }

    public static String concatenateProps(String props1, String props2) {
        return JMXUtil.concatenateProps(props1, props2);
    }

    public static String concatenateProps(String props1, String props2, String props3) {
        return Util.concatenateProps(Util.concatenateProps(props1, props2), props3);
    }

    public static Set toObjectNames(Set amxs) {
        HashSet<ObjectName> s = new HashSet<ObjectName>();
        Iterator iter = amxs.iterator();
        while (iter.hasNext()) {
            AMX next = (AMX)iter.next();
            s.add(Util.getExtra(next).getObjectName());
        }
        return s;
    }

    public static Map toObjectNames(Map amxMap) {
        HashMap m = new HashMap();
        Iterator iter = amxMap.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            AMX value = (AMX)amxMap.get(key);
            m.put(key, Util.getExtra(value).getObjectName());
        }
        return m;
    }

    public static ObjectName[] toObjectNames(AMX[] amx) {
        ObjectName[] objectNames = new ObjectName[amx.length];
        for (int i = 0; i < objectNames.length; ++i) {
            objectNames[i] = amx[i] == null ? null : Util.getExtra(amx[i]).getObjectName();
        }
        return objectNames;
    }

    public static Set getNamesSet(Set objectNames) {
        return JMXUtil.getKeyPropertySet("name", objectNames);
    }

    public static String[] getNamesArray(Set objectNames) {
        return JMXUtil.getKeyProperty("name", objectNames);
    }

    public static final Map createObjectNameMap(Set objectNames) {
        HashMap<String, ObjectName> m = new HashMap<String, ObjectName>();
        Iterator iter = objectNames.iterator();
        while (iter.hasNext()) {
            ObjectName objectName = (ObjectName)iter.next();
            String name = Util.getName(objectName);
            if (!$assertionsDisabled && m.containsKey(name)) {
                throw new AssertionError((Object)("createObjectNameMap: key already present: " + name + " in " + objectName));
            }
            m.put(name, objectName);
        }
        if (!$assertionsDisabled && m.keySet().size() != objectNames.size()) {
            throw new AssertionError();
        }
        return m;
    }

    public static final Map createNameMap(Set amxs) {
        HashMap<String, AMX> m = new HashMap<String, AMX>();
        Iterator iter = amxs.iterator();
        while (iter.hasNext()) {
            AMX amx = (AMX)iter.next();
            String name = amx.getName();
            m.put(name, amx);
        }
        return m;
    }

    public static Extra getExtra(AMX proxy) {
        return (Extra)((Object)Proxy.getInvocationHandler(proxy));
    }

    public static ObjectName getObjectName(AMX proxy) {
        return Util.getExtra(proxy).getObjectName();
    }

    public static ObjectName getObjectName(Map candidates, String name) {
        ObjectName item = (ObjectName)candidates.get(name);
        if (item == null) {
            throw new IllegalArgumentException("Not found: " + name);
        }
        ObjectName objectName = null;
        if (item instanceof ObjectName) {
            objectName = item;
        } else if (item instanceof AMX) {
            objectName = Util.getObjectName((AMX)((Object)item));
        } else {
            throw new IllegalArgumentException();
        }
        return objectName;
    }

    static {
        $assertionsDisabled = !Util.class.desiredAssertionStatus();
        PATTERN_PROPS = Collections.unmodifiableSet(SetUtil.newSet(new String[]{"j2eeType", "name"}));
    }
}

