/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wsi.scm.util;

import com.sun.wsi.scm.configuration.ConfigurationEndpointRole;
import com.sun.wsi.scm.configuration.ConfigurationEndpointType;
import com.sun.wsi.scm.configuration.ConfigurationFaultType;
import com.sun.wsi.scm.configuration.ConfigurationType;
import java.util.Hashtable;

public class ConfigurationValidator {
    public static Hashtable validateHeader(ConfigurationType configurationHeader) throws ConfigurationFaultType {
        if (configurationHeader.getUserId().equals("")) {
            throw new ConfigurationFaultType(Boolean.FALSE, "Invalid UserId", new ConfigurationEndpointRole[0]);
        }
        ConfigurationEndpointType[] serviceUrl = configurationHeader.getServiceUrl();
        if (serviceUrl == null) {
            throw new ConfigurationFaultType(Boolean.FALSE, "Invalid serviceUrl", new ConfigurationEndpointRole[0]);
        }
        if (serviceUrl.length != 8) {
            throw new ConfigurationFaultType(Boolean.FALSE, serviceUrl.length + " entries found in configuration header, expected \"8\"", new ConfigurationEndpointRole[0]);
        }
        Hashtable<ConfigurationEndpointRole, String> roles = new Hashtable<ConfigurationEndpointRole, String>();
        for (int i = 0; i < serviceUrl.length; ++i) {
            if (serviceUrl[i].getRole() == null) {
                throw new ConfigurationFaultType(Boolean.FALSE, "Null role not permitted", new ConfigurationEndpointRole[0]);
            }
            if (serviceUrl[i].get_value() == null) {
                ConfigurationEndpointRole[] role = new ConfigurationEndpointRole[]{serviceUrl[i].getRole()};
                throw new ConfigurationFaultType(Boolean.FALSE, "Null URIs not permitted", role);
            }
            roles.put(serviceUrl[i].getRole(), serviceUrl[i].get_value().toString());
        }
        return roles;
    }
}

