/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wsi.scm.configurator;

import com.sun.wsi.scm.configurator.ConfigOptionType;
import com.sun.wsi.scm.configurator.ConfigOptionsType;
import com.sun.wsi.scm.configurator.ConfiguratorFailedFault;
import com.sun.wsi.scm.configurator.ConfiguratorPortType;
import com.sun.wsi.scm.configurator.ConfiguratorService_Impl;
import com.sun.wsi.scm.util.HTMLReporter;
import com.sun.wsi.scm.util.JAXRConstants;
import com.sun.wsi.scm.util.WSIConstants;
import com.sun.wsi.scm.util.XMLWriter;
import com.sun.xml.rpc.client.ClientTransportFactory;
import com.sun.xml.rpc.client.StubBase;
import com.sun.xml.rpc.client.http.HttpClientTransportFactory;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.rpc.Stub;

public class WSIQuery
implements JAXRConstants,
WSIConstants {
    private static ConfigOptionsType configOptions = null;
    private static Logger logger = null;
    private Properties props = null;

    public WSIQuery(Properties props, boolean logResults) {
        this.props = props;
        logger = Logger.getLogger("com.sun.wsi.scm", "com.sun.wsi.scm.resources.resources_en");
        logger.log(Level.CONFIG, logResults ? "config.results.logging.on" : "config.results.logging.off");
        try {
            this.query(logResults);
        }
        catch (ConfiguratorFailedFault ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public static void main(String[] args) {
        try {
            Properties props = System.getProperties();
            boolean logResults = false;
            logResults = props.getProperty("log.home") != null && props.getProperty("log.file") != null;
            new WSIQuery(props, logResults);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ConfigOptionsType getConfigurationOptions() {
        return configOptions;
    }

    public void query(boolean logResults) throws ConfiguratorFailedFault, RemoteException, IOException {
        logger.log(Level.INFO, "config.query.all");
        ConfiguratorPortType port = new ConfiguratorService_Impl().getConfiguratorPort();
        String endpoint = this.props.getProperty("endpoint");
        if (endpoint == null) {
            logger.log(Level.WARNING, "config.endpoint.notSepcified", "http://localhost:8080/wsi-server/scm/configurator");
            endpoint = "http://localhost:8080/wsi-server/scm/configurator";
        }
        logger.log(Level.INFO, "config.endpoint", endpoint);
        ((Stub)port)._setProperty("javax.xml.rpc.service.endpoint.address", (Object)endpoint);
        if (logger.isLoggable(Level.FINE) & logResults) {
            FileOutputStream soapLog = new FileOutputStream(System.getProperty("log.home") + System.getProperty("file.separator") + System.getProperty("configurator.soap.msgs.file"), true);
            ((StubBase)port)._setTransportFactory((ClientTransportFactory)new HttpClientTransportFactory((OutputStream)soapLog));
        }
        boolean refresh = true;
        if (this.props.getProperty("refresh") != null) {
            refresh = this.props.getProperty("refresh").equals("true");
        }
        logger.log(Level.INFO, refresh ? "config.query.public.registry" : "config.query.cache");
        configOptions = port.getConfigurationOptions(refresh);
        if (logResults) {
            this.logQueryResults(configOptions);
        }
    }

    private void logQueryResults(ConfigOptionsType configOptions) throws IOException {
        logger.log(Level.CONFIG, "config.uddi.service.results");
        if (configOptions == null || configOptions.getConfigOption() == null) {
            logger.log(Level.WARNING, "config.uddi.service.notFound");
            return;
        }
        PrintStream xmlLog = new PrintStream(new FileOutputStream(System.getProperty("log.home") + System.getProperty("file.separator") + System.getProperty("log.file")));
        XMLWriter.setOutputStream(xmlLog);
        XMLWriter.writeStartTag("query");
        HTMLReporter htmlReporter = HTMLReporter.getInstance();
        htmlReporter.logEnvironment();
        ConfigOptionType[] configOption = configOptions.getConfigOption();
        logger.log(Level.INFO, "config.uddi.service.found", String.valueOf(configOption.length));
        for (int i = 0; i < configOption.length; ++i) {
            logger.log(Level.CONFIG, "config.uddi.service.info", new String[]{configOption[i].getName(), configOption[i].getConfigurationEndpoint().get_value().toString()});
            logger.log(Level.FINE, "config.uddi.service.params", configOption[i].getSelectionParms());
            logger.log(Level.FINE, "config.uddi.service.role", configOption[i].getConfigurationEndpoint().getRole().getValue());
            XMLWriter.writeStartTag("service");
            XMLWriter.writeContent("name", configOption[i].getName());
            XMLWriter.writeContent("endpoint", configOption[i].getConfigurationEndpoint().get_value().toString());
            XMLWriter.writeContent("role", configOption[i].getConfigurationEndpoint().getRole().getValue());
            XMLWriter.writeContent("params", configOption[i].getSelectionParms());
            XMLWriter.writeEndTag("service");
        }
        XMLWriter.writeEndTag("query");
        htmlReporter.prepareHTMLReport();
        logger.log(Level.INFO, "config.uddi.service.success", new String[]{String.valueOf(configOption.length), System.getProperty("log.home"), System.getProperty("file.separator"), System.getProperty("log.file")});
    }
}

