/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wsi.scm.catalog;

import com.sun.wsi.scm.catalog.CatalogPortType;
import com.sun.wsi.scm.catalog.CatalogService_Impl;
import com.sun.wsi.scm.catalog.GetCatalogWithImagesType;
import com.sun.wsi.scm.catalog.GetProductDetailsType;
import com.sun.wsi.scm.catalog.ProductCatalogType;
import com.sun.wsi.scm.catalog.ProductDetailsType;
import com.sun.wsi.scm.catalog.ProductType;
import com.sun.wsi.scm.catalog.holders.ImageHolder;
import com.sun.wsi.scm.catalog.holders.ProductDetailsTypeHolder;
import com.sun.wsi.scm.catalog.holders.SourceHolder;
import com.sun.wsi.scm.util.AttachmentHelper;
import com.sun.wsi.scm.util.HTMLReporter;
import com.sun.wsi.scm.util.WSIConstants;
import com.sun.wsi.scm.util.XMLWriter;
import com.sun.xml.rpc.client.ClientTransportFactory;
import com.sun.xml.rpc.client.StubBase;
import com.sun.xml.rpc.client.http.HttpClientTransportFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.xml.rpc.Stub;

public class CatalogClient
implements WSIConstants {
    private static Logger logger = null;
    private CatalogPortType catalogStub = null;
    private String vendor = null;
    private final String imageDirNameSuffix = "images";
    private final String imageDirName = System.getProperty("log.home") + System.getProperty("file.separator") + "images";
    private final String specsheetDirNameSuffix = "specsheet";
    private final String specsheetDirName = System.getProperty("log.home") + System.getProperty("file.separator") + "specsheet";
    private final String fs = System.getProperty("file.separator");

    public CatalogClient() {
        logger = Logger.getLogger("com.sun.wsi.scm", "com.sun.wsi.scm.resources.resources_en");
        try {
            PrintStream xmlLog = new PrintStream(new FileOutputStream(System.getProperty("log.home") + this.fs + System.getProperty("log.file")));
            XMLWriter.setOutputStream(xmlLog);
            Properties props = new Properties();
            FileInputStream is = new FileInputStream(System.getProperty("endpoints.props"));
            props.load(is);
            this.vendor = System.getProperty("endpoint");
            logger.log(Level.CONFIG, "catalog.endpoint", this.vendor);
            String uri = props.getProperty(this.vendor + ".catalog");
            logger.log(Level.CONFIG, "catalog.endpoint.uri", uri);
            CatalogService_Impl serviceImpl = new CatalogService_Impl();
            this.catalogStub = serviceImpl.getCatalogPort();
            ((Stub)this.catalogStub)._setProperty("javax.xml.rpc.service.endpoint.address", (Object)uri);
            FileOutputStream fos = new FileOutputStream(System.getProperty("log.home") + this.fs + System.getProperty("soap.msgs.file"));
            ((StubBase)this.catalogStub)._setTransportFactory((ClientTransportFactory)new HttpClientTransportFactory((OutputStream)fos));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace();
            logger.log(Level.SEVERE, t.getMessage(), t);
        }
    }

    public static void main(String[] args) {
        CatalogClient client = new CatalogClient();
        XMLWriter.writeStartTag("catalog");
        HTMLReporter htmlReporter = HTMLReporter.getInstance();
        htmlReporter.logEnvironment();
        String methods = System.getProperty("catalog");
        if (methods == null || methods.indexOf("thumbnail") != -1) {
            try {
                client.getCatalogWithImages();
            }
            catch (Throwable t) {
                t.printStackTrace();
                logger.log(Level.SEVERE, t.getMessage(), t);
            }
        }
        if (methods == null || methods.indexOf("details") != -1) {
            try {
                client.getProductDetails();
            }
            catch (Throwable t) {
                t.printStackTrace();
                logger.log(Level.SEVERE, t.getMessage(), t);
            }
        }
        XMLWriter.writeEndTag("catalog");
        htmlReporter.prepareHTMLReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCatalogWithImages() {
        logger.log(Level.INFO, "catalog.client.getCatalogWithImages", this.vendor);
        XMLWriter.writeStartTag("catalog-with-images");
        try {
            ProductCatalogType catalog = this.catalogStub.getCatalogWithImages(new GetCatalogWithImagesType());
            ProductType[] products = catalog.getProduct();
            Collection attachments = (Collection)((Stub)this.catalogStub)._getProperty("com.sun.xml.rpc.attachment.GetAttachmentContext");
            if (attachments == null) {
                logger.log(Level.SEVERE, "catalog.client.getCatalogWithImages.notFound");
                return;
            }
            logger.log(Level.INFO, "catalog.client.getCatalogWithImages.found", String.valueOf(attachments.size()));
            this.makeDirectory(this.imageDirName);
            AttachmentHelper attachmentHelper = new AttachmentHelper(attachments, logger);
            for (int i = 0; i < products.length; ++i) {
                logger.log(Level.CONFIG, "retailer.client.catalog.thProduct", String.valueOf(i + 1));
                logger.log(Level.CONFIG, "retailer.client.catalog.productNumber", String.valueOf(products[i].getProductNumber()));
                logger.log(Level.CONFIG, "retailer.client.catalog.name", products[i].getName());
                logger.log(Level.CONFIG, "retailer.client.catalog.description", products[i].getDescription());
                logger.log(Level.CONFIG, "retailer.client.catalog.category", products[i].getCategory());
                logger.log(Level.CONFIG, "retailer.client.catalog.brand", products[i].getBrand());
                logger.log(Level.CONFIG, "retailer.client.catalog.price", products[i].getPrice().setScale(2, 4));
                URI uri = products[i].getThumbnail();
                DataHandler dataHandler = null;
                if (uri != null) {
                    int index = uri.toString().indexOf(":");
                    String contentId = "<" + uri.toString().substring(index + 1, uri.toString().length()) + ">";
                    logger.log(Level.FINE, "catalog.client.registry.search", contentId);
                    dataHandler = attachmentHelper.search(contentId);
                }
                String imageFileName = null;
                if (dataHandler != null) {
                    imageFileName = this.imageDirName + this.fs + String.valueOf(products[i].getProductNumber()) + "_small.jpg";
                    FileOutputStream imageFile = new FileOutputStream(imageFileName);
                    dataHandler.writeTo((OutputStream)imageFile);
                    logger.log(Level.CONFIG, "catalog.client.getCatalogWithImages.thumbnail", imageFileName);
                }
                XMLWriter.writeStartTag("catalog-item");
                XMLWriter.writeContent("number", String.valueOf(products[i].getProductNumber()));
                XMLWriter.writeContent("name", products[i].getName());
                XMLWriter.writeContent("description", products[i].getDescription());
                XMLWriter.writeContent("category", products[i].getCategory());
                XMLWriter.writeContent("brand", products[i].getBrand());
                XMLWriter.writeContent("price", products[i].getPrice().toString());
                imageFileName = imageFileName != null ? "images" + imageFileName.substring(imageFileName.lastIndexOf(this.fs), imageFileName.length()) : "";
                XMLWriter.writeContent("thumbnail", imageFileName);
                XMLWriter.writeEndTag("catalog-item");
            }
            logger.log(Level.INFO, "catalog.client.getCatalogWithImages.copied", this.imageDirName);
        }
        catch (Throwable t) {
            t.printStackTrace();
            logger.log(Level.SEVERE, t.getMessage(), t);
        }
        finally {
            XMLWriter.writeEndTag("catalog-with-images");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getProductDetails() {
        logger.log(Level.INFO, "catalog.client.getProductDetails", this.vendor);
        XMLWriter.writeStartTag("catalog-with-details");
        try {
            this.makeDirectory(this.imageDirName);
            this.makeDirectory(this.specsheetDirName);
            for (int i = 605001; i <= 605009; ++i) {
                GetProductDetailsType request = new GetProductDetailsType();
                ProductDetailsTypeHolder productDetailsHolder = new ProductDetailsTypeHolder();
                ImageHolder imageHolder = new ImageHolder();
                SourceHolder specsheetHolder = new SourceHolder();
                request.setProductNumber(i);
                this.catalogStub.getProductDetails(request, productDetailsHolder, imageHolder, specsheetHolder);
                if (productDetailsHolder == null || productDetailsHolder.value == null) {
                    logger.log(Level.SEVERE, "catalog.client.getProductDetails.holder");
                    return;
                }
                ProductDetailsType productDetails = productDetailsHolder.value;
                if (imageHolder.value == null) {
                    logger.log(Level.SEVERE, "catalog.client.getProductDetails.noImage", String.valueOf(i));
                    return;
                }
                String imageFileName = this.imageDirName + this.fs + String.valueOf(i) + ".jpg";
                FileOutputStream imageFile = new FileOutputStream(imageFileName);
                DataHandler dh = new DataHandler((Object)imageHolder.value, "image/jpeg");
                dh.writeTo((OutputStream)imageFile);
                if (specsheetHolder.value == null) {
                    logger.log(Level.SEVERE, "catalog.client.getProductDetails.noSpecsheet", String.valueOf(i));
                    return;
                }
                String specsheetFileName = this.specsheetDirName + this.fs + String.valueOf(i) + ".xml";
                FileOutputStream specsheetFile = new FileOutputStream(specsheetFileName);
                dh = new DataHandler((Object)specsheetHolder.value, "text/xml");
                dh.writeTo((OutputStream)specsheetFile);
                specsheetFile.close();
                logger.log(Level.INFO, "retailer.client.catalog.thProduct", String.valueOf(i - 605000));
                logger.log(Level.CONFIG, "catalog.product.number", String.valueOf(i));
                logger.log(Level.CONFIG, "catalog.product.weight", String.valueOf(productDetails.getWeight()));
                logger.log(Level.CONFIG, "catalog.product.weight.unit", productDetails.getWeightUnit());
                logger.log(Level.CONFIG, "catalog.product.dimensions.width", String.valueOf(productDetails.getDimensions().getWidth()));
                logger.log(Level.CONFIG, "catalog.product.dimensions.height", String.valueOf(productDetails.getDimensions().getHeight()));
                logger.log(Level.CONFIG, "catalog.product.dimensions.depth", String.valueOf(productDetails.getDimensions().getDepth()));
                logger.log(Level.CONFIG, "catalog.product.dimensions.unit", String.valueOf(productDetails.getDimensionsUnit()));
                logger.log(Level.CONFIG, "catalog.product.picture", imageFileName);
                logger.log(Level.CONFIG, "catalog.product.specsheet", specsheetFileName);
                logger.log(Level.CONFIG, "");
                XMLWriter.writeStartTag("catalog-item-detail");
                XMLWriter.writeContent("number", String.valueOf(i));
                XMLWriter.writeContent("weight", String.valueOf(productDetails.getWeight()));
                XMLWriter.writeContent("weight-unit", productDetails.getWeightUnit());
                XMLWriter.writeContent("width", String.valueOf(productDetails.getDimensions().getWidth()));
                XMLWriter.writeContent("height", String.valueOf(productDetails.getDimensions().getHeight()));
                XMLWriter.writeContent("depth", String.valueOf(productDetails.getDimensions().getDepth()));
                XMLWriter.writeContent("dimensions-unit", productDetails.getDimensionsUnit());
                imageFileName = imageFileName != null ? "images" + imageFileName.substring(imageFileName.lastIndexOf(this.fs), imageFileName.length()) : "";
                XMLWriter.writeContent("picture", imageFileName);
                specsheetFileName = specsheetFileName != null ? "specsheet" + specsheetFileName.substring(specsheetFileName.lastIndexOf(this.fs), specsheetFileName.length()) : "";
                XMLWriter.writeContent("specsheet", specsheetFileName);
                XMLWriter.writeEndTag("catalog-item-detail");
            }
            logger.log(Level.INFO, "catalog.client.getProductDetails.copied", new String[]{this.imageDirName, this.specsheetDirName});
        }
        catch (Throwable t) {
            t.printStackTrace();
            logger.log(Level.SEVERE, t.getMessage(), t);
        }
        finally {
            XMLWriter.writeEndTag("catalog-with-details");
        }
    }

    private void makeDirectory(String dirName) throws IOException {
        File dir = new File(dirName);
        if (dir.exists() && !dir.isDirectory()) {
            throw new IOException(MessageFormat.format("catalog.client.dir.notADir", dirName));
        }
        if (!dir.getParentFile().canWrite()) {
            throw new IOException(MessageFormat.format("catalog.client.dir.cannotWrite", dir.getParentFile().toString()));
        }
        dir.mkdir();
        logger.log(Level.CONFIG, "catalog.client.dir.created", dirName);
    }
}

