/*
 * Decompiled with CFR 0.152.
 */
package com.sun.connector.jaxr;

import com.sun.connector.jaxr.JaxrConnection;
import com.sun.connector.jaxr.JaxrConnectionEventListener;
import com.sun.connector.jaxr.MetaDataImpl;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JaxrManagedConnection
implements ManagedConnection {
    private XAConnection xacon;
    private Connection con;
    private JaxrConnectionEventListener jaxrListener;
    private PasswordCredential passCred;
    private ManagedConnectionFactory mcf;
    private PrintWriter logWriter;
    private boolean supportsXA;
    private boolean supportsLocalTx;
    private boolean destroyed;
    private Properties properties;
    private Set connectionSet;
    Log log = LogFactory.getLog((String)"com.sun.connector.jaxr");

    JaxrManagedConnection(ManagedConnectionFactory managedConnectionFactory, PasswordCredential passwordCredential, XAConnection xAConnection, Connection connection, boolean bl, boolean bl2) {
        this.mcf = managedConnectionFactory;
        this.passCred = passwordCredential;
        this.xacon = xAConnection;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JAXRManagedConnection has actual jaxr connection impl");
        }
        this.con = connection;
        this.supportsXA = bl;
        this.supportsLocalTx = bl2;
        this.connectionSet = new HashSet();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Instantiating JAXRConnectionEventListener in JAXRManagedConnection constructor");
        }
        this.jaxrListener = new JaxrConnectionEventListener(this);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"End of JAXRManagedConnection constructor");
        }
    }

    JaxrManagedConnection(ManagedConnectionFactory managedConnectionFactory, Properties properties, XAConnection xAConnection, Connection connection, boolean bl, boolean bl2) {
        this.mcf = managedConnectionFactory;
        this.properties = properties;
        this.xacon = xAConnection;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JAXRManagedConnection has actual jaxr connection impl");
        }
        this.con = connection;
        this.supportsXA = bl;
        this.supportsLocalTx = bl2;
        this.connectionSet = new HashSet();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Instantiating JAXRConnectionEventListener in JAXRManagedConnection constructor");
        }
        this.jaxrListener = new JaxrConnectionEventListener(this);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"End of JAXRManagedConnection constructor");
        }
    }

    private void throwResourceException(JAXRException jAXRException) throws ResourceException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"throwing REx in in JAXRManagedConnection constructor");
        }
        jAXRException.printStackTrace();
        ResourceException resourceException = new ResourceException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("JAXRException:_") + jAXRException.getMessage());
        resourceException.setLinkedException((Exception)((Object)jAXRException));
        throw resourceException;
    }

    private void throwResourceException(SQLException sQLException) throws ResourceException {
        ResourceException resourceException = new ResourceException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("SQLException:_") + sQLException.getMessage());
        resourceException.setLinkedException((Exception)sQLException);
        throw resourceException;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        this.checkIfDestroyed();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JAXRManagedConnection getting connection");
        }
        JaxrConnection jaxrConnection = new JaxrConnection(this, this.supportsLocalTx);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JAXRManagedConnectiond created JAXRConnection");
        }
        this.addJaxrConnection(jaxrConnection);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JAXRMananagedConnection adding JAXRConnection to connection set");
        }
        return jaxrConnection;
    }

    public void destroy() throws ResourceException {
        try {
            if (this.destroyed) {
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"JAXRManagedConnection destroying all JAXRConnections");
            }
            this.destroyed = true;
            Iterator iterator = this.connectionSet.iterator();
            while (iterator.hasNext()) {
                JaxrConnection jaxrConnection = (JaxrConnection)iterator.next();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"JAXRManagedConnection destroying JAXRConnection - invalidate");
                }
                jaxrConnection.invalidate();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"JAXRManagedConnection destorying JAXRConnection - connection set clear");
            }
            this.connectionSet.clear();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"JAXRManagedConnection destorying JAXRConnection - closing actual jaxr connectionImpl");
            }
            this.con.close();
            if (this.xacon != null) {
                this.xacon.close();
            }
        }
        catch (JAXRException jAXRException) {
            this.throwResourceException(jAXRException);
        }
        catch (SQLException sQLException) {
            this.throwResourceException(sQLException);
        }
    }

    public void cleanup() throws ResourceException {
        try {
            this.checkIfDestroyed();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"JAXRManagedConnection cleanup all JAXRConnections");
            }
            Iterator iterator = this.connectionSet.iterator();
            while (iterator.hasNext()) {
                JaxrConnection jaxrConnection = (JaxrConnection)iterator.next();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"JAXRManagedConnection cleaning JAXRConnection - invalidate");
                }
                jaxrConnection.invalidate();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"JAXRManagedConnection cleaning JAXRConnection - connection set clear");
            }
            this.connectionSet.clear();
        }
        catch (Exception exception) {
            throw new ResourceException((Throwable)exception);
        }
    }

    public void associateConnection(Object object) throws ResourceException {
        JaxrConnection jaxrConnection;
        this.checkIfDestroyed();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JAXRManagedConnection associate JAXRConnection - ");
        }
        if (object instanceof JaxrConnection) {
            jaxrConnection = (JaxrConnection)object;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"JAXRManagedConnection calling JAXRConnection associateConnection - ");
            }
        } else {
            throw new IllegalStateException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("Invalid_connection_object:_") + object);
        }
        jaxrConnection.associateConnection(this);
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JAXRManagedConnection calling jaxr connectionEventListener - addConnectorListener");
        }
        this.jaxrListener.addConnectorListener(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.jaxrListener.removeConnectorListener(connectionEventListener);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("Local_transaction_not_supported"));
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.checkIfDestroyed();
        return new MetaDataImpl(this);
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    Connection getJaxrConnection() throws ResourceException {
        this.checkIfDestroyed();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JAXRManagedConnection returning actual jaxr connectionImpl");
        }
        return this.con;
    }

    boolean isDestroyed() {
        return this.destroyed;
    }

    Properties getProperties() {
        return this.properties;
    }

    void sendEvent(int n, Exception exception) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JAXRManagedConnection calling eventlistener sendEvent");
        }
        this.jaxrListener.sendEvent(n, exception, null);
    }

    void sendEvent(int n, Exception exception, Object object) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JAXRManagedConnection calling eventlistener sendEvent w/ connectionHandle");
        }
        this.jaxrListener.sendEvent(n, exception, object);
    }

    void removeJaxrConnection(JaxrConnection jaxrConnection) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JAXRManagedConnection removing JAXRConnection from connection set");
        }
        this.connectionSet.remove(jaxrConnection);
        jaxrConnection.invalidate();
        try {
            this.con.close();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"JAXRManagedConnection Closed actual jaxr ConnectionImpl");
            }
        }
        catch (JAXRException jAXRException) {
            this.log.warn((Object)"Error closing jaxr connection");
        }
    }

    void addJaxrConnection(JaxrConnection jaxrConnection) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JAXRManagedConnection adding JAXRConnection to connection set");
        }
        this.connectionSet.add(jaxrConnection);
    }

    private void checkIfDestroyed() throws ResourceException {
        if (this.destroyed) {
            throw new IllegalStateException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("Managed_connection_is_closed"));
        }
    }

    ManagedConnectionFactory getManagedConnectionFactory() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JAXRManagedConnection returning JAXRManagedConnectionFactory");
        }
        return this.mcf;
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("XAResource_not_supported"));
    }
}

