/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.util;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;

public class MethodExecutor
implements Serializable {
    private static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.resource.resourceadapter");
    private boolean debug = false;
    private StringManager sm = StringManager.getManager((Class)DataSourceObjectBuilder.class);

    public void runJavaBeanMethod(String value, Method method, Object obj) throws ResourceException {
        if (value == null || value.trim().equals("")) {
            return;
        }
        try {
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length == 1) {
                Object[] values = new Object[]{this.convertType(parameters[0], value)};
                method.invoke(obj, values);
            }
        }
        catch (IllegalAccessException iae) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", iae);
            String msg = this.sm.getString("me.access_denied", (Object)method.getName());
            throw new ResourceException(msg);
        }
        catch (IllegalArgumentException ie) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", ie);
            String msg = this.sm.getString("me.illegal_args", (Object)method.getName());
            throw new ResourceException(msg);
        }
        catch (InvocationTargetException ite) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", ite);
            String msg = this.sm.getString("me.access_denied", (Object)method.getName());
            throw new ResourceException(msg);
        }
    }

    public void runMethod(Method method, Object obj, Vector values) throws ResourceException {
        try {
            Class<?>[] parameters = method.getParameterTypes();
            if (values.size() != parameters.length) {
                return;
            }
            Object[] actualValues = new Object[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                String val = (String)values.get(i);
                actualValues[i] = val.trim().equals("NULL") ? null : this.convertType(parameters[i], val);
            }
            method.invoke(obj, actualValues);
        }
        catch (IllegalAccessException iae) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", iae);
            String msg = this.sm.getString("me.access_denied", (Object)method.getName());
            throw new ResourceException(msg);
        }
        catch (IllegalArgumentException ie) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", ie);
            String msg = this.sm.getString("me.illegal_args", (Object)method.getName());
            throw new ResourceException(msg);
        }
        catch (InvocationTargetException ite) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", ite);
            String msg = this.sm.getString("me.access_denied", (Object)method.getName());
            throw new ResourceException(msg);
        }
    }

    private Object convertType(Class type, String parameter) throws ResourceException {
        try {
            String typeName = type.getName();
            if (typeName.equals("java.lang.String") || typeName.equals("java.lang.Object")) {
                return parameter;
            }
            if (typeName.equals("int") || typeName.equals("java.lang.Integer")) {
                return new Integer(parameter);
            }
            if (typeName.equals("short") || typeName.equals("java.lang.Short")) {
                return new Short(parameter);
            }
            if (typeName.equals("byte") || typeName.equals("java.lang.Byte")) {
                return new Byte(parameter);
            }
            if (typeName.equals("long") || typeName.equals("java.lang.Long")) {
                return new Long(parameter);
            }
            if (typeName.equals("float") || typeName.equals("java.lang.Float")) {
                return new Float(parameter);
            }
            if (typeName.equals("double") || typeName.equals("java.lang.Double")) {
                return new Double(parameter);
            }
            if (typeName.equals("java.math.BigDecimal")) {
                return new BigDecimal(parameter);
            }
            if (typeName.equals("java.math.BigInteger")) {
                return new BigInteger(parameter);
            }
            if (typeName.equals("boolean") || typeName.equals("java.lang.Boolean")) {
                return new Boolean(parameter);
            }
            return parameter;
        }
        catch (NumberFormatException nfe) {
            _logger.log(Level.SEVERE, "jdbc.exc_nfe", parameter);
            String msg = this.sm.getString("me.invalid_param", (Object)parameter);
            throw new ResourceException(msg);
        }
    }
}

