/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cli.commands;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.ee.admin.servermgmt.AgentConfig;
import com.sun.enterprise.ee.admin.servermgmt.AgentManager;
import com.sun.enterprise.ee.cli.commands.BaseNodeAgentCommand;
import com.sun.enterprise.util.i18n.StringManager;

public class ChangeMasterPasswordCommand
extends BaseNodeAgentCommand {
    private String newMasterPassword = null;
    private String masterPassword = null;
    private static final StringManager _strMgr = StringManager.getManager((Class)ChangeMasterPasswordCommand.class);

    public boolean validateOptions() throws CommandValidationException {
        super.validateOptions();
        if (!this.isPasswordValid(this.newMasterPassword)) {
            throw new CommandValidationException(_strMgr.getString("PasswordLimit", new Object[]{"adminpassword"}));
        }
        return true;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        DomainsManager mgr;
        DomainConfig config;
        this.setLoggerLevel();
        String domainName = this.getDomainName();
        String agentName = null;
        try {
            config = this.getDomainConfig(domainName);
            mgr = this.getFeatureFactory().getDomainsManager();
            mgr.validateDomain(config, true);
        }
        catch (Exception ex) {
            domainName = null;
        }
        try {
            if (domainName != null) {
                config = this.getDomainConfig(domainName);
                mgr = this.getFeatureFactory().getDomainsManager();
                mgr.validateDomain(config, true);
                this.masterPassword = this.getMasterPassword(new RepositoryManager(), (RepositoryConfig)config);
                config.put((Object)"domain.masterPassword", (Object)this.masterPassword);
                mgr.validateMasterPassword(config);
                this.newMasterPassword = this.getNewMasterPassword();
                this.validateOptions();
                Boolean saveMasterPassword = this.getSaveMasterPassword(null);
                config.put((Object)"domain.newMasterPassword", (Object)this.newMasterPassword);
                config.put((Object)"domain.saveMasterPassword", (Object)saveMasterPassword);
                mgr.changeMasterPassword(config);
                CLILogger.getInstance().printDetailMessage(_strMgr.getString("DomainPasswordChanged", new Object[]{domainName}));
            } else {
                agentName = this.getAgentName();
                config = new AgentConfig(agentName, this.getAgentPath());
                AgentManager manager = this.getAgentManager((AgentConfig)config);
                manager.validateNodeAgent((AgentConfig)config, true);
                this.masterPassword = this.getMasterPassword((RepositoryManager)manager, (RepositoryConfig)config);
                config.put((Object)"agent.masterpassword", (Object)this.masterPassword);
                manager.validateMasterPassword((AgentConfig)config, true);
                this.newMasterPassword = this.getNewMasterPassword();
                Boolean saveMasterPassword = this.getSaveMasterPassword(null);
                config.put((Object)"agent.newmasterpassword", (Object)this.newMasterPassword);
                config.put((Object)"agent.saveMasterPassword", (Object)saveMasterPassword);
                manager.changeMasterPassword((AgentConfig)config);
                CLILogger.getInstance().printDetailMessage(_strMgr.getString("NodeAgentPasswordChanged", new Object[]{agentName}));
            }
        }
        catch (Exception e) {
            CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            if (agentName != null) {
                throw new CommandException(_strMgr.getString("ExceptionChangingAgentPassword", new Object[]{agentName}), (Throwable)e);
            }
            throw new CommandException(_strMgr.getString("ExceptionChangingDomainPassword", new Object[]{domainName}), (Throwable)e);
        }
    }
}

