/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.io.NbMarshalledObject;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public abstract class CloneableTopComponent
extends TopComponent
implements Externalizable,
TopComponent.Cloneable {
    static final long serialVersionUID = 4893753008783256289L;
    private Ref ref;
    public static final Ref EMPTY = new Ref();
    static /* synthetic */ Class class$org$openide$windows$CloneableTopComponent;

    public CloneableTopComponent() {
    }

    public CloneableTopComponent(DataObject obj) {
        super(obj);
    }

    public final Object clone() {
        return this.cloneComponent();
    }

    public final CloneableTopComponent cloneTopComponent() {
        CloneableTopComponent top = this.createClonedObject();
        top.setReference(this.getReference());
        return top;
    }

    public final TopComponent cloneComponent() {
        return this.cloneTopComponent();
    }

    protected CloneableTopComponent createClonedObject() {
        try {
            NbMarshalledObject o = new NbMarshalledObject(this);
            CloneableTopComponent top = (CloneableTopComponent)o.get();
            return top;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new InternalError();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            throw new InternalError();
        }
    }

    public final synchronized Ref getReference() {
        if (this.ref == null) {
            this.ref = new Ref(this);
        }
        return this.ref;
    }

    public final synchronized void setReference(Ref another) {
        if (another == EMPTY) {
            throw new IllegalArgumentException(NbBundle.getBundle(class$org$openide$windows$CloneableTopComponent == null ? (class$org$openide$windows$CloneableTopComponent = CloneableTopComponent.class$("org.openide.windows.CloneableTopComponent")) : class$org$openide$windows$CloneableTopComponent).getString("EXC_CannotAssign"));
        }
        if (this.ref != null) {
            this.ref.removeComponent(this);
        }
        another.register(this);
        this.ref = another;
    }

    public boolean canClose(Workspace workspace, boolean last) {
        if (last) {
            return this.getReference().unregister(this);
        }
        return true;
    }

    protected boolean closeLast() {
        return true;
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        Ref ref;
        super.readExternal(oi);
        if (this.serialVersion != 0 && (ref = (Ref)oi.readObject()) != null) {
            this.setReference(ref);
        }
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        super.writeExternal(oo);
        oo.writeObject(this.ref);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Ref
    implements Serializable {
        static final long serialVersionUID = 5543148876020730556L;
        private static final Object LOCK = new Object();
        private transient Set componentSet = new HashSet(7);

        protected Ref() {
        }

        private Ref(CloneableTopComponent c) {
            Object object = LOCK;
            synchronized (object) {
                this.componentSet.add(c);
            }
        }

        public Enumeration getComponents() {
            HashSet components;
            Object object = LOCK;
            synchronized (object) {
                components = new HashSet(this.componentSet);
            }
            return Collections.enumeration(components);
        }

        public boolean isEmpty() {
            Object object = LOCK;
            synchronized (object) {
                boolean bl = this.componentSet.isEmpty();
                return bl;
            }
        }

        public CloneableTopComponent getAnyComponent() {
            Object object = LOCK;
            synchronized (object) {
                CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)this.componentSet.iterator().next();
                return cloneableTopComponent;
            }
        }

        public CloneableTopComponent getArbitraryComponent() {
            Object object = LOCK;
            synchronized (object) {
                Iterator it = this.componentSet.iterator();
                if (it.hasNext()) {
                    CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)it.next();
                    return cloneableTopComponent;
                }
                CloneableTopComponent cloneableTopComponent = null;
                return cloneableTopComponent;
            }
        }

        private final void register(CloneableTopComponent c) {
            Object object = LOCK;
            synchronized (object) {
                this.componentSet.add(c);
            }
        }

        private final boolean unregister(CloneableTopComponent c) {
            int componentCount;
            Object object = LOCK;
            synchronized (object) {
                componentCount = this.componentSet.size();
            }
            if (componentCount > 1 || c.closeLast()) {
                this.removeComponent(c);
                return true;
            }
            return false;
        }

        private void removeComponent(CloneableTopComponent c) {
            Object object = LOCK;
            synchronized (object) {
                this.componentSet.remove(c);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            Object object = LOCK;
            synchronized (object) {
                this.componentSet = new HashSet(7);
            }
        }
    }
}

