/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import org.openide.nodes.Node;

public final class Sheet {
    private ArrayList sets;
    private Node.PropertySet[] array;
    private PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private PropertyChangeListener propL = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            Sheet.this.supp.firePropertyChange(null, null, null);
        }
    };
    public static final String PROPERTIES = "properties";
    public static final String EXPERT = "expert";

    public Sheet() {
        this(new ArrayList(2));
    }

    private Sheet(ArrayList ar) {
        this.sets = ar;
    }

    public final Node.PropertySet[] toArray() {
        Node.PropertySet[] l = this.array;
        if (l != null) {
            return l;
        }
        Sheet sheet = this;
        synchronized (sheet) {
            if (this.array != null) {
                Node.PropertySet[] propertySetArray = this.array;
                return propertySetArray;
            }
            this.array = new Node.PropertySet[this.sets.size()];
            this.sets.toArray(this.array);
            Node.PropertySet[] propertySetArray = this.array;
            return propertySetArray;
        }
    }

    public synchronized Sheet cloneSheet() {
        int len = this.sets.size();
        ArrayList<Set> l = new ArrayList<Set>(len);
        int i = 0;
        while (i < len) {
            l.add(((Set)this.sets.get(i)).cloneSet());
            ++i;
        }
        return new Sheet(l);
    }

    public synchronized Set get(String name) {
        int indx = this.findIndex(name);
        return indx == -1 ? null : (Set)this.sets.get(indx);
    }

    public synchronized Set put(Set set) {
        Set removed;
        int indx = this.findIndex(set.getName());
        if (indx == -1) {
            this.sets.add(set);
            removed = null;
        } else {
            removed = this.sets.set(indx, set);
        }
        set.removePropertyChangeListener(this.propL);
        if (removed == null) {
            set.addPropertyChangeListener(this.propL);
        }
        this.refresh();
        return removed;
    }

    public synchronized Set remove(String set) {
        int indx = this.findIndex(set);
        if (indx != -1) {
            Set s = (Set)this.sets.remove(indx);
            s.removePropertyChangeListener(this.propL);
            this.refresh();
            return s;
        }
        return null;
    }

    public static Sheet createDefault() {
        Sheet newSheet = new Sheet();
        newSheet.put(Sheet.createPropertiesSet());
        return newSheet;
    }

    public static Set createPropertiesSet() {
        Set ps = new Set();
        ps.setName(PROPERTIES);
        ps.setDisplayName(Node.getString("Properties"));
        ps.setShortDescription(Node.getString("HINT_Properties"));
        return ps;
    }

    public static Set createExpertSet() {
        Set ps = new Set();
        ps.setName(EXPERT);
        ps.setDisplayName(Node.getString("Expert"));
        ps.setShortDescription(Node.getString("HINT_Expert"));
        return ps;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    private int findIndex(String name) {
        int s = this.sets.size();
        int i = 0;
        while (i < s) {
            Node.PropertySet p = (Node.PropertySet)this.sets.get(i);
            if (p.getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void refresh() {
        this.array = null;
        this.supp.firePropertyChange(null, null, null);
    }

    public static final class Set
    extends Node.PropertySet {
        private ArrayList props;
        private Node.Property[] array;
        private PropertyChangeSupport supp = new PropertyChangeSupport(this);

        public Set() {
            this(new ArrayList());
        }

        private Set(ArrayList al) {
            this.props = al;
        }

        public synchronized Set cloneSet() {
            return new Set((ArrayList)this.props.clone());
        }

        public Node.Property get(String name) {
            int indx = this.findIndex(name);
            return indx == -1 ? null : (Node.Property)this.props.get(indx);
        }

        public Node.Property[] getProperties() {
            Node.Property[] l = this.array;
            if (l != null) {
                return l;
            }
            Set set = this;
            synchronized (set) {
                if (this.array != null) {
                    Node.Property[] propertyArray = this.array;
                    return propertyArray;
                }
                this.array = new Node.Property[this.props.size()];
                this.props.toArray(this.array);
                Node.Property[] propertyArray = this.array;
                return propertyArray;
            }
        }

        public synchronized Node.Property put(Node.Property p) {
            Node.Property removed;
            int indx = this.findIndex(p.getName());
            if (indx != -1) {
                removed = this.props.set(indx, p);
            } else {
                this.props.add(p);
                removed = null;
            }
            this.refresh();
            return removed;
        }

        public synchronized void put(Node.Property[] ar) {
            int i = 0;
            while (i < ar.length) {
                Node.Property p = ar[i];
                p = ar[i];
                int indx = this.findIndex(p.getName());
                if (indx != -1) {
                    this.props.set(indx, p);
                } else {
                    this.props.add(p);
                }
                ++i;
            }
            this.refresh();
        }

        public synchronized Node.Property remove(String name) {
            int indx = this.findIndex(name);
            if (indx != -1) {
                try {
                    Node.Property property = (Node.Property)this.props.remove(indx);
                    Object var5_4 = null;
                    this.refresh();
                    return property;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.refresh();
                    throw throwable;
                }
            }
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.supp.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.supp.removePropertyChangeListener(l);
        }

        private int findIndex(String name) {
            int s = this.props.size();
            int i = 0;
            while (i < s) {
                Node.Property p = (Node.Property)this.props.get(i);
                if (p.getName().equals(name)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private void refresh() {
            this.array = null;
            this.supp.firePropertyChange(null, null, null);
        }
    }
}

