/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.TMUtil;

public interface Index
extends Node.Cookie {
    public int getNodesCount();

    public Node[] getNodes();

    public int indexOf(Node var1);

    public void reorder();

    public void reorder(int[] var1);

    public void move(int var1, int var2);

    public void exchange(int var1, int var2);

    public void moveUp(int var1);

    public void moveDown(int var1);

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    public static abstract class KeysChildren
    extends Children.Keys {
        private Index support;
        protected final List list;

        public KeysChildren(List ar) {
            this.list = ar;
            this.update();
        }

        public Index getIndex() {
            KeysChildren keysChildren = this;
            synchronized (keysChildren) {
                if (this.support == null) {
                    this.support = this.createIndex();
                }
                Index index = this.support;
                return index;
            }
        }

        protected Index createIndex() {
            return new Support(this){
                private final /* synthetic */ KeysChildren this$0;
                {
                    this.this$0 = this$0;
                }

                public Node[] getNodes() {
                    List<Node> l = Arrays.asList(this.this$0.getNodes());
                    if (this.this$0.nodes != null) {
                        l.removeAll(this.this$0.nodes);
                    }
                    return l.toArray(new Node[l.size()]);
                }

                public int getNodesCount() {
                    return this.this$0.list.size();
                }

                public void reorder(int[] perm) {
                    this.this$0.reorder(perm);
                    this.this$0.update();
                    this.fireChangeEvent(new ChangeEvent(this));
                }
            };
        }

        protected void reorder(int[] perm) {
            Object object = this.lock();
            synchronized (object) {
                Object[] n = this.list.toArray();
                int i = 0;
                while (i < n.length) {
                    this.list.set(perm[i], n[i]);
                    ++i;
                }
            }
        }

        protected Object lock() {
            return this.list;
        }

        public final void update() {
            Object[] keys;
            Object object = this.lock();
            synchronized (object) {
                keys = this.list.toArray();
            }
            super.setKeys(keys);
        }
    }

    public static class ArrayChildren
    extends Children.Array
    implements Index {
        protected Index support = new Support(this){
            private final /* synthetic */ ArrayChildren this$0;
            {
                this.this$0 = this$0;
            }

            public Node[] getNodes() {
                return this.this$0.getNodes();
            }

            public int getNodesCount() {
                return this.this$0.getNodesCount();
            }

            public void reorder(int[] perm) {
                this.this$0.reorder(perm);
                this.fireChangeEvent(new ChangeEvent(this.this$0));
            }
        };

        public ArrayChildren() {
            this(null);
        }

        private ArrayChildren(List ar) {
            super(ar);
        }

        protected Collection initCollection() {
            return new ArrayList();
        }

        public void reorder(int[] perm) {
            try {
                Children.PR.enterWriteAccess();
                Object[] n = this.nodes.toArray();
                List l = (List)this.nodes;
                int i = 0;
                while (i < n.length) {
                    l.set(perm[i], n[i]);
                    ++i;
                }
                this.refresh();
                Object var6_5 = null;
                Children.PR.exitWriteAccess();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                Children.PR.exitWriteAccess();
                throw throwable;
            }
        }

        public void reorder() {
            try {
                Children.PR.enterReadAccess();
                Support.showIndexedCustomizer(this);
                Object var2_1 = null;
                Children.PR.exitReadAccess();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                Children.PR.exitReadAccess();
                throw throwable;
            }
        }

        public void move(int x, int y) {
            this.support.move(x, y);
        }

        public void exchange(int x, int y) {
            this.support.exchange(x, y);
        }

        public void moveUp(int x) {
            this.support.exchange(x, x - 1);
        }

        public void moveDown(int x) {
            this.support.exchange(x, x + 1);
        }

        public int indexOf(Node node) {
            try {
                Children.PR.enterWriteAccess();
                int n = ((List)this.nodes).indexOf(node);
                Object var4_3 = null;
                Children.PR.exitWriteAccess();
                return n;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                Children.PR.exitWriteAccess();
                throw throwable;
            }
        }

        public void addChangeListener(ChangeListener chl) {
            this.support.addChangeListener(chl);
        }

        public void removeChangeListener(ChangeListener chl) {
            this.support.removeChangeListener(chl);
        }
    }

    public static abstract class Support
    implements Index {
        private HashSet listeners;

        public void move(int x, int y) {
            int[] perm = new int[this.getNodesCount()];
            if (x == y) {
                return;
            }
            int i = 0;
            while (i < perm.length) {
                perm[i] = i < x && i < y || i > x && i > y ? i : (i > x && i < y ? i - 1 : i + 1);
                ++i;
            }
            perm[x] = y;
            perm[y] = x < y ? y - 1 : y + 1;
            this.reorder(perm);
        }

        public void exchange(int x, int y) {
            int[] perm = new int[this.getNodesCount()];
            int i = 0;
            while (i < perm.length) {
                perm[i] = i;
                ++i;
            }
            perm[x] = y;
            perm[y] = x;
            this.reorder(perm);
        }

        public void moveUp(int x) {
            this.exchange(x, x - 1);
        }

        public void moveDown(int x) {
            this.exchange(x, x + 1);
        }

        public void addChangeListener(ChangeListener chl) {
            if (this.listeners == null) {
                this.listeners = new HashSet();
            }
            this.listeners.add(chl);
        }

        public void removeChangeListener(ChangeListener chl) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(chl);
        }

        protected void fireChangeEvent(ChangeEvent che) {
            HashSet cloned;
            if (this.listeners == null) {
                return;
            }
            Support support = this;
            synchronized (support) {
                cloned = (HashSet)this.listeners.clone();
            }
            Iterator iter = cloned.iterator();
            while (iter.hasNext()) {
                ((ChangeListener)iter.next()).stateChanged(che);
            }
        }

        public abstract Node[] getNodes();

        public int indexOf(Node node) {
            Node[] arr = this.getNodes();
            int i = 0;
            while (i < arr.length) {
                if (node.equals(arr[i])) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void reorder() {
            Support.showIndexedCustomizer(this);
        }

        public static void showIndexedCustomizer(Index idx) {
            TMUtil.showIndexedCustomizer(idx);
        }

        public abstract int getNodesCount();

        public abstract void reorder(int[] var1);
    }
}

