/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListener;

final class ProxyNode
extends AbstractNode {
    private Node[] original;
    private PropertyChangeListener pcl;

    public ProxyNode(Node[] original) {
        super(Children.LEAF);
        this.original = original;
        this.pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                ProxyNode.super.firePropertyChange(pce.getPropertyName(), pce.getOldValue(), pce.getNewValue());
            }
        };
        int i = 0;
        while (i < original.length) {
            original[i].addPropertyChangeListener(WeakListener.propertyChange(this.pcl, original[i]));
            ++i;
        }
    }

    public HelpCtx getHelpCtx() {
        int i = 0;
        while (i < this.original.length) {
            if (this.original[i].getHelpCtx() != HelpCtx.DEFAULT_HELP) {
                return this.original[i].getHelpCtx();
            }
            ++i;
        }
        return HelpCtx.DEFAULT_HELP;
    }

    public Node cloneNode() {
        return new ProxyNode(this.original);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set[] computedSet = this.computePropertySets();
        int i = 0;
        while (i < computedSet.length) {
            sheet.put(computedSet[i]);
            ++i;
        }
        return sheet;
    }

    Node[] getOriginalNodes() {
        return this.original;
    }

    private Sheet.Set[] computePropertySets() {
        if (this.original.length > 0) {
            Node.PropertySet[] firstSet = this.original[0].getPropertySets();
            HashSet<Node.PropertySet> sheets = new HashSet<Node.PropertySet>(Arrays.asList(firstSet));
            int i = 1;
            while (i < this.original.length) {
                sheets.retainAll(new HashSet<Node.PropertySet>(Arrays.asList(this.original[i].getPropertySets())));
                ++i;
            }
            ArrayList<Sheet.Set> resultSheets = new ArrayList<Sheet.Set>(sheets.size());
            int i2 = 0;
            while (i2 < firstSet.length) {
                if (sheets.contains(firstSet[i2]) && !firstSet[i2].isHidden()) {
                    FeatureDescriptor[] p;
                    Node.PropertySet current = firstSet[i2];
                    Sheet.Set res = new Sheet.Set();
                    res.setName(current.getName());
                    res.setDisplayName(current.getDisplayName());
                    res.setShortDescription(current.getShortDescription());
                    HashSet<Node.Property> props = new HashSet<Node.Property>(Arrays.asList(current.getProperties()));
                    int j = 0;
                    while (j < this.original.length) {
                        p = this.original[j].getPropertySets();
                        int k = 0;
                        while (k < p.length) {
                            Node.Property[] arr = ((Node.PropertySet)p[k]).getProperties();
                            if (current.getName().equals(p[k].getName())) {
                                props.retainAll(new HashSet<Node.Property>(Arrays.asList(((Node.PropertySet)p[k]).getProperties())));
                            }
                            ++k;
                        }
                        ++j;
                    }
                    p = current.getProperties();
                    int j2 = 0;
                    while (j2 < p.length) {
                        if (props.contains(p[j2]) && !p[j2].isHidden()) {
                            ProxyProperty pp = this.createProxyProperty(p[j2].getName(), res.getName());
                            res.put(pp);
                        }
                        ++j2;
                    }
                    resultSheets.add(res);
                }
                ++i2;
            }
            return resultSheets.toArray(new Sheet.Set[resultSheets.size()]);
        }
        return new Sheet.Set[0];
    }

    private ProxyProperty createProxyProperty(String propName, String setName) {
        Node.Property[] arr = new Node.Property[this.original.length];
        int i = 0;
        while (i < this.original.length) {
            Node.PropertySet[] p = this.original[i].getPropertySets();
            int j = 0;
            while (j < p.length) {
                if (p[j].getName().equals(setName)) {
                    Node.Property[] np = p[j].getProperties();
                    int k = 0;
                    while (k < np.length) {
                        if (np[k].getName().equals(propName)) {
                            arr[i] = np[k];
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return new ProxyProperty(arr);
    }

    static class DifferentValuesException
    extends RuntimeException {
        public DifferentValuesException() {
        }

        public DifferentValuesException(String message) {
            super(message);
        }
    }

    private static class ProxyProperty
    extends Node.Property {
        private Node.Property[] original;

        public ProxyProperty(Node.Property[] original) {
            super(original[0].getValueType());
            this.original = original;
            this.setName(original[0].getName());
            this.setDisplayName(original[0].getDisplayName());
            this.setShortDescription(original[0].getShortDescription());
        }

        public boolean canWrite() {
            int i = 0;
            while (i < this.original.length) {
                if (!this.original[i].canWrite()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean canRead() {
            int i = 0;
            while (i < this.original.length) {
                if (!this.original[i].canRead()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            Object o = this.original[0].getValue();
            if (o == null) {
                return null;
            }
            int i = 0;
            while (i < this.original.length) {
                if (!o.equals(this.original[i].getValue())) {
                    throw new DifferentValuesException();
                }
                ++i;
            }
            return o;
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            int i = 0;
            while (i < this.original.length) {
                this.original[i].setValue(val);
                ++i;
            }
        }

        public Object getValue(String attributeName) {
            Object o = this.original[0].getValue(attributeName);
            if (o == null) {
                return null;
            }
            int i = 0;
            while (i < this.original.length) {
                if (!o.equals(this.original[i].getValue(attributeName))) {
                    ErrorManager.getDefault().notify(1, new DifferentValuesException("Different values in attribute " + attributeName));
                    return null;
                }
                ++i;
            }
            return o;
        }

        public void setValue(String attributeName, Object value) {
            int i = 0;
            while (i < this.original.length) {
                this.original[i].setValue(attributeName, value);
                ++i;
            }
        }

        public PropertyEditor getPropertyEditor() {
            return this.original[0].getPropertyEditor();
        }

        public boolean supportsDefaultValue() {
            int i = 0;
            while (i < this.original.length) {
                if (!this.original[i].supportsDefaultValue()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            int i = 0;
            while (i < this.original.length) {
                this.original[i].restoreDefaultValue();
                ++i;
            }
        }
    }
}

