/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.EmptyPanel;
import org.openide.explorer.propertysheet.PropertySheetSettings;
import org.openide.explorer.propertysheet.PropertySheetTab;
import org.openide.explorer.propertysheet.PropertySheetToolbar;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PropertySheet
extends JPanel {
    static final long serialVersionUID = -7698351033045864945L;
    public static final String PROPERTY_SORTING_MODE = "sortingMode";
    public static final String PROPERTY_VALUE_COLOR = "valueColor";
    public static final String PROPERTY_DISABLED_PROPERTY_COLOR = "disabledPropertyColor";
    public static final String PROPERTY_CURRENT_PAGE = "currentPage";
    public static final String PROPERTY_PLASTIC = "plastic";
    public static final String PROPERTY_PROPERTY_PAINTING_STYLE = "propertyPaintingStyle";
    public static final String PROPERTY_DISPLAY_WRITABLE_ONLY = "displayWritableOnly";
    public static final int ALWAYS_AS_STRING = 1;
    public static final int STRING_PREFERRED = 2;
    public static final int PAINTING_PREFERRED = 3;
    public static final int UNSORTED = 0;
    public static final int SORTED_BY_NAMES = 1;
    public static final int SORTED_BY_TYPES = 2;
    private static final int INIT_DELAY = 70;
    private static final int MAX_DELAY = 350;
    protected static Icon iNoSort;
    protected static Icon iAlphaSort;
    protected static Icon iTypeSort;
    protected static Icon iDisplayWritableOnly;
    protected static Icon iCustomize;
    static final String PROP_HAS_CUSTOMIZER = "hasCustomizer";
    static final String PROP_PAGE_HELP_ID = "pageHelpID";
    private int savedSplitterPosition = -1;
    private transient JTabbedPane pages;
    private transient EmptyPanel emptyPanel;
    private transient int pageIndex = 0;
    private transient ChangeListener tabListener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            int index = PropertySheet.this.pages.getSelectedIndex();
            PropertySheet.this.setCurrentPage(index);
        }
    };
    private Node activeNode;
    private NodeListener activeNodeListener;
    private boolean displayWritableOnly;
    private int propertyPaintingStyle;
    private int sortingMode;
    private boolean plastic;
    private Color disabledPropertyColor;
    private Color valueColor;
    static ThreadLocal current;
    private transient Node[] helperNodes;
    private transient RequestProcessor.Task scheduleTask;
    private transient RequestProcessor.Task initTask;
    private String storedTab = null;
    private boolean attached = false;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertySheet;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$openide$util$HelpCtx;

    private static String getString(String key) {
        return NbBundle.getBundle(class$org$openide$explorer$propertysheet$PropertySheet == null ? (class$org$openide$explorer$propertysheet$PropertySheet = PropertySheet.class$("org.openide.explorer.propertysheet.PropertySheet")) : class$org$openide$explorer$propertysheet$PropertySheet).getString(key);
    }

    public PropertySheet() {
        this.setLayout(new BorderLayout());
        boolean problem = false;
        try {
            Class<?> c = Class.forName("org.openide.explorer.propertysheet.PropertySheet$PropertySheetSettingsInvoker");
            Runnable r = (Runnable)c.newInstance();
            current.set(this);
            r.run();
        }
        catch (Exception e) {
            problem = true;
        }
        catch (LinkageError le) {
            problem = true;
        }
        if (problem) {
            this.displayWritableOnly = false;
            this.propertyPaintingStyle = 3;
            this.sortingMode = 1;
            this.plastic = false;
            this.disabledPropertyColor = UIManager.getColor("textInactiveText");
            this.valueColor = new Color(0, 0, 128);
        }
        this.pages = new HelpAwareJTabbedPane();
        this.pages.getAccessibleContext().setAccessibleName(PropertySheet.getString("ACS_PropertySheetTabs"));
        this.pages.getAccessibleContext().setAccessibleDescription(PropertySheet.getString("ACSD_PropertySheetTabs"));
        this.pages.addChangeListener(this.tabListener);
        this.emptyPanel = new EmptyPanel(PropertySheet.getString("CTL_NoProperties"));
        this.pages.setTabPlacement(3);
        PropertySheetToolbar p = new PropertySheetToolbar(this);
        p.setBorder(UIManager.getBorder("Toolbar.border"));
        this.addPropertyChangeListener(p);
        this.add((Component)p, "North");
        this.setPreferredSize(new Dimension(200, 300));
    }

    public void setNodes(Node[] nodes) {
        this.setHelperNodes(nodes);
    }

    private synchronized void setHelperNodes(Node[] nodes) {
        RequestProcessor.Task task = this.getScheduleTask();
        this.helperNodes = nodes;
        if (task.equals(this.initTask)) {
            this.scheduleTask.schedule(0);
            task.schedule(70);
        } else {
            int delay = task.getDelay() * 2;
            if (delay > 350) {
                delay = 350;
            }
            if (delay < 70) {
                delay = 70;
            }
            task.schedule(delay);
        }
    }

    private synchronized Node[] getHelperNodes() {
        return this.helperNodes;
    }

    private synchronized RequestProcessor.Task getScheduleTask() {
        if (this.scheduleTask == null) {
            this.scheduleTask = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    Node[] nodes = PropertySheet.this.getHelperNodes();
                    Node n = nodes.length == 1 ? nodes[0] : (nodes.length == 0 ? null : new ProxyNode(nodes));
                    SwingUtilities.invokeLater(new Runnable(this, n){
                        private final /* synthetic */ Node val$n;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$n = val$n;
                        }

                        public void run() {
                            PropertySheet.access$900(2.access$800(this.this$1), this.val$n);
                        }
                    });
                }

                static /* synthetic */ PropertySheet access$800(2 x0) {
                    return x0.PropertySheet.this;
                }
            });
            this.initTask = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                }
            });
        }
        if (this.initTask.isFinished() && this.scheduleTask.isFinished()) {
            return this.initTask;
        }
        return this.scheduleTask;
    }

    public void setPropertyPaintingStyle(int style) {
        if (style == this.propertyPaintingStyle) {
            return;
        }
        int oldVal = this.propertyPaintingStyle;
        this.propertyPaintingStyle = style;
        this.firePropertyChange(PROPERTY_PROPERTY_PAINTING_STYLE, new Integer(oldVal), new Integer(style));
    }

    public int getPropertyPaintingStyle() {
        return this.propertyPaintingStyle;
    }

    public void setSortingMode(int sortingMode) throws PropertyVetoException {
        if (this.sortingMode == sortingMode) {
            return;
        }
        int oldVal = this.sortingMode;
        this.sortingMode = sortingMode;
        this.firePropertyChange(PROPERTY_SORTING_MODE, new Integer(oldVal), new Integer(sortingMode));
    }

    public int getSortingMode() {
        return this.sortingMode;
    }

    public void setCurrentPage(int index) {
        Component comp;
        int selected;
        if (this.pageIndex == index) {
            return;
        }
        this.pageIndex = index;
        if (index < 0) {
            return;
        }
        if (index != this.pages.getSelectedIndex()) {
            this.pages.setSelectedIndex(index);
        }
        if ((selected = this.pages.getSelectedIndex()) >= 0 && (comp = this.pages.getComponentAt(selected)) instanceof PropertySheetTab) {
            ((PropertySheetTab)comp).ensurePaneCreated();
        }
        this.firePropertyChange(PROP_PAGE_HELP_ID, null, null);
    }

    public boolean setCurrentPage(String str) {
        int index = this.pages.indexOfTab(str);
        if (index < 0) {
            return false;
        }
        this.setCurrentPage(index);
        return true;
    }

    public int getCurrentPage() {
        return this.pages.getSelectedIndex();
    }

    String getPageHelpID() {
        String helpID;
        Component comp;
        if (this.isAncestorOf(this.pages) && (comp = this.pages.getSelectedComponent()) instanceof PropertySheetTab && (helpID = ((PropertySheetTab)comp).getHelpID()) != null) {
            return helpID;
        }
        return null;
    }

    public void setPlastic(boolean plastic) {
        if (this.plastic == plastic) {
            return;
        }
        this.plastic = plastic;
        this.firePropertyChange(PROPERTY_PLASTIC, plastic ? Boolean.FALSE : Boolean.TRUE, plastic ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getPlastic() {
        return this.plastic;
    }

    public void setValueColor(Color color) {
        if (this.valueColor.equals(color)) {
            return;
        }
        Color oldVal = this.valueColor;
        this.valueColor = color;
        this.firePropertyChange(PROPERTY_VALUE_COLOR, oldVal, color);
    }

    public Color getValueColor() {
        return this.valueColor;
    }

    public void setDisabledPropertyColor(Color color) {
        if (this.disabledPropertyColor.equals(color)) {
            return;
        }
        Color oldVal = this.disabledPropertyColor;
        this.disabledPropertyColor = color;
        this.firePropertyChange(PROPERTY_DISABLED_PROPERTY_COLOR, oldVal, color);
    }

    public Color getDisabledPropertyColor() {
        return this.disabledPropertyColor;
    }

    public void setDisplayWritableOnly(boolean b) {
        if (this.displayWritableOnly == b) {
            return;
        }
        this.displayWritableOnly = b;
        this.firePropertyChange(PROPERTY_DISPLAY_WRITABLE_ONLY, b ? Boolean.FALSE : Boolean.TRUE, b ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getDisplayWritableOnly() {
        return this.displayWritableOnly;
    }

    void setSavedPosition(int savedPostion) {
        this.savedSplitterPosition = savedPostion;
    }

    int getSavedPosition() {
        return this.savedSplitterPosition;
    }

    private final String detachFromNode() {
        String result = null;
        if (this.activeNode != null) {
            this.activeNode.removeNodeListener(this.activeNodeListener);
            this.attached = false;
            Node.PropertySet[] oldP = this.activeNode.getPropertySets();
            if (oldP == null) {
                ErrorManager.getDefault().log(16, "Node " + this.activeNode + ": getPropertySets() returns null!");
                oldP = new Node.PropertySet[]{};
            }
            if (this.pageIndex >= 0 && this.pageIndex < oldP.length) {
                result = oldP[this.pageIndex].getDisplayName();
            }
            int i = 0;
            int tabCount = this.pages.getTabCount();
            while (i < tabCount) {
                ((PropertySheetTab)this.pages.getComponentAt(i)).detachPropertyChangeListener();
                ++i;
            }
            this.pages.removeAll();
        }
        return result;
    }

    public void addNotify() {
        super.addNotify();
        if (this.activeNode != null) {
            if (!this.attached) {
                this.attachToNode(this.activeNode);
                this.createPages();
                if (this.storedTab != null) {
                    this.navToCorrectPage(this.storedTab);
                    this.storedTab = null;
                } else if (this.pages.getTabCount() > 0) {
                    String first = this.pages.getTitleAt(0);
                    this.navToCorrectPage(first);
                } else {
                    this.add((Component)this.emptyPanel, "Center");
                }
            }
        } else {
            this.remove(this.pages);
            this.add((Component)this.emptyPanel, "Center");
        }
    }

    public void removeNotify() {
        if (this.attached) {
            this.storedTab = this.detachFromNode();
        }
        super.removeNotify();
    }

    private final void attachToNode(Node node) {
        if (this.activeNodeListener == null) {
            this.activeNodeListener = new ActiveNodeListener();
        }
        this.activeNode.addNodeListener(this.activeNodeListener);
        this.attached = true;
    }

    private final void createPages() {
        Node.PropertySet[] propsets = this.activeNode.getPropertySets();
        if (propsets == null) {
            ErrorManager.getDefault().log(16, "Node " + this.activeNode + ": getPropertySets() returns null!");
            propsets = new Node.PropertySet[]{};
        }
        int i = 0;
        int n = propsets.length;
        while (i < n) {
            Node.PropertySet set = propsets[i];
            if (!set.isHidden()) {
                this.pages.addTab(set.getDisplayName(), null, new PropertySheetTab(set, this.activeNode, this), set.getShortDescription());
            }
            ++i;
        }
    }

    private final void navToCorrectPage(String selectedTabName) {
        Component comp;
        int selected;
        if (this.isAncestorOf(this.emptyPanel)) {
            this.remove(this.emptyPanel);
        }
        this.add((Component)this.pages, "Center");
        if (selectedTabName != null) {
            this.setCurrentPage(selectedTabName);
        }
        if ((selected = this.pages.getSelectedIndex()) >= 0 && (comp = this.pages.getComponentAt(selected)) instanceof PropertySheetTab) {
            ((PropertySheetTab)comp).ensurePaneCreated();
        }
    }

    private void setCurrentNode(Node node) {
        if (this.activeNode == node) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Current node for propertysheet set from off the AWT thread: " + Thread.currentThread());
        }
        String selectedTabName = this.detachFromNode();
        this.activeNode = node;
        if (this.getParent() == null) {
            return;
        }
        if (this.activeNode != null) {
            this.attachToNode(this.activeNode);
            this.createPages();
            if (this.pages.getTabCount() > 0) {
                this.navToCorrectPage(selectedTabName);
            } else if (this.isAncestorOf(this.pages)) {
                this.remove(this.pages);
                this.add((Component)this.emptyPanel, "Center");
            }
        } else if (this.isAncestorOf(this.pages)) {
            this.remove(this.pages);
            this.add((Component)this.emptyPanel, "Center");
        }
        this.revalidate();
        this.repaint();
        if (this.activeNode != null && this.activeNode.hasCustomizer()) {
            this.firePropertyChange(PROP_HAS_CUSTOMIZER, null, Boolean.TRUE);
        } else {
            this.firePropertyChange(PROP_HAS_CUSTOMIZER, null, Boolean.FALSE);
        }
        this.firePropertyChange(PROP_PAGE_HELP_ID, null, null);
    }

    void invokeCustomization() {
        NodeOperation.getDefault().customize(this.activeNode);
    }

    void invokeHelp() {
        HelpCtx h = new HelpCtx(this.getPageHelpID());
        try {
            Class<?> c = ((ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = PropertySheet.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader)).loadClass("org.netbeans.api.javahelp.Help");
            Object o = Lookup.getDefault().lookup(c);
            if (o != null) {
                Method m = c.getMethod("showHelp", class$org$openide$util$HelpCtx == null ? (class$org$openide$util$HelpCtx = PropertySheet.class$("org.openide.util.HelpCtx")) : class$org$openide$util$HelpCtx);
                m.invoke(o, h);
                return;
            }
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, e);
        }
        Toolkit.getDefaultToolkit().beep();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$900(PropertySheet x0, Node x1) {
        x0.setCurrentNode(x1);
    }

    static /* synthetic */ int access$1200(PropertySheet x0) {
        return x0.pageIndex;
    }

    static {
        current = new ThreadLocal();
    }

    private static final class HelpAwareJTabbedPane
    extends JTabbedPane
    implements HelpCtx.Provider {
        public HelpAwareJTabbedPane() {
            if (Boolean.getBoolean("netbeans.scrolling.tabs")) {
                boolean jdk14;
                boolean bl = jdk14 = Dependency.JAVA_SPEC.compareTo(new SpecificationVersion("1.4")) >= 0;
                if (jdk14) {
                    try {
                        Method method = this.getClass().getMethod("setTabLayoutPolicy", Integer.TYPE);
                        method.invoke((Object)this, new Integer(1));
                    }
                    catch (NoSuchMethodException nme) {
                    }
                    catch (SecurityException se) {
                    }
                    catch (IllegalAccessException iae) {
                    }
                    catch (IllegalArgumentException iare) {
                    }
                    catch (InvocationTargetException ite) {
                        // empty catch block
                    }
                }
            }
        }

        public HelpCtx getHelpCtx() {
            String helpID;
            Component comp = this.getSelectedComponent();
            if (comp instanceof PropertySheetTab && (helpID = ((PropertySheetTab)comp).getHelpID()) != null) {
                return new HelpCtx(helpID);
            }
            return HelpCtx.findHelp(this.getParent());
        }
    }

    private class ActiveNodeListener
    extends NodeAdapter {
        int id;

        ActiveNodeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() != PropertySheet.this.activeNode) {
                return;
            }
            if (evt.getPropertyName() == null || "propertySets".equals(evt.getPropertyName())) {
                Mutex.EVENT.readAccess(new Runnable(this){
                    private final /* synthetic */ ActiveNodeListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        String selectedTabName = null;
                        if (PropertySheet.access$1000(ActiveNodeListener.access$1100(this.this$1)) != null) {
                            Node.PropertySet[] oldP = PropertySheet.access$1000(ActiveNodeListener.access$1100(this.this$1)).getPropertySets();
                            if (oldP == null) {
                                ErrorManager.getDefault().log(16, "Node " + PropertySheet.access$1000(ActiveNodeListener.access$1100(this.this$1)) + ": getPropertySets() returns null!");
                                oldP = new Node.PropertySet[]{};
                            }
                            if (PropertySheet.access$1200(ActiveNodeListener.access$1100(this.this$1)) >= 0 && PropertySheet.access$1200(ActiveNodeListener.access$1100(this.this$1)) < oldP.length) {
                                selectedTabName = oldP[PropertySheet.access$1200(ActiveNodeListener.access$1100(this.this$1))].getDisplayName();
                            }
                        }
                        Node old = PropertySheet.access$1000(ActiveNodeListener.access$1100(this.this$1));
                        PropertySheet.access$900(ActiveNodeListener.access$1100(this.this$1), null);
                        PropertySheet.access$900(ActiveNodeListener.access$1100(this.this$1), old);
                        if (selectedTabName != null) {
                            ActiveNodeListener.access$1100(this.this$1).setCurrentPage(selectedTabName);
                        }
                    }
                });
            }
        }

        static /* synthetic */ PropertySheet access$1100(ActiveNodeListener x0) {
            return x0.PropertySheet.this;
        }
    }

    private static class PropertySheetSettingsInvoker
    implements Runnable {
        public void run() {
            PropertySheet instance = (PropertySheet)current.get();
            current.set(null);
            if (instance == null) {
                throw new IllegalStateException();
            }
            PropertySheetSettings pss = PropertySheetSettings.getDefault();
            instance.displayWritableOnly = pss.getDisplayWritableOnly();
            instance.propertyPaintingStyle = pss.getPropertyPaintingStyle();
            instance.sortingMode = pss.getSortingMode();
            instance.plastic = pss.getPlastic();
            instance.disabledPropertyColor = pss.getDisabledPropertyColor();
            instance.valueColor = pss.getValueColor();
        }
    }
}

