/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;
import javax.swing.Timer;
import org.openide.explorer.ExplorerActions;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.SafeException;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class ExplorerPanel
extends TopComponent
implements ExplorerManager.Provider {
    static final long serialVersionUID = 5522528786650751459L;
    private static MessageFormat formatExplorerTitle;
    private ExplorerManager manager;
    private final transient PropertyChangeListener managerListener = new PropL();
    private static final ExplorerActions actions;
    private static final int INIT_DELAY = 70;
    private static final int MAX_DELAY = 350;
    private static Boolean scheduleAcivatedNodes;
    private transient DelayedSetter delayedSetter;
    static /* synthetic */ Class class$org$openide$explorer$ExplorerPanel;

    public ExplorerPanel(ExplorerManager manager) {
        this.manager = manager;
        this.setLayout(new BorderLayout());
        this.initActionMap();
        this.initListening();
    }

    public ExplorerPanel() {
        this((ExplorerManager)null);
    }

    private void initActionMap() {
        ExplorerActions a = new ExplorerActions(false);
        a.attach(this.getExplorerManager());
        this.getActionMap().put("copy-to-clipboard", a.copyAction());
        this.getActionMap().put("cut-to-clipboard", a.cutAction());
        this.getActionMap().put("paste-from-clipboard", a.pasteAction());
        this.getActionMap().put("delete", a.deleteAction());
    }

    private void initListening() {
        ExplorerManager man = this.getExplorerManager();
        man.addPropertyChangeListener(WeakListener.propertyChange(this.managerListener, man));
    }

    public void open() {
        this.open(WindowManager.getDefault().getCurrentWorkspace());
    }

    public void open(Workspace workspace) {
        super.open(workspace);
        this.setActivatedNodes(this.getExplorerManager().getSelectedNodes());
        this.updateTitle();
    }

    public synchronized ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
        }
        return this.manager;
    }

    protected void componentDeactivated() {
        if (this.getExplorerManager() == actions.getAttachedManager()) {
            actions.detach();
        }
    }

    protected void updateTitle() {
        String nm;
        Node n;
        String name = "";
        ExplorerManager em = this.getExplorerManager();
        if (em != null && (n = em.getExploredContext()) != null && (nm = n.getDisplayName()) != null) {
            name = nm;
        }
        if (formatExplorerTitle == null) {
            formatExplorerTitle = new MessageFormat(NbBundle.getMessage(class$org$openide$explorer$ExplorerPanel == null ? (class$org$openide$explorer$ExplorerPanel = ExplorerPanel.class$("org.openide.explorer.ExplorerPanel")) : class$org$openide$explorer$ExplorerPanel, "explorerTitle"));
        }
        this.setName(formatExplorerTitle.format(new Object[]{name}));
    }

    public HelpCtx getHelpCtx() {
        return ExplorerPanel.getHelpCtx(this.getExplorerManager().getSelectedNodes(), new HelpCtx(class$org$openide$explorer$ExplorerPanel == null ? (class$org$openide$explorer$ExplorerPanel = ExplorerPanel.class$("org.openide.explorer.ExplorerPanel")) : class$org$openide$explorer$ExplorerPanel));
    }

    public static HelpCtx getHelpCtx(Node[] sel, HelpCtx def) {
        HelpCtx result = null;
        int i = 0;
        while (i < sel.length) {
            HelpCtx attempt = sel[i].getHelpCtx();
            if (attempt != null && !attempt.equals(HelpCtx.DEFAULT_HELP)) {
                if (result == null || result.equals(attempt)) {
                    result = attempt;
                } else {
                    result = null;
                    break;
                }
            }
            ++i;
        }
        if (result != null) {
            return result;
        }
        return def;
    }

    public static void setConfirmDelete(boolean confirmDelete) {
        actions.setConfirmDelete(confirmDelete);
    }

    public static boolean isConfirmDelete() {
        return actions.isConfirmDelete();
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        super.writeExternal(oo);
        oo.writeObject(new NbMarshalledObject(this.manager));
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        super.readExternal(oi);
        Object anObj = oi.readObject();
        if (anObj instanceof ExplorerManager) {
            this.manager = (ExplorerManager)anObj;
            this.initActionMap();
            this.initListening();
            return;
        }
        NbMarshalledObject obj = (NbMarshalledObject)anObj;
        try {
            this.manager = (ExplorerManager)obj.get();
            this.initActionMap();
            this.initListening();
        }
        catch (SafeException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw new SafeException(ioe);
        }
    }

    private boolean delayActivatedNodes() {
        if (scheduleAcivatedNodes == null) {
            scheduleAcivatedNodes = System.getProperty("netbeans.delay.tc") != null ? (Boolean.getBoolean("netbeans.delay.tc") ? Boolean.TRUE : Boolean.FALSE) : Boolean.FALSE;
        }
        return scheduleAcivatedNodes;
    }

    private final void scheduleActivatedNodes(Node[] nodes) {
        ExplorerPanel explorerPanel = this;
        synchronized (explorerPanel) {
            if (this.delayedSetter == null) {
                this.delayedSetter = new DelayedSetter();
            }
        }
        this.delayedSetter.scheduleActivatedNodes(nodes);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        actions = new ExplorerActions();
    }

    private class DelayedSetter
    implements ActionListener {
        private Node[] nodes;
        private Timer timer;
        private boolean firstChange = true;

        DelayedSetter() {
        }

        public void scheduleActivatedNodes(Node[] nodes) {
            DelayedSetter delayedSetter = this;
            synchronized (delayedSetter) {
                this.nodes = nodes;
                if (this.timer == null) {
                    this.timer = new Timer(70, this);
                    this.timer.setCoalesce(true);
                    this.timer.setRepeats(false);
                }
                if (this.timer.isRunning()) {
                    if (this.timer.getInitialDelay() < 350) {
                        this.timer.setInitialDelay(this.timer.getInitialDelay() * 2);
                    }
                    this.firstChange = false;
                } else {
                    ExplorerPanel.this.setActivatedNodes(nodes);
                    this.firstChange = true;
                }
                this.timer.restart();
            }
        }

        public void actionPerformed(ActionEvent evt) {
            DelayedSetter delayedSetter = this;
            synchronized (delayedSetter) {
                DelayedSetter delayedSetter2 = this;
                synchronized (delayedSetter2) {
                    this.timer.stop();
                }
            }
            if (!this.firstChange) {
                ExplorerPanel.this.setActivatedNodes(this.nodes);
            }
        }
    }

    private final class PropL
    implements PropertyChangeListener {
        PropL() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() != ExplorerPanel.this.manager) {
                return;
            }
            if ("selectedNodes".equals(evt.getPropertyName())) {
                if (ExplorerPanel.this.delayActivatedNodes()) {
                    ExplorerPanel.this.scheduleActivatedNodes(ExplorerPanel.this.manager.getSelectedNodes());
                } else {
                    ExplorerPanel.this.setActivatedNodes(ExplorerPanel.this.manager.getSelectedNodes());
                }
                return;
            }
            if ("exploredContext".equals(evt.getPropertyName())) {
                ExplorerPanel.this.updateTitle();
                return;
            }
        }
    }
}

