/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.text.BreakIterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Keymap;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class NotifyDescriptor {
    public static final String PROP_MESSAGE = "message";
    public static final String PROP_MESSAGE_TYPE = "messageType";
    public static final String PROP_OPTION_TYPE = "optionType";
    public static final String PROP_OPTIONS = "options";
    public static final String PROP_VALUE = "value";
    public static final String PROP_TITLE = "title";
    public static final String PROP_DETAIL = "detail";
    public static final String PROP_VALID = "valid";
    private Object message;
    private int messageType = -1;
    private int optionType;
    private Object[] options;
    private Object[] adOptions;
    private Object value;
    private String title;
    private boolean valid = true;
    private PropertyChangeSupport changeSupport;
    public static final Object YES_OPTION = new Integer(0);
    public static final Object NO_OPTION = new Integer(1);
    public static final Object CANCEL_OPTION = new Integer(2);
    public static final Object OK_OPTION = new Integer(0);
    public static final Object CLOSED_OPTION = new Integer(-1);
    public static final int DEFAULT_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    private static final int MAXIMUM_TEXT_WIDTH = 100;
    static /* synthetic */ Class class$org$openide$NotifyDescriptor;

    public NotifyDescriptor(Object message, String title, int optionType, int messageType, Object[] options, Object initialValue) {
        this.message = message;
        this.messageType = messageType;
        this.options = options;
        this.optionType = optionType;
        this.title = title;
        this.value = initialValue;
    }

    protected void initialize() {
    }

    final void getterCalled() {
        if (this.changeSupport != null) {
            return;
        }
        boolean init = false;
        NotifyDescriptor notifyDescriptor = this;
        synchronized (notifyDescriptor) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
                init = true;
            }
        }
        if (init) {
            this.initialize();
        }
    }

    public final boolean isValid() {
        this.getterCalled();
        return this.valid;
    }

    public final void setValid(boolean newValid) {
        boolean oldValid = this.valid;
        this.valid = newValid;
        this.firePropertyChange(PROP_VALID, oldValid ? Boolean.TRUE : Boolean.FALSE, newValid ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setMessage(Object newMessage) {
        Object oldMessage = this.message;
        this.message = newMessage;
        this.firePropertyChange(PROP_MESSAGE, oldMessage, newMessage);
    }

    public Object getMessage() {
        this.getterCalled();
        return this.message;
    }

    public void setMessageType(int newType) {
        if (newType != 0 && newType != 1 && newType != 2 && newType != 3 && newType != -1) {
            throw new IllegalArgumentException("Message type must be one of the following: ERROR_MESSAGE, INFORMATION_MESSAGE, WARNING_MESSAGE, QUESTION_MESSAGE or PLAIN_MESSAGE.");
        }
        int oldType = this.messageType;
        this.messageType = newType;
        this.firePropertyChange(PROP_MESSAGE_TYPE, new Integer(oldType), new Integer(this.messageType));
    }

    public int getMessageType() {
        this.getterCalled();
        return this.messageType;
    }

    public void setOptionType(int newType) {
        if (newType != -1 && newType != 0 && newType != 1 && newType != 2) {
            throw new IllegalArgumentException("Option type must be one of the following: DEFAULT_OPTION, YES_NO_OPTION, YES_NO_CANCEL_OPTION or OK_CANCEL_OPTION.");
        }
        int oldType = this.optionType;
        this.optionType = newType;
        this.firePropertyChange(PROP_OPTION_TYPE, new Integer(oldType), new Integer(this.optionType));
    }

    public int getOptionType() {
        this.getterCalled();
        return this.optionType;
    }

    public void setOptions(Object[] newOptions) {
        Object[] oldOptions = this.options;
        this.options = newOptions;
        this.firePropertyChange(PROP_OPTIONS, oldOptions, newOptions);
    }

    public Object[] getOptions() {
        this.getterCalled();
        if (this.options != null) {
            return (Object[])this.options.clone();
        }
        return this.options;
    }

    public void setAdditionalOptions(Object[] newOptions) {
        Object[] oldOptions = this.adOptions;
        this.adOptions = newOptions;
        this.firePropertyChange(PROP_OPTIONS, oldOptions, newOptions);
    }

    public Object[] getAdditionalOptions() {
        this.getterCalled();
        if (this.adOptions != null) {
            return (Object[])this.adOptions.clone();
        }
        return null;
    }

    public void setValue(Object newValue) {
        Object oldValue = this.value;
        this.value = newValue;
        this.firePropertyChange(PROP_VALUE, oldValue, newValue);
    }

    public Object getValue() {
        this.getterCalled();
        return this.value;
    }

    public void setTitle(String newTitle) {
        String oldTitle = this.title;
        this.title = newTitle;
        this.firePropertyChange(PROP_TITLE, oldTitle, newTitle);
    }

    public String getTitle() {
        this.getterCalled();
        return this.title;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getterCalled();
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected static String getTitleForType(int messageType) {
        switch (messageType) {
            case 0: {
                return NbBundle.getMessage(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = NotifyDescriptor.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor, "NTF_ErrorTitle");
            }
            case 2: {
                return NbBundle.getMessage(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = NotifyDescriptor.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor, "NTF_WarningTitle");
            }
            case 3: {
                return NbBundle.getMessage(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = NotifyDescriptor.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor, "NTF_QuestionTitle");
            }
            case 1: {
                return NbBundle.getMessage(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = NotifyDescriptor.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor, "NTF_InformationTitle");
            }
            case -1: {
                return NbBundle.getMessage(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = NotifyDescriptor.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor, "NTF_PlainTitle");
            }
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class InputLine
    extends NotifyDescriptor {
        protected JTextField textField;
        static /* synthetic */ Class class$org$openide$NotifyDescriptor;

        public InputLine(String text, String title) {
            this(text, title, 2, -1);
        }

        public InputLine(String text, String title, int optionType, int messageType) {
            super(null, title, optionType, messageType, null, null);
            super.setMessage(this.createDesign(text));
        }

        public String getInputText() {
            return this.textField.getText();
        }

        public void setInputText(String text) {
            this.textField.setText(text);
            this.textField.selectAll();
        }

        protected Component createDesign(String text) {
            String txt;
            int index;
            char mnemonic = '\u0000';
            JPanel panel = new JPanel();
            if (text != null && (index = text.indexOf(38)) >= 0 && index + 1 < text.length()) {
                mnemonic = text.charAt(index + 1);
                txt = text.substring(0, index) + text.substring(index + 1);
            } else {
                txt = text;
            }
            JLabel textLabel = new JLabel(txt);
            if (txt != null && txt.length() > 0) {
                textLabel.setDisplayedMnemonic(mnemonic == '\u0000' ? text.charAt(0) : mnemonic);
            }
            textLabel.setBorder(new EmptyBorder(0, 0, 0, 10));
            panel.setLayout(new BorderLayout());
            panel.setBorder(new EmptyBorder(11, 12, 1, 11));
            panel.add("West", textLabel);
            this.textField = new JTextField(25);
            panel.add("Center", this.textField);
            textLabel.setLabelFor(this.textField);
            this.textField.setBorder(new CompoundBorder(this.textField.getBorder(), new EmptyBorder(2, 0, 2, 0)));
            this.textField.requestFocus();
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            Keymap map = this.textField.getKeymap();
            map.removeKeyStrokeBinding(enter);
            panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = InputLine.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor, "ACSD_InputPanel"));
            this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = InputLine.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor, "ACSD_InputField"));
            return panel;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class Exception
    extends Confirmation {
        static final long serialVersionUID = -3387516993124229948L;
        static /* synthetic */ Class class$org$openide$NotifyDescriptor;

        public Exception(Throwable detail) {
            this(detail, (Object)detail.getMessage());
            if (detail instanceof InvocationTargetException) {
                Throwable target = ((InvocationTargetException)detail).getTargetException();
                this.setMessage(target);
                if (this.getMessage() == null || "".equals(this.getMessage())) {
                    String msg = target.getMessage();
                    msg = Utilities.wrapString(msg, 100, BreakIterator.getCharacterInstance(), false);
                    this.setMessage(msg);
                }
            }
            if (this.getMessage() == null || "".equals(this.getMessage())) {
                this.setMessage(NbBundle.getMessage(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = Exception.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor, "NTF_ExceptionalException", detail.getClass().getName()));
                this.setTitle(NbBundle.getMessage(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = Exception.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor, "NTF_ExceptionalExceptionTitle"));
            }
        }

        public Exception(Throwable detail, Object message) {
            super(message, -1, 0);
            this.setTitle(NbBundle.getMessage(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = Exception.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor, "NTF_ExceptionTitle"));
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class Confirmation
    extends NotifyDescriptor {
        public Confirmation(Object message) {
            this(message, 1);
        }

        public Confirmation(Object message, String title) {
            this(message, title, 1);
        }

        public Confirmation(Object message, int optionType) {
            this(message, optionType, 3);
        }

        public Confirmation(Object message, String title, int optionType) {
            this(message, title, optionType, 3);
        }

        public Confirmation(Object message, int optionType, int messageType) {
            Object[] objectArray;
            String string = NotifyDescriptor.getTitleForType(messageType);
            if (optionType == -1) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = OK_OPTION;
            } else {
                objectArray = null;
            }
            super(message, string, optionType, messageType, objectArray, OK_OPTION);
        }

        public Confirmation(Object message, String title, int optionType, int messageType) {
            Object[] objectArray;
            if (optionType == -1) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = OK_OPTION;
            } else {
                objectArray = null;
            }
            super(message, title, optionType, messageType, objectArray, OK_OPTION);
        }
    }

    public static class Message
    extends NotifyDescriptor {
        public Message(Object message) {
            this(message, 1);
        }

        public Message(Object message, int messageType) {
            super(message, NotifyDescriptor.getTitleForType(messageType), -1, messageType, new Object[]{OK_OPTION}, OK_OPTION);
        }
    }
}

