/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.ui.wizard;

import com.sun.jdo.spi.persistence.utility.ui.wizard.AbstractWizardPanel;
import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.NoSuchElementException;
import javax.swing.JDialog;
import javax.swing.event.ChangeListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;

public abstract class AbstractWizard
implements WizardDescriptor.Iterator {
    public static final String WP_AUTO_WIZARD_STYLE = "WizardPanel_autoWizardStyle";
    public static final String WP_CONTENT_DATA = "WizardPanel_contentData";
    public static final String WP_CONTENT_DISPLAYED = "WizardPanel_contentDisplayed";
    public static final String WP_CONTENT_SEL_INDEX = "WizardPanel_contentSelectedIndex";
    public static final String WP_CONTENT_NUMBERED = "WizardPanel_contentNumbered";
    public static final String WP_HELP_DISPLAYED = "WizardPanel_helpDisplayed";
    public static final String WP_HELP_URL = "WizardPanel_helpURL";
    public static final String WP_IMAGE = "WizardPanel_image";
    protected Dialog dialog = null;
    protected Object data;
    protected WizardDescriptor.Panel[] panels;
    protected int index;
    protected WizardDescriptor descriptor = null;

    public AbstractWizard(WizardDescriptor.Panel[] panels, Object data) {
        this.panels = panels;
        this.data = data;
        this.index = 0;
        this.descriptor = new WizardDescriptor(this, data);
        this.fillStaticProperties(this.descriptor);
    }

    public AbstractWizard(WizardDescriptor.Panel[] panels) {
        this(panels, new Object());
    }

    public void setPanels(WizardDescriptor.Panel[] panels) {
        this.panels = panels;
    }

    public WizardDescriptor.Panel[] getPanels() {
        return this.panels;
    }

    public WizardDescriptor.Panel getPanel(int index) {
        return this.panels != null ? this.panels[index] : null;
    }

    public int getNumberOfPanels() {
        return this.panels != null ? this.panels.length : 0;
    }

    public int getCurrentIndex() {
        return this.index;
    }

    public WizardDescriptor getWizardDescriptor() {
        return this.descriptor;
    }

    public WizardDescriptor.Panel current() {
        return this.panels != null ? this.panels[this.index] : null;
    }

    public String name() {
        MessageFormat mf = new MessageFormat("{0}");
        Object[] args = new Object[]{new String(((AbstractWizardPanel)this.current()).getTitle())};
        return mf.format(args);
    }

    public boolean hasNext() {
        return this.panels != null ? this.index < this.panels.length - 1 : false;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public synchronized void nextPanel() {
        if (this.panels != null) {
            if (this.index + 1 == this.panels.length) {
                throw new NoSuchElementException();
            }
            ++this.index;
        }
    }

    public synchronized void previousPanel() {
        if (this.index == 0) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public Object getData() {
        return this.data;
    }

    public boolean onFinish() {
        return true;
    }

    public boolean onCancel() {
        return true;
    }

    protected Object[] getAdditionalOptions() {
        return new Object[0];
    }

    protected Object[] getClosingOptions() {
        return new Object[0];
    }

    protected Object[] getOptions() {
        if (this.panels != null && this.panels.length > 1) {
            return new Object[]{WizardDescriptor.PREVIOUS_OPTION, WizardDescriptor.NEXT_OPTION, WizardDescriptor.FINISH_OPTION, NotifyDescriptor.CANCEL_OPTION};
        }
        return new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION};
    }

    public Object executeWizard() {
        this.getDialog().show();
        return this.descriptor.getValue();
    }

    public Dialog getDialog() {
        this.fillDescriptor(this.descriptor);
        this.addListenersToDescriptor(this.descriptor);
        if (DialogDisplayer.getDefault() == null) {
            System.out.println("Can't find DialogDisplayer! Assuming module is running without IDE so creating default window");
            this.dialog = new JDialog();
            this.dialog.setSize(400, 600);
        } else {
            this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        }
        this.setAccessibleDescription();
        return this.dialog;
    }

    protected WizardDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void fillDescriptor(WizardDescriptor descriptor) {
    }

    protected void fillStaticProperties(WizardDescriptor descriptor) {
    }

    protected void setAccessibleDescription() {
    }

    protected void addListenersToDescriptor(WizardDescriptor descriptor) {
        descriptor.addPropertyChangeListener(new PropertyListener());
    }

    protected void wizardDescriptorPropertyChange(PropertyChangeEvent event) {
        Object option;
        if (event.getPropertyName().equals("value") && ((option = event.getNewValue()) == WizardDescriptor.FINISH_OPTION || option == WizardDescriptor.CANCEL_OPTION)) {
            boolean done = false;
            done = option == WizardDescriptor.FINISH_OPTION ? this.onFinish() : this.onCancel();
            if (done) {
                this.dialog.setVisible(false);
                this.dialog.dispose();
            }
        }
    }

    class PropertyListener
    implements PropertyChangeListener {
        PropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            AbstractWizard.this.wizardDescriptorPropertyChange(event);
        }
    }
}

