/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.DBElement;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.jdo.api.persistence.mapping.core.FieldHolderState;
import com.sun.jdo.api.persistence.mapping.core.PairState;
import com.sun.jdo.api.persistence.mapping.core.RelationshipState;
import com.sun.jdo.api.persistence.mapping.core.TableState;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship.RelationshipMappingStep;
import com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship.RelationshipMappingWizard;
import com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship.RelationshipTablePanel;
import com.sun.jdo.modules.persistence.mapping.core.util.DBListElement;
import com.sun.jdo.modules.persistence.mapping.core.util.Util;
import com.sun.jdo.spi.persistence.utility.ui.ComboBoxTableCellEditor;
import com.sun.jdo.spi.persistence.utility.ui.CustomListCellRenderer;
import com.sun.jdo.spi.persistence.utility.ui.CustomTableCellRenderer;
import com.sun.jdo.spi.persistence.utility.ui.IconWrapper;
import com.sun.jdo.spi.persistence.utility.ui.SwingUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public abstract class MapToKeyStep
extends RelationshipMappingStep {
    public static final int LOCAL_COLUMN = 0;
    public static final int FOREIGN_COLUMN = 1;
    private static final String ICON_ROOT = "/com/sun/jdo/modules/persistence/mapping/core/resources/";
    private RelationshipTablePanel tablePanel;
    private int panelType;

    public MapToKeyStep(RelationshipMappingWizard wizard, int type) {
        super(wizard);
        this.panelType = type;
    }

    protected abstract String getImageName();

    protected abstract String getLocalHeader();

    protected abstract String getForeignHeader();

    protected abstract List getColumnsForHeader(String var1);

    protected void addRelationshipTablePanel(JPanel containerPanel) {
        GridBagConstraints constraints = new GridBagConstraints();
        this.tablePanel = new RelationshipTablePanel(this.panelType, this);
        this.tablePanel.setImage(this.getIcon(this.getImageName()));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 100.0;
        constraints.weighty = 100.0;
        constraints.fill = 1;
        constraints.anchor = 17;
        containerPanel.add((Component)this.tablePanel, constraints);
        SwingUtils.autosizeTable(this.tablePanel.getMappingTable());
    }

    protected RelationshipTablePanel getTablePanel() {
        return this.tablePanel;
    }

    protected ImageIcon getIcon(String imageFile) {
        return new ImageIcon(this.getClass().getResource(ICON_ROOT + imageFile));
    }

    protected void clearTable() {
        this.tablePanel.clearTable();
    }

    protected void updateCellEditors() {
        JTable table = this.getTablePanel().getMappingTable();
        this.buildCellEditor(table.getColumn(this.getLocalHeader()));
        this.buildCellEditor(table.getColumn(this.getForeignHeader()));
    }

    private void buildCellEditor(TableColumn tableColumn) {
        tableColumn.setCellRenderer(new CustomTableCellRenderer());
        tableColumn.setCellEditor(new ComboBoxTableCellEditor((ListCellRenderer)new CustomListCellRenderer()){

            public final Component getEditorComponent(JTable table, Object value, boolean selected, int row, int col) {
                List elements = MapToKeyStep.this.getColumnsForHeader(table.getColumnName(col));
                Object[] items = elements != null ? DBListElement.convertArray(elements, MapToKeyStep.this.getMappingContext().getString("VALUE_column"), true) : new DBListElement[]{};
                this.setItems(MapToKeyStep.this.getChoicesForValue(items, value));
                return super.getEditorComponent(table, value, selected, row, col);
            }
        });
    }

    private Object[] getChoicesForValue(Object[] choices, Object value) {
        if (value instanceof IconWrapper) {
            int length = choices != null ? choices.length : 0;
            Object[] newChoices = new Object[length + 1];
            newChoices[0] = value;
            System.arraycopy(choices, 0, newChoices, 1, length);
            return newChoices;
        }
        return choices;
    }

    private int getColumnType() {
        return this.panelType == 2 ? 1 : 0;
    }

    private ColumnElement getColumnElementAt(DefaultTableModel tableModel, int row, int column) {
        Object value = tableModel.getValueAt(row, column);
        DBListElement listElement = value instanceof DBListElement ? (DBListElement)value : null;
        return listElement != null ? (ColumnElement)listElement.getFirstElement() : null;
    }

    public void processInsert(TableModelEvent evt) {
        FieldHolderState holderState = this.getHolderState();
        RelationshipElement field = this.getField();
        RelationshipState relationshipState = this.getRelationshipState();
        DefaultTableModel tableModel = (DefaultTableModel)evt.getSource();
        int columnType = this.getColumnType();
        int lLastRow = evt.getLastRow();
        if (!this.areListenersDisabled()) {
            holderState.editFieldMapping((PersistenceFieldElement)field, relationshipState);
        }
        for (int i = evt.getFirstRow(); i <= lLastRow; ++i) {
            ColumnElement local = this.getColumnElementAt(tableModel, i, 0);
            ColumnElement foreign = this.getColumnElementAt(tableModel, i, 1);
            if (!holderState.hasPairAt(i, field, columnType)) {
                holderState.addColumnPair(local, foreign, field, columnType);
                continue;
            }
            holderState.editColumnPair(i, local, foreign, field, columnType, relationshipState);
        }
        if (!this.areListenersDisabled()) {
            this.fireChange();
        }
    }

    public void processUpdate(TableModelEvent evt) {
        FieldHolderState holderState = this.getHolderState();
        RelationshipElement field = this.getField();
        RelationshipState relationshipState = this.getRelationshipState();
        DefaultTableModel tableModel = (DefaultTableModel)evt.getSource();
        int columnType = this.getColumnType();
        int lLastRow = evt.getLastRow();
        for (int i = evt.getFirstRow(); i <= lLastRow; ++i) {
            ColumnElement local = this.getColumnElementAt(tableModel, i, 0);
            ColumnElement foreign = this.getColumnElementAt(tableModel, i, 1);
            holderState.editColumnPair(i, local, foreign, field, columnType, relationshipState);
        }
        if (!this.areListenersDisabled()) {
            this.fireChange();
        }
    }

    public void processDelete(TableModelEvent evt) {
        FieldHolderState holderState = this.getHolderState();
        RelationshipElement field = this.getField();
        RelationshipState relationshipState = this.getRelationshipState();
        DefaultTableModel tableModel = (DefaultTableModel)evt.getSource();
        int columnType = this.getColumnType();
        int lFirstRow = evt.getFirstRow();
        if (!this.areListenersDisabled()) {
            holderState.editFieldMapping((PersistenceFieldElement)field, relationshipState);
        }
        for (int i = evt.getLastRow(); i >= lFirstRow; --i) {
            holderState.removeColumnPair(i, field, columnType);
        }
        if (!this.areListenersDisabled()) {
            this.fireChange();
        }
    }

    private Object getValueForColumn(String columnName, TableState tableState) {
        ColumnElement column = tableState.getColumn(columnName);
        return column != null ? new DBListElement((DBElement)column, true, this.getMappingContext().getString("VALUE_unmapped")) : new IconWrapper(columnName, Util.getIllegalIcon());
    }

    protected List getLocalColumns() {
        return this.getHolderState().getSortedAllColumns();
    }

    protected List getJoinColumns() {
        RelationshipState state = this.getRelationshipState();
        TableElement joinTable = state != null ? this.getTable(state.getJoinTable()) : null;
        return joinTable != null ? FieldHolderState.getSortedAllColumns(joinTable) : new ArrayList();
    }

    protected List getForeignColumns() {
        FieldHolderState holder = this.getHolderState();
        String relatedClass = holder.getCurrentRelatedClass(this.getField());
        return relatedClass != null ? holder.getTableState(relatedClass).getSortedAllColumns() : null;
    }

    public boolean isValid() {
        PairState pairState = this.getPairState();
        return this.getRelationshipState() != null && pairState.hasCompleteRows() && !pairState.hasInvalidPairs();
    }

    protected PairState getPairState() {
        RelationshipState state = this.getRelationshipState();
        return state != null ? state.getColumnPairState() : null;
    }

    protected void populateTableFromColumns(PairState pairState) {
        DefaultTableModel tableModel = this.tablePanel.getMappingTableModel();
        TableState tableState = pairState.getTableState();
        JTable mappingTable = this.tablePanel.getMappingTable();
        List columnPairs = pairState.getAllColumnPairs();
        Iterator iterator = columnPairs.iterator();
        while (iterator.hasNext()) {
            Object[] nextPair = (String[])iterator.next();
            if (!PairState.isCompletePair(nextPair)) continue;
            Object[] lRow = new Object[]{this.getValueForColumn((String)nextPair[0], tableState), this.getValueForColumn((String)nextPair[1], tableState)};
            tableModel.addRow(lRow);
        }
        if (columnPairs.size() == 0 || tableModel.getRowCount() == 0) {
            this.tablePanel.insertRow();
        }
        SwingUtils.autosizeTable(mappingTable);
        if (mappingTable.getRowCount() > 0) {
            SwingUtils.selectNearestRow(mappingTable, 0);
        }
    }
}

