/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.websrv.wizard;

import com.sun.enterprise.tools.deployment.ui.utils.FileTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledHTMLText;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.websrv.wizard.InputTypePanel;
import com.sun.enterprise.tools.deployment.ui.websrv.wizard.WebServiceWizard;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.help.CSH;
import javax.swing.JRadioButton;

public class ComponentTypePanel
extends UIPanel {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(InputTypePanel.class);
    private static final String COMPONENT_PNL_ACC_DSC = localStrings.getLocalString("ui.componenttypepanel.component_panel.acc_dsc", "This wizard will generate a web service component. If you provide either a WSDL file, or an endpoint interface and implementation, the wizard will generate the additional files necessary to create a web service component.");
    private static final String COMPONENT_TYPE = localStrings.getLocalString("ui.componenttypepanel.component_type.rblabel", "Please choose the type of component you want to create:");
    private static final String COMPONENT_TYPE_ACC_DESC = localStrings.getLocalString("ui.componenttypepanel.component_type.acc_desc", "Please choose the type of component you want to create: Web Service Endpoint or Web Service Client.");
    private static final String ENDPOINT_LABEL = localStrings.getLocalString("ui.componenttypepanel.endpoint.rboption", "Web Service Endpoint");
    private static final String ENDPOINT_ACC_DESC1 = localStrings.getLocalString("ui.componenttypepanel.endpoint.acc_desc1", "Choose this option to create a web service endpoint.");
    private static final String ENDPOINT_ACC_DESC2 = localStrings.getLocalString("ui.componenttypepanel.endpoint.acc_desc2", "The methods of this endpoint will be invoked by web service clients.");
    private static final String ENDPOINT_ACC_DESC = ENDPOINT_ACC_DESC1 + ENDPOINT_ACC_DESC2;
    private static final String ENDPOINT_HTML_DESC = "<HTML><I>" + ENDPOINT_ACC_DESC1 + "<br>" + ENDPOINT_ACC_DESC2 + "</I></HTML>";
    private static final String ENDPOINT_MN = localStrings.getLocalString("ui.componenttypepanel.endpoint.mnemonic", "E");
    private static final String CLIENT_LABEL = localStrings.getLocalString("ui.comonenttypepanel.client.rboption", "Web Service Client");
    private static final String CLIENT_ACC_DESC = localStrings.getLocalString("ui.componenttypepanel.client.acc_desc", "Choose this option to generate the items necessary for a client to invoke methods on a web service.");
    private static final String CLIENT_HTML_DESC = "<HTML><I>" + CLIENT_ACC_DESC + "</I></HTML>";
    private static final String CLIENT_MN = localStrings.getLocalString("ui.componenttypepanel.client.mnemonic", "S");
    static final String OUTPUT_DIR = localStrings.getLocalString("ui.componenttypepanel.output_dir.tflabel", "Output Directory:");
    private static final String OUTPUT_DIR_ACC_DESC = localStrings.getLocalString("ui.componenttypepanel.output_dir.acc_desc", "Use the Browse button to choose the directory where the generated files will reside.");
    private static final String OUTPUT_DIR_MN = localStrings.getLocalString("ui.componenttypepanel.output_dir.mnemonic", "O");
    private static final String OUTPUT_DIR_BROWSE_BTN_MN = localStrings.getLocalString("ui.componenttypepanel.output_dir_browse_btn.mnemonic", "r");
    private UIRadioButtonBox compType = null;
    private JRadioButton rb_Endpoint = null;
    private JRadioButton rb_Client = null;
    private UITitledTextField outputDir = null;
    private UITitledHTMLText endpointText = null;
    private UITitledHTMLText clientText = null;
    private UITitledHTMLText compTypeLabel = null;

    private static final String NOT_DIR_ERR(String v0) {
        return localStrings.getLocalString("ui.componenttypepanel.notdir.err", "{0} is a file. Please specify a directory.", new Object[]{v0});
    }

    private static final String NO_WRITE_PERMISSION_ERR(String v0) {
        return localStrings.getLocalString("ui.componenttypepanel.nowritepermission.err", "No write permission for {0}.  Please choose another Output Directory.", new Object[]{v0});
    }

    private static final String CREATE_DIR_ERR(String v0) {
        return localStrings.getLocalString("ui.componenttypepanel.createdir.err", "Error creating directory: {0}.", new Object[]{v0});
    }

    private static final String ASK_CREATE_DIR(String v0) {
        return localStrings.getLocalString("ui.componenttypepanel.createdir.ask", "{0} does not exist.  Do you want to create this directory now?", new Object[]{v0});
    }

    private static final String NO_PERMISSION_ERR(String v0) {
        return localStrings.getLocalString("ui.componenttypepanel.nopermission.err", "You do not have permission to create the directory: {0}.", new Object[]{v0});
    }

    private static final String INVALID_DIR_ERR(String v0) {
        return localStrings.getLocalString("ui.componenttypepanel.invaliddir.err", "{0} is not a valid directory name.  Please specify the complete output directory path name.", new Object[]{v0});
    }

    public String getHelpID() {
        return "Component";
    }

    public ComponentTypePanel() {
        super(WebServiceWizard.WIZARD_TITLE_NEW + " " + WebServiceWizard.COMPONENT_TYPE_TITLE, COMPONENT_PNL_ACC_DSC);
        this.initializeLayout();
    }

    private void initializeLayout() {
        CSH.setHelpIDString((Component)this, (String)("SW" + this.getHelpID()));
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        this.compTypeLabel = new UITitledHTMLText(null, false, false);
        this.compTypeLabel.setText(COMPONENT_TYPE);
        this.compTypeLabel.setAccessibleDescription(COMPONENT_TYPE_ACC_DESC);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(20, 5, 0, 5);
        c.fill = 2;
        c.anchor = 10;
        this.add((Component)this.compTypeLabel, c);
        this.compType = new UIRadioButtonBox(null, false);
        this.compType.setAccessibleDescription(COMPONENT_TYPE_ACC_DESC);
        c.weightx = 0.5;
        c.weighty = 0.1;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 5, 5, 5);
        c.fill = 1;
        c.anchor = 11;
        this.add((Component)this.compType, c);
        this.compType.getGBConstraints().insets.left += 10;
        this.rb_Endpoint = UIRadioButtonBox.createRadioButton(ENDPOINT_LABEL, ENDPOINT_MN.charAt(0));
        this.rb_Endpoint.getAccessibleContext().setAccessibleDescription(ENDPOINT_ACC_DESC);
        this.rb_Endpoint.setVerticalTextPosition(1);
        this.rb_Endpoint.setSelected(true);
        this.compType.addItem(this.rb_Endpoint);
        this.endpointText = new UITitledHTMLText(null, false, false);
        this.endpointText.setText(ENDPOINT_HTML_DESC);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 30, 15, 5);
        c.fill = 1;
        c.anchor = 10;
        this.compType.add((Component)this.endpointText, c);
        this.rb_Client = UIRadioButtonBox.createRadioButton(CLIENT_LABEL, CLIENT_MN.charAt(0));
        this.rb_Client.getAccessibleContext().setAccessibleDescription(CLIENT_ACC_DESC);
        this.rb_Client.setVerticalTextPosition(1);
        this.compType.addItem(this.rb_Client);
        this.clientText = new UITitledHTMLText(null, false, false);
        this.clientText.setText(CLIENT_HTML_DESC);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 30, 20, 5);
        c.fill = 1;
        c.anchor = 10;
        this.compType.add((Component)this.clientText, c);
        this.outputDir = new UITitledTextField(OUTPUT_DIR, false);
        this.outputDir.setMnemonic(OUTPUT_DIR_MN.charAt(0));
        this.outputDir.setToolTipText(OUTPUT_DIR_ACC_DESC);
        this.outputDir.setAccessibleDescription(OUTPUT_DIR_ACC_DESC);
        this.outputDir.setRequired(true);
        this.outputDir.setBrowserFilterKey(null);
        this.outputDir.setBrowserMnemonic(OUTPUT_DIR_BROWSE_BTN_MN.charAt(0));
        c.weighty = 0.9;
        c.gridy = 2;
        c.insets = new Insets(5, 5, 5, 150);
        c.fill = 2;
        c.anchor = 11;
        this.add((Component)this.outputDir, c);
    }

    boolean isEndpoint() {
        return this.rb_Endpoint.isSelected();
    }

    boolean isClient() {
        return this.rb_Client.isSelected();
    }

    public String getOutputDirectory() {
        return this.outputDir.getText();
    }

    public boolean isOutputDirectoryValid() {
        boolean valid = true;
        if (FileTools.validateFileName(this, this.getOutputDirectory())) {
            File f = new File(this.getOutputDirectory());
            if (f.exists()) {
                if (f.isFile()) {
                    valid = false;
                    UIOptionPane.showErrorDialog(this, ComponentTypePanel.NOT_DIR_ERR(f.getName()));
                } else if (!f.canWrite()) {
                    valid = false;
                    UIOptionPane.showErrorDialog(this, ComponentTypePanel.NO_WRITE_PERMISSION_ERR(f.getAbsolutePath()));
                }
            } else {
                File canonFile = null;
                try {
                    canonFile = f.getCanonicalFile();
                }
                catch (IOException ioe) {
                    UIOptionPane.showErrorDialog(this, ComponentTypePanel.CREATE_DIR_ERR(this.getOutputDirectory()));
                    Print.dprintStackTrace((String)ComponentTypePanel.CREATE_DIR_ERR(this.getOutputDirectory()), (Throwable)ioe);
                }
                if (f.equals(canonFile)) {
                    if (UIOptionPane.showYesNoDialog(this, ComponentTypePanel.ASK_CREATE_DIR(this.getOutputDirectory()))) {
                        valid = f.mkdirs();
                        if (!valid) {
                            UIOptionPane.showErrorDialog(this, ComponentTypePanel.NO_PERMISSION_ERR(this.getOutputDirectory()));
                        }
                    } else {
                        valid = false;
                    }
                } else {
                    valid = false;
                    UIOptionPane.showErrorDialog(this, ComponentTypePanel.INVALID_DIR_ERR(this.getOutputDirectory()));
                }
            }
        } else {
            valid = false;
        }
        return valid;
    }
}

