/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.websrv;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.common.dd.CallProperty;
import com.sun.enterprise.tools.common.dd.PortInfo;
import com.sun.enterprise.tools.common.dd.ServiceRef;
import com.sun.enterprise.tools.common.dd.StubProperty;
import com.sun.enterprise.tools.common.dd.SunBaseBean;
import com.sun.enterprise.tools.common.dd.WsdlPort;
import com.sun.enterprise.tools.common.dd.appclient.SunApplicationClient;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.table.TableCellEditor;

public class WebServiceReference
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebServiceReference.class);
    private static final String TABNAME = localStrings.getLocalString("ui.webservicereference.tabname", "Web Service References");
    private static final String SERVICE_REF_DIALOG_TITLE = localStrings.getLocalString("ui.webservicereference.service_ref_dialog_title", "Web Service References Sun-specific Settings");
    private static final String EJB_LIST_HEADER = localStrings.getLocalString("ui.webservicereference.ejb_list_header", "Service References in JAR File");
    private static final String APP_CLIENT_LIST_HEADER = localStrings.getLocalString("ui.webservicereference.app_client_list_header", "Service References in JAR File");
    private static final String WEB_LIST_HEADER = localStrings.getLocalString("ui.webservicereference.web_list_header", "Service References in WAR File");
    private static final String INITIAL_PORT_SETTINGS_TABLE_TITLE = localStrings.getLocalString("ui.webservicereference.portsettings.table.title.initial", "Port Settings");
    private static final String INITIAL_CALL_PROPS_TABLE_TITLE = localStrings.getLocalString("ui.webservicereference.callproperties.table.title.initial", "Call Properties");
    private static final String CALL_PROPS_TABLE_PROP_NAME = localStrings.getLocalString("ui.webservicereference.callproperties.table.prop.name", "Property Name");
    private static final String CALL_PROPS_TABLE_VALUE_NAME = localStrings.getLocalString("ui.webservicereference.callproperties.table.prop.value", "Value");
    private static final String PORT_SETTINGS_TABLE_PANEL_NAME = localStrings.getLocalString("ui.webservicereference.portsettings.table.panel.name", "Port Settings Table Panel Name");
    private static final String CALL_PROPS_TABLE_PANEL_NAME = localStrings.getLocalString("ui.webservicereference.callproperties.table.panel.name", "Call Properties Table Panel Name");
    private static final String CALL_PROPS_TABLE_TOOLTIP = localStrings.getLocalString("ui.webservicereference.callproperties.table.tooltip", "Table of Call Properties");
    private static final String PORT_SETTINGS_TABLE_TOOLTIP = localStrings.getLocalString("ui.webservicereference.portsettings.table.tooltip", "Table of Port Settings");
    private static final String PORT_SETTINGS_TABLE_SERVICE_ENDPOINT_INTERFACE = localStrings.getLocalString("ui.webservicereference.portsettings.table.service.endpoint", "Service Endpoint Int.");
    private static final String PORT_SETTINGS_TABLE_QNAME_NAMESPACE = localStrings.getLocalString("ui.webservicereference.portsettings.table.qname.namespace", "Q-Name Namespace");
    private static final String PORT_SETTINGS_TABLE_QNAME_LOCALPART = localStrings.getLocalString("ui.webservicereference.portsettings.table.qname.localpart", "Q-Name Local Part");
    private static final String PORT_SETTINGS_TABLE_STUB = localStrings.getLocalString("ui.webservicereference.portsettings.table.stub", "Stub");
    private static final String PORT_SETTINGS_TABLE_CALL = localStrings.getLocalString("ui.webservicereference.portsettings.table.call", "Call");
    private static final String STUB_PROPS_TABLE_TOOLTIP = localStrings.getLocalString("ui.webservicereference.stub.props.table.tooltip", "Table of Stub Properties");
    private static final String QNAME_WILL_BE_REMOVED = localStrings.getLocalString("ui.webservicereference.portsettings.qname_will_be_removed", "The selected ServiceEndpointInterface has Port Component Name specified\nQ-Name Namespace and Q-Name Localpart will be removed.\n Do you want to continue ?");
    private static final String CONFIRM_TITLE = localStrings.getLocalString("ui.webservicereference.portsettings.confirm_title", "Port Component Name conflict");
    private static final String STUB_TABLE_PROPERTY_NAME_COLUMN = localStrings.getLocalString("ui.webservicereference.stub.props.table.namecolumn", "Property Name");
    private static final String STUB_TABLE_PROPERTY_VALUE_COLUMN = localStrings.getLocalString("ui.webservicereference.stub.props.table.valuecolumn", "Value");
    private static final String DUPLICATE_SEI_ERROR_DIALOG_TITLE = localStrings.getLocalString("ui.webservicereference.sei.errordialog.title", "Duplicate Service Endpoint Interface");
    private static final String WSDL_OVERRIDE_LOCATION_TITLE = localStrings.getLocalString("ui.webservicereference.wsdl.override.location", "WSDL Override Location:");
    private static final String CALL_COLUMN_HEADER_VALUE = localStrings.getLocalString("ui.webservicereference.call.column.header.value", "Call");
    private static final String STUB_COLUMN_HEADER_VALUE = localStrings.getLocalString("ui.webservicereference.stub.column.header.value", "Stub");
    private static final char ADD_PORT_MNEMONIC = localStrings.getLocalString("ui.webservicereference.port_add_mnemonic", "P").charAt(0);
    private static final char DELETE_PORT_MNEMONIC = localStrings.getLocalString("ui.webservicereference.port_del_mnemonic", "E").charAt(0);
    private static String wizardHelpID = "WSReferencesDS";
    private static String deployHelpID = "WSReferencesDS";
    private static String stubDialogHelpID = "DS_WebServiceReference_StubDialog";
    private static String callDialogHelpID = "DS_WebServiceReference_CallDialog";
    private PortSettingsTable portSettingsTable = null;
    private CallPropertiesTable callPropertiesTable = null;
    private UITitledBox portSettingsTablePanel = null;
    private UITitledBox callPropsTablePanel = null;
    private StubDialog stubDialog = null;
    private StubDialog callDialog = null;
    private JButton callPropsAddPB = null;
    private JButton portAddPB = null;
    private UITitledTextField wsdlPublishLocationValueText = null;
    private ServiceReferenceDescriptor descriptor = null;
    private ServiceRef sunServiceRef = null;
    private ServiceRef sunServiceRefOrig = null;
    private static InspectorPane.InspectorPaneDialog webSrvRefDialog = null;

    private static final String SERVICE_REF_DIALOG_TITLE_NAME(String v0) {
        return localStrings.getLocalString("ui.webservicereference.service_ref_dialog_title_name", "Web Service References Sun-specific Settings - {0}", new Object[]{v0});
    }

    private static final String ADDING_DUPLICATE_SEI(String v0) {
        return localStrings.getLocalString("ui.webservicereference.sei.duplicate.error", "Attempting to add duplicate Service Endpoint Interface - {0}", new Object[]{v0});
    }

    private static final String STUB_DIALOG_TITLE(String v0) {
        return localStrings.getLocalString("ui.webservicereference.stubproperties.dialog.title", "Stub Properties - {0}", new Object[]{v0});
    }

    private static final String CALL_DIALOG_TITLE(String v0) {
        return localStrings.getLocalString("ui.webservicereference.callproperties.dialog.title", "Call Properties - {0}", new Object[]{v0});
    }

    private static final String MISSING_PROP_NAME(String v0) {
        return localStrings.getLocalString("ui.webservicereference.stub.missing_prop_name", "Properties Name for row #{0} must be specified", new Object[]{v0});
    }

    private static final String MISSING_VALUE(String v0) {
        return localStrings.getLocalString("ui.webservicereference.stub.missing_value", "Value must be specified for Property {0}", new Object[]{v0});
    }

    private static final String MISSING_PORT_VALUE(String v0) {
        return localStrings.getLocalString("ui.webservicereference.portsettings.missing_all", "Either Service Endpoint Interface or Q-Name must be specified for row {0}", new Object[]{v0});
    }

    private static final String MISSING_QNAME(String v0) {
        return localStrings.getLocalString("ui.webservicereference.portsettings.missing_qname", "Both Q-Name NamespaceURI and Q-Name LocalPart for row {0} must be specified", new Object[]{v0});
    }

    public static InspectorPane newInspectorPane(String mode) {
        return new WebServiceReference(mode);
    }

    public String getTabName() {
        return "N/A";
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public void showDialog(ServiceReferenceDescriptor srd) {
        this.setDescriptor((Descriptor)srd);
        this.show();
    }

    public Class getDescriptorClass() {
        return ServiceReferenceDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public Descriptor getSelectedComponent() {
        Descriptor desc = this.getDescriptor();
        if (desc instanceof WServiceReferenceDescriptor) {
            return ((WServiceReferenceDescriptor)desc).getServiceReferenceDescriptor();
        }
        return desc;
    }

    public void setDescriptor(Descriptor d) {
        if (d instanceof ServiceReferenceDescriptor) {
            this.descriptor = (ServiceReferenceDescriptor)d;
            webSrvRefDialog.setTitle(WebServiceReference.SERVICE_REF_DIALOG_TITLE_NAME(this.descriptor.getDisplayName()));
        } else {
            this.descriptor = null;
        }
    }

    public void setSunDescriptor(ServiceRef sunSr) {
        this.sunServiceRefOrig = sunSr;
        this.sunServiceRef = (ServiceRef)sunSr.clone();
    }

    private ServiceRef getSelectedSunComponent() {
        return this.sunServiceRef;
    }

    private ServiceRef findAndLinkServiceRef(ServiceReferenceDescriptor srDol) {
        SunApplicationClient sac;
        ServiceRef sr = (ServiceRef)SunOneUtils.getSunDescriptor((Descriptor)srDol);
        if (sr != null) {
            return sr;
        }
        BundleDescriptor dsd = srDol.getBundleDescriptor();
        if (dsd == null) {
            Print.dprintln((String)"findAndLinkServiceRef: bundleDescriptor of ServiceReferenceDescriptor is NULL");
            return null;
        }
        SunBaseBean sbb = SunOneUtils.getSunDescriptor((Descriptor)dsd);
        if (dsd instanceof EjbBundleDescriptor) {
            Ejb sunEjb;
            EjbDescriptor ejbDesc = DescriptorTools.getEjbOfServiceReferenceDescriptor(srDol);
            if (ejbDesc == null) {
                Print.dprintln((String)"No EJB found for this ServiceReferenceDescriptor !!");
            }
            if ((sr = this.searchServiceRef((sunEjb = (Ejb)SunOneUtils.getSunDescriptor((Descriptor)ejbDesc)).getServiceRef(), srDol.getDisplayName())) == null) {
                sr = new ServiceRef();
                sr.setServiceRefName(srDol.getDisplayName());
                sunEjb.addServiceRef(sr);
            }
        } else if (dsd instanceof WebBundleDescriptor) {
            SunWebApp swa = (SunWebApp)sbb;
            sr = this.searchServiceRef(swa.getServiceRef(), srDol.getDisplayName());
            if (sr == null) {
                sr = new ServiceRef();
                sr.setServiceRefName(srDol.getDisplayName());
                swa.addServiceRef(sr);
            }
        } else if (dsd instanceof ApplicationClientDescriptor && (sr = this.searchServiceRef((sac = (SunApplicationClient)sbb).getServiceRef(), srDol.getDisplayName())) == null) {
            sr = new ServiceRef();
            sr.setServiceRefName(srDol.getDisplayName());
            sac.addServiceRef(sr);
        }
        SunOneUtils.setSunDescriptor((Descriptor)srDol, (SunBaseBean)sr);
        return sr;
    }

    private ServiceRef searchServiceRef(ServiceRef[] rrArray, String name) {
        if (rrArray == null) {
            return null;
        }
        for (int i = 0; i < rrArray.length; ++i) {
            if (!name.equals(rrArray[i].getServiceRefName())) continue;
            return rrArray[i];
        }
        return null;
    }

    public WebServiceReference(String mode) {
        this.setInspectorMode(mode);
        this.initCustomizer();
    }

    protected void initCustomizer() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.portSettingsTable = new PortSettingsTable(new PortSettingsTableModel());
        this.callPropertiesTable = new CallPropertiesTable(new CallPropertiesTableModel());
        this.portSettingsTablePanel = new UITitledBox(INITIAL_PORT_SETTINGS_TABLE_TITLE, true);
        this.callPropsTablePanel = new UITitledBox(INITIAL_CALL_PROPS_TABLE_TITLE, true);
        ActionListener portActions = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (cmd.equals("add")) {
                    WebServiceReference.this.addPortAction();
                } else if (cmd.equals("delete")) {
                    WebServiceReference.this.deletePortAction();
                } else {
                    Print.printStackTrace((String)("Unknown action-command: " + cmd));
                }
            }
        };
        ActionListener callPropertyActions = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (cmd.equals("add")) {
                    WebServiceReference.this.addPropertyAction();
                } else if (cmd.equals("delete")) {
                    WebServiceReference.this.deletePropertyAction();
                } else {
                    Print.printStackTrace((String)("Unknown action-command: " + cmd));
                }
            }
        };
        UITitledTable portSettingsTableBox = new UITitledTable(null, false);
        this.portAddPB = UIButton.createAddButton(localStrings.getLocalString("ui.webservicereference.port_add", "Add Port"), ADD_PORT_MNEMONIC, portActions, false);
        portSettingsTableBox.addControlButton(this.portAddPB);
        UIButton portDelPB = UIButton.createDeleteButton(localStrings.getLocalString("ui.webservicereference.port_del", "Delete Port..."), DELETE_PORT_MNEMONIC, portActions, true);
        portSettingsTableBox.addSelectionEnabledButton(portDelPB);
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 0, 5, 0);
        c.fill = 1;
        this.portSettingsTablePanel.add((Component)portSettingsTableBox, c);
        portSettingsTableBox.setTableView(this.portSettingsTable);
        UITitledTable callPropertiesTableBox = new UITitledTable(null, false);
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 0, 5, 0);
        c.fill = 1;
        this.callPropsTablePanel.add((Component)callPropertiesTableBox, c);
        callPropertiesTableBox.setTableView(this.callPropertiesTable);
        this.callPropsAddPB = UIButton.createAddButton(callPropertyActions);
        callPropertiesTableBox.addControlButton(this.callPropsAddPB);
        UIButton callPropsDelPB = UIButton.createDeleteButton(callPropertyActions, true);
        callPropertiesTableBox.addSelectionEnabledButton(callPropsDelPB);
        c.weightx = 1.0;
        c.weighty = 0.7;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        this.add((Component)this.portSettingsTablePanel, c);
        c.weightx = 1.0;
        c.weighty = 0.7;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        this.add((Component)this.callPropsTablePanel, c);
        UIPanel wsdlPublishLocationTextPanel = new UIPanel(new GridBagLayout());
        this.wsdlPublishLocationValueText = new UITitledTextField(WSDL_OVERRIDE_LOCATION_TITLE, false);
        this.wsdlPublishLocationValueText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                WebServiceReference.this.storeWSDLPublishLocationValue(WebServiceReference.this.wsdlPublishLocationValueText.getText());
            }
        });
        this.wsdlPublishLocationValueText.setBrowserActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebServiceReference.this.browsePublishLocation();
            }
        });
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        wsdlPublishLocationTextPanel.add((Component)this.wsdlPublishLocationValueText, c);
        this.add((Component)wsdlPublishLocationTextPanel, c);
        this.disableUIComponents();
    }

    public static InspectorPane.InspectorPaneDialog createDialog(InspectorPane.InspectorPaneOwner inspOwner, Component winOwner, boolean modal, String mode) {
        WebServiceReference wsr = (WebServiceReference)WebServiceReference.newInspectorPane(mode);
        webSrvRefDialog = wsr.createInspectorPaneDialog(inspOwner, winOwner, true);
        webSrvRefDialog.setDisposeOnHide(true);
        webSrvRefDialog.setTitle(SERVICE_REF_DIALOG_TITLE);
        webSrvRefDialog.setSize(600, 500);
        webSrvRefDialog.centerOnScreen();
        return webSrvRefDialog;
    }

    public void updateView() {
        if (this.getSelectedComponent() != null) {
            this.portSettingsTable.updateTableData(this.getSelectedSunComponent().getPortInfo());
            this.callPropertiesTable.updateTableData(this.getSelectedSunComponent().getCallProperty());
            this.wsdlPublishLocationValueText.setText(this.getSelectedSunComponent().getWsdlOverride());
            this.enableUIComponents();
        } else {
            this.portSettingsTable.clearTableData();
            this.callPropertiesTable.clearTableData();
            this.portSettingsTablePanel.setTitle(INITIAL_PORT_SETTINGS_TABLE_TITLE);
            this.callPropsTablePanel.setTitle(INITIAL_CALL_PROPS_TABLE_TITLE);
            this.wsdlPublishLocationValueText.setText("");
            this.disableUIComponents();
        }
    }

    private void storeWSDLPublishLocationValue(String value) {
        ServiceRef serviceRef = this.getSelectedSunComponent();
        if (serviceRef != null) {
            serviceRef.setWsdlOverride(value);
            this.getDescriptor().changed();
        }
    }

    private void addPropertyAction() {
        if (this.callPropertiesTable.getRowWithValue(0, "") == null) {
            this.getSelectedSunComponent().addCallProperty(new CallProperty());
        }
        this.callPropertiesTable.selectRowWithValueOnUpdate(0, "");
        this.invoke_refresh();
    }

    private void deletePropertyAction() {
        Object[] list = this.callPropertiesTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                CallProperty callProperty = (CallProperty)list[i];
                this.getSelectedSunComponent().removeCallProperty(callProperty);
            }
            this.invoke_refresh();
        }
    }

    private void addPortAction() {
        int row = this.portSettingsTable.getEmptyRowNumber();
        if (row == -1) {
            PortInfo pi = new PortInfo();
            this.getSelectedSunComponent().addPortInfo(pi);
            this.portSettingsTable.selectRowWithValueOnUpdate(0, "");
        } else {
            this.portSettingsTable.setSelectedIndex(row);
        }
        this.invoke_refresh();
    }

    private void deletePortAction() {
        Object[] list = this.portSettingsTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                PortInfo pi = (PortInfo)list[i];
                this.getSelectedSunComponent().removePortInfo(pi);
            }
            this.invoke_refresh();
        }
    }

    private void disableUIComponents() {
        this.callPropsAddPB.setEnabled(false);
        this.portAddPB.setEnabled(false);
    }

    private void enableUIComponents() {
        this.portAddPB.setEnabled(true);
        this.callPropsAddPB.setEnabled(true);
    }

    private void invoke_refresh() {
        this.portSettingsTable.updateTableData(this.getSelectedSunComponent().getPortInfo());
        this.callPropertiesTable.updateTableData(this.getSelectedSunComponent().getCallProperty());
        this.wsdlPublishLocationValueText.setText(this.getSelectedSunComponent().getWsdlOverride());
    }

    public void refresh() {
        this.updateView();
    }

    protected String getComponentListHeader() {
        Descriptor dsd = this.getDescriptor();
        if (dsd instanceof EjbBundleDescriptor) {
            return EJB_LIST_HEADER;
        }
        if (dsd instanceof WebBundleDescriptor) {
            return WEB_LIST_HEADER;
        }
        if (dsd instanceof ApplicationClientDescriptor) {
            return APP_CLIENT_LIST_HEADER;
        }
        return null;
    }

    private Set getEjbBundleWebServicesRefsComponentSet(Descriptor descriptor) {
        if (descriptor instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor bd = (EjbBundleDescriptor)descriptor;
            HashSet<WServiceReferenceDescriptor> hashSet = new HashSet<WServiceReferenceDescriptor>();
            Iterator i = bd.getEjbs().iterator();
            while (i.hasNext()) {
                EjbDescriptor nextEjbDescriptor = (EjbDescriptor)i.next();
                Set webServiceRefs = nextEjbDescriptor.getServiceReferenceDescriptors();
                Iterator i2 = webServiceRefs.iterator();
                while (i2.hasNext()) {
                    ServiceReferenceDescriptor nextServiceReferenceDescriptor = (ServiceReferenceDescriptor)i2.next();
                    WServiceReferenceDescriptor wsr = new WServiceReferenceDescriptor(nextServiceReferenceDescriptor, (Descriptor)nextEjbDescriptor);
                    hashSet.add(wsr);
                }
            }
            return hashSet;
        }
        return new HashSet();
    }

    protected Set getBundleComponentSet() {
        Descriptor dsd = this.getDescriptor();
        if (dsd instanceof Application) {
            Application wsbd = (Application)dsd;
            return wsbd.getServiceReferenceDescriptors();
        }
        if (dsd instanceof WebBundleDescriptor) {
            WebBundleDescriptor wsbd = (WebBundleDescriptor)dsd;
            return wsbd.getServiceReferenceDescriptors();
        }
        if (dsd instanceof EjbBundleDescriptor) {
            return this.getEjbBundleWebServicesRefsComponentSet(dsd);
        }
        if (dsd instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor wsbd = (ApplicationClientDescriptor)dsd;
            return wsbd.getServiceReferenceDescriptors();
        }
        return Collections.EMPTY_SET;
    }

    private void browsePublishLocation() {
        UIFileChooser fc = UIFileChooser.getFileChooser(this.getFileLocation());
        fc.setFileSelectionMode(2);
        int rtn = fc.showDialog(this, null);
        if (rtn == 0) {
            File file = fc.getSelectedFile();
            try {
                this.wsdlPublishLocationValueText.setText(file.toURL().toString());
                this.storeWSDLPublishLocationValue(this.wsdlPublishLocationValueText.getText());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return;
            }
        }
    }

    private boolean isFileLocationRequired() {
        return this.wsdlPublishLocationValueText.isVisible() && !this.wsdlPublishLocationValueText.getText().equals("");
    }

    public File getFileLocation() {
        if (!this.isFileLocationRequired()) {
            return null;
        }
        String fn = this.wsdlPublishLocationValueText.getText();
        if (fn.equals("")) {
            return null;
        }
        File f = new File(fn).getAbsoluteFile();
        if (!fn.equals(f.toString())) {
            this.wsdlPublishLocationValueText.setText(f.toString());
        }
        return f;
    }

    public static ServiceRefPortInfo findPortsInfoDOL(PortInfo pi, ServiceReferenceDescriptor srd) {
        if (pi == null) {
            return null;
        }
        return WebServiceReference.findPortsInfoDOL(pi.getServiceEndpointInterface(), srd);
    }

    public static ServiceRefPortInfo findPortsInfoDOL(String piEndpoint, ServiceReferenceDescriptor srd) {
        if (piEndpoint == null || "".equals(piEndpoint)) {
            return null;
        }
        Set portInfoSet = srd.getPortsInfo();
        Iterator i = portInfoSet.iterator();
        while (i.hasNext()) {
            ServiceRefPortInfo srpi = (ServiceRefPortInfo)i.next();
            if (!srpi.hasServiceEndpointInterface() || !piEndpoint.equals(srpi.getServiceEndpointInterface())) continue;
            return srpi;
        }
        return null;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        return obj instanceof String && "".equals((String)obj);
    }

    protected InspectorPane.InspectorPaneDialog _createInspectorPaneDialog(Window win, InspectorPane.InspectorPaneOwner inspOwner, boolean modal) {
        if (win instanceof Frame) {
            return new WSRefInspectorPaneDialog((Frame)win, inspOwner, modal);
        }
        if (win instanceof Dialog) {
            return new WSRefInspectorPaneDialog((Dialog)win, inspOwner, modal);
        }
        return null;
    }

    public class WSRefInspectorPaneDialog
    extends InspectorPane.InspectorPaneDialog {
        public WSRefInspectorPaneDialog(Frame frame, InspectorPane.InspectorPaneOwner owner, boolean isModal) {
            super(frame, owner, isModal);
            super.setCancelEnabled(true);
        }

        public WSRefInspectorPaneDialog(Dialog dialog, InspectorPane.InspectorPaneOwner owner, boolean isModal) {
            super(dialog, owner, isModal);
            super.setCancelEnabled(true);
        }

        public void setSunDescriptor(ServiceRef sr) {
            WebServiceReference.this.setSunDescriptor(sr);
        }

        public boolean validateEntries() {
            int count = WebServiceReference.this.portSettingsTable.getRowCount();
            for (int i = 0; i < count; ++i) {
                Object localpart;
                Object namespace;
                Object sei = WebServiceReference.this.portSettingsTable.getValueAt(i, 0);
                if (WebServiceReference.isEmpty(sei)) {
                    namespace = WebServiceReference.this.portSettingsTable.getValueAt(i, 1);
                    localpart = WebServiceReference.this.portSettingsTable.getValueAt(i, 2);
                    if (!WebServiceReference.isEmpty(namespace) && !WebServiceReference.isEmpty(localpart)) continue;
                    UIOptionPane.showErrorDialog(null, WebServiceReference.MISSING_PORT_VALUE("" + i));
                    return false;
                }
                namespace = WebServiceReference.this.portSettingsTable.getValueAt(i, 1);
                localpart = WebServiceReference.this.portSettingsTable.getValueAt(i, 2);
                if ((!WebServiceReference.isEmpty(namespace) || WebServiceReference.isEmpty(localpart)) && (WebServiceReference.isEmpty(namespace) || !WebServiceReference.isEmpty(localpart))) continue;
                UIOptionPane.showErrorDialog(null, WebServiceReference.MISSING_QNAME("" + i));
                return false;
            }
            int ix = WebServiceReference.this.callPropertiesTable.findRowWithValue(0, "");
            if (ix != -1) {
                UIOptionPane.showErrorDialog(null, WebServiceReference.MISSING_PROP_NAME("" + (ix + 1)));
                return false;
            }
            ix = WebServiceReference.this.callPropertiesTable.findRowWithValue(1, "");
            if (ix != -1) {
                String str = (String)WebServiceReference.this.callPropertiesTable.getValueAt(ix, 0);
                UIOptionPane.showErrorDialog(null, WebServiceReference.MISSING_VALUE(str));
                return false;
            }
            return true;
        }

        protected void okAction() {
            if (!this.validateEntries()) {
                return;
            }
            SunOneUtils.copyServiceRef(WebServiceReference.this.sunServiceRefOrig, WebServiceReference.this.sunServiceRef);
            this.hide();
        }

        protected void cancelAction() {
            Print.dprint((String)"In Cancel");
            super.cancelAction();
        }
    }

    public class WServiceReferenceDescriptor
    extends Descriptor {
        private ServiceReferenceDescriptor serviceReferenceDescriptor = null;

        public WServiceReferenceDescriptor(ServiceReferenceDescriptor sd, Descriptor ds) {
            this.serviceReferenceDescriptor = sd;
            if (ds == null) {
                this.setLocalizedDisplayName(null, sd.getName());
            } else {
                this.setLocalizedDisplayName(null, sd.getName() + " - " + ds.getName());
            }
        }

        public ServiceReferenceDescriptor getServiceReferenceDescriptor() {
            return this.serviceReferenceDescriptor;
        }

        public void setServiceReferenceDescriptor(ServiceReferenceDescriptor sd) {
            this.serviceReferenceDescriptor = sd;
        }
    }

    private class StubDialog
    extends UIDialog {
        private StubPropertiesTable stubPropertiesTable;
        private CallPropertiesTable seiEntryCallPropertiesTable;
        private PortInfo currentlySelectedPortInfo;
        private PortInfo origPortInfo;
        private JButton stubPropsAddPB;
        private boolean isCall;

        public StubDialog(boolean isCallTable) {
            super((Dialog)new JDialog(), true);
            this.stubPropertiesTable = null;
            this.seiEntryCallPropertiesTable = null;
            this.currentlySelectedPortInfo = null;
            this.origPortInfo = null;
            this.stubPropsAddPB = null;
            this.isCall = false;
            this.isCall = isCallTable;
            this.initLayout();
        }

        protected String getHelpID() {
            if (!this.isCall) {
                return stubDialogHelpID;
            }
            return callDialogHelpID;
        }

        private UITitledBox initViewLayout() {
            UITitledBox propsTablePanel = new UITitledBox(null, false);
            UITitledTable stubPropertiesTableBox = new UITitledTable(null, false);
            propsTablePanel.addWithGBConstraints(stubPropertiesTableBox);
            if (!this.isCall) {
                this.stubPropertiesTable = new StubPropertiesTable(new StubPropertiesTableModel());
                stubPropertiesTableBox.setTableView(this.stubPropertiesTable);
            } else {
                this.seiEntryCallPropertiesTable = new CallPropertiesTable(new CallPropertiesTableModel());
                stubPropertiesTableBox.setTableView(this.seiEntryCallPropertiesTable);
            }
            ActionListener actions = new ActionListener(this){
                private final /* synthetic */ StubDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    String cmd = ae.getActionCommand();
                    if (cmd.equals("add")) {
                        StubDialog.access$3100(this.this$1);
                    } else if (cmd.equals("delete")) {
                        StubDialog.access$3200(this.this$1);
                    } else {
                        Print.printStackTrace((String)("Unknown action-command: " + cmd));
                    }
                }
            };
            this.stubPropsAddPB = UIButton.createAddButton(actions);
            stubPropertiesTableBox.addControlButton(this.stubPropsAddPB);
            UIButton stubPropsDelPB = UIButton.createDeleteButton(actions, true);
            stubPropertiesTableBox.addSelectionEnabledButton(stubPropsDelPB);
            return propsTablePanel;
        }

        protected void initLayout() {
            UIControlButtonBox container = new UIControlButtonBox(null, false);
            container.setControlButtonLocation(101);
            this.getContentBox().addWithGBConstraints(container);
            container.setView(this.initViewLayout());
            container.addControlButton(UIButton.createOkButton(new ActionListener(this){
                private final /* synthetic */ StubDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    StubDialog.access$3300(this.this$1);
                }
            }));
            container.addControlButton(UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ StubDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    StubDialog.access$3400(this.this$1);
                }
            }));
            container.addControlButton(new UIHelpButton(this.getHelpID()));
        }

        private void setStubData(PortInfo portInfo, boolean isCallTable) {
            this.isCall = isCallTable;
            this.origPortInfo = portInfo;
            this.currentlySelectedPortInfo = (PortInfo)portInfo.clone();
            if (!this.isCall) {
                Object[] spArray = this.currentlySelectedPortInfo.getStubProperty();
                this.stubPropertiesTable.updateTableData(spArray);
            } else {
                Object[] cpArray = this.currentlySelectedPortInfo.getCallProperty();
                this.seiEntryCallPropertiesTable.updateTableData(cpArray);
            }
        }

        private void invoke_StubRefresh() {
            if (!this.isCall) {
                this.stubPropertiesTable.updateTableData(this.currentlySelectedPortInfo.getStubProperty());
            } else {
                this.seiEntryCallPropertiesTable.updateTableData(this.currentlySelectedPortInfo.getCallProperty());
            }
        }

        public void centerOnScreen() {
            Dimension d = this.getToolkit().getScreenSize();
            Rectangle r = this.getBounds();
            int x = (d.width - r.width) / 2;
            int y = (d.height - r.height) / 2;
            this.setLocation(x, y);
        }

        private void addStubPropertyAction() {
            if (!this.isCall) {
                if (this.stubPropertiesTable.getRowWithValue(0, "") == null) {
                    StubProperty stubProperty = new StubProperty();
                    this.currentlySelectedPortInfo.addStubProperty(stubProperty);
                }
                this.stubPropertiesTable.selectRowWithValueOnUpdate(0, "");
            } else {
                if (this.seiEntryCallPropertiesTable.getRowWithValue(0, "") == null) {
                    CallProperty callProperty = new CallProperty();
                    this.currentlySelectedPortInfo.addCallProperty(callProperty);
                }
                this.seiEntryCallPropertiesTable.selectRowWithValueOnUpdate(0, "");
            }
            this.invoke_StubRefresh();
        }

        private void deleteStubPropertyAction() {
            Object[] list = null;
            list = !this.isCall ? this.stubPropertiesTable.confirmDeleteSelection(null, null) : this.seiEntryCallPropertiesTable.confirmDeleteSelection(null, null);
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    if (!this.isCall) {
                        this.currentlySelectedPortInfo.removeStubProperty((StubProperty)list[i]);
                        continue;
                    }
                    this.currentlySelectedPortInfo.removeCallProperty((CallProperty)list[i]);
                }
                this.invoke_StubRefresh();
            }
        }

        private boolean validateEntries() {
            if (this.isCall) {
                int ix = this.seiEntryCallPropertiesTable.findRowWithValue(0, "");
                if (ix != -1) {
                    UIOptionPane.showErrorDialog(null, WebServiceReference.MISSING_PROP_NAME("" + (ix + 1)));
                    return false;
                }
                ix = this.seiEntryCallPropertiesTable.findRowWithValue(1, "");
                if (ix != -1) {
                    String str = (String)this.seiEntryCallPropertiesTable.getValueAt(ix, 0);
                    UIOptionPane.showErrorDialog(null, WebServiceReference.MISSING_VALUE(str));
                    return false;
                }
            } else {
                int ix = this.stubPropertiesTable.findRowWithValue(0, "");
                if (ix != -1) {
                    UIOptionPane.showErrorDialog(null, WebServiceReference.MISSING_PROP_NAME("" + (ix + 1)));
                    return false;
                }
                ix = this.stubPropertiesTable.findRowWithValue(1, "");
                if (ix != -1) {
                    String str = (String)this.stubPropertiesTable.getValueAt(ix, 0);
                    UIOptionPane.showErrorDialog(null, WebServiceReference.MISSING_VALUE(str));
                    return false;
                }
            }
            return true;
        }

        private void okPropertyAction() {
            if (!this.validateEntries()) {
                return;
            }
            if (!this.isCall) {
                StubProperty[] sp = this.currentlySelectedPortInfo.getStubProperty();
                this.origPortInfo.setStubProperty(sp);
            } else {
                CallProperty[] cp = this.currentlySelectedPortInfo.getCallProperty();
                this.origPortInfo.setCallProperty(cp);
            }
            WebServiceReference.this.invoke_refresh();
            this.setVisible(false);
        }

        private void cancelPropertyAction() {
            this.setVisible(false);
        }

        static /* synthetic */ void access$3100(StubDialog x0) {
            x0.addStubPropertyAction();
        }

        static /* synthetic */ void access$3200(StubDialog x0) {
            x0.deleteStubPropertyAction();
        }

        static /* synthetic */ void access$3300(StubDialog x0) {
            x0.okPropertyAction();
        }

        static /* synthetic */ void access$3400(StubDialog x0) {
            x0.cancelPropertyAction();
        }

        private class StubPropertiesTableModel
        extends InspectorTableModel {
            public StubPropertiesTableModel() {
                super(new String[]{STUB_TABLE_PROPERTY_NAME_COLUMN, STUB_TABLE_PROPERTY_VALUE_COLUMN});
            }

            public StubProperty getRow(int index) {
                return (StubProperty)this.getRowObject(index);
            }

            public boolean isCellEditable(int row, int col) {
                return true;
            }

            public Object getObjectValue(Object obj, int col) {
                StubProperty ref = (StubProperty)obj;
                String value = null;
                switch (col) {
                    case 0: {
                        value = ref.getName();
                        break;
                    }
                    case 1: {
                        value = ref.getValue();
                    }
                }
                return value == null ? "" : value;
            }

            public void setObjectValue(Object obj, int col, Object value) {
                StubProperty ref = (StubProperty)obj;
                if (ref == null) {
                    return;
                }
                String valStr = value.toString();
                switch (col) {
                    case 0: {
                        ref.setName((String)value);
                        break;
                    }
                    case 1: {
                        ref.setValue((String)value);
                    }
                }
            }
        }

        private class StubPropertiesTable
        extends InspectorTable {
            private final String USERNAME = "javax.xml.rpc.security.auth.username";
            private final String PASSWORD = "javax.xml.rpc.security.auth.password";
            private final String ENDPOINT_ADDRESS = "javax.xml.rpc.service.endpoint.address";
            private final String MAINTAIN = "javax.xml.rpc.session.maintain";
            private String[] rpcStubValues;

            public StubPropertiesTable(StubPropertiesTableModel model) {
                super(model);
                this.USERNAME = "javax.xml.rpc.security.auth.username";
                this.PASSWORD = "javax.xml.rpc.security.auth.password";
                this.ENDPOINT_ADDRESS = "javax.xml.rpc.service.endpoint.address";
                this.MAINTAIN = "javax.xml.rpc.session.maintain";
                this.rpcStubValues = new String[]{"javax.xml.rpc.security.auth.username", "javax.xml.rpc.security.auth.password", "javax.xml.rpc.service.endpoint.address", "javax.xml.rpc.session.maintain"};
                this.setToolTipText(STUB_PROPS_TABLE_TOOLTIP);
                this.setAutoResizeMode(4);
                this.setSelectionMode(0);
            }

            public TableCellEditor getCellEditor(int row, int col) {
                TableCellEditor rtn = null;
                switch (col) {
                    case 0: {
                        rtn = this.getStubValuesEditor();
                        break;
                    }
                    default: {
                        rtn = super.getCellEditor(row, col);
                    }
                }
                return rtn;
            }

            public TableCellEditor getStubValuesEditor() {
                InspectorTable.TableComboBoxEditor tableCellEditor = this.getComboBoxEditor(this.rpcStubValues);
                tableCellEditor.setEditable(true);
                return tableCellEditor;
            }
        }
    }

    private class PortSettingsTableModel
    extends InspectorTableModel {
        public PortSettingsTableModel() {
            super(new String[]{PORT_SETTINGS_TABLE_SERVICE_ENDPOINT_INTERFACE, PORT_SETTINGS_TABLE_QNAME_NAMESPACE, PORT_SETTINGS_TABLE_QNAME_LOCALPART, PORT_SETTINGS_TABLE_CALL, PORT_SETTINGS_TABLE_STUB});
        }

        public PortInfo getRow(int index) {
            return (PortInfo)this.getRowObject(index);
        }

        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
                case 1: 
                case 2: {
                    PortInfo pi = this.getRow(row);
                    if (WebServiceReference.isEmpty(pi.getServiceEndpointInterface())) {
                        return true;
                    }
                    ServiceRefPortInfo srpi = WebServiceReference.findPortsInfoDOL(pi, (ServiceReferenceDescriptor)WebServiceReference.this.getSelectedComponent());
                    return srpi == null || !srpi.hasPortComponentLinkName();
                }
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }

        public Object getObjectValue(Object obj, int col) {
            PortInfo pi = (PortInfo)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = pi.getServiceEndpointInterface();
                    break;
                }
                case 1: {
                    WsdlPort wp = pi.getWsdlPort();
                    value = wp == null ? "" : wp.getNamespaceURI();
                    break;
                }
                case 2: {
                    WsdlPort wp1 = pi.getWsdlPort();
                    value = wp1 == null ? "" : wp1.getLocalpart();
                    break;
                }
                case 3: {
                    value = this.hasCallProperty(pi) ? "filled" : "empty";
                    break;
                }
                case 4: {
                    value = this.hasStubProperty(pi) ? "filled" : "empty";
                }
            }
            return value == null ? "" : value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            PortInfo pi = (PortInfo)obj;
            String valStr = value.toString();
            switch (col) {
                case 0: {
                    ServiceRefPortInfo srpi = WebServiceReference.findPortsInfoDOL(valStr, (ServiceReferenceDescriptor)WebServiceReference.this.getSelectedComponent());
                    if (srpi != null && srpi.hasPortComponentLinkName()) {
                        String lp;
                        WsdlPort wp1 = pi.getWsdlPort();
                        String ns = wp1 == null ? "" : wp1.getNamespaceURI();
                        String string = lp = wp1 == null ? "" : wp1.getLocalpart();
                        if (!WebServiceReference.isEmpty(ns) || !WebServiceReference.isEmpty(lp)) {
                            int rtn = UIOptionPane.showConfirmDialog(null, QNAME_WILL_BE_REMOVED, CONFIRM_TITLE, UIOptionPane.OK_CANCEL_OPTIONS);
                            if (rtn == UIOptionPane.YES_OPTION) {
                                pi.setWsdlPort(null);
                                WebServiceReference.this.invoke_refresh();
                            } else {
                                return;
                            }
                        }
                    }
                    if (" ".equals(valStr)) break;
                    pi.setServiceEndpointInterface(valStr);
                    break;
                }
                case 1: {
                    WsdlPort wp = pi.getWsdlPort();
                    if (wp == null) {
                        wp = new WsdlPort();
                        pi.setWsdlPort(wp);
                    }
                    wp.setNamespaceURI(valStr);
                    break;
                }
                case 2: {
                    WsdlPort wp1 = pi.getWsdlPort();
                    if (wp1 == null) {
                        wp1 = new WsdlPort();
                        pi.setWsdlPort(wp1);
                    }
                    wp1.setLocalpart(valStr);
                }
            }
        }

        public boolean hasStubProperty(PortInfo pi) {
            StubProperty[] stubPropertyArray;
            return pi != null && (stubPropertyArray = pi.getStubProperty()) != null && stubPropertyArray.length > 0;
        }

        public boolean hasCallProperty(PortInfo pi) {
            CallProperty[] callPropertyArray;
            return pi != null && (callPropertyArray = pi.getCallProperty()) != null && callPropertyArray.length > 0;
        }
    }

    private class PortSettingsTable
    extends InspectorTable {
        public PortSettingsTable(PortSettingsTableModel model) {
            super(model);
            this.setToolTipText(PORT_SETTINGS_TABLE_TOOLTIP);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.initIconColumn(3, CALL_COLUMN_HEADER_VALUE, (Object[][])new Object[][]{{"filled", UIIcons.getImageIconFor(UIIcons.CONF_PROPS_FILLED_TBL_ICON)}, {"empty", UIIcons.getImageIconFor(UIIcons.CONF_PROPS_EMPTY_TBL_ICON)}}, new ActionListener(this){
                private final /* synthetic */ PortSettingsTable this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    PortSettingsTable.access$1200(this.this$1);
                }
            });
            this.initIconColumn(4, STUB_COLUMN_HEADER_VALUE, (Object[][])new Object[][]{{"filled", UIIcons.getImageIconFor(UIIcons.CONF_PROPS_FILLED_TBL_ICON)}, {"empty", UIIcons.getImageIconFor(UIIcons.CONF_PROPS_EMPTY_TBL_ICON)}}, new ActionListener(this){
                private final /* synthetic */ PortSettingsTable this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    PortSettingsTable.access$1400(this.this$1);
                }
            });
        }

        private void stubDialogAction() {
            if (WebServiceReference.this.stubDialog == null) {
                WebServiceReference.this.stubDialog = new StubDialog(false);
                WebServiceReference.this.stubDialog.setModal(true);
                WebServiceReference.this.stubDialog.setSize(460, 185);
                WebServiceReference.this.stubDialog.centerOnScreen();
            }
            WebServiceReference.this.stubDialog.setStubData((PortInfo)WebServiceReference.this.portSettingsTable.getSelectedRowObject(), false);
            String str = ((PortInfo)WebServiceReference.this.portSettingsTable.getSelectedRowObject()).getServiceEndpointInterface();
            WebServiceReference.this.stubDialog.setTitle(WebServiceReference.STUB_DIALOG_TITLE(str == null ? "" : str));
            WebServiceReference.this.stubDialog.setVisible(true);
        }

        private void callDialogAction() {
            if (WebServiceReference.this.callDialog == null) {
                WebServiceReference.this.callDialog = new StubDialog(true);
                WebServiceReference.this.callDialog.setModal(true);
                WebServiceReference.this.callDialog.setSize(460, 185);
                WebServiceReference.this.callDialog.centerOnScreen();
            }
            WebServiceReference.this.callDialog.setStubData((PortInfo)WebServiceReference.this.portSettingsTable.getSelectedRowObject(), true);
            String str = ((PortInfo)WebServiceReference.this.portSettingsTable.getSelectedRowObject()).getServiceEndpointInterface();
            WebServiceReference.this.callDialog.setTitle(WebServiceReference.CALL_DIALOG_TITLE(str == null ? "" : str));
            WebServiceReference.this.callDialog.setVisible(true);
        }

        private Vector getAllServiceEndpointInterface(ServiceReferenceDescriptor desc) {
            Set portsInfoSet = desc.getPortsInfo();
            Vector<String> vec = new Vector<String>();
            if (portsInfoSet == null) {
                return vec;
            }
            Iterator i = portsInfoSet.iterator();
            while (i.hasNext()) {
                ServiceRefPortInfo serviceRefPortInfo = (ServiceRefPortInfo)i.next();
                String endpt = serviceRefPortInfo.getServiceEndpointInterface();
                if (WebServiceReference.isEmpty(endpt)) continue;
                vec.add(endpt);
            }
            return vec;
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 0: {
                    Vector vec = this.getAllServiceEndpointInterface((ServiceReferenceDescriptor)WebServiceReference.this.getSelectedComponent());
                    vec.add(" ");
                    int rows = this.getRowCount();
                    for (int i = 0; i < rows; ++i) {
                        Object obj;
                        if (i == row || WebServiceReference.isEmpty(obj = this.getValueAt(i, 0))) continue;
                        vec.remove(obj);
                    }
                    InspectorTable.TableComboBoxEditor tableCellEditor = this.getComboBoxEditor(vec);
                    tableCellEditor.setEditable(false);
                    return tableCellEditor;
                }
                case 1: {
                    rtn = super.getCellEditor(row, col);
                    break;
                }
                case 2: {
                    rtn = super.getCellEditor(row, col);
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }

        public TableCellEditor getQNameNamespaceValuesEditor(ServiceReferenceDescriptor serviceReferenceDescriptor) {
            Vector<String> list = new Vector<String>();
            if (serviceReferenceDescriptor != null) {
                Set portsInfoSet = serviceReferenceDescriptor.getPortsInfo();
                Iterator i = portsInfoSet.iterator();
                while (i.hasNext()) {
                    ServiceReferenceDescriptor thisServiceReferenceDescriptor;
                    ServiceRefPortInfo serviceRefPortInfo = (ServiceRefPortInfo)i.next();
                    if (!serviceRefPortInfo.isContainerManaged() || (thisServiceReferenceDescriptor = serviceRefPortInfo.getServiceReference()) == null || list.contains(thisServiceReferenceDescriptor.getServiceNamespaceUri())) continue;
                    list.add(thisServiceReferenceDescriptor.getServiceNamespaceUri());
                }
                InspectorTable.TableComboBoxEditor tableCellEditor = this.getComboBoxEditor(list);
                tableCellEditor.setEditable(true);
                return tableCellEditor;
            }
            Vector v = new Vector();
            InspectorTable.TableComboBoxEditor tableCellEditor = this.getComboBoxEditor(v);
            tableCellEditor.setEditable(true);
            return tableCellEditor;
        }

        public TableCellEditor getQNameLocalPartValuesEditor(ServiceReferenceDescriptor serviceReferenceDescriptor) {
            Vector<String> list = new Vector<String>();
            if (serviceReferenceDescriptor != null) {
                Set portsInfoSet = serviceReferenceDescriptor.getPortsInfo();
                Iterator i = portsInfoSet.iterator();
                while (i.hasNext()) {
                    ServiceReferenceDescriptor thisServiceReferenceDescriptor;
                    ServiceRefPortInfo serviceRefPortInfo = (ServiceRefPortInfo)i.next();
                    if (serviceRefPortInfo == null || !serviceRefPortInfo.isContainerManaged() || (thisServiceReferenceDescriptor = serviceRefPortInfo.getServiceReference()) == null || list.contains(thisServiceReferenceDescriptor.getServiceLocalPart())) continue;
                    list.add(thisServiceReferenceDescriptor.getServiceLocalPart());
                }
                InspectorTable.TableComboBoxEditor tableCellEditor = this.getComboBoxEditor(list);
                tableCellEditor.setEditable(true);
                return tableCellEditor;
            }
            Vector v = new Vector();
            InspectorTable.TableComboBoxEditor tableCellEditor = this.getComboBoxEditor(v);
            tableCellEditor.setEditable(true);
            return tableCellEditor;
        }

        public int getEmptyRowNumber() {
            int rows = this.getRowCount();
            for (int i = 0; i < rows; ++i) {
                if (!WebServiceReference.isEmpty(this.getValueAt(i, 0)) || !WebServiceReference.isEmpty(this.getValueAt(i, 1)) && !WebServiceReference.isEmpty(this.getValueAt(i, 2))) continue;
                return i;
            }
            return -1;
        }

        static /* synthetic */ void access$1200(PortSettingsTable x0) {
            x0.callDialogAction();
        }

        static /* synthetic */ void access$1400(PortSettingsTable x0) {
            x0.stubDialogAction();
        }
    }

    private class CallPropertiesTableModel
    extends InspectorTableModel {
        public CallPropertiesTableModel() {
            super(new String[]{CALL_PROPS_TABLE_PROP_NAME, CALL_PROPS_TABLE_VALUE_NAME});
        }

        public CallProperty getRow(int index) {
            return (CallProperty)this.getRowObject(index);
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public Object getObjectValue(Object obj, int col) {
            CallProperty ref = (CallProperty)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getName();
                    break;
                }
                case 1: {
                    value = ref.getValue();
                }
            }
            return value == null ? "" : value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            CallProperty ref = (CallProperty)obj;
            if (ref == null) {
                return;
            }
            String valStr = value.toString();
            switch (col) {
                case 0: {
                    ref.setName(valStr);
                    break;
                }
                case 1: {
                    ref.setValue(valStr);
                }
            }
        }
    }

    private class CallPropertiesTable
    extends InspectorTable {
        private final String USERNAME = "javax.xml.rpc.security.auth.username";
        private final String PASSWORD = "javax.xml.rpc.security.auth.password";
        private final String STYLE = "javax.xml.rpc.soap.operation.style";
        private final String USE = "javax.xml.rpc.soap.http.soapaction.use";
        private final String SOAPACTION_URI = "javax.xml.rpc.http.soapaction.uri";
        private final String NAMESPACE_URI = "javax.xml.rpc.encodingsytle.namespace.uri";
        private final String MAINTAIN = "javax.xml.rpc.session.maintain";
        private String[] rpcCallValues;

        public CallPropertiesTable(CallPropertiesTableModel model) {
            super(model);
            this.USERNAME = "javax.xml.rpc.security.auth.username";
            this.PASSWORD = "javax.xml.rpc.security.auth.password";
            this.STYLE = "javax.xml.rpc.soap.operation.style";
            this.USE = "javax.xml.rpc.soap.http.soapaction.use";
            this.SOAPACTION_URI = "javax.xml.rpc.http.soapaction.uri";
            this.NAMESPACE_URI = "javax.xml.rpc.encodingsytle.namespace.uri";
            this.MAINTAIN = "javax.xml.rpc.session.maintain";
            this.rpcCallValues = new String[]{"javax.xml.rpc.security.auth.username", "javax.xml.rpc.security.auth.password", "javax.xml.rpc.soap.operation.style", "javax.xml.rpc.soap.http.soapaction.use", "javax.xml.rpc.http.soapaction.uri", "javax.xml.rpc.encodingsytle.namespace.uri", "javax.xml.rpc.session.maintain"};
            this.setToolTipText(CALL_PROPS_TABLE_TOOLTIP);
            this.setAutoResizeMode(4);
            this.setSelectionMode(2);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 0: {
                    rtn = this.getCallValuesEditor();
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }

        public TableCellEditor getCallValuesEditor() {
            InspectorTable.TableComboBoxEditor tableCellEditor = this.getComboBoxEditor(this.rpcCallValues);
            tableCellEditor.setEditable(true);
            return tableCellEditor;
        }
    }
}

