/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.websrv;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.tools.common.dd.ServiceRef;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WSPortMapping
extends UIDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WSPortMapping.class);
    private static String TABLE_ENDPOINT_INTERFACE = localStrings.getLocalString("ui.wsportmapping.table.endpoint_interface", "Service Endpoint Interface");
    private static String TABLE_PORT_NAME = localStrings.getLocalString("ui.wsportmapping.table.port_name", "Port Component Name");
    private boolean isOK = false;
    private ServiceRef sunServiceRef = null;
    private ServiceRef sunServiceRefOrig = null;
    private ServiceRefPortInfoContainer descriptor = null;
    private PortMappingTableView portMappingTablePanel = null;

    private static String DIALOG_TITLE(Object v0) {
        return localStrings.getLocalString("ui.wsportmapping.title", "Container Managed Ports - {0}", new Object[]{v0});
    }

    private static String TABLE_TITLE(Object v0) {
        return localStrings.getLocalString("ui.wsportmapping.table.title", "Container Managed Ports", new Object[]{v0});
    }

    private static final String MISSING_SERVICE(String v0) {
        return localStrings.getLocalString("ui.wsportmapping.table.missing_service", "Service Endpoint Interface for row #{0} must be specified", new Object[]{v0});
    }

    public static WSPortMapping newDialog(Component comp) {
        Window win = WinTools.getAncestorWindow(comp);
        WSPortMapping dialog = null;
        if (win instanceof Dialog) {
            dialog = new WSPortMapping((Dialog)win);
        } else if (win instanceof Frame) {
            dialog = new WSPortMapping((Frame)win);
        }
        return dialog;
    }

    public WSPortMapping(Dialog d) {
        super(d, true);
        this.initLayout();
    }

    public WSPortMapping(Frame f) {
        super(f, true);
        this.initLayout();
    }

    public void showDialog(ServiceReferenceDescriptor d, ServiceRef sr) {
        this.setDescriptor(d);
        this.sunServiceRefOrig = sr;
        this.sunServiceRef = (ServiceRef)sr.clone();
        this.isOK = false;
        this.setSize(650, 300);
        this.setLocationRelativeToOwner();
        this.show();
    }

    public void setDescriptor(ServiceReferenceDescriptor d) {
        this.descriptor = new ServiceRefPortInfoContainer(d.getDisplayName(), d.getPortsInfo(), true);
        this.setTitle(WSPortMapping.DIALOG_TITLE(this.descriptor.getDisplayName()));
        this.portMappingTablePanel.refresh();
    }

    private void initLayout() {
        UIControlButtonBox container = new UIControlButtonBox(null, false);
        container.setControlButtonLocation(101);
        this.getContentBox().addWithGBConstraints(container);
        container.setView(this.initViewLayout());
        container.addControlButton(UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WSPortMapping.this.okAction();
            }
        }));
        container.addControlButton(UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WSPortMapping.this.cancelAction();
            }
        }));
        container.addControlButton(new UIHelpButton("WSPortMapping"));
    }

    private UITitledBox initViewLayout() {
        UITitledBox portMappingBox = new UITitledBox(WSPortMapping.TABLE_TITLE(""), true);
        this.portMappingTablePanel = new PortMappingTableView();
        portMappingBox.addWithGBConstraints(this.portMappingTablePanel);
        this.portMappingTablePanel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        return portMappingBox;
    }

    private boolean validateEntries() {
        int ix = this.portMappingTablePanel.getInspectorTable().findRowWithValue(0, "");
        if (ix != -1) {
            UIOptionPane.showErrorDialog(null, WSPortMapping.MISSING_SERVICE("" + (ix + 1)));
            return false;
        }
        return true;
    }

    protected void okAction() {
        if (!this.validateEntries()) {
            return;
        }
        this.isOK = true;
        this.descriptor.commit();
        SunOneUtils.copyServiceRef(this.sunServiceRefOrig, this.sunServiceRef);
        this.hide();
    }

    protected void cancelAction() {
        this.isOK = false;
        this.hide();
    }

    private class PortMappingTableModel
    extends InspectorTableModel {
        public PortMappingTableModel() {
            super(new String[]{TABLE_ENDPOINT_INTERFACE, TABLE_PORT_NAME});
        }

        public Object getObjectValue(Object obj, int col) {
            ServiceRefPortInfo ref = (ServiceRefPortInfo)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getServiceEndpointInterface();
                    break;
                }
                case 1: {
                    value = ref.getPortComponentLinkName();
                }
            }
            return value != null ? value : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            ServiceRefPortInfo ref = (ServiceRefPortInfo)obj;
            switch (col) {
                case 0: {
                    if (value.toString().equals("")) {
                        WSPortMapping.this.portMappingTablePanel.refresh();
                        break;
                    }
                    SunOneUtils.renamePortInfoByEndpointName(WSPortMapping.this.sunServiceRef, ref.getServiceEndpointInterface(), value.toString());
                    ref.setServiceEndpointInterface(value.toString());
                    break;
                }
                case 1: {
                    ref.setPortComponentLinkName(value.toString(), false);
                }
            }
        }
    }

    private class PortMappingTable
    extends InspectorTable {
        public PortMappingTable(PortMappingTableModel model) {
            super(model);
        }
    }

    private class PortMappingTableView
    extends UITitledTable {
        public PortMappingTableView() {
            super((String)null, false);
            this.setTableView(new PortMappingTable(new PortMappingTableModel()));
            this.setControlButtonLocation(13);
            this.addControlButton(UIButton.createAddButton(new ActionListener(this){
                private final /* synthetic */ PortMappingTableView this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.addPortInfoAction();
                }
            }));
            this.addControlButton(UIButton.createDeleteButton(new ActionListener(this){
                private final /* synthetic */ PortMappingTableView this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.deletePortInfoAction();
                }
            }, true));
        }

        public void refresh() {
            this.clear();
            if (WSPortMapping.this.descriptor != null) {
                this.setModel(WSPortMapping.this.descriptor.getPortsInfo());
            }
        }

        protected void addPortInfoAction() {
            if (this.getRowWithValue(0, "") == null) {
                ServiceRefPortInfo srpi = new ServiceRefPortInfo();
                srpi.setIsContainerManaged(true);
                WSPortMapping.this.descriptor.addPortInfo(srpi);
            }
            this.selectRowWithValueOnUpdate(0, "");
            this.refresh();
        }

        protected void deletePortInfoAction() {
            Object[] list = this.confirmDeleteSelection(null, null);
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    WSPortMapping.this.descriptor.removePortInfo((ServiceRefPortInfo)list[i]);
                    SunOneUtils.removePortInfoByEndpointName(WSPortMapping.this.sunServiceRef, ((ServiceRefPortInfo)list[i]).getServiceEndpointInterface());
                }
                this.refresh();
            }
        }
    }

    private class ServiceRefPortInfoContainer
    extends Descriptor {
        private Set portsInfoOriginal;
        private Set portsInfo;

        public ServiceRefPortInfoContainer(String displayName, Set portsInfo, boolean copy) {
            super(displayName, "");
            this.portsInfoOriginal = null;
            this.portsInfo = null;
            if (copy && portsInfo != null) {
                this.portsInfoOriginal = portsInfo;
                this.portsInfo = new HashSet();
                Iterator i = portsInfo.iterator();
                while (i.hasNext()) {
                    this.portsInfo.add(new ServiceRefPortInfo((ServiceRefPortInfo)i.next()));
                }
            } else {
                this.portsInfoOriginal = null;
                this.portsInfo = portsInfo != null ? portsInfo : new HashSet();
            }
        }

        public Set getPortsInfo() {
            return this.portsInfo;
        }

        public void addPortInfo(ServiceRefPortInfo portInfo) {
            this.portsInfo.add(portInfo);
        }

        public void removePortInfo(ServiceRefPortInfo portInfo) {
            this.portsInfo.remove(portInfo);
        }

        public void commit() {
            if (this.portsInfoOriginal != null && this.portsInfoOriginal != this.portsInfo) {
                this.portsInfoOriginal.clear();
                this.portsInfoOriginal.addAll(this.portsInfo);
            }
        }
    }
}

