/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.websrv;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.utils.FileTools;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.utils.Wizard;
import com.sun.enterprise.tools.deployment.ui.websrv.WSInspector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;

public class WSLocationInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WSLocationInspector.class);
    private static String ADD_TO_EXISTING = localStrings.getLocalString("ui.wslocationinspector.add_to_existing", "Add to Existing Service:");
    private static String DEFINE_NEW_SERVICE = localStrings.getLocalString("ui.wslocationinspector.define_new_service", "Define New Service:");
    private static String TABNAME = localStrings.getLocalString("ui.wslocationinspector.tabname", "Location");
    private BundleDescriptor descriptor = null;
    private WebService webService = null;
    private UIRadioButtonBox serviceDest = null;
    private UITitledComboBox currServices = null;
    private ServiceDefinitionBox serviceDefBox = null;
    private static String SERVICE_DEFINITION = localStrings.getLocalString("ui.wslocationinspector.service_definition.title", "Service Definition");
    private static String WSDL_FILE = localStrings.getLocalString("ui.wslocationinspector.service_definition.wsdl_file", "WSDL File:");
    private static String MAPPING_FILE = localStrings.getLocalString("ui.wslocationinspector.service_definition.mapping_file", "Mapping File:");
    private static String SERVICE_NAME = localStrings.getLocalString("ui.wslocationinspector.service_definition.service_name", "Service Name:");
    private static String SERVICE_DISPLAY_NAME = localStrings.getLocalString("ui.wslocationinspector.service_definition.service_display_name", "Service Display Name:");

    public static InspectorPane newInspectorPane(String mode) {
        return new WSLocationInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return "WebSrvLocation";
    }

    public Class getDescriptorClass() {
        return BundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            if (desc instanceof BundleDescriptor) {
                this.descriptor = (BundleDescriptor)desc;
                this.webService = new WebService();
                this.webService.setWebServicesDescriptor(this.descriptor.getWebServices());
            } else {
                this.descriptor = null;
                this.webService = null;
            }
        }
    }

    public WebService getWebService() {
        if (this.isAddToExistingWebService()) {
            return (WebService)this.currServices.getSelectedItem();
        }
        return this.webService;
    }

    public boolean isAddToExistingWebService() {
        return ADD_TO_EXISTING.equals(this.serviceDest.getSelectedItem());
    }

    private WSLocationInspector(String mode) {
        super.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout(new GridBagLayout());
        this.serviceDest = new UIRadioButtonBox(null, false);
        this.serviceDest.getGBConstraints().insets.top += 5;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 2;
        gbc.anchor = 18;
        this.add((Component)this.serviceDest, gbc);
        this.serviceDest.addItem(ADD_TO_EXISTING);
        this.currServices = new UITitledComboBox(null, false);
        this.currServices.setRequired(true);
        GridBagConstraints c = this.serviceDest.getGBConstraintsCopy();
        c.insets.left += 25;
        c.insets.top = 5;
        this.serviceDest.add((Component)this.currServices, c);
        this.serviceDest.addSelectionEnabledComponent(this.currServices, ADD_TO_EXISTING);
        this.serviceDest.addItem(DEFINE_NEW_SERVICE);
        this.serviceDefBox = new ServiceDefinitionBox();
        c = this.serviceDest.getGBConstraintsCopy();
        c.insets.left += 25;
        c.insets.top = 5;
        this.serviceDest.add((Component)this.serviceDefBox, c);
        this.serviceDest.addSelectionEnabledComponent(this.serviceDefBox, DEFINE_NEW_SERVICE);
        this.serviceDest.setSelectedItem(ADD_TO_EXISTING);
    }

    public void refresh() {
        if (!this.isWizardMode()) {
            return;
        }
        WebServicesDescriptor wsd = this.getTargetWebServicesDescriptor();
        Collection wslist = wsd.getWebServices();
        this.currServices.setModel(wslist);
        this.serviceDest.setItemEnabled(ADD_TO_EXISTING, wslist.size() > 0);
        this.serviceDefBox.setWebService(this.webService);
    }

    public boolean validateEntries(boolean showErrors) {
        return !(this.isAddToExistingWebService() ? !this.currServices.checkRequired(showErrors, ADD_TO_EXISTING) : !this.serviceDefBox.checkRequired(showErrors));
    }

    protected WebServicesDescriptor getTargetWebServicesDescriptor() {
        if (this.getOwner() instanceof Wizard) {
            Wizard wiz = (Wizard)this.getOwner();
            Descriptor target = wiz.getSelectedParentDescriptor();
            BundleDescriptor bd = target instanceof BundleDescriptor ? (BundleDescriptor)target : wiz.getBundleDescriptor();
            return bd.getWebServices();
        }
        return null;
    }

    protected class ServiceDefinitionBox
    extends UITitledBox {
        private WebService webService;
        private List archContents;
        private UITitledComboBox wsdlFile;
        private UITitledComboBox mappingFile;
        private UITitledTextField serviceName;
        private UITitledTextField serviceDisplayName;
        private DescriptionInspector.DialogDisplayButton descInspector;

        public ServiceDefinitionBox() {
            super(SERVICE_DEFINITION, true);
            this.webService = null;
            this.archContents = null;
            this.wsdlFile = null;
            this.mappingFile = null;
            this.serviceName = null;
            this.serviceDisplayName = null;
            this.descInspector = null;
            this.initLayout();
        }

        private void initLayout() {
            this.getGBConstraints().insets.bottom = 8;
            this.wsdlFile = new UITitledComboBox(WSDL_FILE, false);
            this.wsdlFile.setClearWhenDisabled(true);
            this.wsdlFile.setRequired(true);
            this.wsdlFile.addActionListener(new ActionListener(this){
                private final /* synthetic */ ServiceDefinitionBox this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    String uri = ServiceDefinitionBox.access$200(this.this$1).getText();
                    this.this$1.getWebService().setWsdlFileUri(uri);
                    String dftName = FileTools.GetFileName(uri, false);
                    if (!dftName.equals(ServiceDefinitionBox.access$300(this.this$1).getText())) {
                        ServiceDefinitionBox.access$300(this.this$1).setText(dftName);
                        ServiceDefinitionBox.access$300(this.this$1).fireUpdate();
                    }
                    if (!dftName.equals(ServiceDefinitionBox.access$400(this.this$1).getText())) {
                        ServiceDefinitionBox.access$400(this.this$1).setText(dftName);
                        ServiceDefinitionBox.access$400(this.this$1).fireUpdate();
                    }
                }
            });
            this.addWithGBConstraints(this.wsdlFile);
            this.mappingFile = new UITitledComboBox(MAPPING_FILE, false);
            this.mappingFile.setClearWhenDisabled(true);
            this.mappingFile.setRequired(true);
            this.mappingFile.addActionListener(new ActionListener(this){
                private final /* synthetic */ ServiceDefinitionBox this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.getWebService().setMappingFileUri(ServiceDefinitionBox.access$600(this.this$1).getText());
                }
            });
            this.addWithGBConstraints(this.mappingFile);
            this.serviceName = new UITitledTextField(SERVICE_NAME, false);
            this.serviceName.setClearWhenDisabled(true);
            this.serviceName.setRequired(true);
            this.serviceName.addActionListener(new ActionListener(this){
                private final /* synthetic */ ServiceDefinitionBox this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    WebService ws = this.this$1.getWebService();
                    WebServicesDescriptor wsd = ServiceDefinitionBox.access$800(this.this$1).getTargetWebServicesDescriptor();
                    String n1 = ServiceDefinitionBox.access$300(this.this$1).getText();
                    String n2 = !n1.equals("") ? n1 : FileTools.GetFileName(ServiceDefinitionBox.access$200(this.this$1).getText(), false);
                    if (!(n2 = DescriptorTools.createUniqueWebServiceName(wsd, n2)).equals(n1)) {
                        ServiceDefinitionBox.access$300(this.this$1).setText(n2);
                    }
                    ws.setWebServiceName(n2);
                }
            });
            this.addWithGBConstraints(this.serviceName);
            this.serviceDisplayName = new UITitledTextField(SERVICE_DISPLAY_NAME, false);
            this.serviceDisplayName.setClearWhenDisabled(true);
            this.serviceDisplayName.addActionListener(new ActionListener(this){
                private final /* synthetic */ ServiceDefinitionBox this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    String n2;
                    WebService ws = this.this$1.getWebService();
                    WebServicesDescriptor wsd = ServiceDefinitionBox.access$800(this.this$1).getTargetWebServicesDescriptor();
                    String n1 = ServiceDefinitionBox.access$400(this.this$1).getText();
                    String string = n2 = !n1.equals("") ? n1 : FileTools.GetFileName(ServiceDefinitionBox.access$200(this.this$1).getText(), false);
                    if (wsd != null) {
                        List nlist = DescriptorTools.getDescriptorComponentNames(wsd.getWebServices());
                        n2 = DescriptorTools.createUniqueName(n2, nlist);
                    }
                    if (!n2.equals(n1)) {
                        ServiceDefinitionBox.access$400(this.this$1).setText(n2);
                    }
                    ws.setDisplayName(n2);
                }
            });
            this.addWithGBConstraints(this.serviceDisplayName);
            this.descInspector = new DescriptionInspector.DialogDisplayButton();
            this.addWithGBConstraints(this.descInspector);
        }

        public WebService getWebService() {
            return this.webService;
        }

        public void setWebService(WebService ws) {
            this.webService = ws;
            ws = this.getWebService();
            this.refreshComboBoxes();
            this.wsdlFile.setText(ws.getWsdlFileUri());
            this.mappingFile.setText(ws.getMappingFileUri());
            this.serviceName.setText(ws.getWebServiceName());
            this.serviceDisplayName.setText(ws.getDisplayName());
            this.descInspector.setDescriptionInspector((Descriptor)ws);
        }

        public void refreshComboBoxes() {
            this.wsdlFile.setModel(WSLocationInspector.this.getArchiveContents(WSInspector.WSDL_EXTN));
            this.mappingFile.setModel(WSLocationInspector.this.getArchiveContentsFiltered(WSInspector.MAPPING_EXTN_FILTERS));
        }

        public boolean checkRequired(boolean showErrors, String msg) {
            if (!this.wsdlFile.checkRequired(showErrors)) {
                return false;
            }
            if (!this.mappingFile.checkRequired(showErrors)) {
                return false;
            }
            return this.serviceName.checkRequired(showErrors);
        }

        static /* synthetic */ UITitledComboBox access$200(ServiceDefinitionBox x0) {
            return x0.wsdlFile;
        }

        static /* synthetic */ UITitledTextField access$300(ServiceDefinitionBox x0) {
            return x0.serviceName;
        }

        static /* synthetic */ UITitledTextField access$400(ServiceDefinitionBox x0) {
            return x0.serviceDisplayName;
        }

        static /* synthetic */ UITitledComboBox access$600(ServiceDefinitionBox x0) {
            return x0.mappingFile;
        }

        static /* synthetic */ WSLocationInspector access$800(ServiceDefinitionBox x0) {
            return x0.WSLocationInspector.this;
        }
    }
}

