/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.war;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ServletFilterDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.deployment.web.ServletFilter;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.Filter;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;

public class WebServletFiltersInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebServletFiltersInspector.class);
    private static final String CBOX_NAME = localStrings.getLocalString("ui.webservletfilterinspector.cbox_name", "ComboBox");
    private static final String CBOX_DESC = localStrings.getLocalString("ui.webservletfilterinspector.cbox_desc", "This is a ComboBox for the web event listener inspector window");
    private static final String FILTER_TABLE_TITLE = localStrings.getLocalString("ui.webservletfiltersinspector.filter_table_title", "Servlet Filters");
    private static final String FILTER_TABLE_CLASS = localStrings.getLocalString("ui.webservletfiltersinspector.column_filter_class", "Filter Class");
    private static final String FILTER_TABLE_DISPLAY = localStrings.getLocalString("at.webservletfiltersinspector.column_filter_name", "Filter Name");
    private static final String INIT_TABLE_TITLE = localStrings.getLocalString("ui.webservletfiltersinspector.init_parm_title", "Initialization Parameters Referenced in Filter");
    private static final String INIT_TABLE_PARM = localStrings.getLocalString("ui.webservletfiltersinspector.init_parm.column_coded_parm", "Coded Parameter");
    private static final String INIT_TABLE_VALUE = localStrings.getLocalString("ui.webservletfiltersinspector.init_parm.column_value", "Value");
    private static final String MISSING_SERVLET_CLASS = localStrings.getLocalString("at.webservletfiltersinspector.missing_servlet_class", "Servlet Filter Class must be filled in");
    private static final String MISSING_SERVLET_NAME = localStrings.getLocalString("at.webservletfiltersinspector.missing_servlet_name", "Servlet Filter Name must be filled in");
    private static final String DUP_SERVLET_NAME = localStrings.getLocalString("at.webservletfiltersinspector.dup_servlet_name", "Duplicate Servlet Filter Name");
    private static final String TABNAME = localStrings.getLocalString("ui.webservletfiltersinspector.tabname", "Servlet Filters");
    private static final char ADD_FILTER_MNEMONIC = localStrings.getLocalString("ui.webservletfilterinspector.add_filt_butt_mnemonic", "A").charAt(0);
    private static final char DELETE_FILTER_MNEMONIC = localStrings.getLocalString("ui.webservletfilterinspector.del_filt_butt_mnemonic", "D").charAt(0);
    private static final char ADD_INIT_MNEMONIC = localStrings.getLocalString("ui.webservletfilterinspector.add_init_butt_mnemonic", "P").charAt(0);
    private static final char DELETE_INIT_MNEMONIC = localStrings.getLocalString("ui.webservletfilterinspector.del_init_butt_mnemonic", "T").charAt(0);
    private static String wizardHelpID = "ServletFilters";
    private static String deployHelpID = "ServletFilters";
    private WebBundleDescriptor descriptor = null;
    private UITitledTable servletTablePanel = null;
    private ServletFilterTable servletFilterTable = null;
    private ServletFilterTableModel servletFilterTableModel = null;
    private UITitledTable parametersPanel = null;
    private ParametersTable parametersTable = null;
    private ParametersTableModel parametersTableModel = null;
    private JButton addFiltBtn = null;
    private Vector servletFilterVector = null;

    private static String INIT_TABLE_TITLE_FOR(String v0) {
        return localStrings.getLocalString("ui.webservletfiltersinspector.init_parm_title_for", "Initialization Parameters Referenced in Filter {0}", new Object[]{v0});
    }

    public static InspectorPane newInspectorPane(String mode) {
        return new WebServletFiltersInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : (desc instanceof WebComponentDescriptor ? ((WebComponentDescriptor)desc).getWebBundleDescriptor() : null);
            this.servletFilterVector = null;
            this.servletFilterTable.clearTableData();
            this.parametersTable.clearTableData();
        }
    }

    private WebServletFiltersInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.servletTablePanel = new UITitledTable(FILTER_TABLE_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.servletTablePanel, c);
        this.servletFilterTableModel = new ServletFilterTableModel();
        this.servletFilterTable = new ServletFilterTable(this.servletFilterTableModel);
        this.servletTablePanel.setTableView(this.servletFilterTable);
        this.servletFilterTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                WebServletFiltersInspector.this.showInitParmRefs(WebServletFiltersInspector.this.getSelectedServletFilter());
            }
        });
        this.addFiltBtn = UIButton.createAddButton(localStrings.getLocalString("ui.webservletfilterinspector.add_filt_butt", "Add Filter"), ADD_FILTER_MNEMONIC, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebServletFiltersInspector.this.addFilterAction();
            }
        }, false);
        this.servletTablePanel.addControlButton(this.addFiltBtn);
        UIButton delFiltBtn = UIButton.createDeleteButton(localStrings.getLocalString("ui.webservletfilterinspector.del_filt_butt", "Delete Filter..."), DELETE_FILTER_MNEMONIC, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebServletFiltersInspector.this.deleteFilterAction();
            }
        }, true);
        this.servletTablePanel.addSelectionEnabledButton(delFiltBtn);
        this.parametersPanel = new UITitledTable(INIT_TABLE_TITLE, true);
        this.servletTablePanel.setAccessoryView(this.parametersPanel);
        this.servletTablePanel.addComponentToSelectionEnabledList(this.parametersPanel);
        this.parametersTableModel = new ParametersTableModel();
        this.parametersTable = new ParametersTable(this.parametersTableModel);
        this.parametersPanel.setTableView(this.parametersTable);
        UIButton addInitBtn = UIButton.createAddButton(localStrings.getLocalString("ui.webservletfilterinspector.add_init_butt", "Add Parameter"), ADD_INIT_MNEMONIC, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebServletFiltersInspector.this.addInitAction();
            }
        }, false);
        this.parametersPanel.addControlButton(addInitBtn);
        UIButton delInitBtn = UIButton.createDeleteButton(localStrings.getLocalString("ui.webservletfilterinspector.del_init_butt", "Delete Parameter..."), DELETE_INIT_MNEMONIC, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebServletFiltersInspector.this.deleteInitAction();
            }
        }, true);
        this.parametersPanel.addSelectionEnabledButton(delInitBtn);
    }

    public void refresh() {
        Vector filters = this.descriptor.getServletFilterDescriptors();
        this.servletFilterTable.updateTableData(filters);
        if (this.servletFilterVector == null) {
            this.servletFilterVector = this.getFilters();
        }
        this.showInitParmRefs(this.getSelectedServletFilter());
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.servletFilterTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, MISSING_SERVLET_CLASS);
            }
            return false;
        }
        if (this.servletFilterTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, MISSING_SERVLET_NAME);
            }
            return false;
        }
        this.servletFilterVector = null;
        return true;
    }

    private ServletFilterDescriptor getSelectedServletFilter() {
        return (ServletFilterDescriptor)this.servletFilterTable.getSelectedRowObject();
    }

    private void showInitParmRefs(ServletFilterDescriptor sfd) {
        if (sfd != null) {
            this.parametersTable.updateTableData(sfd.getInitializationParameters());
            this.parametersPanel.setTitle(WebServletFiltersInspector.INIT_TABLE_TITLE_FOR(sfd.getDisplayName()));
        } else {
            this.parametersTable.clearTableData();
            this.parametersPanel.setTitle(INIT_TABLE_TITLE);
        }
    }

    private Vector getFilters() {
        Vector<String> v = new Vector<String>();
        Vector fc = this.getArchiveClasses(new Class[]{Filter.class});
        if (fc == null) {
            Print.dprintln((String)"Unabled to obtain a list of Filter classes");
        } else if (fc.size() == 0) {
            Print.dprintln((String)"No Filter classes found");
        } else {
            Iterator i = fc.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                String cn = obj instanceof Class ? ((Class)obj).getName() : obj.toString();
                v.add(cn);
            }
        }
        return v;
    }

    public ServletFilterDescriptor getServletFilterByName(String name) {
        Enumeration e = this.descriptor.getServletFilterDescriptors().elements();
        while (e.hasMoreElements()) {
            ServletFilterDescriptor sfd = (ServletFilterDescriptor)e.nextElement();
            if (!sfd.getClassName().equals(name)) continue;
            return sfd;
        }
        return null;
    }

    private void addFilterAction() {
        if (this.servletFilterTable.getRowWithValue(0, "") == null) {
            this.descriptor.addServletFilter(new ServletFilterDescriptor("", ""));
        }
        this.servletFilterTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteFilterAction() {
        Object[] list = this.servletFilterTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                ServletFilterDescriptor ref = (ServletFilterDescriptor)list[i];
                this.descriptor.removeServletFilter((ServletFilter)ref);
            }
            this.invokeRefresh();
        }
    }

    private void addInitAction() {
        ServletFilterDescriptor sfd = this.getSelectedServletFilter();
        if (sfd == null) {
            return;
        }
        if (this.parametersTable.getRowWithValue(0, "") == null) {
            sfd.addInitializationParameter(new EnvironmentProperty("", "", ""));
            this.descriptor.changed();
        }
        this.parametersTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteInitAction() {
        ServletFilterDescriptor sfd = this.getSelectedServletFilter();
        if (sfd == null) {
            return;
        }
        Object[] list = this.parametersTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                EnvironmentProperty ref = (EnvironmentProperty)list[i];
                sfd.removeInitializationParameter((InitializationParameter)ref);
            }
            this.descriptor.changed();
        }
        this.invokeRefresh();
    }

    private class ParametersTableModel
    extends InspectorTableModel {
        public ParametersTableModel() {
            super(new String[]{INIT_TABLE_PARM, INIT_TABLE_VALUE, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public EnvironmentProperty getRow(int index) {
            return (EnvironmentProperty)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getDisplayName();
                    break;
                }
                case 1: {
                    value = ref.getValue();
                    break;
                }
                case 2: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    ref.setDisplayName(value.toString());
                    break;
                }
                case 1: {
                    ref.setValue(value.toString());
                    break;
                }
                case 2: {
                    ref.setDescription(value.toString());
                }
            }
            WebServletFiltersInspector.this.descriptor.changed();
        }
    }

    private class ParametersTable
    extends InspectorTable {
        public ParametersTable(ParametersTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }
    }

    private class ServletFilterTableModel
    extends InspectorTableModel {
        public ServletFilterTableModel() {
            super(new String[]{FILTER_TABLE_CLASS, FILTER_TABLE_DISPLAY, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public ServletFilterDescriptor getRow(int index) {
            return (ServletFilterDescriptor)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            ServletFilterDescriptor ref = (ServletFilterDescriptor)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getClassName();
                    break;
                }
                case 1: {
                    value = ref.getDisplayName();
                    break;
                }
                case 2: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            ServletFilterDescriptor ref = (ServletFilterDescriptor)obj;
            if (ref == null) {
                return;
            }
            String vs = value.toString();
            switch (col) {
                case 0: {
                    ref.setClassName(vs);
                    break;
                }
                case 1: {
                    if (vs.equals(ref.getDisplayName())) break;
                    if (this.getRowWithValue(col, vs) != null) {
                        UIOptionPane.showErrorDialog(null, DUP_SERVLET_NAME);
                        break;
                    }
                    ref.setName(vs);
                    ref.setDisplayName(vs);
                    break;
                }
                case 2: {
                    ref.setDescription(vs);
                }
            }
        }
    }

    private class ServletFilterTable
    extends InspectorTable {
        public ServletFilterTable(ServletFilterTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 0: {
                    JComboBox cb = new JComboBox(WebServletFiltersInspector.this.servletFilterVector);
                    cb.getAccessibleContext().setAccessibleName(CBOX_NAME);
                    cb.getAccessibleContext().setAccessibleDescription(CBOX_DESC);
                    rtn = new DefaultCellEditor(cb);
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }
}

