/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.war;

import com.sun.enterprise.deployment.AppListenerDescriptorImpl;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;

public class WebEventListenerInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebEventListenerInspector.class);
    private static final String CBOX_NAME = localStrings.getLocalString("ui.webeventlistenerinspector.cbox_name", "ComboBox");
    private static final String CBOX_DESC = localStrings.getLocalString("ui.webeventlistenerinspector.cbox_desc", "This is a ComboBox for the web event listener inspector window");
    private static final String EVENT_TABLE_TITLE = localStrings.getLocalString("ui.webeventlistenerinspector.table_title", "Event Listeners");
    private static final String EVENT_TABLE_ACC_DSC = localStrings.getLocalString("at.webeventlistenerinspector.table.acc_dsc", "List of Event Listeners in the Web Application. User can add or delete and also change ordering of the list");
    private static final String MOVE_UP = localStrings.getLocalString("ui.webeventlistenerinspector.move_up", "Move Up");
    private static final String MOVE_DOWN = localStrings.getLocalString("ui.webeventlistenerinspector.move_down", "Move Down");
    private static final String EVENT_LISTENER_CLASSES = localStrings.getLocalString("ui.webeventlistenerinspector.event_listener_classes", "Event Listener Classes");
    private static final String MISSING_EVENT_LISTENER = localStrings.getLocalString("at.webeventlistenerinspector.missing_event_listener", "All Event Listeners must be filled in");
    private static final String TABNAME = localStrings.getLocalString("ui.webeventlistenerinspector.tabname", "Event Listeners");
    private static final char MOVE_UP_MNEMONIC = localStrings.getLocalString("ui.webservletfiltermapinspector.move_up_mnemonic", "u").charAt(0);
    private static final char MOVE_DOWN_MNEMONIC = localStrings.getLocalString("ui.webservletfiltermapinspector.move_down_mnemonic", "m").charAt(0);
    private static String wizardHelpID = "AppListener";
    private static String deployHelpID = "AppListener";
    private WebBundleDescriptor descriptor = null;
    private UITitledTable listenerPanel = null;
    private ListenerTable listenerTable = null;
    private ListenerTableModel listenerTableModel = null;
    private Vector eventListenerVector = null;
    private UIButton addButton = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new WebEventListenerInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : (desc instanceof WebComponentDescriptor ? ((WebComponentDescriptor)desc).getWebBundleDescriptor() : null);
            this.listenerTable.clearTableData();
            this.eventListenerVector = null;
        }
    }

    private WebEventListenerInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.listenerPanel = new UITitledTable(EVENT_TABLE_TITLE, true);
        this.listenerPanel.getAccessibleContext().setAccessibleDescription(EVENT_TABLE_ACC_DSC);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.listenerPanel, c);
        this.listenerTableModel = new ListenerTableModel();
        this.listenerTable = new ListenerTable(this.listenerTableModel);
        this.listenerPanel.setTableView(this.listenerTable);
        this.addButton = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebEventListenerInspector.this.addAction();
            }
        });
        this.listenerPanel.addControlButton(this.addButton);
        UIButton delButton = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebEventListenerInspector.this.deleteAction();
            }
        }, true);
        this.listenerPanel.addSelectionEnabledButton(delButton);
        UIButton mvUpBtn = new UIButton(MOVE_UP, MOVE_UP_MNEMONIC, null, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebEventListenerInspector.this.moveUpAction();
            }
        });
        this.listenerPanel.addSelectionEnabledButton(mvUpBtn);
        UIButton mvDnBtn = new UIButton(MOVE_DOWN, MOVE_DOWN_MNEMONIC, null, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebEventListenerInspector.this.moveDownAction();
            }
        });
        this.listenerPanel.addSelectionEnabledButton(mvDnBtn);
    }

    public void refresh() {
        this.listenerTable.updateTableData(this.descriptor.getAppListenerDescriptors());
        if (this.eventListenerVector == null) {
            this.eventListenerVector = this.getListeners();
        }
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.listenerPanel.setReadOnly(state);
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.listenerTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, MISSING_EVENT_LISTENER);
            }
            return false;
        }
        this.eventListenerVector = null;
        return true;
    }

    private AppListenerDescriptorImpl getSelectedListener() {
        return (AppListenerDescriptorImpl)this.listenerTable.getSelectedRowObject();
    }

    private Vector getListeners() {
        Vector v = new Vector();
        Class[] listenerClasses = new Class[]{ServletContextListener.class, ServletContextAttributeListener.class, HttpSessionListener.class, HttpSessionAttributeListener.class};
        Vector el = this.getArchiveClassNames(listenerClasses);
        if (el == null) {
            Print.dprintln((String)"Unabled to obtain list of Listener classes");
        } else if (el.size() == 0) {
            Print.dprintln((String)"No Listener classes found");
        } else {
            v.addAll(el);
        }
        return v;
    }

    private void addAction() {
        if (this.listenerTable.getRowWithValue(0, "") == null) {
            this.descriptor.addAppListenerDescriptor(new AppListenerDescriptorImpl(""));
        }
        this.listenerTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteAction() {
        Object[] list = this.listenerTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                AppListenerDescriptorImpl ref = (AppListenerDescriptorImpl)list[i];
                this.descriptor.removeAppListenerDescriptor((AppListenerDescriptor)ref);
            }
            this.invokeRefresh();
        }
    }

    private void moveUpAction() {
        AppListenerDescriptorImpl ref = this.getSelectedListener();
        if (ref != null) {
            this.descriptor.moveAppListenerDescriptor((AppListenerDescriptor)ref, -1);
            this.invokeRefresh();
        }
    }

    private void moveDownAction() {
        AppListenerDescriptorImpl ref = this.getSelectedListener();
        if (ref != null) {
            this.descriptor.moveAppListenerDescriptor((AppListenerDescriptor)ref, 1);
            this.invokeRefresh();
        }
    }

    private class ListenerTableModel
    extends InspectorTableModel {
        public ListenerTableModel() {
            super(new String[]{EVENT_LISTENER_CLASSES});
            this.setDataOrdering(2);
        }

        public AppListenerDescriptorImpl getRow(int index) {
            return (AppListenerDescriptorImpl)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            AppListenerDescriptorImpl ref = (AppListenerDescriptorImpl)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getListener();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            AppListenerDescriptorImpl ref = (AppListenerDescriptorImpl)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    ref.setListener(value.toString());
                }
            }
        }
    }

    private class ListenerTable
    extends InspectorTable {
        public ListenerTable(ListenerTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
        }

        private List getListeners() {
            Vector<String> newList = new Vector<String>();
            Iterator i = WebEventListenerInspector.this.getListeners().iterator();
            while (i.hasNext()) {
                String st = (String)i.next();
                if (this.getRowWithValue(0, st) != null) continue;
                newList.add(st);
            }
            return newList;
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 0: {
                    List evl = this.getListeners();
                    String old = WebEventListenerInspector.this.listenerTableModel.getRow(row).getListener();
                    if (old != null && !old.equals("") && !evl.contains(old)) {
                        evl.add(old);
                    }
                    JComboBox cb = new JComboBox((Vector)evl);
                    cb.getAccessibleContext().setAccessibleName(CBOX_NAME);
                    cb.getAccessibleContext().setAccessibleDescription(CBOX_DESC);
                    rtn = new DefaultCellEditor(cb);
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }
}

