/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.war;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LoadBalancingInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LoadBalancingInspector.class);
    private final String TABNAME = localStrings.getLocalString("ui.war.LoadBalancingInspector.LoadBalancing_Tab", "Load Balancing");
    private final String PNL_ACC_DSC = localStrings.getLocalString("ui.war.LoadBalancingInspector.acc_dsc", "Configure load balancing for this web module on the Sun Application Server");
    private final String URL_TITLE = localStrings.getLocalString("ui.war.LoadBalancingInspector.url_title", "Idempotent URL Patterns");
    private final String URL_TITLE_ACC = localStrings.getLocalString("ui.war.LoadBalancingInspector.url_title.acc", "Click on the Add button to add an Idempotent URL Pattern");
    private final String URL_PATTERN_HEADER = localStrings.getLocalString("ui.war.LoadBalancingInspector.url_pattern.header", "URL Pattern");
    private final String RETRIES_HEADER = localStrings.getLocalString("ui.war.LoadBalancingInspector.retries.header", "Retries");
    private final String ERROR_URL = localStrings.getLocalString("ui.war.LoadBalancingInspector.error_url", "Error URL");
    private final String ERROR_URL_MN = localStrings.getLocalString("ui.war.LoadBalancingInspector.error_url.mnemonic", "E");
    private final String ERROR_URL_TOOL_TIP = localStrings.getLocalString("ui.war.LoadBalancingInspector.error_url.tooltip", "Specify the url of an error page to be displayed in case of a failure or error.");
    private final String URL_TABLE_TOOL_TIP = localStrings.getLocalString("ui.war.LoadBalancingInspector.url_table.tooltip", "Table of Idempotent URL Patterns");
    private final String MISSING_URL_PATTERN = localStrings.getLocalString("ui.war.LoadBalancingInspector.Missing_url_pattern", "All Idempotent URL Patterns must have a 'URL Pattern' ");
    private static String helpID = "LoadBalancing";
    private WebBundleDescriptor descriptor = null;
    private SunWebApp sunWebApp = null;
    private boolean[] urlPatterns = null;
    private UrlPatternTable urlPatternTable = null;
    private UITitledTextField errorUrl = null;
    private String errorUrlText = null;
    static /* synthetic */ Class class$java$lang$Integer;

    public static InspectorPane newInspectorPane(String mode) {
        return new LoadBalancingInspector(mode);
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public Class getDescriptorClass() {
        return WebBundleDescriptor.class;
    }

    public String getHelpID() {
        return helpID;
    }

    public String getTabName() {
        return this.TABNAME;
    }

    protected void refresh() {
        if (this.descriptor == null) {
            return;
        }
        this.errorUrl.setText(this.sunWebApp.getErrorUrl());
        this.urlPatternTable.updateTableData(this.getUrlPatternAsBoolean());
    }

    public void setDescriptor(Descriptor d) {
        if (this.descriptor != d) {
            this.descriptor = d instanceof WebBundleDescriptor ? (WebBundleDescriptor)d : null;
            this.sunWebApp = (SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor);
            this.urlPatternTable.clearTableData();
        }
    }

    public boolean validateEntries(boolean showErrors) {
        boolean valid = true;
        if (this.urlPatternTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_URL_PATTERN);
            }
            valid = false;
        }
        return valid;
    }

    private LoadBalancingInspector(String mode) {
        this.getAccessibleContext().setAccessibleName(this.TABNAME);
        this.getAccessibleContext().setAccessibleDescription(this.PNL_ACC_DSC);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        this.errorUrl = new UITitledTextField(this.ERROR_URL, false);
        this.errorUrl.setMnemonic(this.ERROR_URL_MN.charAt(0));
        this.errorUrl.setToolTipText(this.ERROR_URL_TOOL_TIP);
        this.errorUrl.setAccessibleDescription(this.ERROR_URL_TOOL_TIP);
        this.errorUrl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                LoadBalancingInspector.this.errorUrlText = LoadBalancingInspector.this.errorUrl.getText();
                if (LoadBalancingInspector.this.errorUrlText.length() > 0) {
                    LoadBalancingInspector.this.sunWebApp.setErrorUrl(LoadBalancingInspector.this.errorUrlText);
                } else {
                    LoadBalancingInspector.this.sunWebApp.setErrorUrl(null);
                }
                LoadBalancingInspector.this.descriptor.changed();
            }
        });
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.errorUrl, c);
        UITitledTable pnlUrl = new UITitledTable(this.URL_TITLE, true);
        pnlUrl.setAccessibleDescription(this.URL_TITLE_ACC);
        pnlUrl.setToolTipText(this.URL_TITLE_ACC);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)pnlUrl, c);
        this.urlPatternTable = new UrlPatternTable(new UrlPatternTableModel());
        pnlUrl.setTableView(this.urlPatternTable);
        UIButton btnAddUrl = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoadBalancingInspector.this.addUrlAction();
            }
        });
        pnlUrl.addControlButton(btnAddUrl);
        UIButton btnDeleteUrl = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                LoadBalancingInspector.this.deleteUrlAction();
            }
        });
        pnlUrl.addSelectionEnabledButton(btnDeleteUrl);
    }

    private Boolean[] getUrlPatternAsBoolean() {
        int cnt = this.sunWebApp.sizeIdempotentUrlPattern();
        Boolean[] bar = new Boolean[cnt];
        for (int i = 0; i < cnt; ++i) {
            bar[i] = new Boolean(this.sunWebApp.isIdempotentUrlPattern(i));
        }
        return bar;
    }

    private void addUrlAction() {
        int index = 0;
        Object obj0 = this.urlPatternTable.getRowWithValue(0, "");
        Object obj1 = this.urlPatternTable.getRowWithValue(1, "");
        if (obj0 == null && obj1 == null) {
            int i = this.sunWebApp.addIdempotentUrlPattern(true);
            index = 2;
            this.descriptor.changed();
        }
        if (index == 2 || obj0 != null) {
            this.urlPatternTable.selectRowWithValueOnUpdate(0, "");
        } else {
            this.urlPatternTable.selectRowWithValueOnUpdate(1, "");
        }
        this.urlPatternTable.updateTableData(this.getUrlPatternAsBoolean());
    }

    private void deleteUrlAction() {
        Object[] list = this.urlPatternTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                Object ref = list[i];
                int objIndex = this.urlPatternTable.getObjectIndex(ref);
                this.sunWebApp.removeIdempotentUrlPattern(objIndex);
            }
            this.descriptor.changed();
            this.urlPatternTable.updateTableData(this.getUrlPatternAsBoolean());
        }
    }

    public class UrlPatternTableModel
    extends InspectorTableModel {
        private static final String URL_PATTERN = "UrlPattern";
        private static final String RETRIES = "NumOfRetries";

        public UrlPatternTableModel() {
            super(new String[]{LoadBalancingInspector.this.URL_PATTERN_HEADER, LoadBalancingInspector.this.RETRIES_HEADER});
        }

        public Object getObjectValue(Object obj, int col) {
            String value = null;
            int objIndex = LoadBalancingInspector.this.urlPatternTable.getObjectIndex(obj);
            switch (col) {
                case 0: {
                    if (LoadBalancingInspector.this.sunWebApp == null) break;
                    value = LoadBalancingInspector.this.sunWebApp.getAttributeValue("IdempotentUrlPattern", objIndex, URL_PATTERN);
                    break;
                }
                case 1: {
                    if (LoadBalancingInspector.this.sunWebApp == null) break;
                    value = LoadBalancingInspector.this.sunWebApp.getAttributeValue("IdempotentUrlPattern", objIndex, RETRIES);
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            int objIndex = LoadBalancingInspector.this.urlPatternTable.getObjectIndex(obj);
            switch (col) {
                case 0: {
                    String str = (String)value;
                    LoadBalancingInspector.this.sunWebApp.setAttributeValue("IdempotentUrlPattern", objIndex, URL_PATTERN, str);
                    break;
                }
                case 1: {
                    String str2 = value.toString();
                    LoadBalancingInspector.this.sunWebApp.setAttributeValue("IdempotentUrlPattern", objIndex, RETRIES, str2);
                }
            }
            LoadBalancingInspector.this.descriptor.changed();
        }
    }

    private class UrlPatternTable
    extends InspectorTable {
        public UrlPatternTable(UrlPatternTableModel model) {
            super(model);
            this.setToolTipText(LoadBalancingInspector.this.URL_TABLE_TOOL_TIP);
            this.setSelectionMode(0);
            this.getColumn(1).setCellEditor(this.getPrimitiveValueEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = LoadBalancingInspector.class$("java.lang.Integer")) : class$java$lang$Integer));
        }
    }
}

