/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.war;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.JspConfigDescriptor;
import com.sun.enterprise.deployment.JspGroupDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JspConfigPropInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JspConfigPropInspector.class);
    private static final String GROUP_LIST_HEADER = localStrings.getLocalString("ui.jspconfigpropinspector.config_list_header", "Name");
    private static final String CONFIGURATION_PROPERTIES = localStrings.getLocalString("ui.jspconfigpropinspector.config.box_title", "Configuration Properties");
    private static final String CONFIG_URL_PATTERNS = localStrings.getLocalString("ui.jspconfigpropinspector.config.url_patterns", "URL Patterns");
    private static final String CONFIG_SCRIPTING_INVALID = localStrings.getLocalString("ui.jspconfigpropinspector.config.scripting_invalid", "Scripting Invalid");
    private static final String CONFIG_EL_IGNORED = localStrings.getLocalString("ui.jspconfigpropinspector.config.el_ignored", "EL Evaluation Ignored");
    private static final String CONFIG_IS_XML = localStrings.getLocalString("ui.jspconfigpropinspector.config.is_xml", "Is XML Document");
    private static final String CONFIG_INCLUDE_PRELUDES = localStrings.getLocalString("ui.jspconfigpropinspector.config.include_preludes", "Include Preludes:");
    private static final String CONFIG_INCLUDE_CODAS = localStrings.getLocalString("ui.jspconfigpropinspector.config.include_codas", "Include Codas:");
    private static final String CONFIG_PAGE_ENCODING = localStrings.getLocalString("ui.jspconfigpropinspector.config.page_encoding", "Page Encoding:");
    private static final String INCLUDE_ELEMENTS = localStrings.getLocalString("ui.jspconfigpropinspector.include_elements", "Include Elements");
    private static final String INCLUDE_TITLE_PRELUDES = localStrings.getLocalString("ui.jspconfigpropinspector.include_preludes.title", "Include Elements - Preludes");
    private static final String INCLUDE_TITLE_CODAS = localStrings.getLocalString("ui.jspconfigpropinspector.include_codas.title", "Include Elements - Codas");
    private static final String TABNAME = localStrings.getLocalString("ui.jspconfigpropinspector.tabname", "JSP Properties");
    private static final char mnemonic_AddUrl = localStrings.getLocalString("ui.jspconfigpropinspector.add_url_button_mnemonic", "U").charAt(0);
    private static final char mnemonic_DeleteUrl = localStrings.getLocalString("ui.jspconfigpropinspector.del_url_button_mnemonic", "L").charAt(0);
    private static final char mnemonic_EditPrelude = localStrings.getLocalString("ui.jspconfigpropinspector.edit_prelude_button_mnemonic", "P").charAt(0);
    private static final char mnemonic_EditCodas = localStrings.getLocalString("ui.jspconfigpropinspector.edit_codas_button_mnemonic", "C").charAt(0);
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();
    private static final String DEFAULT_URL_PATTERN = "/url_pattern";
    private static String wizardHelpID = "JspProperties";
    private static String deployHelpID = "JspProperties";
    private WebBundleDescriptor descriptor = null;
    protected JspGroupDescriptor currentJspGroup = null;
    protected UITitledTable jspGroupPanel = null;
    protected JspGroupTable jspGroupTable = null;
    protected UIButton mvUpJspConfig = null;
    protected UIButton mvDnJspConfig = null;
    protected UITitledBox configPropBox = null;
    protected UITitledTable urlPatterns = null;
    protected URLTable urlPatternTable = null;
    protected UICheckBox scriptingInvalid = null;
    protected UICheckBox elIgnored = null;
    protected UICheckBox isXMLDoc = null;
    protected UITitledList includePreludes = null;
    protected UITitledList includeCodas = null;
    protected UITitledComboBox pageEncoding = null;
    protected UITitledBox otherProps = null;
    private PreludeCodaDialog preludeCodaDialog = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new JspConfigPropInspector();
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    protected JspConfigDescriptor getJspConfigDescriptor() {
        if (this.descriptor != null) {
            JspConfigDescriptor jspConfig = this.descriptor.getJspConfigDescriptor();
            if (jspConfig == null) {
                jspConfig = new JspConfigDescriptor();
                this.descriptor.setJspConfigDescriptor(jspConfig);
            }
            return jspConfig;
        }
        return null;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : null;
        }
    }

    private JspConfigPropInspector() {
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.jspGroupPanel = new UITitledTable(null, false);
        this.jspGroupTable = new JspGroupTable(new JspGroupTableModel());
        this.jspGroupPanel.setTableView(this.jspGroupTable);
        this.jspGroupPanel.addControlButton(UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JspConfigPropInspector.this.addJspGroup();
            }
        }));
        this.jspGroupPanel.addSelectionEnabledButton(UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JspConfigPropInspector.this.removeJspGroup();
            }
        }, true));
        this.mvUpJspConfig = UIButton.createMoveUpButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JspConfigPropInspector.this.moveJspGroup(-1);
            }
        }, true);
        this.jspGroupPanel.addSelectionEnabledButton(this.mvUpJspConfig);
        this.mvDnJspConfig = UIButton.createMoveDownButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JspConfigPropInspector.this.moveJspGroup(1);
            }
        }, true);
        this.jspGroupPanel.addSelectionEnabledButton(this.mvDnJspConfig);
        c.weightx = 0.5;
        c.weighty = 0.2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 5, 5);
        c.anchor = 18;
        c.fill = 1;
        this.add((Component)this.jspGroupPanel, c);
        this.jspGroupPanel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                if (lse.getValueIsAdjusting()) {
                    return;
                }
                JspConfigPropInspector.this.refreshSelectedGroup();
            }
        });
        c.gridx = 1;
        this.add((Component)new UIPanel(), c);
        this.configPropBox = new UITitledBox(CONFIGURATION_PROPERTIES, true);
        c.weightx = 1.0;
        c.weighty = 0.8;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        c.fill = 1;
        this.add((Component)this.configPropBox, c);
        GridBagConstraints gbc = this.configPropBox.getGBConstraints();
        this.urlPatterns = new UITitledTable(null, false);
        this.urlPatternTable = new URLTable(new URLTableModel());
        this.urlPatterns.setTableView(this.urlPatternTable);
        this.urlPatterns.addControlButton(UIButton.createAddButton(localStrings.getLocalString("ui.jspconfigpropinspector.add_url_button", "Add URL"), mnemonic_AddUrl, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JspConfigPropInspector.this.addUrlPattern();
            }
        }, false));
        this.urlPatterns.addSelectionEnabledButton(UIButton.createDeleteButton(localStrings.getLocalString("ui.jspconfigpropinspector.del_url_button", "Delete URL..."), mnemonic_DeleteUrl, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JspConfigPropInspector.this.removeUrlPattern();
            }
        }, true));
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 17;
        gbc.fill = 1;
        this.configPropBox.add((Component)this.urlPatterns, gbc);
        this.otherProps = new UITitledBox(null, false);
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 10, 0, 0);
        gbc.anchor = 13;
        gbc.fill = 1;
        this.configPropBox.add((Component)this.otherProps, gbc);
        gbc = this.otherProps.getGBConstraints();
        gbc.insets.top = 5;
        this.elIgnored = new UICheckBox(CONFIG_EL_IGNORED);
        this.elIgnored.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JspConfigPropInspector.this.toggleElEnabled();
            }
        });
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.otherProps.addWithGBConstraints(this.elIgnored);
        this.isXMLDoc = new UICheckBox(CONFIG_IS_XML);
        this.isXMLDoc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JspConfigPropInspector.this.toggleIsXMLDocument();
            }
        });
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.otherProps.addWithGBConstraints(this.isXMLDoc);
        this.scriptingInvalid = new UICheckBox(CONFIG_SCRIPTING_INVALID);
        this.scriptingInvalid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JspConfigPropInspector.this.toggleScriptingEnabled();
            }
        });
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.otherProps.addWithGBConstraints(this.scriptingInvalid);
        this.includePreludes = new UITitledList(CONFIG_INCLUDE_PRELUDES, false);
        this.includePreludes.getListView().setBackground(UIManager.getColor("Panel.background"));
        UIButton editInclPreludes = UIButton.createEditButton(localStrings.getLocalString("ui.jspconfigpropinspector.edit_prelude_button", "Edit Preludes..."), mnemonic_EditPrelude, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JspConfigPropInspector.this.editPreludes();
            }
        }, true);
        this.includePreludes.addControlButton(editInclPreludes);
        gbc.weighty = 0.5;
        gbc.fill = 1;
        this.otherProps.addWithGBConstraints(this.includePreludes);
        this.includeCodas = new UITitledList(CONFIG_INCLUDE_CODAS, false);
        this.includeCodas.getListView().setBackground(UIManager.getColor("Panel.background"));
        UIButton editInclCodas = UIButton.createEditButton(localStrings.getLocalString("ui.jspconfigpropinspector.edit_codas_button", "Edit Codas..."), mnemonic_EditCodas, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JspConfigPropInspector.this.editCodas();
            }
        }, true);
        this.includeCodas.addControlButton(editInclCodas);
        gbc.weighty = 0.5;
        gbc.fill = 1;
        this.otherProps.addWithGBConstraints(this.includeCodas);
        this.pageEncoding = new UITitledComboBox(CONFIG_PAGE_ENCODING, false);
        this.pageEncoding.setEditable(true);
        this.pageEncoding.setModel(new String[]{"", "ISO-8859-1", "US-ASCII", "UTF-8", "UTF-16"});
        this.pageEncoding.setSelectedItem("");
        this.pageEncoding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JspConfigPropInspector.this.setPageEncoding();
            }
        });
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.otherProps.addWithGBConstraints(this.pageEncoding);
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        JspConfigDescriptor jspConfig = this.getJspConfigDescriptor();
        Collection jspGroups = jspConfig.getJspGroupSet();
        this.jspGroupPanel.updateTableData(jspGroups);
        this.mvUpJspConfig.setVisible(!(jspGroups instanceof HashSet));
        this.mvDnJspConfig.setVisible(!(jspGroups instanceof HashSet));
        this.refreshSelectedGroup();
    }

    protected void refreshSelectedGroup() {
        String jspGroupName;
        JspGroupDescriptor jspGroup = (JspGroupDescriptor)this.jspGroupPanel.getSelectedRowObject();
        String string = jspGroupName = jspGroup != null ? jspGroup.getDisplayName() : null;
        if (jspGroupName != null && !jspGroupName.equals("")) {
            this.urlPatternTable.updateTableData(jspGroup.getUrlPatternsSet());
            this.urlPatterns.setEnabled(true);
            if (this.urlPatternTable.getRowCount() > 0) {
                this.otherProps.setEnabled(true);
                this.scriptingInvalid.setSelected(jspGroup.isScriptingInvalid());
                this.scriptingInvalid.setEnabled(true);
                this.elIgnored.setSelected(jspGroup.isElIgnored());
                this.elIgnored.setEnabled(true);
                this.isXMLDoc.setSelected(jspGroup.isXml());
                this.isXMLDoc.setEnabled(true);
                this.includePreludes.setModel(jspGroup.getIncludePreludeSet());
                this.includePreludes.setEnabled(true);
                this.includeCodas.setModel(jspGroup.getIncludeCodaSet());
                this.includeCodas.setEnabled(true);
                this.pageEncoding.setText(jspGroup.getPageEncoding());
                this.pageEncoding.setEnabled(true);
            } else {
                this.scriptingInvalid.setEnabled(false);
                this.scriptingInvalid.setSelected(false);
                jspGroup.setScriptingInvalid(false);
                this.elIgnored.setEnabled(false);
                this.elIgnored.setSelected(false);
                jspGroup.setElIgnored(false);
                this.isXMLDoc.setEnabled(false);
                this.isXMLDoc.setSelected(false);
                jspGroup.setIsXml(false);
                this.includePreludes.setEnabled(false);
                this.includePreludes.clear();
                jspGroup.getIncludePreludeSet().clear();
                this.includeCodas.setEnabled(false);
                this.includeCodas.clear();
                jspGroup.getIncludeCodaSet().clear();
                this.pageEncoding.setEnabled(false);
                this.pageEncoding.setText("");
                jspGroup.setPageEncoding("");
            }
        } else {
            this.urlPatterns.setEnabled(false);
            this.urlPatternTable.clearTableData();
            this.scriptingInvalid.setEnabled(false);
            this.scriptingInvalid.setSelected(false);
            this.elIgnored.setEnabled(false);
            this.elIgnored.setSelected(false);
            this.isXMLDoc.setEnabled(false);
            this.isXMLDoc.setSelected(false);
            this.includePreludes.setEnabled(false);
            this.includePreludes.clear();
            this.includeCodas.setEnabled(false);
            this.includeCodas.clear();
            this.pageEncoding.setEnabled(false);
            this.pageEncoding.setText("");
            this.urlPatterns.setEnabled(false);
            this.otherProps.setEnabled(false);
        }
        this.currentJspGroup = jspGroup;
    }

    protected JspGroupDescriptor getSelectedJspGroup() {
        return this.currentJspGroup;
    }

    protected Collection getSelectedPreludes() {
        JspGroupDescriptor jspGroup = this.getSelectedJspGroup();
        return jspGroup != null ? jspGroup.getIncludePreludeSet() : null;
    }

    protected Collection getSelectedCodas() {
        JspGroupDescriptor jspGroup = this.getSelectedJspGroup();
        return jspGroup != null ? jspGroup.getIncludeCodaSet() : null;
    }

    protected void addJspGroup() {
        if (this.jspGroupTable.getRowWithValue(0, "") == null) {
            JspConfigDescriptor jspConfig = this.getJspConfigDescriptor();
            jspConfig.addJspGroup(new JspGroupDescriptor());
        }
        this.jspGroupTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    protected void removeJspGroup() {
        Object[] list = this.jspGroupTable.confirmDeleteSelection(null, null);
        if (list != null) {
            JspConfigDescriptor jspConfig = this.getJspConfigDescriptor();
            for (int i = 0; i < list.length; ++i) {
                jspConfig.removeJspGroup((JspGroupDescriptor)list[i]);
            }
        }
        this.invokeRefresh();
    }

    protected void moveJspGroup(int dir) {
        JspConfigDescriptor jspConfig = this.getJspConfigDescriptor();
        JspGroupDescriptor jspGrp = this.getSelectedJspGroup();
        Collection grpSet = jspConfig.getJspGroupSet();
        if (grpSet instanceof List) {
            ListTools.moveElement((List)grpSet, jspGrp, dir);
        } else {
            Print.dprintln((String)"JspConfigDescriptor may not support moving JspGroup");
            Vector newSet = new Vector(grpSet);
            ListTools.moveElement(newSet, jspGrp, dir);
            grpSet.clear();
            grpSet.addAll(newSet);
        }
        this.jspGroupTable.selectRowWithValueOnUpdate(0, jspGrp.getDisplayName());
        this.invokeRefresh();
    }

    protected void addUrlPattern() {
        if (this.getSelectedJspGroup() != null) {
            if (this.urlPatternTable.getRowWithValue(0, DEFAULT_URL_PATTERN) == null) {
                this.getSelectedJspGroup().addUrlPattern(DEFAULT_URL_PATTERN);
            } else {
                Print.dprintln((String)"Default entry already exists");
            }
            this.urlPatternTable.selectRowWithValueOnUpdate(0, DEFAULT_URL_PATTERN);
            this.invokeRefresh();
        }
    }

    protected void removeUrlPattern() {
        Object[] list;
        if (this.getSelectedJspGroup() != null && (list = this.urlPatternTable.confirmDeleteSelection(null, null)) != null) {
            for (int i = 0; i < list.length; ++i) {
                this.getSelectedJspGroup().removeUrlPattern((String)list[i]);
            }
            this.invokeRefresh();
        }
    }

    protected void toggleElEnabled() {
        if (this.getSelectedJspGroup() != null) {
            this.getSelectedJspGroup().setElIgnored(this.elIgnored.isSelected());
            this.invokeRefresh();
        }
    }

    protected void toggleScriptingEnabled() {
        if (this.getSelectedJspGroup() != null) {
            this.getSelectedJspGroup().setScriptingInvalid(this.scriptingInvalid.isSelected());
            this.invokeRefresh();
        }
    }

    protected void toggleIsXMLDocument() {
        if (this.getSelectedJspGroup() != null) {
            this.getSelectedJspGroup().setIsXml(this.isXMLDoc.isSelected());
            this.invokeRefresh();
        }
    }

    protected void editPreludes() {
        Collection inclData;
        Collection newData;
        if (this.getSelectedJspGroup() != null && (newData = this.showPreludeCodaDialog("prelude", inclData = this.getSelectedPreludes())) != null) {
            inclData.clear();
            inclData.addAll(newData);
            this.refreshSelectedGroup();
        }
    }

    protected void editCodas() {
        Collection inclData;
        Collection newData;
        if (this.getSelectedJspGroup() != null && (newData = this.showPreludeCodaDialog("coda", inclData = this.getSelectedCodas())) != null) {
            inclData.clear();
            inclData.addAll(newData);
            this.refreshSelectedGroup();
        }
    }

    protected void setPageEncoding() {
        if (this.getSelectedJspGroup() != null) {
            this.getSelectedJspGroup().setPageEncoding(this.pageEncoding.getText());
            this.invokeRefresh();
        }
    }

    private Collection showPreludeCodaDialog(String type, Collection data) {
        if (this.preludeCodaDialog == null) {
            Window win = WinTools.getAncestorWindow(this);
            this.preludeCodaDialog = win instanceof Frame ? new PreludeCodaDialog((Frame)win) : (win instanceof Dialog ? new PreludeCodaDialog((Dialog)win) : new PreludeCodaDialog((Frame)null));
        }
        this.preludeCodaDialog.setSize(400, 300);
        this.preludeCodaDialog.setLocationRelativeTo(this);
        return this.preludeCodaDialog.showDialog(type, data);
    }

    private class PreludeCodaDialog
    extends UIDialog
    implements ActionListener {
        private List data;
        private UITitledTable editTable;
        private UIHelpButton help;
        private boolean isOk;

        public PreludeCodaDialog(Frame frame) {
            super(frame, true);
            this.data = null;
            this.editTable = null;
            this.help = null;
            this.isOk = false;
            this.initLayout();
        }

        public PreludeCodaDialog(Dialog dialog) {
            super(dialog, true);
            this.data = null;
            this.editTable = null;
            this.help = null;
            this.isOk = false;
            this.initLayout();
        }

        public void setType(String type, Collection data) {
            boolean isCoda = type.equals("coda");
            super.setTitle(isCoda ? INCLUDE_TITLE_CODAS : INCLUDE_TITLE_PRELUDES);
            this.editTable.setTitle(isCoda ? CONFIG_INCLUDE_CODAS : CONFIG_INCLUDE_PRELUDES);
            this.help.setHelpID(isCoda ? "IncludeCoda" : "IncludePrelude");
            this.data = this.editTable.wrapData(data);
            this.editTable.clear();
            this.editTable.setModel(this.data);
        }

        private void initLayout() {
            UIControlButtonBox container = new UIControlButtonBox(null, false);
            container.setControlButtonLocation(101);
            super.setContentBox(container);
            this.editTable = new UITitledTable("<changed later>", false);
            this.editTable.initSingleColumnTable(INCLUDE_ELEMENTS);
            this.editTable.addControlButton(UIButton.createAddButton(this));
            this.editTable.addSelectionEnabledButton(UIButton.createDeleteButton(this));
            this.editTable.addSelectionEnabledButton(UIButton.createMoveUpButton(this));
            this.editTable.addSelectionEnabledButton(UIButton.createMoveDownButton(this));
            container.setView(this.editTable);
            container.addControlButton(UIButton.createOkButton(this));
            container.addControlButton(UIButton.createCancelButton(this));
            this.help = new UIHelpButton("");
            container.addControlButton(this.help);
        }

        public void actionPerformed(ActionEvent ae) {
            String cmd = ae.getActionCommand();
            if (cmd.equals("add")) {
                if (this.editTable.getRowWithValue(0, "") == null) {
                    this.data.add(this.editTable.wrapDataItem(""));
                    this.editTable.setModel(this.data);
                }
                this.editTable.selectRowWithValue(0, "");
            } else if (cmd.equals("delete")) {
                Object rcd = this.editTable.getSelectedRowObject();
                if (rcd != null) {
                    this.data.remove(rcd);
                }
                this.editTable.setModel(this.data);
            } else if (cmd.equals("move up")) {
                Object rcd = this.editTable.getSelectedRowObject();
                this.moveDataRecord(rcd, -1);
            } else if (cmd.equals("move down")) {
                Object rcd = this.editTable.getSelectedRowObject();
                this.moveDataRecord(rcd, 1);
            } else if (cmd.equals("ok")) {
                this.isOk = true;
                this.hide();
            } else if (cmd.equals("cancel")) {
                this.isOk = false;
                this.hide();
            }
        }

        private void moveDataRecord(Object rcd, int loc) {
            ListTools.moveElement(this.data, rcd, loc);
            this.editTable.clear();
            this.editTable.setModel(this.data);
            this.editTable.selectRowWithValue(0, rcd.toString());
        }

        public Collection showDialog(String type, Collection data) {
            this.setType(type, data);
            this.show();
            List rtnData = this.isOk ? this.editTable.unwrapData(this.data) : null;
            this.data.clear();
            return rtnData;
        }

        private class PreludeCodaTableModel
        extends InspectorTableModel {
            public PreludeCodaTableModel() {
                super(new String[]{CONFIG_URL_PATTERNS});
            }

            public Object getObjectValue(Object obj, int col) {
                InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
                return ref != null && col == 0 ? (String)ref.getObject() : "";
            }

            public void setObjectValue(Object obj, int col, Object value) {
                InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
                if (ref != null && col == 0) {
                    ref.setObject(value);
                }
            }
        }

        private class PreludeCodaTable
        extends InspectorTable {
            public PreludeCodaTable(PreludeCodaTableModel model) {
                super(model);
            }
        }
    }

    private class URLTableModel
    extends InspectorTableModel {
        public URLTableModel() {
            super(new String[]{CONFIG_URL_PATTERNS});
        }

        public Object getObjectValue(Object obj, int col) {
            return (String)obj;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            if (JspConfigPropInspector.this.getSelectedJspGroup() != null && !"".equals(value)) {
                ListTools.replaceElement(JspConfigPropInspector.this.getSelectedJspGroup().getUrlPatternsSet(), obj, value);
                this.getInspectorTable().selectRowWithValueOnUpdate(0, value);
                JspConfigPropInspector.this.invokeRefresh();
            }
        }
    }

    private class URLTable
    extends InspectorTable {
        public URLTable(URLTableModel model) {
            super(model);
        }
    }

    private class JspGroupTableModel
    extends InspectorTableModel {
        public JspGroupTableModel() {
            super(new String[]{GROUP_LIST_HEADER});
            this.setDataOrdering(2);
        }

        public Object getObjectValue(Object obj, int col) {
            JspGroupDescriptor ref = (JspGroupDescriptor)obj;
            String val = col == 0 ? ref.getDisplayName() : "";
            return val != null ? val : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            JspGroupDescriptor ref = (JspGroupDescriptor)obj;
            if (ref != null && col == 0 && !"".equals(value)) {
                ref.setDisplayName(value.toString());
                JspConfigPropInspector.this.invokeRefresh();
            }
        }
    }

    private class JspGroupTable
    extends InspectorTable {
        public JspGroupTable(JspGroupTableModel model) {
            super(model);
        }
    }
}

