/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorViewer;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleContent;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIDivider;
import com.sun.enterprise.tools.deployment.ui.utils.UIEventQueue;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UIJarPackager;
import com.sun.enterprise.tools.deployment.ui.utils.UIProject;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledCheckBoxList;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledHTMLText;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationListener;
import com.sun.enterprise.util.Print;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public abstract class Wizard
extends UIDialog
implements DescriptionInspector.DescriptionInspectorManager,
InspectorPane.InspectorPaneOwner {
    public static final boolean SHOW_PANE_SELECTOR = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Wizard.class);
    private static String PANEL_NAME = localStrings.getLocalString("ui.wizard.panel_name", "Panel");
    private static String PANEL_DESC = localStrings.getLocalString("ui.wizard.panel_desc", "This is a  panel");
    private static String LABEL_NAME = localStrings.getLocalString("ui.wizard.label_name", "Label");
    private static String LABEL_DESC = localStrings.getLocalString("ui.wizard.label_desc", "This is a label");
    private static String BACK = localStrings.getLocalString("ui.wizard.back", "< Back");
    private static String NEXT = localStrings.getLocalString("ui.wizard.next", "Next >");
    private static String FINISH = localStrings.getLocalString("ui.wizard.finish", "Finish");
    private static String INTRODUCTION = localStrings.getLocalString("ui.wizard.introduction", "Introduction");
    private static String NEXT_STEPS = localStrings.getLocalString("ui.wizard.next_steps", "Next Steps");
    private static String SKIP_THIS = localStrings.getLocalString("ui.wizard.skip_this_screen", "Skip this Screen in the Future");
    private static final String SETTINGS_SELECTOR_HELP = localStrings.getLocalString("ui.wizard.settings_selector_help", "Please select the set of module-level settings that you would like to define.");
    private static final String SETTINGS_SELECTOR = localStrings.getLocalString("ui.wizard.settings_selector", "Module-level Settings:");
    private static char BACK_MNEMONIC = localStrings.getLocalString("ui.wizard.back_mnemonic", "B").charAt(0);
    private static char NEXT_MNEMONIC = localStrings.getLocalString("ui.wizard.next_mnemonic", "N").charAt(0);
    private static char FINISH_MNEMONIC = localStrings.getLocalString("ui.wizard.finish_mnemonic", "F").charAt(0);
    public static final String WIZARD_NEW = "New";
    public static final String WIZARD_EDIT = "Edit";
    private static String SLIM_WIZARD_IMAGE = "wizard_generic_sliver.gif";
    private WizPanel mainPanel = null;
    private WizardPane reviewSettingsPane = null;
    private int currentState = 0;
    private int firstState = 0;
    private boolean didComplete = false;
    private String frameTitle = null;
    private String wizardNewEdit = null;
    private IntroInspector introInspector = null;
    private NextStepsInspector nextStepsInspector = null;
    private WizardPane nextStepsPanel = null;
    private JButton backButton = null;
    private JButton nextButton = null;
    private JButton finishButton = null;
    private String doneLabelString = FINISH;
    protected UIHelpButton helpButton = null;
    private boolean fastForward = false;
    private int okToFinishIndex = -1;
    private DescriptionInspector descriptionInspector = null;
    private ModuleContent contentFCD = null;
    private ModuleContent classFCD = null;
    private Vector notificationListenerList = new Vector();
    private static boolean CallRefreshDirectly = true;
    private int refreshCount = 0;
    private Runnable deferredRefresh = null;
    private PaneSelectorBox paneSelectorBox = null;
    private Hashtable disabledPanes = null;
    private Vector wizPaneByIndex = new Vector();
    private Hashtable wizPaneByClass = new Hashtable();
    private Hashtable wizPaneByTitle = new Hashtable();
    private static String WIDE_IMAGE = "wizard_generic_full.gif";
    private static Image wideImage = null;
    private static String THIN_IMAGE = "wizard_generic_sliver.gif";
    private static Image thinImage = null;

    public static Descriptor newModule(Frame owner) throws IOException {
        throw new RuntimeException("'newModule' method must be overridden");
    }

    public static Descriptor editModule(Frame owner) throws IOException {
        throw new RuntimeException("'editModule' method must be overridden");
    }

    protected Wizard(Frame owner) {
        this(owner, true);
    }

    protected Wizard(Frame owner, boolean disposeOnHide) {
        super(owner, true);
        this.setDisposeOnHide(disposeOnHide);
        this.descriptionInspector = new DescriptionInspector(this);
        this._initLayout();
    }

    private void _initLayout() {
        this.getContentPane().setLayout(new BorderLayout());
        this.helpButton = new UIHelpButton();
        ActionListener buttonListener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (cmd.equals("cancel")) {
                    Wizard.this.cancelAction();
                } else if (cmd.equals("back")) {
                    Wizard.this._goBackward();
                } else if (cmd.equals("next")) {
                    Wizard.this._goForward();
                } else if (cmd.equals("finish")) {
                    Wizard.this._finishAction();
                }
            }
        };
        UIButton cancelButton = UIButton.createCancelButton(buttonListener);
        this.backButton = new UIButton(BACK, BACK_MNEMONIC, "back", buttonListener);
        this.nextButton = new UIButton(NEXT, NEXT_MNEMONIC, "next", buttonListener);
        this.finishButton = new UIButton(this.doneLabelString, FINISH_MNEMONIC, "finish", buttonListener);
        this.finishButton.setEnabled(false);
        UIControlButtonBox cbp = new UIControlButtonBox(null, false);
        cbp.setControlButtonLocation(15);
        this.setContentPane(cbp);
        this.mainPanel = new WizPanel();
        cbp.setView(this.mainPanel);
        cbp.addControlSpacer(5);
        JLabel jl = new JLabel(UITitledBox.REQUIRED_LEGEND);
        jl.getAccessibleContext().setAccessibleName(LABEL_NAME);
        jl.getAccessibleContext().setAccessibleDescription(LABEL_DESC);
        cbp.addControlComponent(jl);
        cbp.addControlSpacer(-1);
        cbp.addControlButton(this.helpButton);
        cbp.addControlSpacer(15);
        cbp.addControlButton(cancelButton);
        cbp.addControlSpacer(15);
        cbp.addControlButton(this.backButton);
        cbp.addControlSpacer(1);
        cbp.addControlButton(this.nextButton);
        cbp.addControlSpacer(15);
        cbp.addControlButton(this.finishButton);
        cbp.addControlSpacer(5);
    }

    protected void cancelAction() {
        this._hideWizard();
    }

    protected JButton getNextButton() {
        return this.nextButton;
    }

    protected JButton getBackButton() {
        return this.backButton;
    }

    protected JButton getFinishButton() {
        return this.finishButton;
    }

    public Class getDescriptorClass() {
        Print.printStackTrace((String)"This method should overidden");
        return Descriptor.class;
    }

    public void setDescriptor(Descriptor d) {
        Print.printStackTrace((String)"This method should overidden");
    }

    public Descriptor getDescriptor() {
        Print.printStackTrace((String)"This method should overidden");
        return null;
    }

    public BundleDescriptor getBundleDescriptor() {
        Print.printStackTrace((String)"This method should overidden");
        return null;
    }

    public abstract Descriptor getSelectedParentDescriptor();

    public ModuleContent getContentsFCD() {
        if (this.contentFCD == null) {
            this.contentFCD = UIJarPackager.newModuleContent();
        }
        return this.contentFCD;
    }

    public ModuleContent getClassFCD() {
        if (this.classFCD == null) {
            this.classFCD = UIJarPackager.newModuleContent();
        }
        return this.classFCD;
    }

    public void addContentsAction(ModuleContent clsFcd, ModuleContent conFcd, Vector delCon) throws IOException {
        String key;
        Print.dprintln((String)"Wizard: adding contents...");
        BundleDescriptor bd = DescriptorTools.getBundleDescriptor(this.getDescriptor());
        if (delCon != null) {
            UIJarPackager.removeFileContentsEntries(this.getClassFCD(), delCon);
            UIJarPackager.removeFileContentsEntries(this.getContentsFCD(), delCon);
        }
        if (clsFcd != null) {
            Enumeration clsEnum = clsFcd.getEntryNameMap().keys();
            while (clsEnum.hasMoreElements()) {
                key = (String)clsEnum.nextElement();
                this.getClassFCD().addEntry(key, clsFcd.getFileFor(key));
            }
            UIProject.addArchivePaths((Descriptor)bd, clsFcd);
        }
        if (conFcd != null) {
            Enumeration conEnum = conFcd.getEntryNameMap().keys();
            while (conEnum.hasMoreElements()) {
                key = (String)conEnum.nextElement();
                this.getContentsFCD().addEntry(key, conFcd.getFileFor(key));
            }
            UIProject.addArchivePaths((Descriptor)bd, conFcd);
        }
        this.descriptorChanged();
    }

    protected IntroInspector getIntroInspector() {
        return this.introInspector;
    }

    protected WizardPane addIntroPanel(String helpText) {
        if (this._getPaneCount() == 0) {
            this.currentState = 0;
            this.introInspector = new IntroInspector();
            this.introInspector.setHelpGroup(this.getHelpGroup());
            this.introInspector.setHelpText(helpText);
            return this.addComponent(this.introInspector, INTRODUCTION, "");
        }
        Print.printStackTrace((String)"IntroPanel must be the 1st panel added to this wizard");
        return null;
    }

    protected NextStepsInspector getNextStepsInspector() {
        return this.nextStepsInspector;
    }

    protected WizardPane getNextStepsPanel() {
        return this.nextStepsPanel;
    }

    protected WizardPane addNextStepsPanel(String helpText) {
        if (helpText == null) {
            return null;
        }
        if (this.nextStepsInspector == null) {
            this.nextStepsInspector = new NextStepsInspector();
            this.nextStepsInspector.setHelpGroup(this.getHelpGroup());
            this.nextStepsInspector.setHelpText(helpText);
            this.nextStepsPanel = this.addComponent(this.nextStepsInspector, NEXT_STEPS, "");
            return this.nextStepsPanel;
        }
        Print.printStackTrace((String)"NextStepsPanel already added to this wizard");
        return null;
    }

    protected WizardPane addReviewSettingsPanel(String helpText) {
        if (helpText == null) {
            helpText = DescriptorViewer.REVIEW_SETTINGS_HELP;
        }
        String title = DescriptorViewer.REVIEW_SETTINGS_TITLE;
        DescriptorViewer.XMLTextArea xmlText = new DescriptorViewer.XMLTextArea();
        this.reviewSettingsPane = this.addComponent(xmlText, title, helpText);
        return this.reviewSettingsPane;
    }

    protected WizardPane addReviewSettingsPanel(String helpText, String[] titles) {
        if (helpText == null) {
            helpText = DescriptorViewer.REVIEW_SETTINGS_HELP;
        }
        String title = DescriptorViewer.REVIEW_SETTINGS_TITLE;
        DescriptorViewer.SplitXMLTextArea splitXml = new DescriptorViewer.SplitXMLTextArea(titles, false);
        this.reviewSettingsPane = this.addComponent(splitXml, title, helpText);
        return this.reviewSettingsPane;
    }

    protected WizardPane getReviewSettingsPanel() {
        return this.reviewSettingsPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDescriptorListener(Descriptor desc, NotificationListener listener) {
        Vector vector = this.notificationListenerList;
        synchronized (vector) {
            desc.addNotificationListener(listener);
            this.notificationListenerList.add(new Object[]{desc, listener});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDescriptorListeners() {
        Vector vector = this.notificationListenerList;
        synchronized (vector) {
            Enumeration enumeration = this.notificationListenerList.elements();
            while (enumeration.hasMoreElements()) {
                Object[] obj = (Object[])enumeration.nextElement();
                Descriptor desc = (Descriptor)obj[0];
                NotificationListener listener = (NotificationListener)obj[1];
                desc.removeNotificationListener(listener);
            }
            this.notificationListenerList.removeAllElements();
        }
    }

    protected void descriptorChanged() {
        JComponent comp = this.getCurrentComponent();
        if (comp instanceof InspectorPane) {
            InspectorPane insp = (InspectorPane)comp;
            Descriptor desc = this.getDescriptor();
            if (desc != insp.getDescriptor()) {
                insp.setDescriptor(desc);
            }
            ((InspectorPane)comp).invokeRefresh();
        }
    }

    public DescriptionInspector getDescriptionInspector() {
        return this.descriptionInspector;
    }

    public abstract String getHelpGroup();

    public WizardPane addInspectorPane(InspectorPane inspPane, String title, String help) {
        return this._addWizardPane(inspPane, title, help);
    }

    public WizardPane addInspectorPane(String inspClass, String title, String help) {
        return this._addWizardPane(inspClass, title, help);
    }

    public WizardPane addComponent(JComponent comp, String title, String help) {
        return this._addWizardPane(comp, title, help);
    }

    protected void okToEnableFinish(JComponent resetComponent) {
        this.okToEnableFinish(resetComponent, false);
    }

    protected void okToEnableFinish(JComponent resetComponent, boolean nextNdx) {
        if (resetComponent == null) {
            this.clearOkToEnableFinish();
            return;
        }
        int ndx = this.getIndexOf(resetComponent);
        if (ndx < 0) {
            Print.printStackTrace((String)"Unrecognized specified component");
            return;
        }
        if (this.okToFinishIndex >= 0 && this.okToFinishIndex != ndx) {
            Print.dprintln((String)"Warning: 'okToFinishIndex' already specified");
        }
        this.okToEnableFinish(ndx + (nextNdx ? 1 : 0));
    }

    protected void okToEnableFinish(int ndx) {
        this.okToFinishIndex = ndx;
    }

    protected void clearOkToEnableFinish() {
        this.okToEnableFinish(-1);
    }

    protected boolean isOkToFinish() {
        return this.okToFinishIndex >= 0 && this.currentState >= this.okToFinishIndex;
    }

    protected int getIndexOf(WizardPane wp) {
        return wp != null ? wp.getIndex() : -1;
    }

    protected int getIndexOf(JComponent comp) {
        return comp != null ? this._getPaneIndex(comp.getClass().getName()) : -1;
    }

    protected int getIndexOf(String compClass) {
        return this._getPaneIndex(compClass);
    }

    protected void setDoneLabelString(String doneLabelString) {
        this.doneLabelString = doneLabelString;
    }

    protected String getCurrentDescription() {
        String help = this._getWizardPaneAt(this.getCurrentComponentIndex()).getHelpText();
        return help != null ? help : "";
    }

    public void show(String addMode) {
        this.wizardNewEdit = addMode;
        this.firstState = this.introInspector == null || !WIZARD_EDIT.equals(addMode) ? 0 : 1;
        this.show();
    }

    public void show() {
        Window owner;
        this.clearOkToEnableFinish();
        this.didComplete = false;
        this.currentState = this.firstState;
        if (this.currentState == 0 && this.introInspector != null && this.introInspector.skipThisPanel()) {
            this.goForward();
        }
        if (this.helpButton != null) {
            this.helpButton.setHelpID(this.getCurrentComponent());
        }
        if ((owner = this.getOwner()) != null) {
            int x = owner.getBounds().x + this.getBounds().width / 4;
            int y = owner.getBounds().y + this.getBounds().height / 4;
            int width = 750;
            int height = 600;
            this.setBounds(x, y, width, height);
        }
        this.descriptorChanged();
        this.invokeRefresh();
        super.show();
    }

    public boolean didComplete() {
        return this.didComplete;
    }

    public void clearInspectors() {
        for (int i = 0; i < this._getPaneCount(); ++i) {
            JComponent c;
            WizardPane wp = this._getWizardPaneAt(i);
            if (!wp.hasPaneInitialized() || !((c = wp.getPane()) instanceof DescriptorInspector)) continue;
            ((DescriptorInspector)((Object)c)).setDescriptor(null);
        }
    }

    protected boolean displayLongWizards() {
        return UIConfig.getConfigBoolean("ui.Wizard.longWizards");
    }

    private boolean _isInspectorAcceptable(int compIndex) {
        return this.isPaneSelected(compIndex) && this._getWizardPaneAt(compIndex).getPaneClass() != null && this.isInspectorAcceptable(compIndex);
    }

    protected boolean isInspectorAcceptable(int compIndex) {
        return true;
    }

    public boolean validateComponent(Component c) {
        return true;
    }

    public void setFastForward(boolean s) {
        this.fastForward = s;
    }

    private boolean _performValidation(boolean remaining) {
        boolean valid = true;
        this.invokeRefresh();
        for (int s = this.currentState; s < this._getPaneCount(); ++s) {
            if (!this._isInspectorAcceptable(s)) continue;
            this.currentState = s;
            JComponent c = this.getCurrentComponent();
            if (c instanceof InspectorPane && !((InspectorPane)c).validateEntries(true)) {
                valid = false;
            } else if (!this.validateComponent(c)) {
                valid = false;
            }
            if (!valid || !remaining) break;
        }
        return valid;
    }

    protected void _goForward() {
        if (this._performValidation(false)) {
            this.goForward();
        } else {
            Print.dprintln((String)"Validation failed, 'goForward' ignored.");
        }
    }

    public void goForward() {
        int newState;
        if (this.displayLongWizards() || !this.isOkToFinish()) {
            for (newState = this.currentState + 1; newState < this._getPaneCount() && !this._isInspectorAcceptable(newState); ++newState) {
            }
        } else {
            for (newState = this._getPaneCount() - 1; newState > this.currentState && !this._isInspectorAcceptable(newState); --newState) {
            }
        }
        if (newState > this.currentState && newState < this._getPaneCount()) {
            this.currentState = newState;
        } else {
            Print.printStackTrace((String)"No acceptable inspectors found");
        }
        this.helpButton.setHelpID(this.getCurrentComponent());
        this.invokeRefresh();
    }

    public void _goBackward() {
        this.goBackward();
    }

    public void goBackward() {
        int newState;
        if (this.displayLongWizards() || this.currentState <= this.okToFinishIndex) {
            for (newState = this.currentState - 1; newState >= 0 && !this._isInspectorAcceptable(newState); --newState) {
            }
        } else {
            for (newState = this.okToFinishIndex; newState >= this.firstState && !this._isInspectorAcceptable(newState); --newState) {
            }
        }
        if (newState >= this.firstState) {
            this.currentState = newState;
        } else {
            Print.printStackTrace((String)"No acceptable inspectors found");
        }
        this.helpButton.setHelpID(this.getCurrentComponent());
        this.invokeRefresh();
    }

    protected void _finishAction() {
        if (this._performValidation(this.fastForward)) {
            this.finishAction();
        }
    }

    public void finishAction() {
        this.didComplete = true;
        this._hideWizard();
    }

    protected void _hideWizard() {
        this.currentState = this.firstState;
        this.removeDescriptorListeners();
        this.finishButton.setEnabled(false);
        super.hide();
    }

    public void setTitle(String s) {
        this.frameTitle = s;
        super.setTitle(s);
    }

    protected int getCurrentComponentIndex() {
        return this.currentState;
    }

    protected JComponent getCurrentComponent() {
        return this.getComponentAt(this.currentState);
    }

    protected JComponent getComponentAt(int index) {
        return this._getWizardPaneAt(index).getPane();
    }

    protected void invokeRefresh() {
        if (CallRefreshDirectly) {
            if (this.refreshCount == 0) {
                if (this.deferredRefresh == null) {
                    this.deferredRefresh = new Runnable(){

                        public void run() {
                            Wizard.this.refreshCount = 0;
                        }
                    };
                }
                ++this.refreshCount;
                UIEventQueue.invokeLater(this.deferredRefresh);
            } else {
                Print.dprintStackTrace((String)"Redundant Refresh!");
                ++this.refreshCount;
            }
            this._refresh();
        } else if (this.refreshCount == 0) {
            if (this.deferredRefresh == null) {
                this.deferredRefresh = new Runnable(){

                    public void run() {
                        Wizard.this._refresh();
                    }
                };
            }
            ++this.refreshCount;
            UIEventQueue.invokeLater(this.deferredRefresh);
        } else {
            ++this.refreshCount;
        }
    }

    private void _refresh() {
        InspectorPane ip;
        this.refreshCount = 0;
        String subttl = this._getWizardPaneAt(this.getCurrentComponentIndex()).getTitle();
        super.setTitle(this.frameTitle + " - " + (subttl != null ? subttl : ""));
        this.backButton.setEnabled(this.currentState > this.firstState);
        this.nextButton.setEnabled(this.currentState < this._getPaneCount() - 1);
        boolean finishState = false;
        if (this.currentState == this._getPaneCount() - 1) {
            finishState = true;
        } else if (this.okToFinishIndex >= 0) {
            if (this.currentState >= this.okToFinishIndex) {
                finishState = true;
            } else {
                this.clearOkToEnableFinish();
            }
        }
        this.finishButton.setEnabled(finishState);
        JComponent comp = this.getCurrentComponent();
        this.mainPanel.setShortHelpText(this._getWizardPaneAt(this.getCurrentComponentIndex()).getHelpText());
        this.mainPanel.setInspector(comp);
        if (comp instanceof InspectorPane && !(ip = (InspectorPane)comp).isRefreshPending()) {
            ip.invokeRefresh();
        }
    }

    public boolean isCurrentInspectorPane(InspectorPane pane) {
        return this.getCurrentComponent() == pane;
    }

    public Vector getArchiveContents() {
        Print.dprintln((String)("Class doesn't implement 'getArchiveContents': " + DT.className(this)));
        return null;
    }

    public Vector getArchiveClasses() {
        Print.dprintln((String)("Class doesn't implement 'getArchiveClasses': " + DT.className(this)));
        return null;
    }

    public Vector getArchiveClasses(boolean inApplication) {
        return this.getArchiveClasses();
    }

    protected PaneSelectorBox createPaneSelectorBox() {
        return new PaneSelectorBox(SETTINGS_SELECTOR_HELP, SETTINGS_SELECTOR);
    }

    protected PaneSelectorBox getPaneSelectorBox() {
        if (this.paneSelectorBox == null) {
            this.paneSelectorBox = this.createPaneSelectorBox();
        }
        return this.paneSelectorBox;
    }

    protected WizardPane addPaneSelector(WizardPane wp) {
        return this.addPaneSelector(wp, false, true);
    }

    protected WizardPane addPaneSelector(WizardPane wp, boolean selected, boolean enabled) {
        this.getPaneSelectorBox().addItem(wp, selected, enabled);
        return wp;
    }

    protected boolean isPaneSelected(int index) {
        String paneTitle = this._getWizardPaneAt(index).getTitle();
        return this.getPaneSelectorBox().isItemSelected(paneTitle);
    }

    protected WizardPane addDisabledPane(Object key, WizardPane wp) {
        Vector<WizardPane> list;
        if (key == null) {
            key = "";
        }
        if (this.disabledPanes == null) {
            this.disabledPanes = new Hashtable();
        }
        if ((list = (Vector<WizardPane>)this.disabledPanes.get(key)) == null) {
            list = new Vector<WizardPane>();
            this.disabledPanes.put(key, list);
        }
        if (!list.contains(wp)) {
            list.add(wp);
        }
        return wp;
    }

    protected WizardPane addDisabledPane(Object[] key, WizardPane wp) {
        for (int i = 0; i < key.length; ++i) {
            this.addDisabledPane(key[i], wp);
        }
        return wp;
    }

    protected Vector getDisabledPanes(Object key) {
        if (key == null) {
            key = "";
        }
        return this.disabledPanes != null ? (Vector)this.disabledPanes.get(key) : null;
    }

    protected WizardPane getWizardPane(int index) {
        return this._getWizardPaneAt(index);
    }

    protected WizardPane _addWizardPane(Object comp, String title, String help) {
        if (comp != null) {
            WizardPane wp = null;
            String compClass = null;
            if (comp instanceof String) {
                compClass = (String)comp;
                wp = new WizardPane(compClass, title, help);
            } else if (comp instanceof JComponent) {
                compClass = comp.getClass().getName();
                wp = new WizardPane((JComponent)comp, title, help);
            } else {
                compClass = comp.getClass().getName();
                Print.printStackTrace((String)("Invalid class type: " + compClass));
                return null;
            }
            if (this.wizPaneByClass.get(compClass) != null) {
                Print.printStackTrace((String)("Already exists!: " + compClass));
                return null;
            }
            if (this.wizPaneByTitle.get(title) != null) {
                Print.printStackTrace((String)("Already exists!: " + title));
                return null;
            }
            wp.setIndex(this.wizPaneByIndex.size());
            this.wizPaneByIndex.add(wp);
            this.wizPaneByClass.put(compClass, wp);
            this.wizPaneByTitle.put(title, wp);
            return wp;
        }
        Print.printStackTrace((String)"Attempting to add 'null' component");
        return null;
    }

    protected int _getPaneCount() {
        return this.wizPaneByIndex.size();
    }

    protected WizardPane _getWizardPaneAt(int index) {
        if (index >= 0 && index < this.wizPaneByIndex.size()) {
            return (WizardPane)this.wizPaneByIndex.elementAt(index);
        }
        return null;
    }

    protected int _getPaneIndex(String comp) {
        if (comp == null) {
            return -1;
        }
        WizardPane wp = (WizardPane)this.wizPaneByClass.get(comp);
        if (wp == null) {
            wp = (WizardPane)this.wizPaneByTitle.get(comp);
        }
        return wp != null ? wp.getIndex() : -1;
    }

    private static Image getWideImage() {
        if (wideImage == null) {
            wideImage = UIIcons.getImageIconFor(WIDE_IMAGE).getImage();
        }
        return wideImage;
    }

    private static Image getThinImage() {
        if (thinImage == null) {
            thinImage = UIIcons.getImageIconFor(THIN_IMAGE).getImage();
        }
        return thinImage;
    }

    private static class WizPanel
    extends JPanel {
        private ImagePanel imgPanel = null;
        private UITitledHTMLText shortHelpText = null;
        private UITitledBox inspectorBox = null;

        public WizPanel() {
            this.setLayout(new GridBagLayout());
            this.getAccessibleContext().setAccessibleName(PANEL_NAME);
            this.getAccessibleContext().setAccessibleDescription(PANEL_DESC);
            GridBagConstraints c = new GridBagConstraints();
            this.imgPanel = new ImagePanel(Wizard.getThinImage());
            c.weightx = 0.0;
            c.weighty = 0.5;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 2;
            c.insets = new Insets(0, 0, 0, 0);
            c.fill = 3;
            c.anchor = 10;
            this.add((Component)this.imgPanel, c);
            this.shortHelpText = new UITitledHTMLText(null, false);
            c.weightx = 0.5;
            c.weighty = 0.0;
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(5, 5, 0, 5);
            c.fill = 2;
            c.anchor = 17;
            this.add((Component)this.shortHelpText, c);
            this.inspectorBox = new UITitledBox(null, false);
            c.weightx = 0.5;
            c.weighty = 0.5;
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(5, 5, 5, 5);
            c.fill = 1;
            c.anchor = 17;
            this.add((Component)this.inspectorBox, c);
            UIDivider divider = new UIDivider();
            c.weightx = 0.5;
            c.weighty = 0.0;
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.insets = new Insets(0, 0, 0, 0);
            c.fill = 2;
            c.anchor = 10;
            this.add((Component)divider, c);
        }

        public void setShortHelpText(String help) {
            if (help != null && !help.equals("")) {
                if (!help.startsWith("<")) {
                    help = UITitledHTMLText.wrapText(UITitledHTMLText.convertToHTML(help), new String[]{"<html>", "<body>"});
                }
                this.shortHelpText.setText(help);
                this.shortHelpText.setVisible(true);
            } else {
                this.shortHelpText.setText("");
                this.shortHelpText.setVisible(false);
            }
        }

        public void setInspector(JComponent comp) {
            this.inspectorBox.removeAll();
            this.inspectorBox.addWithGBConstraints(comp);
            this.imgPanel.setImage(comp instanceof IntroInspector ? Wizard.getWideImage() : Wizard.getThinImage());
            this.invalidate();
            this.validate();
            this.repaint();
        }

        private class ImagePanel
        extends JPanel {
            private Image image = null;

            public ImagePanel(Image i) {
                this.setImage(i);
                this.getAccessibleContext().setAccessibleName(PANEL_NAME);
                this.getAccessibleContext().setAccessibleDescription(PANEL_DESC);
            }

            public void setImage(Image i) {
                this.image = i;
                this.setSize(this.image.getWidth(this), this.image.getHeight(this));
            }

            public Image getImage() {
                return this.image;
            }

            public Dimension getMinimumSize() {
                return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
            }

            public Dimension getPreferredSize() {
                return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
            }

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.image, 0, 0, this.getSize().width, this.getSize().height, 0, 0, this.image.getWidth(this), this.image.getHeight(this), this);
            }
        }
    }

    protected static class NextStepsInspector
    extends IntroInspector {
        public NextStepsInspector() {
            super(false);
        }
    }

    protected static class IntroInspector
    extends UIControlButtonBox {
        private boolean isIntroPanel = true;
        private UITitledHTMLText helpTextArea = null;
        private String helpIdKey = null;
        private JCheckBox skipThisScreen = null;

        public IntroInspector() {
            this(true);
        }

        protected IntroInspector(boolean isIntro) {
            super((String)null, false);
            this.isIntroPanel = isIntro;
            this.setControlButtonLocation(102);
            this.helpTextArea = new UITitledHTMLText(null, false);
            this.helpTextArea.setBackground(UIManager.getColor("Panel.background"));
            this.helpTextArea.setText("Sample Text");
            this.setView(this.helpTextArea);
            if (this.isIntroPanel) {
                this.skipThisScreen = new UICheckBox(SKIP_THIS);
                this.skipThisScreen.addActionListener(new ActionListener(this){
                    private final /* synthetic */ IntroInspector this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent ae) {
                        if (IntroInspector.access$300(this.this$0) != null) {
                            boolean skip = IntroInspector.access$400(this.this$0).isSelected();
                            UIConfig.setConfigBoolean(IntroInspector.access$300(this.this$0), skip);
                            UIConfig.saveConfig();
                        }
                    }
                });
                this.addControlComponent(this.skipThisScreen);
            }
        }

        public void setHelpGroup(String helpGroup) {
            if (helpGroup != null) {
                if (this.isIntroPanel) {
                    this.helpIdKey = "ui.Wizard.skipIntro_" + helpGroup;
                    CSH.setHelpIDString((Component)this, (String)(helpGroup + "Intro"));
                    this.skipThisScreen.setVisible(true);
                    this.skipThisScreen.setEnabled(true);
                    this.skipThisScreen.setSelected(UIConfig.getConfigBoolean(this.helpIdKey));
                } else {
                    CSH.setHelpIDString((Component)this, (String)(helpGroup + "NextSteps"));
                }
            } else if (this.isIntroPanel) {
                this.helpIdKey = null;
                CSH.setHelpIDString((Component)this, (String)"WizardIntro");
                this.skipThisScreen.setVisible(false);
                this.skipThisScreen.setEnabled(false);
            } else {
                CSH.setHelpIDString((Component)this, (String)"WizardNextSteps");
            }
        }

        public void setHelpText(String helpText) {
            if (!helpText.startsWith("<")) {
                helpText = UITitledHTMLText.wrapText(UITitledHTMLText.convertToHTML(helpText), new String[]{"<html>", "<body>"});
            }
            this.helpTextArea.setText(helpText);
        }

        public boolean skipThisPanel() {
            if (this.isIntroPanel) {
                return this.skipThisScreen.isVisible() ? this.skipThisScreen.isSelected() : false;
            }
            return false;
        }

        static /* synthetic */ String access$300(IntroInspector x0) {
            return x0.helpIdKey;
        }

        static /* synthetic */ JCheckBox access$400(IntroInspector x0) {
            return x0.skipThisScreen;
        }
    }

    protected class WizardPane {
        private JComponent pane = null;
        private String className = null;
        private Class paneClass = null;
        private String title = null;
        private String help = null;
        private int index = -1;

        public WizardPane(JComponent pane, String title, String help) {
            this.pane = this._initPane(pane);
            this.title = title;
            this.help = help;
        }

        public WizardPane(String paneClass, String title, String help) {
            this.className = paneClass;
            this.title = title;
            this.help = help;
        }

        private JComponent _initPane(JComponent comp) {
            if (comp instanceof InspectorPane) {
                InspectorPane ip = (InspectorPane)comp;
                ip.setOwner(Wizard.this);
                String helpId = ip.getHelpID();
                if (helpId != null && helpId.length() > 0) {
                    CSH.setHelpIDString((Component)ip, (String)(Wizard.this.getHelpGroup() + helpId));
                }
            }
            return comp;
        }

        public boolean hasPaneInitialized() {
            return this.pane != null;
        }

        public JComponent getPane() {
            if (this.pane == null && this.className != null) {
                this.pane = this._initPane(InspectorPane.createInspectorPane(this.className, "WizardMode"));
            }
            return this.pane;
        }

        public Class getPaneClass() {
            if (this.paneClass == null) {
                try {
                    this.paneClass = this.pane != null ? this.pane.getClass() : Class.forName(this.className);
                }
                catch (Exception ex) {
                    Print.dprintln((String)("Class Not Found: " + this.className));
                }
            }
            return this.paneClass;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getHelpText() {
            return this.help;
        }

        public void setHelpText(String help) {
            this.help = help;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return this.getTitle();
        }
    }

    protected static class PaneSelectorBox
    extends UITitledBox {
        private UITitledCheckBoxList paneList = null;

        public PaneSelectorBox(String help, String title) {
            super((String)null, false);
            GridBagConstraints c = this.getGBConstraints();
            c.gridx = 0;
            c.gridy = -1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.anchor = 17;
            c.weightx = 0.5;
            c.weighty = 0.0;
            c.insets = new Insets(0, 0, 5, 0);
            c.fill = 2;
            this.add((Component)new UIDivider(1), c);
            if (help != null) {
                c.weightx = 0.5;
                c.weighty = 0.0;
                c.insets = new Insets(0, 0, 0, 0);
                c.fill = 2;
                UITitledHTMLText helpText = new UITitledHTMLText(null, false);
                helpText.setText(help);
                this.add((Component)helpText, c);
            }
            c.weightx = 0.5;
            c.weighty = 0.5;
            c.insets = new Insets(5, 0, 0, 0);
            c.fill = 1;
            this.paneList = new UITitledCheckBoxList(title, false, false);
            this.paneList.setVerticalWrap(true);
            this.paneList.setSorted(true);
            this.add((Component)this.paneList, c);
        }

        public void clearItems() {
            this.paneList.clearList();
        }

        public void addItem(WizardPane wp, boolean selected, boolean enabled) {
            if (wp != null) {
                this.paneList.addCheckBoxItem(wp.getTitle(), selected, enabled, wp);
            }
        }

        public boolean contains(String paneTitle) {
            return this.paneList.contains(paneTitle);
        }

        public void setItemSelected(String paneTitle, boolean sel) {
            JCheckBox cb = this.paneList.getCheckBox(paneTitle);
            if (cb != null) {
                cb.setSelected(sel);
            }
        }

        public boolean isItemSelected(String paneTitle) {
            JCheckBox cb = this.paneList.getCheckBox(paneTitle);
            return cb != null ? cb.isSelected() : true;
        }

        public void setDisabledItems(Collection disable) {
            this.paneList.setCheckBoxEnabled(disable, false);
        }

        public void setEnabledItems(Collection enable) {
            this.paneList.setCheckBoxEnabled(enable, true);
        }
    }
}

