/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UISortedTreeNode;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Color;
import java.awt.Container;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class UITitledTree
extends UIControlButtonBox {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UITitledTree.class);
    private Container viewParent = null;
    private JPanel blankPanel = null;
    private int rootVisible = -1;
    private int rootHandles = -1;
    private Color treeBackgroundColor = Color.white;

    public UITitledTree(String title, boolean showBorder) {
        super(title, showBorder);
    }

    public UITitledTree(String title, boolean showBorder, JTree tree) {
        super(title, showBorder);
        this.setTreeView(tree);
    }

    public void setRootVisible(boolean val) {
        this.rootVisible = val ? 1 : 0;
        this._setRootVisible(val);
    }

    protected void _setRootVisible(boolean val) {
        JTree tree = this.getTreeView();
        if (tree != null) {
            tree.setRootVisible(val);
            if (val) {
                this.setShowsRootHandles(true);
            } else {
                this.expandNode(this.getRootNode());
            }
        }
    }

    public void setShowsRootHandles(boolean val) {
        this.rootHandles = val ? 1 : 0;
        this._setShowsRootHandles(val);
    }

    protected void _setShowsRootHandles(boolean val) {
        JTree tree = this.getTreeView();
        if (tree != null) {
            tree.setShowsRootHandles(val);
        }
    }

    public void setTreeView(JTree tree) {
        super.setView(tree, true);
        this.treeBackgroundColor = tree.getBackground();
        tree.getSelectionModel().addTreeSelectionListener(this);
        if (this.rootVisible >= 0) {
            this._setRootVisible(this.rootVisible == 1);
        }
        if (this.rootHandles >= 0) {
            this._setShowsRootHandles(this.rootHandles == 1);
        }
        this.expandNode(this.getRootNode());
    }

    public JTree getTreeView() {
        return (JTree)this.getView();
    }

    public void setRootNode(TreeNode root) {
        JTree tree = this.getTreeView();
        if (tree != null) {
            TreeModel model = tree.getModel();
            if (model instanceof DefaultTreeModel) {
                ((DefaultTreeModel)model).setRoot(root);
            } else {
                tree.setModel(new DefaultTreeModel(root));
            }
            this.expandNode(root);
        } else {
            JTree jt = new JTree(root);
            jt.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.uititledtree.tree_name", "Tree"));
            jt.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.uititledtree.tree_desc", "This is a tree view of the contents of the package"));
            this.setTreeView(jt);
        }
    }

    public TreeNode getRootNode() {
        JTree tree = this.getTreeView();
        return tree != null ? (TreeNode)tree.getModel().getRoot() : null;
    }

    public TreeModel getModel() {
        return this.getTreeView().getModel();
    }

    public void setModel(TreeModel model) {
        this.getTreeView().setModel(model);
    }

    public void setFileData(String rootTitle, Collection list) {
        this.setRootNode(UITitledTree.createFileTree(rootTitle, list));
    }

    public void setArchiveData(String rootTitle, Collection list) {
        this.setRootNode(UITitledTree.createArchiveTree(rootTitle, list));
    }

    public void addNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
        JTree tree = this.getTreeView();
        if (tree != null) {
            TreeModel model = tree.getModel();
            TreeNode root = (TreeNode)model.getRoot();
            if (!(model instanceof DefaultTreeModel)) {
                model = new DefaultTreeModel(root);
                tree.setModel(model);
            }
            if (parent == null && root instanceof DefaultMutableTreeNode) {
                parent = (DefaultMutableTreeNode)root;
            }
            if (parent != null) {
                if (!parent.getAllowsChildren()) {
                    parent.setAllowsChildren(true);
                }
                ((DefaultTreeModel)model).insertNodeInto(child, parent, parent.getChildCount());
                if (parent == root && !this.isExpanded(root)) {
                    this.expandNode(root);
                }
            }
        }
    }

    public boolean isExpanded(TreeNode node) {
        JTree tree;
        if (node instanceof DefaultMutableTreeNode && (tree = this.getTreeView()) != null) {
            TreePath tp = new TreePath(((DefaultMutableTreeNode)node).getPath());
            return tree.isExpanded(tp);
        }
        return false;
    }

    public void expandNode(TreeNode node) {
        this._expandNode(this.getTreeView(), node, false);
    }

    public void expandNode(TreeNode node, boolean expandChildren) {
        this._expandNode(this.getTreeView(), node, expandChildren);
    }

    protected void _expandNode(JTree tree, TreeNode node, boolean expandChildren) {
        if (tree != null && node instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)node;
            TreePath tp = new TreePath(dmtn.getPath());
            if (!tree.isExpanded(tp)) {
                tree.expandPath(tp);
            }
            if (expandChildren) {
                Enumeration<TreeNode> e = dmtn.children();
                while (e.hasMoreElements()) {
                    this._expandNode(tree, e.nextElement(), true);
                }
            }
        }
    }

    public void expandAllNodes() {
        this._expandNode(this.getTreeView(), this.getRootNode(), true);
    }

    public void setEnabled(boolean state) {
        JTree tree = this.getTreeView();
        if (tree != null) {
            tree.setBackground(state ? this.treeBackgroundColor : DisabledBackgroundColor);
            if (this.clearWhenDisabled) {
                if (this.blankPanel == null) {
                    this.blankPanel = new UIPanel();
                    this.blankPanel.setOpaque(true);
                    this.blankPanel.setBackground(DisabledBackgroundColor);
                }
                if (state) {
                    if (this.viewParent != null) {
                        this.viewParent.remove(this.blankPanel);
                        this.viewParent.add(tree);
                        this.viewParent = null;
                    }
                } else if (this.viewParent == null) {
                    this.viewParent = tree.getParent();
                    this.viewParent.remove(tree);
                    this.viewParent.add(this.blankPanel);
                }
            }
        }
        super.setEnabled(state);
    }

    public void setButtonsEnabled(boolean state) {
        boolean hasSelection = !this.isSelectionEmpty();
        super.setButtonsEnabled(state, this.selectionControlList, state && hasSelection);
    }

    public void setSelectionMode(int selectionMode) {
        TreeSelectionModel selModel = this.getTreeView().getSelectionModel();
        if (selModel == null) {
            selModel = new DefaultTreeSelectionModel();
            this.getTreeView().setSelectionModel(selModel);
        }
        selModel.setSelectionMode(selectionMode);
    }

    public boolean isSelectionEmpty() {
        return this.getTreeView().isSelectionEmpty();
    }

    public void clearSelection() {
        this.getTreeView().clearSelection();
    }

    public void setSelectionPath(TreePath tp) {
        this.getTreeView().setSelectionPath(tp);
    }

    public void setSelectedNode(DefaultMutableTreeNode node) {
        if (node != null) {
            this.setSelectionPath(new TreePath(node.getPath()));
        } else {
            this.clearSelection();
        }
    }

    public void setSelectedUserObject(Object obj) {
        this.setSelectedNode(this.getNodeForUserObject(obj));
    }

    public TreePath getSelectionPath() {
        return this.getTreeView().getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        return this.getTreeView().getSelectionPaths();
    }

    public Object getSelectedUserObject() {
        Object[] p;
        TreeNode tn;
        TreePath sel = this.getSelectionPath();
        if (sel != null && (tn = (TreeNode)(p = sel.getPath())[p.length - 1]) instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)tn).getUserObject();
        }
        return null;
    }

    public DefaultMutableTreeNode getNodeForUserObject(Object obj) {
        TreeNode root = this.getRootNode();
        return root instanceof DefaultMutableTreeNode ? UITitledTree.getNodeForUserObject((DefaultMutableTreeNode)root, obj) : null;
    }

    public static DefaultMutableTreeNode getNodeForUserObject(DefaultMutableTreeNode parent, Object obj) {
        Enumeration<TreeNode> e = parent.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child;
            TreeNode tn = e.nextElement();
            if (!(tn instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tn;
            Object userObject = node.getUserObject();
            if (userObject == null) {
                return obj == null ? node : null;
            }
            if (userObject.equals(obj)) {
                return node;
            }
            if (node.getChildCount() <= 0 || (child = UITitledTree.getNodeForUserObject(node, obj)) == null) continue;
            return child;
        }
        return null;
    }

    public DefaultMutableTreeNode getNodeForName(String name) {
        TreeNode root = this.getRootNode();
        return root instanceof DefaultMutableTreeNode ? this.getNodeForName((DefaultMutableTreeNode)root, name) : null;
    }

    public DefaultMutableTreeNode getNodeForName(DefaultMutableTreeNode parent, String name) {
        Enumeration<TreeNode> e = parent.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            TreeNode node = e.nextElement();
            if (!(node instanceof DefaultMutableTreeNode) || !node.toString().equals(name)) continue;
            return (DefaultMutableTreeNode)node;
        }
        return null;
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.getTreeView().addTreeSelectionListener(listener);
    }

    public void valueChanged(TreeSelectionEvent tse) {
        super.valueChanged(tse);
    }

    public static MutableTreeNode createNode(String title, Collection list) {
        UISortedTreeNode root = new UISortedTreeNode(title, true);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            MutableTreeNode node = null;
            node = obj instanceof MutableTreeNode ? (MutableTreeNode)obj : (obj instanceof Collection ? UITitledTree.createNode("", (Collection)obj) : new UISortedTreeNode(obj, false));
            root.add(node);
        }
        return root;
    }

    public static MutableTreeNode createArchiveTree(String title, Collection list) {
        UISortedTreeNode root = new UISortedTreeNode(title, true);
        root.addArchiveList(list);
        return root;
    }

    public static MutableTreeNode createFileTree(String title, Collection list) {
        UISortedTreeNode root = new UISortedTreeNode(title, true);
        root.addFileList(list);
        return root;
    }
}

