/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIEventQueue;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class UITitledTextField
extends UITitledBox {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UITitledTextField.class);
    private static String BROWSE = localStrings.getLocalString("ui.uititledtextfield.browser_button", "Browse...");
    private static String BROWSE_SELECT = localStrings.getLocalString("ui.uititledtextfield.browser_button.select", "Select");
    private static String REQUIRED_ENTRY_TITLE = localStrings.getLocalString("ui.uititledtextfield.requiredentrytitle", "Non-Blank Entry Required");
    private static String REQUIRED_ENTRY = localStrings.getLocalString("ui.uititledtextfield.requiredentry", "This textfield requires a non-blank entry.");
    private static char BROWSE_MNEMONIC = localStrings.getLocalString("ui.uititledcombobox.browserbutton_mnemonic", "w").charAt(0);
    private static final String DEFAULT_NONBLANK_TEXT = "?";
    private JScrollPane scrollPane = null;
    private JTextField textField = this.createPrivateTextField();
    private JPanel columnSpacer = null;
    private String lastAvailableText = null;
    private String lastEnabledText = null;
    private NumberFormat numFormatter = null;
    boolean isCancelled = false;
    private JButton browserButton = null;
    private ActionListener browserAction = null;
    private String browserFilterKey = null;
    private int text_updateComponent_recurse = 0;

    public UITitledTextField(String title, boolean showBorder, int columns) {
        this(title, showBorder);
        this.setColumns(columns);
    }

    public UITitledTextField(String title, boolean showBorder) {
        this(title, showBorder, false);
    }

    public UITitledTextField(String title, boolean showBorder, boolean scrollable) {
        super(title, showBorder);
        if (scrollable) {
            this.scrollPane = new JScrollPane(this.textField);
            this.scrollPane.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.uititledtextarea.scroll_name", "Scroll Panel"));
            this.scrollPane.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.uititledtextarea.scroll_desc", "This is a scroll pane"));
            this.add((Component)this.scrollPane, this.getGBConstraints());
        } else {
            this.add((Component)this.textField, this.getGBConstraints());
        }
        this.setLabelComponent(this.textField);
        this.textField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                if (fe.getOppositeComponent() instanceof UIButton && ((UIButton)fe.getOppositeComponent()).getActionCommand().equals("cancel")) {
                    UITitledTextField.this.isCancelled = true;
                }
                if (!UITitledTextField.this.isCancelled) {
                    UITitledTextField.this.updateComponent();
                }
                UITitledTextField.this.isCancelled = false;
            }
        });
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UITitledTextField.this.updateComponent();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent ke) {
                char kc = ke.getKeyChar();
                if (kc == '\n') {
                    JButton btn;
                    JRootPane root = UITitledTextField.this.getRootPane();
                    JButton jButton = btn = root != null ? root.getDefaultButton() : null;
                    if (btn != null) {
                        UIEventQueue.invokeLater(new UIActionDispatcher((Object)btn, "doClick"));
                    }
                }
            }

            public void keyPressed(KeyEvent ke) {
                Dialog dialog = WinTools.getAncestorDialog(UITitledTextField.this);
                UITitledTextField.this.isCancelled = ke.getKeyCode() == 27 && dialog != null;
            }
        });
    }

    public UITitledTextField(String title) {
        this(title, false);
    }

    public UITitledTextField() {
        this((String)null, false);
    }

    public void setBrowserButton(JButton button) {
        if (this.browserButton == null) {
            this.browserButton = button;
            this.browserButton.setMargin(new Insets(0, 3, 0, 3));
            Dimension bsize = new Dimension(this.browserButton.getPreferredSize().width, this.textField.getPreferredSize().height);
            this.browserButton.setPreferredSize(bsize);
            this.browserButton.setMaximumSize(bsize);
            GridBagConstraints c = this.getGBConstraintsCopy();
            c.weightx = 0.0;
            c.gridx = -1;
            c.gridy = 0;
            c.insets.left = 3;
            c.fill = 0;
            this.add((Component)this.browserButton, c);
        } else {
            Print.dprintStackTrace((String)"BrowserButton already set");
        }
    }

    public void setBrowserActionListener(ActionListener listener) {
        if (this.browserButton == null) {
            this.browserAction = listener;
            this.setBrowserButton(new UIButton(BROWSE, BROWSE_MNEMONIC, new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    UITitledTextField.this.fireBrowserAction();
                }
            }));
        } else {
            Print.dprintStackTrace((String)"BrowserButton already set");
        }
    }

    public void setBrowserFilterKey(String filterKey) {
        if (this.browserButton == null) {
            if (filterKey != null) {
                this.browserFilterKey = filterKey;
                this.setBrowserActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        UITitledTextField.this.showBrowserFileChooser();
                    }
                });
            } else {
                this.browserFilterKey = null;
                this.setBrowserActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        UITitledTextField.this.showBrowserDirChooser();
                    }
                });
            }
        } else {
            Print.dprintStackTrace((String)"BrowserButton already set");
        }
    }

    public void setBrowserMnemonic(char c) {
        this.browserButton.setMnemonic(c);
    }

    public void fireBrowserAction() {
        if (this.browserAction != null) {
            UIActionDispatcher.invoke(this.browserAction, this);
        }
    }

    private void showBrowserFileChooser() {
        File currentDir = new File(this.getText());
        UIFileChooser jfc = UIFileChooser.getFileChooser(currentDir, this.browserFilterKey);
        int rtn = jfc.showDialog(this, BROWSE_SELECT);
        if (rtn == 0) {
            File chosenFile = jfc.getSelectedFile();
            this.setText(chosenFile.toString());
            this.fireUpdate();
        }
    }

    private void showBrowserDirChooser() {
        File currentDir = new File(this.getText());
        UIFileChooser jfc = UIFileChooser.getDirChooser(currentDir);
        int rtn = jfc.showDialog(this, BROWSE_SELECT);
        if (rtn == 0) {
            File chosenDir = jfc.getSelectedFile();
            this.setText(chosenDir.toString());
            this.fireUpdate();
        }
    }

    protected GridBagConstraints getDefaultGBConstraints(GridBagConstraints c) {
        c = super.getDefaultGBConstraints(c);
        c.weightx = 0.5;
        c.weighty = 0.0;
        if (this.hasTitle() && !this.hasVisibleBorder() && !this.hasLabeledTitle()) {
            c.insets.left += 3;
        }
        c.fill = 2;
        c.anchor = 18;
        return c;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setReadOnly(boolean state) {
        this.textField.setEnabled(!state && this.isEnabled());
        if (this.browserButton instanceof UIButton) {
            ((UIButton)this.browserButton).setReadOnly(state);
        } else if (this.browserButton != null) {
            Print.dprintln((String)"BrowserButton is not a UIButton");
        }
        super.setReadOnly(state);
    }

    public void updateComponent() {
        boolean isValid;
        if (this.text_updateComponent_recurse > 0) {
            return;
        }
        ++this.text_updateComponent_recurse;
        boolean bl = isValid = this.validateOnUpdate ? this._performValidation() : true;
        if (isValid && (this.lastAvailableText == null || !this.getText().equals(this.lastAvailableText))) {
            this.lastAvailableText = this.getText();
            super.updateComponent();
        }
        --this.text_updateComponent_recurse;
    }

    public UITitledBox.Validator getNonBlankEntryValidator() {
        return new UITitledBox.Validator(){

            public boolean performValidation(UITitledBox b) {
                return UITitledTextField._validateNonBlank(b);
            }
        };
    }

    private static boolean _validateNonBlank(UITitledBox b) {
        UITitledTextField tf = (UITitledTextField)b;
        if (tf.getText().equals("")) {
            String title = tf.getTitle();
            if (title == null || title.equals("")) {
                title = REQUIRED_ENTRY_TITLE;
            }
            UIOptionPane.showErrorDialog(tf.getTextField(), REQUIRED_ENTRY, title);
            tf.setText(tf.lastAvailableText != null ? tf.lastAvailableText : DEFAULT_NONBLANK_TEXT);
            return false;
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        super.propertyChange(pce);
    }

    public void addKeyListener(KeyListener kl) {
        this.textField.addKeyListener(kl);
    }

    public void removeKeyListener(KeyListener kl) {
        this.textField.removeKeyListener(kl);
    }

    public void setColumns(int colWidth) {
        if (colWidth < 0) {
            colWidth = 0;
        }
        this.textField.setColumns(colWidth);
        if (colWidth > 0) {
            if (this.columnSpacer == null) {
                this.columnSpacer = this._addXStretchy(null);
            }
            this.columnSpacer.setVisible(true);
            GridBagConstraints gbc = this.getGBConstraints(this.textField);
            gbc.weightx = 0.0;
            gbc.fill = 0;
            this.setGBConstraints(this.textField, gbc);
        } else if (this.columnSpacer != null) {
            this.columnSpacer.setVisible(false);
            GridBagConstraints gbc = this.getGBConstraints(this.textField);
            gbc.weightx = 0.5;
            gbc.fill = 2;
            this.setGBConstraints(this.textField, gbc);
        }
        this.invalidate();
    }

    public void setEnabled(boolean state) {
        this.textField.setEnabled(state && !this.isReadOnly());
        if (this.browserButton != null) {
            this.browserButton.setEnabled(state);
        }
        super.setEnabled(state);
        if (this.clearWhenDisabled) {
            if (!this.isEnabled() && this.lastEnabledText == null) {
                this.lastEnabledText = this.getText();
                this._setText("");
            } else if (this.isEnabled() && this.lastEnabledText != null) {
                this._setText(this.lastEnabledText);
                this.lastEnabledText = null;
            }
        }
    }

    public String getText() {
        return this.textField.getText().trim();
    }

    public boolean isBlank() {
        return this.getText().equals("");
    }

    public void setText(String text) {
        if (this.clearWhenDisabled) {
            if (!this.isEnabled()) {
                this.lastEnabledText = text;
            } else {
                this._setText(text);
            }
        } else {
            this._setText(text);
        }
    }

    protected void _setText(String text) {
        if (text == null) {
            text = "";
        }
        this.textField.setText(text);
        this.lastAvailableText = !text.equals("") ? text : null;
    }

    public void setDocument(Document doc) {
        this.textField.setDocument(doc);
    }

    protected void setNumericDocument(boolean intOnly, boolean allowNegative) {
        this.numFormatter = NumberFormat.getNumberInstance();
        this.numFormatter.setParseIntegerOnly(intOnly);
        NumericDocument numdoc = new NumericDocument(intOnly);
        numdoc.setAllowNegativeNumbers(allowNegative);
        this.setDocument(numdoc);
    }

    public void setIntegerDocument(boolean allowNegative) {
        this.setNumericDocument(true, allowNegative);
    }

    public void setDecimalDocument(boolean allowNegative) {
        this.setNumericDocument(false, allowNegative);
    }

    public void setLongValue(long val) {
        this.setText(String.valueOf(val));
    }

    public long getLongValue(long defaultValue) {
        String num = this.getText();
        try {
            return Long.parseLong(this.getText());
        }
        catch (NumberFormatException nfe) {
            int p;
            if (num.equals("")) {
                return defaultValue;
            }
            int len = num.length();
            int n = p = num.charAt(0) == '-' ? 1 : 0;
            while (p < len && Character.isDigit(num.charAt(p))) {
                ++p;
            }
            try {
                return Long.parseLong(num.substring(0, p));
            }
            catch (NumberFormatException nfe2) {
                return defaultValue;
            }
        }
    }

    public void setIntValue(int val) {
        this.setText(String.valueOf(val));
    }

    public int getIntValue(int defaultValue) {
        String num = this.getText();
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException nfe) {
            int p;
            if (num.equals("")) {
                return defaultValue;
            }
            int len = num.length();
            int n = p = num.charAt(0) == '-' ? 1 : 0;
            while (p < len && Character.isDigit(num.charAt(p))) {
                ++p;
            }
            try {
                return Integer.parseInt(num.substring(0, p));
            }
            catch (NumberFormatException nfe2) {
                return defaultValue;
            }
        }
    }

    public String toString() {
        return this.textField.toString();
    }

    protected JTextField createPrivateTextField() {
        return new PrivateTextField();
    }

    protected class PrivateTextField
    extends JTextField {
        private Color savedBackground = Color.white;

        public PrivateTextField() {
            this._init();
        }

        private void _init() {
            this.savedBackground = this.getBackground();
            this.setDisabledTextColor(UITitledBox.DisabledTextColor);
            if (UITitledBox.DefaultTextBorder != null) {
                this.setBorder(UITitledBox.DefaultTextBorder);
            }
            Insets textMargin = this.getMargin();
            if (textMargin.left < 3) {
                textMargin.left = 3;
                this.setMargin(textMargin);
            }
        }

        public void setEnabled(boolean state) {
            super.setEnabled(state);
            this.setBackground(state ? this.savedBackground : UITitledBox.DisabledBackgroundColor);
        }

        protected class PrivateCaret
        extends DefaultCaret {
            public PrivateCaret() {
                Print.dprintln((String)"installing");
            }

            public void setDot(int p) {
                Print.dprintStackTrace((String)("Position: " + p));
                super.setDot(p);
            }

            public void moveDot(int p) {
                super.moveDot(p);
                Print.dprintStackTrace((String)("Position: " + p));
            }

            public void paint(Graphics g) {
                super.paint(g);
            }

            public Color getCaretColor() {
                return Color.red;
            }
        }
    }

    protected class NumericDocument
    extends PlainDocument {
        private boolean allowNegative = true;
        private boolean allowDecimal = false;
        private boolean allowExponents = false;

        public NumericDocument(boolean intOnly) {
            this.setAllowIntegerOnly(intOnly);
        }

        public void setAllowIntegerOnly(boolean intOnly) {
            this.allowDecimal = !intOnly;
        }

        public void setAllowNegativeNumbers(boolean allowNeg) {
            this.allowNegative = allowNeg;
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] s = str.toCharArray();
            char[] r = new char[s.length];
            int j = 0;
            for (int i = 0; i < r.length; ++i) {
                if (Character.isDigit(s[i])) {
                    r[j++] = s[i];
                    continue;
                }
                if (offs == 0 && this.allowNegative && s[i] == '-') {
                    if (!UITitledTextField.this.textField.getText().startsWith("-")) {
                        r[j++] = s[i];
                        continue;
                    }
                    Toolkit.getDefaultToolkit().beep();
                    continue;
                }
                if (this.allowDecimal && s[i] == '.') {
                    if (UITitledTextField.this.textField.getText().indexOf(".") < 0) {
                        r[j++] = s[i];
                        continue;
                    }
                    Toolkit.getDefaultToolkit().beep();
                    continue;
                }
                if (this.allowExponents && s[i] == 'E') {
                    String t = UITitledTextField.this.textField.getText();
                    if (t.indexOf("E") < 0 && t.indexOf(".", offs) < 0) {
                        r[j++] = s[i];
                        continue;
                    }
                    Toolkit.getDefaultToolkit().beep();
                    continue;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            super.insertString(offs, new String(r, 0, j), a);
        }
    }
}

