/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UITabbedPane
extends UITitledBox {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UITabbedPane.class);
    private static final String TAB_NAME = localStrings.getLocalString("ui.uitabbedpane.split_name", "Tabbed Pane");
    private static final String TAB_DESC = localStrings.getLocalString("ui.uitabbedpane.split_desc", "This is a tabbed pane");
    private int addingTab = 0;
    private ChangeListener changeListener = null;
    private JTabbedPane tabbedPane = null;

    public UITabbedPane() {
        this((String)null, false);
    }

    public UITabbedPane(String title, boolean showBorder) {
        super(title, showBorder);
        this.setTabbedPane(this.createPrivateTabbedPane());
    }

    public UITabbedPane(String title, boolean showBorder, JTabbedPane tabb) {
        super(title, showBorder);
        this.setTabbedPane(tabb);
    }

    public void setTabbedPane(JTabbedPane tabb) {
        if (this.tabbedPane != null) {
            if (this.changeListener != null) {
                this.tabbedPane.removeChangeListener(this.changeListener);
            }
            this.remove(this.tabbedPane);
        }
        this.tabbedPane = tabb;
        if (this.tabbedPane != null) {
            super.addWithGBConstraints(this.tabbedPane);
            if (this.changeListener == null) {
                this.changeListener = new ChangeListener(){

                    public void stateChanged(ChangeEvent ce) {
                        UITabbedPane.this.selectionChanged();
                    }
                };
            }
            this.tabbedPane.addChangeListener(this.changeListener);
            this.tabbedPane.invalidate();
        } else {
            this.invalidate();
        }
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void selectionChanged() {
    }

    public boolean isAddingTab() {
        return this.addingTab > 0;
    }

    public boolean hasValidTabPane() {
        return this.tabbedPane != null;
    }

    public void addTab(String title, Component comp) {
        if (this.hasValidTabPane()) {
            ++this.addingTab;
            this.tabbedPane.addTab(title, comp);
            --this.addingTab;
        }
    }

    public void insertTab(String title, Icon icon, Component comp, String tip, int ndx) {
        if (this.hasValidTabPane()) {
            ++this.addingTab;
            this.tabbedPane.insertTab(title, icon, comp, tip, ndx);
            --this.addingTab;
        }
    }

    public void removeTabAt(int ndx) {
        if (this.hasValidTabPane() && ndx >= 0) {
            this.tabbedPane.removeTabAt(ndx);
        }
    }

    public int indexOfComponent(Component comp) {
        return this.hasValidTabPane() ? this.tabbedPane.indexOfComponent(comp) : -1;
    }

    public int getTabCount() {
        return this.hasValidTabPane() ? this.tabbedPane.getTabCount() : 0;
    }

    public void requestFocus() {
        if (this.hasValidTabPane()) {
            this.tabbedPane.requestFocus();
        }
    }

    public Component getComponentAt(int ndx) {
        return this.hasValidTabPane() && ndx >= 0 ? this.tabbedPane.getComponentAt(ndx) : null;
    }

    public int getSelectedIndex() {
        return this.hasValidTabPane() ? this.tabbedPane.getSelectedIndex() : -1;
    }

    public void setSelectedIndex(int ndx) {
        if (this.hasValidTabPane() && ndx >= 0) {
            this.tabbedPane.setSelectedIndex(ndx);
        }
    }

    public void setEnabledAt(int ndx, boolean enabled) {
        if (this.hasValidTabPane() && ndx >= 0) {
            this.tabbedPane.setEnabledAt(ndx, enabled);
        }
    }

    public void setTitleAt(int ndx, String title) {
        if (this.hasValidTabPane() && ndx >= 0) {
            this.tabbedPane.setTitleAt(ndx, title);
        }
    }

    public void setIconAt(int ndx, Icon icon) {
        if (this.hasValidTabPane() && ndx >= 0) {
            this.tabbedPane.setIconAt(ndx, icon);
        }
    }

    public void setForegroundAt(int ndx, Color color) {
        if (this.hasValidTabPane() && ndx >= 0) {
            this.tabbedPane.setForegroundAt(ndx, color);
        }
    }

    protected JTabbedPane createPrivateTabbedPane() {
        return new PrivateTabbedPane();
    }

    protected class PrivateTabbedPane
    extends JTabbedPane {
        public PrivateTabbedPane() {
            this.getAccessibleContext().setAccessibleName(TAB_NAME);
            this.getAccessibleContext().setAccessibleDescription(TAB_DESC);
            this.setRequestFocusEnabled(true);
            this.addComponentListener(new ComponentAdapter(this){
                private final /* synthetic */ PrivateTabbedPane this$1;
                {
                    this.this$1 = this$1;
                }

                public void componentShown(ComponentEvent e) {
                    this.this$1.requestFocus();
                }
            });
            this.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ PrivateTabbedPane this$1;
                {
                    this.this$1 = this$1;
                }

                public void stateChanged(ChangeEvent e) {
                    this.this$1.requestFocus();
                }
            });
        }

        public void addNotify() {
            super.addNotify();
            this.requestFocus();
        }

        public void addTab(String title, Component comp) {
            UITabbedPane.this.addingTab++;
            super.addTab(title, comp);
            UITabbedPane.this.addingTab--;
        }

        public void insertTab(String title, Icon icon, Component comp, String tip, int ndx) {
            UITabbedPane.this.addingTab++;
            super.insertTab(title, icon, comp, tip, ndx);
            UITabbedPane.this.addingTab--;
        }

        public void setEnabledAt(int index, boolean enabled) {
            if (index >= 0) {
                super.setEnabledAt(index, enabled);
            }
        }
    }
}

