/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class UIRadioButtonBox
extends UITitledComboBox {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIRadioButtonBox.class);
    protected static String BUTTON_NAME = localStrings.getLocalString("ui.uiradiobuttonbox.about_pane_name", "Radio Button");
    protected static String BUTTON_DESC = localStrings.getLocalString("ui.uiradiobuttonbox.about_pane_desc", "This is a radio button to help you choose an option");
    private static final boolean ENABLE_KEY_SELECTION = true;
    private PrivateButtonGroup buttonGroup = null;

    public UIRadioButtonBox(String title, boolean showBorder, boolean isRadioButton) {
        super(title, showBorder, !isRadioButton);
        UIActionDispatcher.addKeyAction((JComponent)this, 40, new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                UIRadioButtonBox.this.moveSelectedIndex(true);
            }
        });
        UIActionDispatcher.addKeyAction((JComponent)this, 38, new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                UIRadioButtonBox.this.moveSelectedIndex(false);
            }
        });
    }

    public UIRadioButtonBox(String title, boolean showBorder) {
        this(title, showBorder, true);
    }

    public UIRadioButtonBox(String title) {
        this(title, true, true);
    }

    public UIRadioButtonBox() {
        this(null, true, true);
    }

    public static boolean getPrefersRadioButtons() {
        return Boolean.getBoolean("deploytool.preferRadioButtons");
    }

    private void addButton(Object obj) {
        AbstractButton btn = null;
        String key = null;
        if (obj instanceof AbstractButton) {
            btn = (AbstractButton)obj;
            key = btn.getText();
        } else if (obj instanceof String) {
            key = (String)obj;
            btn = UIRadioButtonBox.createRadioButton(key);
        } else {
            Print.printStackTrace((String)("Unsupported type : " + UIUtils.debugClassName(obj)));
        }
        this.radioButtonGroup().addButton(key, btn);
        this.lastAddedItem = key;
        this.addWithGBConstraints(btn);
    }

    private void addButtonList(Set list) {
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            this.addButton(itr.next());
        }
    }

    private void addButtonList(Object[] list) {
        for (int i = 0; i < list.length; ++i) {
            this.addButton(list[i]);
        }
    }

    private void addButtonList(Vector list) {
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            this.addButton(e.nextElement());
        }
    }

    private PrivateButtonGroup radioButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new PrivateButtonGroup();
        }
        return this.buttonGroup;
    }

    public void addSelectionEnabledComponent(Component comp, Object item) {
        if (item instanceof AbstractButton) {
            item = ((AbstractButton)item).getText();
        }
        super.addSelectionEnabledComponent(comp, item);
    }

    public void addSelectionEnabledAction(ActionListener action, Object item) {
        if (item instanceof AbstractButton) {
            item = ((AbstractButton)item).getText();
        }
        super.addSelectionEnabledAction(action, item);
    }

    public Vector getSelectionEnabledComponents(Object item) {
        if (item instanceof AbstractButton) {
            item = ((AbstractButton)item).getText();
        }
        return super.getSelectionEnabledComponents(item);
    }

    public void setItemEnabled(Object item, boolean enable) {
        if (!this.usingComboBox && item != null) {
            String title = item instanceof AbstractButton ? ((AbstractButton)item).getText() : item.toString();
            this.radioButtonGroup().setButtonEnabled(title, enable);
        }
    }

    public boolean isItemEnabled(Object item) {
        if (this.usingComboBox) {
            return true;
        }
        if (item != null) {
            String title = item instanceof AbstractButton ? ((AbstractButton)item).getText() : item.toString();
            return this.radioButtonGroup().isButtonEnabled(title);
        }
        return false;
    }

    public void setItemVisible(Object item, boolean visible) {
        if (!this.usingComboBox && item != null) {
            this.radioButtonGroup().setButtonVisible(item, visible);
        }
    }

    public void setReverseOrdering(boolean state) {
        if (state) {
            Print.printStackTrace((String)"Method not supported");
        } else {
            Print.dprintStackTrace((String)"Method not supported");
        }
    }

    public boolean isReverseOrdering() {
        return false;
    }

    public JComboBox getComboBox() {
        return this.usingComboBox ? super.getComboBox() : null;
    }

    public boolean isEditable() {
        return false;
    }

    public void setEditable(boolean state) {
        if (state) {
            Print.printStackTrace((String)"Method not supported");
        } else {
            Print.dprintStackTrace((String)"Method not supported");
        }
    }

    public boolean containsItem(Object item) {
        if (this.usingComboBox) {
            return super.containsItem(item);
        }
        return this.radioButtonGroup().containsButton(item);
    }

    public void addItem(Object item) {
        if (this.usingComboBox) {
            super.addItem(item);
        } else {
            this.addButton(item);
        }
    }

    public ComboBoxModel getModel() {
        return this.usingComboBox ? super.getModel() : null;
    }

    public void setModel(ComboBoxModel model) {
        if (this.usingComboBox) {
            super.setModel(model);
        } else {
            Object[] list = new Object[model.getSize()];
            for (int i = 0; i < list.length; ++i) {
                list[i] = model.getElementAt(i);
            }
            this.addButtonList(list);
        }
    }

    public void setModel(DefaultComboBoxModel model) {
        this.setModel((ComboBoxModel)model);
    }

    public void setModel(Object[] items) {
        if (this.usingComboBox) {
            super.setModel(items);
        } else {
            this.addButtonList(items);
        }
    }

    public void setModel(Vector items) {
        if (this.usingComboBox) {
            super.setModel(items);
        } else {
            this.addButtonList(items);
        }
    }

    public void setModel(Set items) {
        if (this.usingComboBox) {
            super.setModel(items);
        } else {
            this.addButtonList(items);
        }
    }

    public void setSelectedItem(Object item) {
        if (this.usingComboBox) {
            super.setSelectedItem(item);
        } else if (this.clearWhenDisabled) {
            if (!this.isEnabled()) {
                this.lastEnabledSelection = item;
            } else {
                this._setSelectedItem(item);
            }
        } else {
            this._setSelectedItem(item);
        }
    }

    private void _setSelectedItem(Object item) {
        this.radioButtonGroup().setSelectedButton(item);
        this._enableComponentsForSelection();
    }

    public Object getSelectedItem() {
        if (this.usingComboBox) {
            return super.getSelectedItem();
        }
        return this.radioButtonGroup().getSelectedText();
    }

    public void setSelectedIndex(int index) {
        if (this.usingComboBox) {
            super.setSelectedIndex(index);
        } else if (this.clearWhenDisabled) {
            if (!this.isEnabled()) {
                this.lastEnabledSelection = this.radioButtonGroup().getButtonAt(index);
            } else {
                this._setSelectedIndex(index);
            }
        } else {
            this._setSelectedIndex(index);
        }
    }

    private void _setSelectedIndex(int index) {
        this.radioButtonGroup().setSelectedIndex(index);
        this._enableComponentsForSelection();
    }

    public int getSelectedIndex() {
        if (this.usingComboBox) {
            return super.getSelectedIndex();
        }
        return this.radioButtonGroup().getSelectedIndex();
    }

    public void moveSelectedIndex(boolean down) {
        if (this.usingComboBox) {
            Print.dprintln((String)"Not supported");
        } else {
            this.radioButtonGroup().moveSelectedIndex(down);
        }
    }

    public Object[] getSelectedObjects() {
        if (this.usingComboBox) {
            return super.getSelectedObjects();
        }
        return new Object[]{this.getSelectedItem()};
    }

    public void setEnabled(boolean state) {
        if (this.usingComboBox) {
            super.setEnabled(state);
        } else {
            this.radioButtonGroup().setEnabled(state);
            super._setEnabled(state);
            if (this.clearWhenDisabled) {
                if (!this.isEnabled() && this.lastEnabledSelection == null) {
                    this.lastEnabledSelection = this.getSelectedItem();
                    this._setSelectedIndex(-1);
                } else if (this.isEnabled() && this.lastEnabledSelection != null) {
                    this._setSelectedItem(this.lastEnabledSelection);
                    this.lastEnabledSelection = null;
                }
            }
        }
    }

    public void setReadOnly(boolean state) {
        if (this.usingComboBox) {
            super.setReadOnly(state);
        } else {
            this.radioButtonGroup().setReadOnly(state);
            super._setReadOnly(state);
        }
    }

    public void addItemListener(ItemListener listener) {
        if (this.usingComboBox) {
            super.addItemListener(listener);
        } else {
            this.radioButtonGroup().addItemListener(listener);
        }
    }

    public void removeItemListener(ItemListener listener) {
        if (this.usingComboBox) {
            super.removeItemListener(listener);
        } else {
            this.radioButtonGroup().removeItemListener(listener);
        }
    }

    public static JRadioButton createRadioButton(String title) {
        PrivateRadioButton rb = new PrivateRadioButton();
        UIButton.setButtonText((AbstractButton)rb, title, 0);
        return rb;
    }

    public static JRadioButton createRadioButton(String title, char dftMnemonic) {
        PrivateRadioButton rb = new PrivateRadioButton();
        UIButton.setButtonText((AbstractButton)rb, title, dftMnemonic);
        return rb;
    }

    public String toString() {
        if (this.usingComboBox) {
            return super.toString();
        }
        return this.radioButtonGroup().toString();
    }

    protected GridBagConstraints getDefaultGBConstraints(GridBagConstraints c) {
        c = super.getDefaultGBConstraints(c);
        if (!this.usingComboBox) {
            if (this.hasVisibleBorder()) {
                c.insets.left += 2;
            }
            c.weightx = 0.5;
            c.weighty = 0.0;
            c.fill = 2;
            c.anchor = 17;
        }
        return c;
    }

    private class PrivateButtonGroup
    extends ButtonGroup
    implements ItemSelectable {
        private final String NONE_SELECTED = "<NoneSelected>";
        private HashMap buttonTable = new HashMap();
        private ActionListener actionListener = null;
        private JRadioButton noneSelected = null;
        private Vector itemListeners = null;
        private Vector disabledList = new Vector();
        private boolean _isEnabled = true;
        private boolean _isReadOnly = false;
        private AbstractButton lastActionButton = null;
        private int setSelected_recurse = 0;

        public PrivateButtonGroup() {
            this.actionListener = new ActionListener(this, UIRadioButtonBox.this){
                private final /* synthetic */ UIRadioButtonBox val$this$0;
                private final /* synthetic */ PrivateButtonGroup this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    AbstractButton btn = (AbstractButton)ae.getSource();
                    if (PrivateButtonGroup.access$000(this.this$1) && !PrivateButtonGroup.access$100(this.this$1)) {
                        if (PrivateButtonGroup.access$200(this.this$1) != btn) {
                            PrivateButtonGroup.access$202(this.this$1, btn);
                            PrivateButtonGroup.access$300(this.this$1);
                        } else {
                            Print.dprintln((String)"Button already selected");
                        }
                    }
                }
            };
        }

        private void clearLastSelectedButton() {
            this.lastActionButton = null;
        }

        public void addButton(String key, AbstractButton btn) {
            btn.addActionListener(this.actionListener);
            btn.setEnabled(this._isEnabled && !this._isReadOnly);
            this.buttonTable.put(key, btn);
            super.add(btn);
        }

        public void add(AbstractButton btn) {
            Print.printStackTrace((String)"Use 'addButton(...)' instead of 'add(...)'");
        }

        public AbstractButton getButton(String key) {
            return key != null ? (AbstractButton)this.buttonTable.get(key) : null;
        }

        public AbstractButton getButtonAt(int index) {
            return index >= 0 ? this.buttons.elementAt(index) : this._getNoneSelectedButton();
        }

        public boolean containsButton(Object key) {
            return key != null && this.buttonTable.containsKey(key);
        }

        public int getButtonCount() {
            return this.buttons.size();
        }

        public Vector getVisibleButtons() {
            Vector<AbstractButton> v = new Vector<AbstractButton>();
            Iterator<AbstractButton> i = this.buttons.iterator();
            while (i.hasNext()) {
                AbstractButton ab = i.next();
                if (!ab.isVisible()) continue;
                v.add(ab);
            }
            return v;
        }

        public void setButtonVisible(Object item, boolean visible) {
            AbstractButton btn = null;
            if (item == null) {
                return;
            }
            if (item instanceof AbstractButton) {
                btn = this.getButton(((AbstractButton)item).getText());
            } else if (item instanceof String) {
                btn = this.getButton((String)item);
            }
            if (btn != null) {
                Vector vb;
                btn.setVisible(visible);
                Vector sec = UIRadioButtonBox.this.getSelectionEnabledComponents(btn);
                if (sec != null && sec.size() > 0) {
                    Iterator i = sec.iterator();
                    while (i.hasNext()) {
                        Component c = (Component)i.next();
                        c.setVisible(visible);
                    }
                }
                if ((vb = this.getVisibleButtons()).size() == 1) {
                    AbstractButton rb = (AbstractButton)vb.elementAt(0);
                    if (rb instanceof PrivateRadioButton) {
                        ((PrivateRadioButton)rb).setSingleButton(true);
                    }
                    if (!rb.isSelected()) {
                        this.setSelectedButton(rb);
                    }
                } else if (vb.size() > 0) {
                    Iterator i = vb.iterator();
                    while (i.hasNext()) {
                        AbstractButton rb = (AbstractButton)i.next();
                        if (!(rb instanceof PrivateRadioButton)) continue;
                        ((PrivateRadioButton)rb).setSingleButton(false);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelected(ButtonModel m, boolean b) {
            if (this.setSelected_recurse > 0) {
                return;
            }
            try {
                ++this.setSelected_recurse;
                super.setSelected(m, b);
                this.clearLastSelectedButton();
                this._enableButtons();
                UIRadioButtonBox.this._enableComponentsForSelection();
            }
            finally {
                --this.setSelected_recurse;
            }
        }

        public void setSelectedIndex(int index) {
            AbstractButton btn = this.getButtonAt(index);
            btn.setSelected(true);
        }

        public int getSelectedIndex() {
            for (int i = 0; i < this.getButtonCount(); ++i) {
                AbstractButton btn = (AbstractButton)this.buttons.elementAt(i);
                if (btn == this.noneSelected || !btn.isSelected()) continue;
                return i;
            }
            return -1;
        }

        public void moveSelectedIndex(boolean down) {
            int ofs = down ? 1 : -1;
            int oldNdx = this.getSelectedIndex();
            if (oldNdx < 0) {
                return;
            }
            int selNdx = oldNdx;
            AbstractButton btn = null;
            while ((btn = this.buttons.elementAt(selNdx = (selNdx + ofs + this.getButtonCount()) % this.getButtonCount())) == this.noneSelected || !btn.isEnabled()) {
                if (selNdx != oldNdx) continue;
                return;
            }
            btn.doClick();
            btn.requestFocus();
        }

        public void setSelectedButton(Object item) {
            AbstractButton btn = null;
            if (item == null) {
                btn = this._getNoneSelectedButton();
            } else if (item instanceof AbstractButton) {
                btn = this.getButton(((AbstractButton)item).getText());
            } else if (item instanceof String) {
                btn = this.getButton((String)item);
            }
            if (btn != null) {
                btn.setSelected(true);
            }
        }

        public AbstractButton getSelectedButton() {
            int n = this.getSelectedIndex();
            return n < 0 ? null : (AbstractButton)this.buttons.elementAt(n);
        }

        public String getSelectedText() {
            AbstractButton btn = this.getSelectedButton();
            return btn == null || btn == this.noneSelected ? null : btn.getText();
        }

        public void setReadOnly(boolean state) {
            if (this._isReadOnly != state) {
                this._isReadOnly = state;
                this._enableButtons();
            }
        }

        public void setEnabled(boolean state) {
            if (this._isEnabled != state) {
                this._isEnabled = state;
                this._enableButtons();
            }
        }

        public void setButtonEnabled(String key, boolean state) {
            AbstractButton b = this.getButton(key);
            if (b != null) {
                if (state) {
                    this.disabledList.remove(b);
                } else if (!this.disabledList.contains(b)) {
                    this.disabledList.add(b);
                }
                this._enableButton(b);
                if (!b.isEnabled() && b.isSelected()) {
                    for (int i = 0; i < this.getButtonCount(); ++i) {
                        AbstractButton btn = (AbstractButton)this.buttons.elementAt(i);
                        if (btn == this.noneSelected || !btn.isEnabled()) continue;
                        this.setSelectedIndex(i);
                    }
                }
            }
        }

        public boolean isButtonEnabled(String key) {
            AbstractButton b = this.getButton(key);
            return b != null ? b.isEnabled() : false;
        }

        private void _enableButtons() {
            Enumeration e = this.buttons.elements();
            while (e.hasMoreElements()) {
                this._enableButton((AbstractButton)e.nextElement());
            }
        }

        private void _enableButton(AbstractButton b) {
            if (!this._isEnabled) {
                b.setEnabled(false);
            } else if (this._isReadOnly && !b.isSelected()) {
                b.setEnabled(false);
            } else if (this.disabledList.contains(b)) {
                b.setEnabled(false);
            } else {
                b.setEnabled(true);
            }
        }

        private JRadioButton _getNoneSelectedButton() {
            if (this.noneSelected == null) {
                this.noneSelected = UIRadioButtonBox.createRadioButton("<NoneSelected>");
                super.add(this.noneSelected);
            }
            return this.noneSelected;
        }

        private void selectionChanged() {
            UIRadioButtonBox.this._enableComponentsForSelection();
            UIRadioButtonBox.this.updateComponent(UIRadioButtonBox.this);
            if (this.itemListeners != null) {
                ItemEvent ie = new ItemEvent(this, 701, this.getSelectedButton(), 1);
                Enumeration enumeration = this.itemListeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((ItemListener)enumeration.nextElement()).itemStateChanged(ie);
                }
            }
        }

        public void addItemListener(ItemListener listener) {
            if (listener != null) {
                if (this.itemListeners == null) {
                    this.itemListeners = new Vector();
                }
                this.itemListeners.add(listener);
            }
        }

        public void removeItemListener(ItemListener listener) {
            if (listener != null && this.itemListeners != null) {
                this.itemListeners.remove(listener);
            }
        }

        public Object[] getSelectedObjects() {
            return new Object[]{this.getSelectedButton()};
        }

        static /* synthetic */ boolean access$000(PrivateButtonGroup x0) {
            return x0._isEnabled;
        }

        static /* synthetic */ boolean access$100(PrivateButtonGroup x0) {
            return x0._isReadOnly;
        }

        static /* synthetic */ AbstractButton access$200(PrivateButtonGroup x0) {
            return x0.lastActionButton;
        }

        static /* synthetic */ AbstractButton access$202(PrivateButtonGroup x0, AbstractButton x1) {
            x0.lastActionButton = x1;
            return x0.lastActionButton;
        }

        static /* synthetic */ void access$300(PrivateButtonGroup x0) {
            x0.selectionChanged();
        }
    }

    protected static class SingleRadioButtonUI
    extends BasicRadioButtonUI {
        protected SingleRadioButtonUI() {
        }

        public synchronized void paint(Graphics g, JComponent c) {
            PrivateRadioButton b = (PrivateRadioButton)c;
            ButtonModel model = b.getModel();
            Font f = c.getFont();
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics();
            Dimension size = b.getSize();
            Rectangle viewRect = new Rectangle(0, 0, size.width, size.height);
            Rectangle textRect = new Rectangle(0, 0, 0, 0);
            Rectangle iconRect = new Rectangle(0, 0, 0, 0);
            String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), null, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, 0);
            if (c.isOpaque()) {
                g.setColor(b.getBackground());
                g.fillRect(0, 0, size.width, size.height);
            }
            if (text != null) {
                if (model.isEnabled()) {
                    g.setColor(UITitledBox.getDefaultTitleColor());
                    BasicGraphicsUtils.drawString(g, text, 0, textRect.x, textRect.y + fm.getAscent());
                } else {
                    g.setColor(b.getBackground().brighter());
                    BasicGraphicsUtils.drawString(g, text, 0, textRect.x + 1, textRect.y + fm.getAscent() + 1);
                    g.setColor(b.getBackground().darker());
                    BasicGraphicsUtils.drawString(g, text, 0, textRect.x, textRect.y + fm.getAscent());
                }
            }
        }
    }

    private static class PrivateRadioButton
    extends JRadioButton {
        private ButtonUI singleUI = null;
        private ButtonUI ui = null;

        public PrivateRadioButton() {
            this.getAccessibleContext().setAccessibleName(BUTTON_NAME);
            this.getAccessibleContext().setAccessibleDescription(BUTTON_DESC);
        }

        public void setSingleButton(boolean single) {
            if (single) {
                if (this.ui == null) {
                    this.ui = this.getUI();
                    this.setUI(this.getSingleRadioButtonUI());
                }
            } else if (this.ui != null) {
                this.setUI(this.ui);
                this.ui = null;
            }
        }

        protected ButtonUI getSingleRadioButtonUI() {
            if (this.singleUI == null) {
                this.singleUI = new SingleRadioButtonUI();
            }
            return this.singleUI;
        }

        public void setEnabled(boolean state) {
            super.setEnabled(state);
        }
    }
}

