/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class UIProgressBar
extends UITitledBox {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIProgressBar.class);
    protected static String PROGRESS_NAME = localStrings.getLocalString("ui.uiprogressbar.progress_name", "Progress Bar");
    protected static String PROGRESS_DESC = localStrings.getLocalString("ui.uiprogressbar.progress_desc", "This is a progress status bar");
    private PrivateProgressBar progressBar = null;

    public UIProgressBar(ImageIcon iconTitle, boolean vert, int max, Color color) {
        super((String)null, false);
        GridBagConstraints gbc;
        this.getGBConstraints().gridx = vert ? 0 : -1;
        int n = this.getGBConstraints().gridy = !vert ? 0 : -1;
        if (iconTitle != null) {
            gbc = this.getGBConstraintsCopy();
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            JLabel jl = new JLabel(iconTitle);
            jl.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.uiprogressbar.label_name", "Progress Label"));
            jl.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.uiprogressbar.label_desc", "This is a label for progress bar"));
            this.add((Component)jl, gbc);
        }
        this.progressBar = new PrivateProgressBar(vert, max, color);
        gbc = this.getGBConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.5;
        gbc.fill = 3;
        this.addWithGBConstraints(this.progressBar);
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setBarWidth(int w) {
        Dimension d = this.progressBar.getPreferredSize();
        Dimension pref = this.progressBar.getOrientation() == 1 ? new Dimension(w, d.height) : new Dimension(d.width, w);
        this.progressBar.setMinimumSize(pref);
        this.progressBar.setPreferredSize(pref);
    }

    public int getMaximum() {
        return this.progressBar.getMaximum();
    }

    public int getValue() {
        return this.progressBar.getValue();
    }

    public void setValue(int val) {
        this.progressBar.setValue(val);
    }

    public void increment(int val) {
        this.progressBar.increment(val);
    }

    public void increment() {
        this.progressBar.increment();
    }

    class PrivateProgressBar
    extends JProgressBar {
        public PrivateProgressBar(boolean vertical, int max, Color color) {
            super(vertical ? 1 : 0, 0, max);
            if (color != null) {
                this.setForeground(color);
            }
            this.setBorderPainted(true);
            this.getAccessibleContext().setAccessibleName(PROGRESS_NAME);
            this.getAccessibleContext().setAccessibleDescription(PROGRESS_DESC);
            this.setValue(0);
        }

        public void increment(int val) {
            this.setValue(this.getValue() + val);
        }

        public void increment() {
            this.increment(1);
        }
    }
}

