/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JComponent;

public class UIJndiName
extends UITitledBox {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIJndiName.class);
    private static final String JNDI_NAME = localStrings.getLocalString("ui.uijndiname.jndiname_title", "JNDI Name:");
    private static final String IMPORT_RESOURCES = localStrings.getLocalString("ui.uijndiname.import.button", "Import Data Sources...");
    private static final String IMPORT_TYPE_ALL = localStrings.getLocalString("ui.uijndiname.import.type_all", "All");
    private static boolean AutoImportResources = !UIConfig.getConfigBoolean("/WSPack");
    public static final int TYPE_DEFAULT = 0;
    public static final int TYPE_EJB = 1;
    public static final int TYPE_WEB = 2;
    public static final int TYPE_RESOURCE = 3;
    public static final int TYPE_APPS = 4;
    private UITitledBox jndiName = new UITitledComboBox(null, false);
    private UIButton importButton = null;
    private Descriptor lastJndiDescriptor = null;
    private String lastJndiType = null;

    private static final String IMPORTED_JNDI_NAMES(Object v0) {
        return localStrings.getLocalString("ui.uijndiname.import.done", "JNDI names for the following type have been imported:\n {0}", new Object[]{v0});
    }

    public static String getJNDINameTitle() {
        return JNDI_NAME;
    }

    public UIJndiName(String title, boolean showBorder) {
        super(title, showBorder);
        this.setEditable(true);
        this.jndiName.setClearWhenDisabled(true);
        this.jndiName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UIJndiName.this.updateComponent(UIJndiName.this.jndiName);
            }
        });
        this.addWithGBConstraints(this.jndiName);
        if (!AutoImportResources) {
            this.addImportButton();
        }
    }

    public UIJndiName() {
        this(JNDI_NAME, false);
    }

    private void addImportButton() {
        this.importButton = new UIButton(IMPORT_RESOURCES, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UIJndiName.this.importJndiNames();
            }
        });
        this.importButton.setMargin(new Insets(0, 3, 0, 3));
        Dimension bsize = new Dimension(this.importButton.getPreferredSize().width, this.jndiName.getPreferredSize().height);
        this.importButton.setPreferredSize(bsize);
        this.importButton.setMaximumSize(bsize);
        GridBagConstraints c = this.getGBConstraintsCopy();
        c.weightx = 0.0;
        c.gridx = -1;
        c.gridy = 0;
        c.insets.left = 3;
        c.fill = 0;
        this.add((Component)this.importButton, c);
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.jndiName.setReadOnly(state);
        if (this.importButton != null) {
            this.importButton.setReadOnly(state);
        }
    }

    public void setChildrenReadOnly(boolean state) {
    }

    public void setEnabled(boolean state) {
        super.setEnabled(state);
        if (this.jndiName.isEnabled() != state) {
            this.jndiName.setEnabled(state);
            if (this.importButton != null) {
                this.importButton.setEnabled(state);
            }
        }
    }

    public Component getJndiEditor() {
        JComponent c = null;
        if (this.jndiName instanceof UITitledComboBox) {
            c = ((UITitledComboBox)this.jndiName).getComboBox();
        } else if (this.jndiName instanceof UITitledTextField) {
            c = ((UITitledTextField)this.jndiName).getTextField();
        }
        return c;
    }

    public String getJndiName() {
        String t = null;
        if (this.jndiName instanceof UITitledComboBox) {
            t = ((UITitledComboBox)this.jndiName).getText();
        } else if (this.jndiName instanceof UITitledTextField) {
            t = ((UITitledTextField)this.jndiName).getText();
        }
        return t;
    }

    public void setJndiName(String jndiName) {
        if (this.jndiName instanceof UITitledComboBox) {
            ((UITitledComboBox)this.jndiName).setText(jndiName != null ? jndiName : "");
        } else if (this.jndiName instanceof UITitledTextField) {
            ((UITitledTextField)this.jndiName).setText(jndiName != null ? jndiName : "");
        }
    }

    public void setEditable(boolean editable) {
        if (this.jndiName instanceof UITitledComboBox) {
            ((UITitledComboBox)this.jndiName).setEditable(editable);
        } else if (this.jndiName instanceof UITitledTextField) {
            // empty if block
        }
    }

    public void setAvailableJndiNames(Collection list) {
        if (this.jndiName instanceof UITitledComboBox) {
            UITitledComboBox cb = (UITitledComboBox)this.jndiName;
            Object sel = cb.getSelectedItem();
            cb.setModel(list);
            if (!cb.containsItem(sel)) {
                cb.addItem(sel);
            }
            cb.setSelectedItem(sel);
        } else if (this.jndiName instanceof UITitledTextField) {
            // empty if block
        }
    }

    public void setAvailableJndiNames(Object[] list) {
        if (this.jndiName instanceof UITitledComboBox) {
            UITitledComboBox cb = (UITitledComboBox)this.jndiName;
            Object sel = cb.getSelectedItem();
            cb.setModel(list);
            if (!cb.containsItem(sel)) {
                cb.addItem(sel);
            }
            cb.setSelectedItem(sel);
        } else if (this.jndiName instanceof UITitledTextField) {
            // empty if block
        }
    }

    private Vector getJndiNames(Descriptor d, String type, boolean importNames) {
        String typeKey = type != null ? type : "";
        Vector v = null;
        if (importNames) {
            v = new Vector();
            Collection smJndi = DT.getServerManager().getGlobalJndiNames(type);
            if (smJndi != null) {
                v.addAll(smJndi);
            } else {
                v = null;
            }
        }
        this.lastJndiDescriptor = d;
        this.lastJndiType = type;
        return v;
    }

    public void resetAvailableJndiNames() {
        this.lastJndiDescriptor = null;
        this.lastJndiType = null;
    }

    private void importJndiNames() {
        Vector v = this.getJndiNames(this.lastJndiDescriptor, this.lastJndiType, true);
        this.setAvailableJndiNames(v);
        if (v != null) {
            String type = this.lastJndiType != null ? this.lastJndiType : IMPORT_TYPE_ALL;
            UIOptionPane.showInfoDialog(null, UIJndiName.IMPORTED_JNDI_NAMES(type));
        }
    }

    public void setAvailableJndiNames(Descriptor d, String type) {
        boolean importNames = AutoImportResources;
        this.setAvailableJndiNames(this.getJndiNames(d, type, importNames));
    }
}

