/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.utils.FileTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;

public class UIFileChooser
extends JFileChooser {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIFileChooser.class);
    protected static String FILE_CHOOSER_NAME = localStrings.getLocalString("ui.uifilechooser.file_chooser_name", "File chooser");
    protected static String FILE_CHOOSER_DESC = localStrings.getLocalString("ui.uifilechooser.file_chooser_desc", "This is a file chooser window that enables you to browse directories");
    private static final String APPROVAL_TEXT = localStrings.getLocalString("ui.uifilechooser.approval_text", "Open");
    private static final String CLASS_FILES = localStrings.getLocalString("ui.uifilechooser.filter.class", "Class Files");
    private static final String JAR_FILES = localStrings.getLocalString("ui.uifilechooser.filter.jar", "Jar Files");
    private static final String APP_FILES = localStrings.getLocalString("ui.uifilechooser.filter.application", "Application Files");
    private static final String JSP_FILES = localStrings.getLocalString("ui.uifilechooser.filter.jsp", "Jsp Files");
    private static final String IMAGE_FILES = localStrings.getLocalString("ui.uifilechooser.filter.image", "Image Files");
    private static final String RAR_FILES = localStrings.getLocalString("ui.uifilechooser.filter.rar", "Resource Adapter Files");
    private static final String WAR_FILES = localStrings.getLocalString("ui.uifilechooser.filter.war", "Web Module Files");
    private static final String CERT_FILES = localStrings.getLocalString("ui.uifilechooser.filter.certificates", "Certificate Files");
    private static final String XML_FILES = localStrings.getLocalString("ui.uifilechooser.filter.xml", "XML Files");
    private static final String MODULE_FILES = localStrings.getLocalString("ui.uifilechooser.filter.module", "All Module Files");
    public static final String FILTER_ALL = "AllFiles";
    public static final String FILTER_EAR = "EarFiles";
    public static final String FILTER_JAR = "JarFiles";
    public static final String FILTER_EJB = "JarFiles";
    public static final String FILTER_JSP = "JspFiles";
    public static final String FILTER_RAR = "RarFiles";
    public static final String FILTER_WAR = "WarFiles";
    public static final String FILTER_APPC = "JarFiles";
    public static final String FILTER_ALLMODULE = "AllModuleFiles";
    public static final String FILTER_MODULE = "@ModuleFiles";
    public static final String FILTER_CLASS = "ClassFiles";
    public static final String FILTER_CERT = "CertFiles";
    public static final String FILTER_IMAGE = "ImageFiles";
    public static final String FILTER_XML = "XMLFiles";
    private static final String[] MODULE_FILTERS = new String[]{"AllModuleFiles", "EarFiles", "JarFiles", "WarFiles", "RarFiles", "JarFiles"};
    private static Hashtable _customFilters = null;
    private static UIFileChooser _customFileChooser = null;
    private static UIFileChooser _customDirChooser = null;
    private static File lastWorkingDir = null;
    private static boolean DISABLE_NEW_FOLDER = false;
    private static boolean DISABLE_FILENAME_EDITOR = false;

    private static String INVALID_PARENT(Object v0) {
        return localStrings.getLocalString("ui.uifilechooser.parent_is_invalid", "{0}\nParent directory does not exist.", new Object[]{v0});
    }

    public static String getFilterNameForExtension(String extn) {
        String e = extn.toLowerCase();
        if (!e.startsWith(".")) {
            e = "." + e;
        }
        if (e.equals(".ear")) {
            return FILTER_EAR;
        }
        if (e.equals(".jar")) {
            return "JarFiles";
        }
        if (e.equals(".jsp")) {
            return FILTER_JSP;
        }
        if (e.equals(".rar")) {
            return FILTER_RAR;
        }
        if (e.equals(".war")) {
            return FILTER_WAR;
        }
        if (e.equals(".xml")) {
            return FILTER_XML;
        }
        if (e.equals(".gif")) {
            return FILTER_IMAGE;
        }
        if (e.equals(".jpg")) {
            return FILTER_IMAGE;
        }
        if (e.equals(".jpeg")) {
            return FILTER_IMAGE;
        }
        if (e.equals(".class")) {
            return FILTER_CLASS;
        }
        return FILTER_ALL;
    }

    private static Hashtable getCustomFileFilters() {
        if (_customFilters == null) {
            _customFilters = new Hashtable();
            _customFilters.put(FILTER_EAR, new UIFileFilter("ear", APP_FILES));
            _customFilters.put("JarFiles", new UIFileFilter("jar", JAR_FILES));
            _customFilters.put(FILTER_RAR, new UIFileFilter("rar", RAR_FILES));
            _customFilters.put(FILTER_WAR, new UIFileFilter("war", WAR_FILES));
            _customFilters.put(FILTER_ALLMODULE, new UIFileFilter("ear:jar:war:rar", MODULE_FILES));
            _customFilters.put(FILTER_MODULE, MODULE_FILTERS);
            _customFilters.put(FILTER_JSP, new UIFileFilter("jsp:jspx", JSP_FILES));
            _customFilters.put(FILTER_CLASS, new UIFileFilter("class", CLASS_FILES));
            _customFilters.put(FILTER_CERT, new UIFileFilter("cer:cert", CERT_FILES));
            _customFilters.put(FILTER_IMAGE, new UIFileFilter("gif:jpg:jpeg", IMAGE_FILES));
            _customFilters.put(FILTER_XML, new UIFileFilter("xml", XML_FILES));
        }
        return _customFilters;
    }

    private static FileFilter[] getChoosableFileFilters(String key) {
        Vector v = UIFileChooser._getChoosableFileFilters(new Vector(), key);
        return v.size() > 0 ? v.toArray(new FileFilter[v.size()]) : null;
    }

    private static Vector _getChoosableFileFilters(Vector v, String key) {
        Object filter;
        Object e = filter = key != null ? (Object)UIFileChooser.getCustomFileFilters().get(key) : null;
        if (filter != null) {
            if (filter instanceof FileFilter) {
                if (!v.contains(filter)) {
                    v.add(filter);
                }
            } else if (filter instanceof String[]) {
                String[] filterList = (String[])filter;
                for (int f = 0; f < filterList.length; ++f) {
                    UIFileChooser._getChoosableFileFilters(v, filterList[f]);
                }
            }
        }
        return v;
    }

    public static UIFileChooser getDirChooser(File currentDir) {
        if (_customDirChooser == null) {
            _customDirChooser = new UIFileChooser();
            _customDirChooser.getAccessibleContext().setAccessibleName(FILE_CHOOSER_NAME);
            _customDirChooser.getAccessibleContext().setAccessibleDescription(FILE_CHOOSER_DESC);
            _customDirChooser.setFileSelectionMode(1);
        }
        UIFileChooser._setCurrentDirectory(_customDirChooser, currentDir);
        return _customDirChooser;
    }

    public static UIFileChooser getFileChooser(File currentDir) {
        return UIFileChooser.getFileChooser(currentDir, null);
    }

    public static UIFileChooser getFileChooser(File currentDir, String filterKey) {
        if (_customFileChooser == null) {
            _customFileChooser = new UIFileChooser();
            _customFileChooser.getAccessibleContext().setAccessibleName(FILE_CHOOSER_NAME);
            _customFileChooser.getAccessibleContext().setAccessibleDescription(FILE_CHOOSER_DESC);
            _customFileChooser.setFileSelectionMode(0);
        }
        UIFileChooser._setFileFilter(_customFileChooser, filterKey);
        UIFileChooser._setCurrentDirectory(_customFileChooser, currentDir);
        return _customFileChooser;
    }

    private static void _setFileFilter(UIFileChooser fc, String filterKey) {
        fc.resetChoosableFileFilters();
        fc.setAcceptAllFileFilterUsed(false);
        FileFilter[] filters = UIFileChooser.getChoosableFileFilters(filterKey);
        if (filters != null && filters.length > 0) {
            for (int f = 0; f < filters.length; ++f) {
                fc.addChoosableFileFilter(filters[f]);
            }
            fc.setFileFilter(filters[0]);
        } else {
            fc.setFileFilter(fc.getAcceptAllFileFilter());
        }
    }

    private static void _setCurrentDirectory(UIFileChooser fc, File dir) {
        if (dir != null) {
            if (dir.isFile()) {
                fc.setSelectedFile(dir);
            } else {
                fc.setSelectedFile(null);
                fc.setCurrentDirectory(dir);
            }
        } else {
            fc.setSelectedFile(null);
            fc.setCurrentDirectory(UIConfig.getStartingDirectory());
        }
        fc.rescanCurrentDirectory();
    }

    public static void saveCurrentDirectory() {
        if (lastWorkingDir != null) {
            UIConfig.addStartingDirectory(lastWorkingDir);
            UIConfig.saveConfig();
        }
    }

    private static void _hackFileChooser(JFileChooser jfc) {
        UIFileChooser._scanFileChooserComponents(jfc);
    }

    private static void _scanFileChooserComponents(Component parent) {
        if (parent instanceof JButton) {
            if (DISABLE_NEW_FOLDER) {
                UIFileChooser._disableNewFolderButton((JButton)parent);
            }
        } else if (parent instanceof JList) {
            if (DISABLE_FILENAME_EDITOR) {
                UIFileChooser._disableFilenameEditor((JList)parent);
            }
        } else if (parent instanceof Container) {
            Component[] child = ((Container)parent).getComponents();
            for (int i = 0; i < child.length; ++i) {
                UIFileChooser._scanFileChooserComponents(child[i]);
            }
        }
    }

    private static boolean _disableNewFolderButton(JButton btn) {
        EventListener[] ev = btn.getListeners(ActionListener.class);
        for (int i = 0; i < ev.length; ++i) {
            String name = ev[i].getClass().getName();
            if (!name.endsWith("$NewFolderAction")) continue;
            btn.removeActionListener((ActionListener)ev[i]);
            btn.setEnabled(false);
        }
        return false;
    }

    private static boolean _disableFilenameEditor(JList list) {
        EventListener[] ev = list.getListeners(MouseListener.class);
        for (int i = 0; i < ev.length; ++i) {
            String name = ev[i].getClass().getName();
            if (!name.endsWith("$SingleClickListener")) continue;
            list.removeMouseListener((MouseListener)ev[i]);
            return true;
        }
        return false;
    }

    private UIFileChooser() {
        UIFileChooser._hackFileChooser(this);
    }

    public int showDialog(Component parent, String dialogTitle, String approveButtonText) {
        int rtn;
        if (dialogTitle != null) {
            super.setDialogTitle(dialogTitle);
        }
        if (parent == null) {
            parent = DT.getApplicationFrame();
        }
        if (approveButtonText == null) {
            approveButtonText = APPROVAL_TEXT;
        }
        if ((rtn = super.showDialog(parent, approveButtonText)) == 0) {
            lastWorkingDir = this.getCurrentDirectory();
        }
        if (dialogTitle != null) {
            super.setDialogTitle(null);
        }
        return rtn;
    }

    public int showDialog(Component parent, String approveButtonText) {
        return this.showDialog(parent, null, approveButtonText);
    }

    public int showOpenDialog(Component parent) {
        int rtn;
        if (parent == null) {
            parent = DT.getApplicationFrame();
        }
        if ((rtn = super.showOpenDialog(parent)) == 0) {
            lastWorkingDir = this.getCurrentDirectory();
        }
        return rtn;
    }

    public int showSaveDialog(Component parent) {
        int rtn;
        if (parent == null) {
            parent = DT.getApplicationFrame();
        }
        if ((rtn = super.showSaveDialog(parent)) == 0) {
            lastWorkingDir = this.getCurrentDirectory();
        }
        return rtn;
    }

    public void addChoosableFileFilter(String[] extn, String description) {
        this.addChoosableFileFilter(new UIFileFilter(extn, description));
    }

    public void addChoosableFileFilter(FileFilter filter) {
        if (filter != null) {
            super.addChoosableFileFilter(filter);
        }
    }

    public void approveSelection() {
        FileFilter fileFilter = this.getFileFilter();
        String filterDesc = fileFilter.getDescription();
        if (filterDesc.toLowerCase().indexOf("all") < 0) {
            File file = super.getSelectedFile();
            String fileName = file.getName();
            if (!FileTools.validateFileName(this, fileName)) {
                return;
            }
            if (fileFilter instanceof UIFileFilter && !fileFilter.accept(file)) {
                file = new File(file.getPath() + "." + ((UIFileFilter)fileFilter).getExtensionAt(0));
            }
            if (file.isAbsolute()) {
                file = file.getAbsoluteFile();
            }
            if (!file.getParentFile().isDirectory()) {
                UIOptionPane.showErrorDialog(this, UIFileChooser.INVALID_PARENT(file.getParentFile()));
                return;
            }
            this.setSelectedFile(file);
        }
        super.approveSelection();
    }

    public void setSelectedFile(File file) {
        FileChooserUI ui;
        super.setSelectedFile(file);
        if ((file == null || file.equals("")) && (ui = this.getUI()) instanceof BasicFileChooserUI) {
            ((BasicFileChooserUI)ui).setFileName("");
        }
    }

    public File getSelectedFile() {
        String fn;
        File file = super.getSelectedFile();
        Window win = WinTools.getAncestorWindow(this);
        if (win != null && win.isShowing()) {
            return file;
        }
        String string = fn = file != null ? file.getPath() : null;
        if (fn != null && !fn.equals("") && this.getFileSelectionMode() == 0) {
            if (file.isDirectory()) {
                Print.dprintln((String)"Selected file is a directory!");
                return null;
            }
            FileFilter filter = this.getFileFilter();
            if (filter instanceof UIFileFilter && !filter.accept(file)) {
                file = new File(fn + "." + ((UIFileFilter)filter).getExtensionAt(0));
            }
        }
        return file;
    }

    private static String[] parseExtensions(String extn) {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(extn, ":");
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v.toArray(new String[v.size()]);
    }

    public void setUI(ComponentUI ui) {
        if (UITitledBox.isMetalLookAndFeel()) {
            super.setUI(PrivateMetalFileChooserUI.createUI(this));
        } else {
            Print.dprintln((String)"Not MetalLookAndFeel: initializing with standard L&F");
            super.setUI(ui);
        }
    }

    public void updateUI() {
        super.updateUI();
    }

    private static class PrivateMetalFileChooserUI
    extends MetalFileChooserUI {
        public static ComponentUI createUI(JComponent c) {
            return new PrivateMetalFileChooserUI((JFileChooser)c);
        }

        public PrivateMetalFileChooserUI(JFileChooser fc) {
            super(fc);
        }

        public void setFileName(String fn) {
            if (fn == null || fn.equals("")) {
                super.setFileName(fn);
            } else if (super.getFileChooser().getFileSelectionMode() == 0) {
                File dir = super.getFileChooser().getCurrentDirectory();
                if (dir != null && new File(dir, fn).isDirectory()) {
                    return;
                }
                super.setFileName(fn);
            } else {
                super.setFileName(fn);
            }
        }
    }

    private static class UIFileFilter
    extends FileFilter {
        private Vector extensions = null;
        private String description = null;
        private String fullDescription = null;

        public UIFileFilter(String extn, String text) {
            this(UIFileChooser.parseExtensions(extn), text);
        }

        public UIFileFilter(String[] extn, String text) {
            for (int i = 0; i < extn.length; ++i) {
                this.addExtension(extn[i].toLowerCase());
            }
            if (this.getExtensionCount() <= 0) {
                Print.printStackTrace((String)"Must have at lease one extension");
                this.addExtension("jar");
            }
            if (text != null) {
                this.setDescription(text);
            }
        }

        public boolean accept(File f) {
            return f != null && (f.isDirectory() || this.checkExtension(f));
        }

        public String getDescription() {
            if (this.fullDescription == null) {
                StringBuffer sb = new StringBuffer();
                if (this.description != null) {
                    sb.append(this.description).append(" ");
                }
                sb.append("(");
                Enumeration e = this.getExtensions().elements();
                while (e.hasMoreElements()) {
                    sb.append(".").append((String)e.nextElement());
                    if (!e.hasMoreElements()) continue;
                    sb.append(", ");
                }
                sb.append(")");
                this.fullDescription = sb.toString();
            }
            return this.fullDescription;
        }

        public void setDescription(String d) {
            this.description = d;
            this.fullDescription = null;
        }

        public void addExtension(String extn) {
            this.getExtensions().add(extn.toLowerCase());
            this.fullDescription = null;
        }

        public int getExtensionCount() {
            return this.getExtensions().size();
        }

        public String getExtensionAt(int ndx) {
            return (String)this.getExtensions().elementAt(ndx);
        }

        private Vector getExtensions() {
            if (this.extensions == null) {
                this.extensions = new Vector();
            }
            return this.extensions;
        }

        private boolean checkExtension(File f) {
            String fileName = f.getName();
            String fileExt = "";
            int i = fileName.lastIndexOf(46);
            if (i > 0 && i < fileName.length() - 1) {
                fileExt = fileName.substring(i + 1).toLowerCase();
            }
            return this.getExtensions().contains(fileExt);
        }
    }
}

