/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.dtv.TreeCombo;
import com.sun.enterprise.tools.deployment.ui.utils.FileTools;
import com.sun.enterprise.tools.deployment.ui.utils.StringTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JRadioButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UIDisplayNameBox
extends UITitledBox {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIDisplayNameBox.class);
    private static final String ID_PREFIX = "$.";
    public static final String ID_APP_COMBO = "$.AppChooser";
    public static final String ID_WAR_COMBO = "$.WarChooser";
    public static final String ID_EJB_COMBO = "$.EjbChooser";
    public static final int TYPE_DEFAULT = 0;
    public static final int TYPE_WAR = 1;
    public static final int TYPE_EJB = 2;
    public static final int TYPE_RAR = 3;
    public static final int TYPE_APPC = 4;
    public static final int TYPE_APPS = 99;
    private static boolean enableStandAlone = true;
    private static boolean enableNewInApp = true;
    private static boolean enableAddToExisting = true;
    private static final boolean AllowOpenExisting = true;
    private static final boolean ShowDisabledOptions = true;
    private static final int FILENAME_FIELD_WIDTH = 400;
    private static final int INDENT_SUBITEMS = 18;
    private boolean isWizardMode = false;
    private int bundleType = 0;
    private String bundleTypeName = null;
    private ActionListener actionForwarder = null;
    private UIRadioButtonBox locationBox = null;
    private JRadioButton rb_CreateNewStandAlone = null;
    private JRadioButton rb_CreateNewInApp = null;
    private JRadioButton rb_AddToExisting = null;
    private TreeCombo cb_appsChooser = null;
    private TreeCombo cb_bundleChooser = null;
    private UITitledBox namingBox = null;
    private UITitledTextField tf_fileName = null;
    private UITitledTextField tf_displayName = null;
    private String savedStartingDirectory = UIConfig.getStartingDirectory().getPath();
    private List selectionListeners = null;
    private Vector actionListeners = null;

    private static String OPEN_MODULE(String v0) {
        return localStrings.getLocalString("ui.uidisplaynamebox.open_module", "Open {0} File ...", new Object[]{v0});
    }

    private static String LOCATION_BOX_TITLE(String v0) {
        return localStrings.getLocalString("ui.uidisplaynamebox.location.title", "{0} Location", new Object[]{v0});
    }

    private static String NAMING_BOX_TITLE(String v0) {
        return localStrings.getLocalString("ui.uidisplaynamebox.naming.title", "{0} Naming", new Object[]{v0});
    }

    private static String CREATE_NEW_STAND_ALONE(String v0) {
        return localStrings.getLocalString("ui.uidisplaynamebox.create_new_standalone", "Create New Stand-Alone {0} Module", new Object[]{v0});
    }

    private static String CREATE_NEW_IN_APP(String v0) {
        return localStrings.getLocalString("ui.uidisplaynamebox.create_new_in_app", "Create New {0} Module in Application", new Object[]{v0});
    }

    private static String ADD_TO_EXISTING(String v0) {
        return localStrings.getLocalString("ui.uidisplaynamebox.add_to_existing", "Add to Existing {0} Module", new Object[]{v0});
    }

    private static String PLEASE_SELECT_LOCATION(String v0) {
        return localStrings.getLocalString("ui.uidisplaynamebox.please_select_location", "Please select a {0} module location.", new Object[]{v0});
    }

    private static String PLEASE_SELECT_LOCATION_FOR_APP(String v0) {
        return localStrings.getLocalString("ui.uidisplaynamebox.please_select_location_for_app", "Please select an application and provide a {0} module name.", new Object[]{v0});
    }

    private static String PLEASE_SELECT_LOCATION_FOR_EXISTING(String v0) {
        return localStrings.getLocalString("ui.uidisplaynamebox.please_select_location_for_existing", "Please select an existing {0} module.", new Object[]{v0});
    }

    private static String MODULE_LOCATION(String v0) {
        return localStrings.getLocalString("ui.uidisplaynamebox.module_location", "{0} File:", new Object[]{v0});
    }

    private static String DISPLAY_NAME(String v0) {
        return localStrings.getLocalString("ui.uidisplaynamebox.module_name", "{0} Display Name:", new Object[]{v0});
    }

    private static String getTypeName(int type) {
        switch (type) {
            case 99: {
                return "EAR";
            }
            case 1: {
                return "WAR";
            }
            case 2: {
                return "JAR";
            }
            case 3: {
                return "RAR";
            }
            case 4: {
                return "AppClient";
            }
        }
        return "???";
    }

    private static String getTypeFilter(int type) {
        switch (type) {
            case 99: {
                return "EarFiles";
            }
            case 1: {
                return "WarFiles";
            }
            case 2: {
                return "JarFiles";
            }
            case 3: {
                return "RarFiles";
            }
            case 4: {
                return "JarFiles";
            }
        }
        return "@ModuleFiles";
    }

    private static String getTypeExtension(int type) {
        switch (type) {
            case 99: {
                return ".ear";
            }
            case 1: {
                return ".war";
            }
            case 2: {
                return ".jar";
            }
            case 3: {
                return ".rar";
            }
            case 4: {
                return ".jar";
            }
        }
        return null;
    }

    public static void setEnableStandAlone(boolean f) {
        enableStandAlone = f;
    }

    private static boolean typeSupportsStandAlone(int type) {
        if (enableStandAlone) {
            switch (type) {
                case 99: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    public static void setEnableNewInApp(boolean f) {
        enableNewInApp = f;
    }

    private static boolean typeSupportsNewInApp(int type) {
        if (enableNewInApp) {
            switch (type) {
                case 99: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    public static void setEnableAddToExisting(boolean f) {
        enableAddToExisting = f;
    }

    private static boolean typeSupportsAddToExisting(int type) {
        if (enableAddToExisting) {
            switch (type) {
                case 99: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return false;
                }
            }
        }
        return false;
    }

    public UIDisplayNameBox(int type, boolean wizardMode) {
        this();
        this.bundleType = type;
        this.bundleTypeName = UIDisplayNameBox.getTypeName(type);
        this.isWizardMode = wizardMode;
        this.initLayout();
    }

    public UIDisplayNameBox() {
        super((String)null, false);
    }

    private void initLayout() {
        this.actionForwarder = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Enumeration e = UIDisplayNameBox.this.getActionListeners().elements();
                while (e.hasMoreElements()) {
                    ((ActionListener)e.nextElement()).actionPerformed(ae);
                }
            }
        };
        GridBagConstraints gbc = this.getGBConstraintsCopy();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 10;
        gbc.fill = 1;
        if (this.isWizardMode) {
            this.initLocationBox();
            gbc.insets = new Insets(0, 0, 0, 5);
            this.add((Component)this.locationBox, gbc);
            ++gbc.gridx;
        }
        this.initNamingBox();
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.namingBox, gbc);
    }

    private void initLocationBox() {
        GridBagConstraints g;
        this.locationBox = new UIRadioButtonBox(UIDisplayNameBox.LOCATION_BOX_TITLE(this.bundleTypeName), true);
        this.locationBox.setRequired(true);
        this.locationBox.addActionListener(this.actionForwarder);
        this.locationBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (UIDisplayNameBox.this.tf_fileName != null) {
                    UIDisplayNameBox.this.tf_fileName.setEnabled(UIDisplayNameBox.this.isCreateNewStandAlone());
                }
                if (UIDisplayNameBox.this.tf_displayName != null) {
                    UIDisplayNameBox.this.tf_displayName.setEnabled(!UIDisplayNameBox.this.isAddToExisting());
                }
                UIDisplayNameBox.this.fireListSelectionChanged();
            }
        });
        GridBagConstraints g2 = this.locationBox.getGBConstraints();
        g2.weightx = 0.5;
        g2.weighty = 0.0;
        g2.insets = new Insets(0, 0, 0, 0);
        g2.fill = 2;
        g2.anchor = 17;
        if (UIDisplayNameBox.typeSupportsStandAlone(this.bundleType)) {
            this.rb_CreateNewStandAlone = UIRadioButtonBox.createRadioButton(UIDisplayNameBox.CREATE_NEW_STAND_ALONE(this.bundleTypeName));
            this.locationBox.addItem(this.rb_CreateNewStandAlone);
        }
        if (UIDisplayNameBox.typeSupportsNewInApp(this.bundleType)) {
            TreeCombo appsCombo = this.newTargetChooser(99);
            this.rb_CreateNewInApp = UIRadioButtonBox.createRadioButton(UIDisplayNameBox.CREATE_NEW_IN_APP(this.bundleTypeName));
            this.locationBox.addItem(this.rb_CreateNewInApp);
            this.locationBox.setItemEnabled(this.rb_CreateNewInApp, true);
            g = this.locationBox.getGBConstraintsCopy();
            g.insets.left += 18;
            g.insets.bottom = 5;
            this.cb_appsChooser = appsCombo;
            this.cb_appsChooser.setClearWhenDisabled(true);
            this.cb_appsChooser.addActionListener(this.actionForwarder);
            this.cb_appsChooser.addActionItem(UIDisplayNameBox.OPEN_MODULE(UIDisplayNameBox.getTypeName(99)), new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    UIDisplayNameBox.this.openExistingModule(99);
                }
            });
            this.locationBox.add((Component)this.cb_appsChooser, g);
            this.locationBox.addSelectionEnabledComponent(this.cb_appsChooser, null);
        }
        if (UIDisplayNameBox.typeSupportsAddToExisting(this.bundleType)) {
            TreeCombo bundleCombo = this.newTargetChooser(this.bundleType);
            this.rb_AddToExisting = UIRadioButtonBox.createRadioButton(UIDisplayNameBox.ADD_TO_EXISTING(this.bundleTypeName));
            this.locationBox.addItem(this.rb_AddToExisting);
            this.locationBox.setItemEnabled(this.rb_AddToExisting, true);
            g = this.locationBox.getGBConstraintsCopy();
            g.insets.left += 18;
            g.insets.bottom = 5;
            this.cb_bundleChooser = bundleCombo;
            this.cb_bundleChooser.setClearWhenDisabled(true);
            this.cb_bundleChooser.addActionListener(this.actionForwarder);
            this.cb_bundleChooser.addActionItem(UIDisplayNameBox.OPEN_MODULE(this.bundleTypeName), new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    UIDisplayNameBox.this.openExistingModule(UIDisplayNameBox.this.bundleType);
                }
            });
            this.locationBox.add((Component)this.cb_bundleChooser, g);
            this.locationBox.addSelectionEnabledComponent(this.cb_bundleChooser, null);
        }
    }

    public void refresh() {
        this.refreshLocationBox();
    }

    protected void refreshLocationBox() {
        JRadioButton defaultSelection = null;
        if (this.rb_CreateNewStandAlone != null) {
            defaultSelection = this.rb_CreateNewStandAlone;
        }
        if (this.rb_CreateNewInApp != null) {
            this.cb_appsChooser.refreshModel();
            this.locationBox.setItemEnabled(this.rb_CreateNewInApp, true);
            Descriptor selMod = DT.getSelectedModule();
            if (this.rb_CreateNewInApp.isEnabled() && selMod instanceof Application) {
                this.cb_appsChooser.setSelectedDescriptor(selMod);
                defaultSelection = this.rb_CreateNewInApp;
            }
        }
        if (this.rb_AddToExisting != null) {
            this.cb_bundleChooser.refreshModel();
            BundleDescriptor selBD = DT.getSelectedBundle();
            if (this.rb_AddToExisting.isEnabled() && selBD != null) {
                this.cb_bundleChooser.setSelectedDescriptor((Descriptor)selBD);
                defaultSelection = this.rb_AddToExisting;
            }
        }
        if (defaultSelection != null) {
            defaultSelection.setSelected(true);
        }
    }

    protected void initNamingBox() {
        this.namingBox = new UITitledBox(UIDisplayNameBox.NAMING_BOX_TITLE(this.bundleTypeName), true);
        this.namingBox.setRequired(true);
        GridBagConstraints g = this.namingBox.getGBConstraints();
        g.gridx = 0;
        g.gridy = -1;
        g.weightx = 0.5;
        g.weighty = 0.0;
        g.insets = new Insets(0, 5, 5, 5);
        g.fill = 2;
        g.anchor = 17;
        this.tf_fileName = new UITitledTextField(UIDisplayNameBox.MODULE_LOCATION(this.bundleTypeName), false);
        this.namingBox.addWithGBConstraints(this.tf_fileName);
        this.tf_fileName.setScriptId("ModuleLocation");
        if (this.isWizardMode) {
            this.tf_fileName.setClearWhenDisabled(true);
            this.tf_fileName.addActionListener(this.actionForwarder);
            this.tf_fileName.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UIDisplayNameBox.this.checkModuleLocation();
                }
            });
            this.tf_fileName.setBrowserActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UIDisplayNameBox.this.browseModuleLocation();
                    UIDisplayNameBox.this.checkModuleLocation();
                }
            });
            this.tf_fileName.setEnabled(this.isCreateNewStandAlone());
        } else {
            this.tf_fileName.setReadOnly(true);
        }
        this.tf_displayName = new UITitledTextField(UIDisplayNameBox.DISPLAY_NAME(this.bundleTypeName), false);
        this.namingBox.addWithGBConstraints(this.tf_displayName);
        this.tf_displayName.setScriptId("ModuleDisplayName");
        this.tf_displayName.setClearWhenDisabled(true);
        this.tf_displayName.addActionListener(this.actionForwarder);
        this.tf_displayName.setEnabled(!this.isAddToExisting());
    }

    public void setReadOnly(boolean state) {
        if (!this.isWizardMode && this.tf_displayName != null) {
            this.tf_displayName.setReadOnly(state);
        }
    }

    private void browseModuleLocation() {
        File dir;
        String fileName = this.tf_fileName.getText();
        if ((fileName == null || fileName.equals("")) && !(fileName = this.getSavedStartingDirectory()).endsWith(File.separator)) {
            fileName = fileName + File.separator;
        }
        for (dir = new File(fileName).getAbsoluteFile(); dir != null && !dir.isDirectory(); dir = dir.getParentFile()) {
        }
        UIFileChooser jfc = UIFileChooser.getFileChooser(dir, UIDisplayNameBox.getTypeFilter(this.bundleType));
        int rtn = ((JFileChooser)jfc).showDialog(this, localStrings.getLocalString("ui.uidisplaynamebox.choose_module_file", "Create Module File"));
        if (rtn == 0) {
            File chosenFile = ((JFileChooser)jfc).getSelectedFile();
            this.tf_fileName.setText(chosenFile.toString());
        }
    }

    public void setSavedStartingDirectory(String dir) {
        this.savedStartingDirectory = dir;
    }

    public String getSavedStartingDirectory() {
        return this.savedStartingDirectory;
    }

    private void checkModuleLocation() {
        String fileName = this.tf_fileName.getText();
        if (!fileName.equals("")) {
            File tmpFile = new File(fileName);
            if (!fileName.endsWith(File.separator) && !tmpFile.isDirectory()) {
                File f;
                String ext = UIDisplayNameBox.getTypeExtension(this.bundleType);
                String fn = tmpFile.getName();
                String dir = tmpFile.getParent();
                if (!fn.toLowerCase().endsWith(ext)) {
                    fn = fn + ext;
                }
                if (fn.indexOf(" ") >= 0) {
                    fn = fn.replace(' ', '_');
                }
                if (!(f = new File(fn = dir + File.separator + fn)).isAbsolute()) {
                    fn = f.getAbsolutePath();
                }
                if (!fn.equals(fileName)) {
                    this.tf_fileName.setText(fn);
                }
                String t1 = new File(fn).getName();
                String t2 = t1.substring(0, t1.lastIndexOf(ext));
                if (StringTools.isEmpty(this.tf_displayName.getText())) {
                    this.tf_displayName.setText(t2);
                }
            }
        }
    }

    private void openExistingModule(int type) {
        Descriptor d = DT.getModuleManager().openExistingModule(UIDisplayNameBox.getTypeFilter(type));
        if (d instanceof Application) {
            if (this.cb_appsChooser != null) {
                this.cb_appsChooser.refreshModel();
            }
        } else if (d instanceof BundleDescriptor && this.cb_bundleChooser != null) {
            this.cb_bundleChooser.refreshModel();
        }
    }

    public void setWizardComponentMode(String mode) {
        if (this.isWizardMode) {
            JRadioButton dftSel = this.rb_CreateNewStandAlone;
            boolean newStandAlone = true;
            boolean newInApp = true;
            boolean addToExisting = true;
            if (mode == null) {
                newStandAlone = true;
                newInApp = true;
                addToExisting = true;
                dftSel = this.rb_CreateNewStandAlone;
            } else if (mode.equals("New")) {
                newStandAlone = true;
                newInApp = true;
                addToExisting = false;
                dftSel = this.rb_CreateNewStandAlone;
            } else if (mode.equals("Edit")) {
                newStandAlone = false;
                newInApp = false;
                addToExisting = true;
                dftSel = this.rb_AddToExisting;
            } else {
                Print.printStackTrace((String)("Unsupported mode: " + mode));
            }
            if (newInApp && this.cb_appsChooser != null) {
                this.cb_appsChooser.refreshModel();
                this.cb_appsChooser.selectActiveModule();
                if (this.cb_appsChooser.getSelectedItem() != null) {
                    dftSel = this.rb_CreateNewInApp;
                }
            }
            if (addToExisting && this.cb_bundleChooser != null) {
                this.cb_bundleChooser.refreshModel();
                this.cb_bundleChooser.selectActiveBundle();
                if (this.cb_bundleChooser.getSelectedItem() != null) {
                    dftSel = this.rb_AddToExisting;
                }
            }
            this.locationBox.setItemVisible(this.rb_CreateNewStandAlone, newStandAlone);
            this.locationBox.setItemVisible(this.rb_CreateNewInApp, newInApp);
            this.locationBox.setItemVisible(this.rb_AddToExisting, addToExisting);
            if (dftSel != null) {
                dftSel.setSelected(true);
            }
            this.tf_fileName.setEnabled(this.isCreateNewStandAlone());
            this.tf_fileName.setText("");
            this.tf_displayName.setEnabled(!this.isAddToExisting());
        } else {
            Print.printStackTrace((String)"Should only be called during 'Wizard' mode");
        }
    }

    public TreeCombo newTargetChooser(int type) {
        Object id = null;
        TreeCombo combo = null;
        if (type == 99) {
            combo = TreeCombo.newAppCombo(null, false);
            combo.setScriptId(ID_APP_COMBO);
            combo.selectActiveModule();
        } else if (type == 1) {
            combo = TreeCombo.newWarCombo(null, false);
            combo.setScriptId(ID_WAR_COMBO);
            combo.selectActiveBundle();
        } else if (type == 2) {
            combo = TreeCombo.newEjbCombo(null, false);
            combo.setScriptId(ID_EJB_COMBO);
            combo.selectActiveBundle();
        } else {
            Print.printStackTrace((String)("Type not supported: " + type));
            combo.setScriptId("UnknownChooser");
            combo = TreeCombo.newTreeCombo(null, false);
        }
        return combo;
    }

    private List getListSelectionListeners() {
        if (this.selectionListeners == null) {
            this.selectionListeners = new Vector();
        }
        return this.selectionListeners;
    }

    public void addListSelectionListener(ListSelectionListener sl) {
        this.removeListSelectionListener(sl);
        this.getListSelectionListeners().add(sl);
    }

    public void removeListSelectionListener(ListSelectionListener sl) {
        this.getListSelectionListeners().remove(sl);
    }

    protected void fireListSelectionChanged() {
        int n = this.locationBox.getSelectedIndex();
        ListSelectionEvent lse = new ListSelectionEvent(this.locationBox, n, n, false);
        Iterator i = this.getListSelectionListeners().iterator();
        while (i.hasNext()) {
            ((ListSelectionListener)i.next()).valueChanged(lse);
        }
    }

    private Vector getActionListeners() {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        return this.actionListeners;
    }

    public void addActionListener(ActionListener al) {
        this.removeActionListener(al);
        this.getActionListeners().add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.getActionListeners().remove(al);
    }

    public void setFileLocation(String fileName) {
        if (this.isWizardMode) {
            this.tf_fileName.setText(fileName);
            this.checkModuleLocation();
        } else {
            this.tf_fileName.setText(fileName);
        }
    }

    public String getFileLocation() {
        return this.tf_fileName.getText();
    }

    public boolean validateTargetLocation() {
        if (!this.isWizardMode) {
            return false;
        }
        if (this.isCreateNewStandAlone()) {
            String fileName = this.getFileLocation();
            if (fileName == null || fileName.equals("")) {
                UIOptionPane.showErrorDialog(this, UIDisplayNameBox.PLEASE_SELECT_LOCATION(this.bundleTypeName));
                return false;
            }
            return FileTools.checkFileOverwrite((Component)this, fileName);
        }
        if (this.isCreateNewInApp()) {
            Descriptor d = this.getSelectedParentDescriptor();
            if (d == null) {
                UIOptionPane.showErrorDialog(this, UIDisplayNameBox.PLEASE_SELECT_LOCATION_FOR_APP(this.bundleTypeName));
                return false;
            }
            return true;
        }
        if (this.isAddToExisting()) {
            Descriptor d = this.getSelectedParentDescriptor();
            if (d == null) {
                UIOptionPane.showErrorDialog(this, UIDisplayNameBox.PLEASE_SELECT_LOCATION_FOR_EXISTING(this.bundleTypeName));
                return false;
            }
            return true;
        }
        return false;
    }

    public void setName(String name) {
        Print.printStackTrace((String)"Don't call this!");
        super.setName(name);
    }

    public String getName() {
        Print.printStackTrace((String)"Don't call this!");
        return super.getName();
    }

    public void setModuleName(String name) {
        this.setDisplayName(name);
    }

    public String getModuleName() {
        return this.getDisplayName();
    }

    public void setDisplayName(String name) {
        this.tf_displayName.setText(name);
    }

    public String getDisplayName() {
        return this.tf_displayName.getText();
    }

    public Descriptor getSelectedParentDescriptor() {
        if (this.isCreateNewStandAlone()) {
            return null;
        }
        if (this.isCreateNewInApp()) {
            return (Descriptor)this.cb_appsChooser.getSelectedDescriptor();
        }
        if (this.isAddToExisting()) {
            return (Descriptor)this.cb_bundleChooser.getSelectedDescriptor();
        }
        return null;
    }

    public boolean isCreateNewStandAlone() {
        return this.rb_CreateNewStandAlone != null && this.rb_CreateNewStandAlone.isSelected();
    }

    public boolean isCreateNewInApp() {
        return this.rb_CreateNewInApp != null && this.rb_CreateNewInApp.isSelected();
    }

    public boolean isAddToExisting() {
        return this.rb_AddToExisting != null && this.rb_AddToExisting.isSelected();
    }

    protected GridBagConstraints getDefaultGBConstraints(GridBagConstraints c) {
        c = super.getDefaultGBConstraints(c);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.insets = new Insets(0, 5, 5, 5);
        c.fill = 1;
        c.anchor = 17;
        return c;
    }
}

