/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.utils.UIButtonEnabler;
import com.sun.enterprise.tools.deployment.ui.utils.UIMenu;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;

public class UIContextMenu {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIContextMenu.class);
    protected static String POP_UP_NAME = localStrings.getLocalString("ui.uicontextmenu.pop_up_ame", "pop up menu");
    protected static String POP_UP_DESC = localStrings.getLocalString("ui.uicontextmenu.pop_up_ame", "This is the pop up menu that comes when you right click the mouse");
    private JComponent mouseTarget = null;
    private Hashtable popupMenu = null;
    private JPopupMenu defaultPopupMenu = null;

    public UIContextMenu(JComponent target) {
        this.mouseTarget = target;
        this.mouseTarget.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                String key;
                JPopupMenu pm;
                if (SwingUtilities.isRightMouseButton(e) && (pm = UIContextMenu.this.getPopupMenu(key = UIContextMenu.this.mouseTarget instanceof ContextMenuKey ? ((ContextMenuKey)((Object)UIContextMenu.this.mouseTarget)).getContextKey(UIContextMenu.this, e) : null, false)) != null && pm.getComponentCount() > 0) {
                    pm.show(e.getComponent(), e.getX() + 10, e.getY() + 2);
                }
            }
        });
    }

    public boolean hasPopupMenu(String key) {
        return this.getPopupMenu(key, false) != null;
    }

    public JPopupMenu getPopupMenu(String key, boolean create) {
        JPopupMenu pm;
        if (key == null) {
            if (this.defaultPopupMenu == null) {
                this.defaultPopupMenu = new ContextPopupMenu();
            }
            return this.defaultPopupMenu;
        }
        JPopupMenu jPopupMenu = pm = this.popupMenu != null ? (JPopupMenu)this.popupMenu.get(key) : null;
        if (pm == null && create) {
            pm = new ContextPopupMenu();
            if (this.popupMenu == null) {
                this.popupMenu = new Hashtable();
            }
            this.popupMenu.put(key, pm);
        }
        return pm;
    }

    public void setPopupTitle(String key, String title) {
        this.getPopupMenu(key, true).setLabel(title);
    }

    public JMenuItem addItem(String popupKey, String cmdKey) {
        JMenuItem cmdItem = DT.getActionMenuItem(cmdKey);
        UIMenu.UIMenuItem mnuItem = cmdItem != null ? new UIMenu.UIMenuItem(cmdItem) : null;
        return mnuItem != null ? this.addItem(popupKey, mnuItem) : null;
    }

    public JMenuItem addItem(String key, JMenuItem item) {
        this.getPopupMenu(key, true).add(item);
        return item;
    }

    public JMenuItem addItem(String key, String title, ActionListener action) {
        return this.addItem(key, title, (String)null, action);
    }

    public JMenuItem addItem(String key, String title, String enablementKey, ActionListener action) {
        return this.addItem(key, title, new String[]{enablementKey}, action);
    }

    public JMenuItem addItem(String key, String title, String[] enablementKey, ActionListener action) {
        if (key != null && !(this.mouseTarget instanceof ContextMenuKey)) {
            Print.printStackTrace((String)"Target must be a 'ContextMenuKey' for multi-menu support");
        }
        UIMenu.UIMenuItem item = new UIMenu.UIMenuItem(title, '\u0000', null);
        if (action != null) {
            item.addActionListener(action);
        }
        UIButtonEnabler.GetGlobalEnabler().add(enablementKey, (AbstractButton)item);
        this.getPopupMenu(key, true).add(item);
        return item;
    }

    public void addSeparator() {
        this.addSeparator(null);
    }

    public void addSeparator(String key) {
        this.getPopupMenu(key, true).addSeparator();
    }

    private static class ContextPopupMenu
    extends JPopupMenu {
        public ContextPopupMenu() {
            this.getAccessibleContext().setAccessibleName(POP_UP_NAME);
            this.getAccessibleContext().setAccessibleName(POP_UP_DESC);
        }

        public void show(Component p, int x, int y) {
            MenuElement[] m = this.getSubElements();
            for (int i = 0; i < m.length; ++i) {
                Component c = (Component)((Object)m[i]);
                if (c instanceof UIMenu.UIMenuItem) {
                    ((UIMenu.UIMenuItem)c).resetMasterEnabled();
                }
                c.setVisible(c.isEnabled());
            }
            super.show(p, x, y);
        }
    }

    public static interface ContextMenuKey {
        public String getContextKey(UIContextMenu var1, MouseEvent var2);
    }
}

