/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.util.Print;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;

public class UIConfigProperties {
    public static final String ARRAY = "[-]";
    public static final String ARRAY2D = "[*]";
    public static final String BOOLEAN = "Boolean";
    public static final String INTEGER = "Integer";
    public static final String LIST = "List";
    public static final String COLOR = "Color";
    public static final String STRING = "String";
    public static final String STRINGa = "String[-]";
    public static final String STRING2d = "String[*]";
    public static final String CLASS = "Class";
    public static final String FILE = "File";
    public static final String FILEa = "File[-]";
    public static final String URL = "URL";
    public static final String URLa = "URL[-]";
    public static final String PUBLIC = "public";
    public static final String PRIVATE = "private";
    public static final String OBSOLETE = "obsolete";
    public static final String SYSTEM = "system";
    public static final String RUNTIME = "runtime";
    public static final String UNKNOWN = "unknown";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String YES = "yes";
    public static final String NO = "no";
    public static final String[] BooleanValues = new String[]{"false", "true"};
    public static final String RUNTIME_KEY = "/";
    public static final String BACKUP_EXT = ".bak";
    private Hashtable cfgKeyHash = null;
    private File configFile = null;
    protected boolean checkRuntimeKeyScope = false;
    private Properties configProps = new CustomProperties(false);
    private Properties runtimeProps = new CustomProperties(false);
    private boolean backup = false;
    private long lastModified = 0L;
    private Hashtable keyMap = null;

    public Hashtable getPropertyKeyTable() {
        if (this.cfgKeyHash == null) {
            this.cfgKeyHash = new Hashtable();
        }
        return this.cfgKeyHash;
    }

    public void addPropertyKey(String n, String t, String s, String[] v, String d, String h) {
        this.addPropertyKey(new Key(n, t, s, false, v, d, h));
    }

    public void addPropertyKey(String n, String t, String[] v, String d, String h) {
        this.addPropertyKey(new Key(n, t, PUBLIC, false, v, d, h));
    }

    public void addPropertyKey(Key key) {
        this.getPropertyKeyTable().put(key.key.toLowerCase(), key);
        if (key.isScopeRuntime() && !key.key.startsWith(RUNTIME_KEY)) {
            Print.dprintln((String)("Implicit runtime key: " + key.key));
            this.setCheckRuntimeKeyScope(true);
        }
    }

    public void addPropertyKeys(Key[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            this.addPropertyKey(keys[i]);
            this.convertKey(keys[i].key, true);
        }
    }

    public void removePropertyKey(String n) {
        this.getPropertyKeyTable().remove(n.toLowerCase());
    }

    public Key getPropertyKey(String key) {
        return (Key)this.getPropertyKeyTable().get(key.toLowerCase());
    }

    public String getPropertyScope(String key) {
        Key kr = this.getPropertyKey(key);
        return kr != null ? kr.getScope() : null;
    }

    public String getPropertyDefaultValue(String key) {
        Key kr = this.getPropertyKey(key);
        return kr != null ? kr.getDefaultValue() : null;
    }

    public String[] getPropertyValidValues(String key) {
        Key kr = this.getPropertyKey(key);
        return kr != null ? kr.getValidValues() : null;
    }

    public int getPropertyValidValueIndex(String key, String val) {
        String[] list = this.getPropertyValidValues(key);
        if (list != null) {
            for (int v = 0; v < list.length; ++v) {
                if (!list[v].equalsIgnoreCase(val)) continue;
                return v;
            }
        }
        return -1;
    }

    public UIConfigProperties() {
        this.setConfigFile(null);
    }

    public UIConfigProperties(File cfgFile) throws IOException {
        this.loadFile(cfgFile);
        this.setConfigFile(cfgFile);
    }

    public UIConfigProperties(Key[] cfgKeys) {
        this();
        this.addPropertyKeys(cfgKeys);
    }

    public void setCheckRuntimeKeyScope(boolean state) {
        this.checkRuntimeKeyScope = state;
    }

    private Properties _Prop(String key) {
        Key propKey;
        boolean isRuntime = key.startsWith(RUNTIME_KEY);
        if (this.checkRuntimeKeyScope && !isRuntime && (propKey = this.getPropertyKey(key)) != null && propKey.isScopeRuntime()) {
            isRuntime = true;
        }
        return isRuntime ? this.runtimeProps : this.configProps;
    }

    private boolean _containsProp(String key) {
        String val = this._Prop(key).getProperty(key, null);
        return val != null;
    }

    private String _getConfigProp(String key) {
        String val = this._Prop(key).getProperty(key, null);
        return val != null && !val.equals("") ? val : null;
    }

    private void _setConfigProp(String key, String value) {
        this._Prop(key).setProperty(key, value);
    }

    private void _removeConfigProp(String key) {
        this._Prop(key).remove(key);
    }

    private Enumeration _keys() {
        return new KeyEnumeration(this.configProps.keys(), this.runtimeProps.keys());
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File cfgFile) {
        if (this.configFile == null || !this.configFile.equals(cfgFile)) {
            if (this.configFile != null) {
                Print.dprintln((String)"Configuration file already set");
            }
            this.configFile = cfgFile;
        }
    }

    public void loadStream(InputStream fis) throws IOException {
        this.configProps.load(fis);
        Enumeration<?> pn = this.configProps.propertyNames();
        while (pn.hasMoreElements()) {
            this.convertKey((String)pn.nextElement(), false);
        }
    }

    public void loadFile(File cfgFile) throws IOException {
        if (cfgFile != null) {
            if (!cfgFile.exists()) {
                throw new FileNotFoundException(cfgFile.getPath());
            }
        } else {
            throw new FileNotFoundException("null");
        }
        FileInputStream fis = new FileInputStream(cfgFile);
        this.loadStream(fis);
        fis.close();
        this.setLastModified(cfgFile.lastModified());
    }

    public void loadFile() throws IOException {
        this.loadFile(this.configFile);
    }

    public void saveToStream(OutputStream out, String header) throws IOException {
        this.configProps.store(out, header);
    }

    public void save(File cfgFile, String header) throws IOException {
        this.save(cfgFile, header, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File cfgFile, String header, boolean backup) throws IOException {
        if (cfgFile != null) {
            File cfgBak;
            if (backup && cfgFile.exists() && (!(cfgBak = new File(cfgFile.getPath() + BACKUP_EXT)).exists() || cfgBak.delete())) {
                cfgFile.renameTo(cfgBak);
            }
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(cfgFile);
                this.saveToStream(out, header);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        } else {
            Print.dprintStackTrace((String)"Configuration file not specified");
        }
    }

    public void save(String header) throws IOException {
        this.save(this.configFile, header, false);
    }

    public void save(String header, boolean backup) throws IOException {
        this.save(this.configFile, header, backup);
    }

    public void setLastModified(long mod) {
        this.lastModified = mod;
    }

    public long lastModified() {
        return this.lastModified;
    }

    protected String convertKey(String key, boolean saveKey) {
        String key_lc;
        String act;
        if (this.keyMap == null) {
            this.keyMap = new Hashtable();
        }
        if ((act = (String)this.keyMap.get(key_lc = key.toLowerCase())) == null) {
            this.keyMap.put(key_lc, key);
            return key;
        }
        if (key.equals(act)) {
            return key;
        }
        String setKey = saveKey ? key : act;
        String delKey = saveKey ? act : key;
        this.keyMap.put(key_lc, setKey);
        String value = this._getConfigProp(delKey);
        if (value != null) {
            this._removeConfigProp(delKey);
            this._setConfigProp(setKey, value);
        }
        return setKey;
    }

    public void removeKey(String key) {
        this._removeConfigProp(this.convertKey(key, true));
    }

    public boolean containsProperty(String key) {
        return this._containsProp(this.convertKey(key, true));
    }

    public Enumeration keys() {
        return this._keys();
    }

    public void setProperty(String key, String value) {
        if (value != null) {
            this._setConfigProp(this.convertKey(key, true), value);
        } else {
            this.removeKey(key);
        }
    }

    public String getProperty(String key, String dftVal) {
        String p = this._getConfigProp(this.convertKey(key, true));
        return p != null ? p : dftVal;
    }

    public String getProperty(String key) {
        String p = this._getConfigProp(this.convertKey(key, true));
        return p != null ? p : this.getPropertyDefaultValue(key);
    }

    public void setPropertyArray(String key, Object[] value) {
        this.setProperty(key, UIConfigProperties.arrayToString(value));
    }

    public void setPropertyList(String key, List value) {
        this.setProperty(key, UIConfigProperties.listToString(value));
    }

    public String[] getStringArray(String key, String[] dftVal) {
        String v = this._getConfigProp(this.convertKey(key, true));
        return v != null ? (String[])UIConfigProperties.stringToArray(v, false) : dftVal;
    }

    public List getStringList(String key, List dftVal) {
        String v = this._getConfigProp(this.convertKey(key, true));
        return v != null ? UIConfigProperties.stringToList(v, false) : dftVal;
    }

    public String[] getStringArray(String key) {
        String[] v = this.getStringArray(key, null);
        if (v != null) {
            return v;
        }
        v = (String[])UIConfigProperties.stringToArray(this.getPropertyDefaultValue(key), false);
        return v != null ? v : new String[]{};
    }

    public List getStringList(String key) {
        List v = this.getStringList(key, null);
        if (v != null) {
            return v;
        }
        v = UIConfigProperties.stringToList(this.getPropertyDefaultValue(key), false);
        return v != null ? v : new Vector();
    }

    public Object[] getPropertyArray(String key, Object[] dftVal) {
        String v = this._getConfigProp(this.convertKey(key, true));
        return v != null ? UIConfigProperties.stringToArray(v, true) : dftVal;
    }

    public List getPropertyList(String key, List dftVal) {
        String v = this._getConfigProp(this.convertKey(key, true));
        return v != null ? UIConfigProperties.stringToList(v, true) : dftVal;
    }

    public Object[] getPropertyArray(String key) {
        Object[] v = this.getPropertyArray(key, null);
        if (v != null) {
            return v;
        }
        v = UIConfigProperties.stringToArray(this.getPropertyDefaultValue(key), true);
        return v != null ? v : new Object[]{};
    }

    public List getPropertyList(String key) {
        List v = this.getPropertyList(key, null);
        if (v != null) {
            return v;
        }
        v = UIConfigProperties.stringToList(this.getPropertyDefaultValue(key), true);
        return v != null ? v : new Vector();
    }

    public static Object[] stringToArray(String value, boolean multiDimArray) {
        List list = UIConfigProperties.stringToList(value, multiDimArray);
        return ListTools.listToArray(list, String.class);
    }

    public static List stringToList(String value, boolean multiDimArray) {
        if (value == null) {
            return null;
        }
        String v = value.trim();
        if (v.equals("")) {
            return null;
        }
        if (!v.startsWith("(")) {
            v = "(" + v;
        }
        if (!v.endsWith(")")) {
            v = v + ")";
        }
        Vector list = new Vector();
        Stack<Vector> listStack = multiDimArray ? new Stack<Vector>() : null;
        boolean quoted = false;
        StringBuffer sb = new StringBuffer();
        char[] chr = v.toCharArray();
        for (int i = 0; i < chr.length; ++i) {
            if (!quoted && chr[i] == '(') {
                if (sb.length() > 0) {
                    list.add(sb.toString());
                    sb.setLength(0);
                }
                if (listStack == null) continue;
                listStack.push(list);
                list = new Vector();
                continue;
            }
            if (!quoted && chr[i] == ')') {
                if (sb.length() > 0) {
                    list.add(sb.toString());
                    sb.setLength(0);
                }
                if (listStack == null || listStack.isEmpty()) continue;
                Vector popList = list;
                list = (Vector)listStack.pop();
                list.add(popList);
                continue;
            }
            if (!quoted && Character.isWhitespace(chr[i])) {
                if (sb.length() <= 0) continue;
                list.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            if (chr[i] == '\\') {
                sb.append(chr[i]);
                continue;
            }
            if (chr[i] == '\"') {
                if (quoted) {
                    if (sb.length() > 0) {
                        list.add(sb.toString());
                        sb.setLength(0);
                    }
                    quoted = false;
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append(chr[i]);
                    continue;
                }
                quoted = true;
                continue;
            }
            sb.append(chr[i]);
        }
        if (listStack != null && !listStack.isEmpty()) {
            while (listStack.size() > 0) {
                Vector popList = list;
                list = (Vector)listStack.pop();
                list.add(popList);
            }
        }
        Vector rtnList = null;
        if (list.isEmpty()) {
            rtnList = list;
        } else if (list.size() == 1 && list.elementAt(0) instanceof Vector) {
            rtnList = (Vector)list.elementAt(0);
        } else {
            rtnList = new Vector();
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object item = i.next();
                if (item instanceof String) {
                    rtnList.add(item);
                    continue;
                }
                if (item instanceof Collection) {
                    rtnList.addAll((Collection)item);
                    continue;
                }
                rtnList.add(item.toString());
            }
        }
        return rtnList;
    }

    public static String listToString(List v) {
        return UIConfigProperties.arrayToString(ListTools.listToArray(v, String.class));
    }

    public static String arrayToString(Object[] v) {
        return UIConfigProperties.arrayToString(v, 0, -1, true);
    }

    public static String arrayToString(Object[] v, int start, boolean wrap) {
        return UIConfigProperties.arrayToString(v, start, -1, wrap);
    }

    public static String arrayToString(Object[] v, int start, int length, boolean wrap) {
        int end;
        if (v == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (wrap) {
            sb.append("(");
        }
        if (start < 0) {
            start = 0;
        }
        int n = end = length >= 0 ? start + length : v.length;
        if (end > v.length) {
            end = v.length;
        }
        for (int i = start; i < end; ++i) {
            if (i > start) {
                sb.append(" ");
            }
            if (v[i] instanceof Object[]) {
                sb.append(UIConfigProperties.arrayToString((Object[])v[i]));
                continue;
            }
            if (v[i] instanceof List) {
                List list = (List)v[i];
                sb.append(UIConfigProperties.arrayToString(ListTools.listToArray(list)));
                continue;
            }
            String s = v[i].toString();
            boolean q = false;
            if (s.indexOf("\"") >= 0) {
                StringBuffer vsb = new StringBuffer();
                char[] chr = s.toCharArray();
                for (int c = 0; c < chr.length; ++c) {
                    if (chr[c] == '\"') {
                        vsb.append("\\");
                    }
                    vsb.append(chr[c]);
                }
                s = vsb.toString();
                q = true;
            } else if (s.indexOf(" ") >= 0 || s.indexOf("\t") >= 0) {
                q = true;
            } else if (s.indexOf("(") >= 0 || s.indexOf(")") >= 0) {
                q = true;
            }
            if (q) {
                sb.append("\"");
            }
            sb.append(s);
            if (!q) continue;
            sb.append("\"");
        }
        if (wrap) {
            sb.append(")");
        }
        return sb.toString();
    }

    public static boolean BooleanValue(String bool, boolean dftVal) {
        if (bool == null) {
            return dftVal;
        }
        if (bool.equalsIgnoreCase(TRUE) || bool.equalsIgnoreCase(YES)) {
            return true;
        }
        if (bool.equalsIgnoreCase(FALSE) || bool.equalsIgnoreCase(NO)) {
            return false;
        }
        return dftVal;
    }

    public static boolean IsBoolean(String value) {
        if (value == null) {
            return false;
        }
        if (value.equalsIgnoreCase(TRUE) || value.equalsIgnoreCase(YES)) {
            return true;
        }
        return value.equalsIgnoreCase(FALSE) || value.equalsIgnoreCase(NO);
    }

    public boolean getPropertyDefaultBoolean(String key) {
        return UIConfigProperties.BooleanValue(this.getPropertyDefaultValue(key), false);
    }

    public boolean getPropertyBoolean(String key) {
        return UIConfigProperties.BooleanValue(this.getProperty(key), false);
    }

    public boolean getPropertyBoolean(String key, boolean dftVal) {
        return UIConfigProperties.BooleanValue(this.getProperty(key, null), dftVal);
    }

    public void setPropertyBoolean(String key, boolean value) {
        this.setProperty(key, value ? TRUE : FALSE);
    }

    public static int IntegerValue(String num, int dftVal) {
        return UIConfigProperties.IntegerValue(null, num, dftVal);
    }

    public static int IntegerValue(String[] vals, String num, int dftVal) {
        if (num == null || num.equals("")) {
            return dftVal;
        }
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException nfe) {
            int p;
            int len = num.length();
            int n = p = num.charAt(0) == '-' ? 1 : 0;
            while (p < len && Character.isDigit(num.charAt(p))) {
                ++p;
            }
            try {
                return Integer.parseInt(num.substring(0, p));
            }
            catch (NumberFormatException nfe2) {
                if (vals != null) {
                    for (int v = 0; v < vals.length; ++v) {
                        if (!vals[v].equalsIgnoreCase(num)) continue;
                        return v;
                    }
                }
                return dftVal;
            }
        }
    }

    public static boolean IsInteger(String[] vals, String value) {
        return UIConfigProperties.IntegerValue(vals, value, Integer.MIN_VALUE) != Integer.MIN_VALUE;
    }

    public static boolean IsInteger(String value) {
        return UIConfigProperties.IntegerValue(value, Integer.MIN_VALUE) != Integer.MIN_VALUE;
    }

    public int getPropertyDefaultInteger(String key) {
        String[] vals = this.getPropertyValidValues(key);
        return UIConfigProperties.IntegerValue(vals, this.getPropertyDefaultValue(key), 0);
    }

    public int getPropertyInteger(String key) {
        String[] vals = this.getPropertyValidValues(key);
        return UIConfigProperties.IntegerValue(vals, this.getProperty(key), 0);
    }

    public int getPropertyInteger(String key, int dftVal) {
        String[] vals = this.getPropertyValidValues(key);
        return UIConfigProperties.IntegerValue(vals, this.getProperty(key, null), dftVal);
    }

    public void setPropertyInteger(String key, int value) {
        this.setProperty(key, String.valueOf(value));
    }

    public String toString() {
        return this.configFile != null ? this.configFile.toString() : "<UIConfigProperties>";
    }

    private static class CustomProperties
    extends Properties {
        private boolean checkSystemProperty = false;

        public CustomProperties(boolean checkSysProps) {
            this.checkSystemProperty = checkSysProps;
        }

        public void load(InputStream in) throws IOException {
            super.load(in);
        }

        public void store(OutputStream out, String header) throws IOException {
            super.store(out, header);
        }

        public String getProperty(String key) {
            String sp;
            if (this.checkSystemProperty && (sp = System.getProperty(key, null)) != null) {
                return sp;
            }
            return super.getProperty(key);
        }

        public String getProperty(String key, String defaultValue) {
            String p = this.getProperty(key);
            return p != null ? p : defaultValue;
        }

        public Enumeration keys() {
            Vector<Object> ks = new Vector<Object>(super.keySet());
            ListTools.sortList(ks, true);
            return ks.elements();
        }
    }

    private static class KeyEnumeration
    implements Enumeration {
        private Enumeration enum1 = null;
        private Enumeration enum2 = null;

        public KeyEnumeration(Enumeration e1, Enumeration e2) {
            this.enum1 = e1;
            this.enum2 = e2;
        }

        public boolean hasMoreElements() {
            return this.enum1.hasMoreElements() || this.enum2.hasMoreElements();
        }

        public Object nextElement() {
            return this.enum1.hasMoreElements() ? this.enum1.nextElement() : this.enum2.nextElement();
        }
    }

    public static class Key {
        public String key = null;
        private String type = null;
        private String scope = null;
        private String help = null;
        private boolean isReadOnly = false;
        private String[] validValues = null;
        private String defaultValue = null;
        public String editValue = null;

        public Key(String key, String type, String scope) {
            this(key, type, scope, false, null, null, null);
        }

        public Key(String key, String type, String scope, boolean readOnly, String[] validValues, String defaultValue, String help) {
            this.key = key;
            this.type = type != null ? type : UIConfigProperties.STRING;
            this.isReadOnly = readOnly;
            this.defaultValue = defaultValue != null ? defaultValue : "";
            this.help = help != null ? help : "";
            this.setScope(scope);
            this.setValidValues(validValues);
            if (scope.equals(UIConfigProperties.LIST) && this.validValues == null) {
                Print.dprintStackTrace((String)"'validValues' not specified!");
            }
        }

        public String getHelp() {
            return this.help;
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        public String getType() {
            return this.type;
        }

        public boolean isTypeArray() {
            return this.type.endsWith(UIConfigProperties.ARRAY);
        }

        public boolean isTypeBoolean() {
            return this.type.equals(UIConfigProperties.BOOLEAN);
        }

        public boolean isTypeInteger() {
            return this.type.equals(UIConfigProperties.INTEGER) || this.type.equals(UIConfigProperties.LIST);
        }

        public boolean isTypeColor() {
            return this.type.equals(UIConfigProperties.COLOR);
        }

        public boolean isTypeClass() {
            return this.type.equals(UIConfigProperties.CLASS);
        }

        public boolean isTypeFile() {
            return this.type.equals(UIConfigProperties.FILE);
        }

        public void setScope(String scope) {
            String string = this.scope = scope != null ? scope : UIConfigProperties.PRIVATE;
            if (this.key.startsWith(UIConfigProperties.RUNTIME_KEY) && !this.scope.equals(UIConfigProperties.RUNTIME)) {
                this.scope = UIConfigProperties.RUNTIME;
            }
        }

        public String getScope() {
            return this.scope;
        }

        public boolean isScopeRuntime() {
            return this.scope.equals(UIConfigProperties.RUNTIME);
        }

        public boolean isScopePublic() {
            return this.scope.equals(UIConfigProperties.PUBLIC);
        }

        public boolean isScopePrivate() {
            return this.scope.equals(UIConfigProperties.PRIVATE);
        }

        public boolean isScopeSystem() {
            return this.scope.equals(UIConfigProperties.SYSTEM);
        }

        public boolean isScopeUnknown() {
            return this.scope.equals(UIConfigProperties.UNKNOWN);
        }

        public boolean isScopeObsolete() {
            return this.scope.equals(UIConfigProperties.OBSOLETE);
        }

        public void setValidValues(String[] validValues) {
            this.validValues = validValues;
            if (this.isTypeBoolean() && this.validValues == null) {
                this.validValues = BooleanValues;
            }
        }

        public String[] getValidValues() {
            return this.validValues;
        }

        public String getDefaultValue() {
            return System.getProperty(this.key, this.defaultValue);
        }
    }
}

