/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfigProperties;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.table.TableCellEditor;

public class UIConfig {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIConfig.class);
    public static String UI_PACKAGE = "com.sun.enterprise.tools.deployment.ui.";
    private static final String CONFIG_DIR_NAME = ".deploytool";
    private static final String TEMP_DIR_NAME = "tmp_deploytool";
    public static final String ARRAY = "[-]";
    public static final String BOOLEAN = "Boolean";
    public static final String INTEGER = "Integer";
    public static final String LIST = "List";
    public static final String COLOR = "Color";
    public static final String STRING = "String";
    public static final String STRINGa = "String[-]";
    public static final String CLASS = "Class";
    public static final String FILE = "File";
    public static final String FILEa = "File[-]";
    public static final String URL = "URL";
    public static final String URLa = "URL[-]";
    public static final String PUBLIC = "public";
    public static final String PRIVATE = "private";
    public static final String OBSOLETE = "obsolete";
    public static final String SYSTEM = "system";
    public static final String RUNTIME = "runtime";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String RUNTIME_KEY = "/";
    public static final String[] ColorValues = new String[]{"", "black", "blue", "cyan", "darkGray", "gray", "green", "lightGray", "magenta", "orange", "pink", "red", "white", "yellow", "#"};
    public static final Object[][] ColorMap = new Object[][]{{"black", Color.black}, {"blue", Color.blue}, {"cyan", Color.cyan}, {"darkGray", Color.darkGray}, {"gray", Color.gray}, {"green", Color.green}, {"lightGray", Color.lightGray}, {"magenta", Color.magenta}, {"orange", Color.orange}, {"pink", Color.pink}, {"red", Color.red}, {"white", Color.white}, {"yellow", Color.yellow}};
    public static final String[] BorderValues = new String[]{"LineBorder", "EtchedBorder", "RaisedBevelBorder", "LoweredBevelBorder"};
    public static final String[] BooleanValues = UIConfigProperties.BooleanValues;
    public static final String RUNTIME_WSPACK = "/WSPack";
    public static final String RUNTIME_DEBUG_LOG_FILE = "/debugLogFile";
    public static final String RUNTIME_EXCEPTION_LOG_FILE = "/exceptionLogFile";
    public static final String SHOW_DEPLOYMENT_SETTINGS = "/showDeploymentSettings";
    public static final String SYS_CONFIG_FILENAME = "ui.configFilename";
    public static final String BUGFIX = "bugfix.";
    public static final String JSR88_MODE = "ui.jsr88Mode";
    public static final String DEBUG_MODE = "ui.debugMode";
    public static final String HOME_DIR = "ui.homeDirectory";
    public static final String TEMP_DIR = "ui.tempDirectory";
    public static final String TEST_MODE = "ui.testMode";
    public static final String ENABLE_EXCEPTION_LOG = "ui.enableExceptionLogFile";
    public static final String UI_CLASS = "ui.startup.uiClass";
    public static final String Box_BorderType = "ui.Box.borderType";
    public static final String DEBUG_SHOW_CONTROL_BORDERS = "ui.debug.showControlBorders";
    public static final String BROWSER_OPEN_URL = "ui.browser.openUrlCommand";
    public static final String BROWSER_HELP_URLS = "ui.browser.helpUrls";
    public static final String MAX_STARTING_DIRECTORIES = "ui.startingDirectories.max";
    public static final String STARTING_DIRECTORIES = "ui.startingDirectories";
    public static final String SHOW_SPLASH_SCREEN = "ui.startup.showSplashPanel";
    public static final String SHOW_ABBREV_URI = "ui.tree.showAbbreviatedUri";
    public static final String ENABLE_CONTEXT_MENUS = "ui.tree.enableContextMenus";
    public static final String CURRENT_MODULES = "ui.current.modules";
    public static final String RESTORE_MODULES = "ui.startup.restoreModules";
    public static final String UPDATE_SEARCHPATH_WAR = "ui.update.searchPath.war";
    public static final String UPDATE_SEARCHPATH_EJB = "ui.update.searchPath.ejb";
    public static final String UPDATE_SEARCHPATH_RAR = "ui.update.searchPath.rar";
    public static final String UPDATE_SEARCHPATH_CLIENT = "ui.update.searchPath.appClient";
    public static final String UPDATE_SEARCHPATH_APP = "ui.update.searchPath.app";
    public static final String UPDATE_SEARCHPATH_DEFAULT = "ui.update.searchPath.default";
    public static final String SAVE_PROJECT_FILE = "ui.project.saveProjectFile";
    public static final String DEFAULT_CLASSPATH = "ui.defaultClasspath";
    public static final String DISABLE_BUSY_CURSOR = "ui.startup.disableBusyCursor";
    public static final String USE_CONNECTOR_DISPLAY_NAME = "ui.Deploy.connectors.useDisplayName";
    public static final String SAVE_ON_DEPLOY = "ui.Deploy.saveOnDeploy";
    public static final String DEPLOYMENT_MANAGERS = "ui.Deploy.deploymentManagers";
    public static final String LONG_WIZARDS = "ui.Wizard.longWizards";
    public static final String COMPONENT_SELECTION_TYPE = "ui.Wizard.treeComboSelectionType";
    public static final String SKIP_WIZARD_INTRO_ = "ui.Wizard.skipIntro_";
    public static final String DONT_SHOW_AGAIN_ = "ui.dontShowAgain_";
    public static final String PRECHECK_HELP_IDS = "ui.Help.preCheck";
    public static final String HIDE_BAD_HELP_IDS = "ui.Help.hideInvalidHelp";
    public static final String REMOTE_PORT = "ui.RemoteAccess.port";
    public static final String EXECPROCESS_WORD_WRAP = "ui.ExecProcess.consoleWordWrap";
    public static final String Box_EnabledTitleColor = "ui.Box.enabledTitleColor";
    public static final String Box_DisabledTitleColor = "ui.Box.disabledTitleColor";
    public static final String JarPackager_NonDelColor = "ui.JarPackager.nonDeletableColor";
    public static final String ComboBox_ActionItemCellColor = "ui.ComboBox.actionItemCellColor";
    public static final String APP_CLIENT_STUB_EXTN = "ui.appClientStubExtension";
    public static final String DEPLOYMENT_SETTINGS_EXTN = "ui.deploymentSettingsExtn";
    private static final UIConfigProperties.Key[] cfgKeys = new UIConfigProperties.Key[]{new UIConfigProperties.Key("ui.startup.uiClass", "Class", "private", false, null, UI_PACKAGE + "DeployToolWindow", "Startup - main ui entrypoint class"), new UIConfigProperties.Key("ui.homeDirectory", "File", "private", false, null, "", "Home Directory (leave blank for default)"), new UIConfigProperties.Key("ui.tempDirectory", "File", "public", false, null, "", localStrings.getLocalString("ui.uiconfig.propertyhelp.temporary_directory", "Temporary Directory (blank for default)")), new UIConfigProperties.Key("ui.tree.showAbbreviatedUri", "Boolean", "public", false, null, "true", localStrings.getLocalString("ui.uiconfig.propertyhelp.show_abbrev_uri", "Show abbreviated URIs in tree")), new UIConfigProperties.Key("ui.tree.enableContextMenus", "Boolean", "public", false, null, "false", localStrings.getLocalString("ui.uiconfig.propertyhelp.enable_context_menus", "Enable context menus in tree")), new UIConfigProperties.Key("ui.startingDirectories.max", "Integer", "private", false, null, "7", "Maximum number of retained starting directories"), new UIConfigProperties.Key("ui.startingDirectories", "File[-]", "system", false, null, "", "List of current starting directories"), new UIConfigProperties.Key("ui.startup.showSplashPanel", "Boolean", "public", false, null, "true", localStrings.getLocalString("ui.uiconfig.propertyhelp.show_splash_screen", "Startup - show splash-screen")), new UIConfigProperties.Key("ui.current.modules", "File[-]", "private", false, null, "", "Current open modules"), new UIConfigProperties.Key("ui.startup.restoreModules", "Boolean", "public", false, null, "true", localStrings.getLocalString("ui.uiconfig.propertyhelp.restore_modules", "Startup - restore openned modules")), new UIConfigProperties.Key("ui.Deploy.saveOnDeploy", "List", "private", false, new String[]{"never", "always", "confirm"}, "confirm", "Save application/object when deployed"), new UIConfigProperties.Key("ui.Deploy.deploymentManagers", "String[-]", "private", false, null, "", "Deployment Managers"), new UIConfigProperties.Key("ui.browser.openUrlCommand", "String[-]", "private", false, null, "", "Browser 'Open URL' command"), new UIConfigProperties.Key("ui.browser.helpUrls", "URL[-]", "private", false, null, "(http://java.sun.com/j2ee/)", "Help menu URLs"), new UIConfigProperties.Key("ui.Wizard.longWizards", "Boolean", "public", false, null, "true", localStrings.getLocalString("ui.uiconfig.propertyhelp.show_long_wizards", "Wizards - include optional wizard panels")), new UIConfigProperties.Key("ui.Box.enabledTitleColor", "Color", "private", false, ColorValues, "black", "Box enabled title color"), new UIConfigProperties.Key("ui.Box.disabledTitleColor", "Color", "private", false, ColorValues, "gray", "Box disabled title color"), new UIConfigProperties.Key("ui.JarPackager.nonDeletableColor", "Color", "private", false, ColorValues, "black", "JarPackager color for non-deletable entries"), new UIConfigProperties.Key("ui.ComboBox.actionItemCellColor", "Color", "private", false, ColorValues, "black", "ComboBox 'ActionItem' Cell Color"), new UIConfigProperties.Key("ui.update.searchPath.war", "File[-]", "public", false, null, "(WEB-INF/classes classes WEB-INF/lib lib contentRoot .)", localStrings.getLocalString("ui.uiconfig.propertyhelp.war_search_paths", "SearchPaths - WAR module default")), new UIConfigProperties.Key("ui.update.searchPath.ejb", "File[-]", "public", false, null, "(. classes)", localStrings.getLocalString("ui.uiconfig.propertyhelp.ejb_search_paths", "SearchPaths - EJB module default")), new UIConfigProperties.Key("ui.update.searchPath.rar", "File[-]", "public", false, null, "(. classes)", localStrings.getLocalString("ui.uiconfig.propertyhelp.rar_search_paths", "SearchPaths - RAR module default")), new UIConfigProperties.Key("ui.update.searchPath.appClient", "File[-]", "public", false, null, "(. classes)", localStrings.getLocalString("ui.uiconfig.propertyhelp.appclient_search_paths", "SearchPaths - App-Client module default")), new UIConfigProperties.Key("ui.update.searchPath.app", "File[-]", "public", false, null, "(. lib)", localStrings.getLocalString("ui.uiconfig.propertyhelp.app_search_paths", "SearchPaths - Application module default")), new UIConfigProperties.Key("ui.update.searchPath.default", "File[-]", "private", false, null, "(classes lib .)", localStrings.getLocalString("ui.uiconfig.propertyhelp.default_search_paths", "SearchPaths - General default")), new UIConfigProperties.Key("ui.project.saveProjectFile", "Boolean", "public", false, null, "true", localStrings.getLocalString("ui.uiconfig.propertyhelp.save_project_file", "Save project file in jar")), new UIConfigProperties.Key("ui.Wizard.treeComboSelectionType", "List", "system", false, new String[]{"list", "tree"}, "list", "TreeCombo list selection type"), new UIConfigProperties.Key("ui.startup.disableBusyCursor", "Boolean", "system", false, null, "false", "Disable installation of busy-cursor"), new UIConfigProperties.Key("ui.Wizard.skipIntro_", "Boolean", "system", false, null, "false", "Prefix to Wizard 'Skip this screen...' properties"), new UIConfigProperties.Key("ui.dontShowAgain_", "Boolean", "system", false, null, "false", "Prefix to 'Dont show this again' dialog properties"), new UIConfigProperties.Key("ui.Box.borderType", "List", "private", false, BorderValues, "EtchedBorder", "Box Border"), new UIConfigProperties.Key("ui.enableExceptionLogFile", "Boolean", "private", false, null, "false", "Enable Exception LogFile"), new UIConfigProperties.Key("ui.Deploy.connectors.useDisplayName", "Boolean", "system", false, null, "false", "Use resource-adapter display name (rather than file name)"), new UIConfigProperties.Key("ui.Help.preCheck", "Boolean", "private", false, null, "true", "Pre-check help-ids at initialization time"), new UIConfigProperties.Key("ui.Help.hideInvalidHelp", "Boolean", "private", false, null, "true", "Hide buttons with invalid help-ids"), new UIConfigProperties.Key("ui.RemoteAccess.port", "Integer", "private", false, null, "-1", "Remote Command Port (> 1024)"), new UIConfigProperties.Key("ui.ExecProcess.consoleWordWrap", "Boolean", "private", false, null, "true", "Exec Console Word-Wrap"), new UIConfigProperties.Key("/showDeploymentSettings", "Boolean", "runtime", false, null, "true", "Show Sun-specific Settings"), new UIConfigProperties.Key("ui.defaultClasspath", "String[-]", "public", false, null, "", "Default Classpath"), new UIConfigProperties.Key("ui.appClientStubExtension", "String[-]", "public", false, null, "_client.jar", "AppClient stub extension"), new UIConfigProperties.Key("ui.deploymentSettingsExtn", "String[-]", "public", false, null, "_ds.xml", "DeploymentSettings extension"), new UIConfigProperties.Key("ui.debugMode", "Boolean", "private", false, null, "false", "Debug mode"), new UIConfigProperties.Key("ui.debug.showControlBorders", "Boolean", "private", false, null, "false", "Show Control-Box Borders"), new UIConfigProperties.Key("ui.testMode", "Boolean", "private", false, null, "false", "Test mode"), new UIConfigProperties.Key("/debugLogFile", "File", "runtime", true, null, null, "Debug Log File (read only)"), new UIConfigProperties.Key("/exceptionLogFile", "File", "runtime", true, null, null, "Exception Log File (read only)"), new UIConfigProperties.Key("/WSPack", "Boolean", "runtime", false, null, "false", "WSPack mode")};
    private static boolean showPrivateKeys = false;
    private static boolean showRuntimeKeys = true;
    private static boolean showSystemKeys = false;
    private static boolean showUnknownKeys = true;
    private static boolean isTestMode = false;
    private static String userDir = null;
    private static final String TEMP_DIR_TYPE = "tmp";
    private static String cachedSystemTempDir = null;
    private static Vector startingDirectories = null;
    private static UIConfigProperties configProps = null;
    private static String CONFIG_FILENAME = "deploytool.conf";
    private static File configDir = null;
    private static File configFile = null;
    private static final String EDIT_TABLE_TITLE = localStrings.getLocalString("ui.uiconfig.edit.table.title", "Edit Runtime Configuration");
    private static final String EDIT_TABLE_KEY = localStrings.getLocalString("ui.uiconfig.edit.table.key", "Property");
    private static final String EDIT_TABLE_SCOPE = localStrings.getLocalString("ui.uiconfig.edit.table.scope", "S");
    private static final String EDIT_TABLE_TYPE = localStrings.getLocalString("ui.uiconfig.edit.table.type", "Type");
    private static final String EDIT_TABLE_VALUE = localStrings.getLocalString("ui.uiconfig.edit.table.value", "Value");
    private static final String COLOR_CHOOSER = localStrings.getLocalString("ui.uiconfig.edit.color_chooser", "Color Chooser...");
    private static final String COLOR_CHOOSER_TITLE = localStrings.getLocalString("ui.uiconfig.edit.color_chooser.title", "Color Chooser");
    private static ConfigEditor configEditor = null;

    public static void addConfigProperty(String n, String t, String[] v, String d) {
        UIConfig._Props().addPropertyKey(n, t, PUBLIC, v, d, null);
    }

    public static void addConfigProperty(String n, String t, String[] v, String d, String h) {
        UIConfig._Props().addPropertyKey(n, t, PUBLIC, v, d, h);
    }

    public static void setShowPrivateKeys(boolean pk) {
        showPrivateKeys = pk;
    }

    public static boolean getShowPrivateKeys() {
        return showPrivateKeys;
    }

    public static void setShowRuntimeKeys(boolean pk) {
        showRuntimeKeys = pk;
    }

    public static boolean getShowRuntimeKeys() {
        return showPrivateKeys && showRuntimeKeys;
    }

    public static void setShowSystemeKeys(boolean pk) {
        showSystemKeys = pk;
    }

    public static boolean getShowSystemKeys() {
        return showPrivateKeys && showSystemKeys;
    }

    public static void setShowUnknownKeys(boolean pk) {
        showUnknownKeys = pk;
    }

    public static boolean getShowUnknownKeys() {
        return showPrivateKeys && showUnknownKeys;
    }

    private static void _initSystemProperties(boolean didReload) {
        String debugProp = System.getProperty(DEBUG_MODE);
        if (debugProp == null) {
            debugProp = System.getProperty(DEBUG_MODE.toLowerCase());
        }
        if (debugProp != null) {
            UIConfig.setDebugMode(UIConfig.BooleanValue(debugProp, false));
            System.getProperties().remove(DEBUG_MODE);
            System.getProperties().remove(DEBUG_MODE.toLowerCase());
        } else {
            UIConfig.setDebugMode(UIConfig.getConfigBoolean(DEBUG_MODE));
        }
        String testProp = System.getProperty(TEST_MODE);
        if (testProp == null) {
            testProp = System.getProperty(TEST_MODE.toLowerCase());
        }
        if (testProp != null) {
            UIConfig.setTestMode(UIConfig.BooleanValue(testProp, false));
            System.getProperties().remove(TEST_MODE);
            System.getProperties().remove(TEST_MODE.toLowerCase());
        } else {
            UIConfig.setTestMode(UIConfig.getConfigBoolean(TEST_MODE));
        }
        UIConfig._setSystemHomeDirectory(UIConfig.getHomeDirectory());
        UIConfig._setSystemTempDirectory(UIConfig.getTempDirectory());
    }

    public static boolean debugMode() {
        return Print.isDebugMode();
    }

    public static void setDebugMode(boolean mode) {
        Print.setDebugMode((boolean)mode);
    }

    public static boolean testMode() {
        return isTestMode;
    }

    public static void setTestMode(boolean mode) {
        isTestMode = mode;
    }

    public static boolean bugfix(String bugId) {
        return UIConfig.getConfigBoolean(BUGFIX + bugId);
    }

    public static File getHomeDirectory() {
        File homeDirectory = UIConfig.getConfigFile(HOME_DIR, null);
        if (homeDirectory == null) {
            String key = HOME_DIR.toLowerCase();
            homeDirectory = UIConfig.getConfigFile(key, null);
            if (homeDirectory != null) {
                UIConfig.removeConfigKey(key);
                UIConfig.setConfigFile(HOME_DIR, homeDirectory);
            } else {
                String home = System.getProperty("user.home");
                homeDirectory = home != null ? new File(home) : new File("");
            }
        }
        return homeDirectory;
    }

    public static void setHomeDirectory(File homedir) {
        UIConfig.setConfigFile(HOME_DIR, homedir);
        UIConfig._setSystemHomeDirectory(homedir);
    }

    protected static void _setSystemHomeDirectory(File homeDir) {
        String homeDirStr = homeDir.getPath();
        System.setProperty(HOME_DIR, homeDirStr);
    }

    public static void setUserDir(String userSpecify) {
        userDir = userSpecify;
    }

    public static String getUserDir() {
        return userDir;
    }

    public static File getDefaultTempDirectory() {
        File tmpDir = null;
        if (TEMP_DIR_TYPE.equals("home")) {
            tmpDir = new File(UIConfig.getHomeDirectory(), TEMP_DIR_NAME);
        } else if (TEMP_DIR_TYPE.equals("config")) {
            tmpDir = new File(UIConfig.getConfigDirectory(), TEMP_DIR_NAME);
        } else if (TEMP_DIR_TYPE.equals(TEMP_DIR_TYPE) || TEMP_DIR_TYPE.equals("temp")) {
            String tempName = "sun-dt-" + System.getProperty("user.name", "s1as");
            tmpDir = new File(UIConfig._getSystemTempDirectory(), tempName);
        } else {
            tmpDir = new File(UIConfig._getSystemTempDirectory(), TEMP_DIR_NAME);
        }
        return tmpDir;
    }

    public static File getTempDirectory() {
        File tempDirectory = UIConfig.getConfigFile(TEMP_DIR, null);
        if (tempDirectory == null) {
            String key = TEMP_DIR.toLowerCase();
            tempDirectory = UIConfig.getConfigFile(key, null);
            if (tempDirectory != null) {
                UIConfig.removeConfigKey(key);
                UIConfig.setConfigFile(TEMP_DIR, tempDirectory);
            } else {
                tempDirectory = UIConfig.getDefaultTempDirectory();
            }
        }
        if (!tempDirectory.exists()) {
            tempDirectory.mkdirs();
        }
        FileUtil.deleteOnExit((File)tempDirectory, (boolean)true);
        return tempDirectory;
    }

    protected static String _getSystemTempDirectory() {
        if (cachedSystemTempDir == null) {
            cachedSystemTempDir = System.getProperty("java.io.tmpdir", File.separator + TEMP_DIR_TYPE);
            Print.dprintln((String)("Cached 'java.io.tmpdir': " + cachedSystemTempDir));
        }
        return cachedSystemTempDir;
    }

    protected static void _setSystemTempDirectory(File tmpDir) {
        String tmpDirStr = tmpDir.getPath();
        System.setProperty(TEMP_DIR, tmpDirStr);
        System.setProperty("user.dir", tmpDirStr);
        UIConfig._getSystemTempDirectory();
        System.setProperty("java.io.tmpdir", tmpDirStr);
        if (System.getProperty("user.name") == null) {
            System.setProperty("user.name", "s1as");
        }
    }

    public static File makeTempFile(String fileName) {
        File file = new File(UIConfig.getTempDirectory(), fileName);
        FileUtil.deleteOnExit((File)file, (boolean)true);
        return file;
    }

    public static File makeTempDir(String dirName) {
        File dir = new File(UIConfig.getTempDirectory(), dirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileUtil.deleteOnExit((File)dir, (boolean)true);
        return dir;
    }

    public static boolean isInTempDirectory(File file) {
        return file != null ? UIConfig.isInTempDirectory(file.getPath()) : false;
    }

    public static boolean isInTempDirectory(String file) {
        String tmpDir = UIConfig.getTempDirectory().getAbsolutePath();
        if (file == null) {
            return false;
        }
        return tmpDir.equals(file) || file.startsWith(tmpDir + File.separator);
    }

    public static String getInstallationRoot() {
        return System.getProperty("com.sun.aas.installRoot");
    }

    public static String getDefaultUserName() {
        String user = System.getProperty("com.sun.aas.defaultUserName");
        return user == null ? "" : user;
    }

    public static String getDefaultPassword() {
        String pswd = System.getProperty("com.sun.aas.defaultPassword");
        return pswd == null ? "" : pswd;
    }

    public static String getLogFile() {
        return System.getProperty("com.sun.aas.defaultLogFile");
    }

    public static String getJavaHome() {
        return System.getProperty("JAVA_HOME");
    }

    public static Vector _getStartingDirectories(File defaultDir, Vector cacheList) {
        if (cacheList == null) {
            String[] dirs;
            int max = UIConfig.getMaxStartingDirectories();
            if (max > (dirs = UIConfig.getStringArray(STARTING_DIRECTORIES)).length) {
                max = dirs.length;
            }
            cacheList = new Vector<File>();
            for (int i = 0; i < max; ++i) {
                File d = new File(dirs[i]);
                if (UIConfig.isInTempDirectory(d)) continue;
                cacheList.add(d);
            }
        }
        if (cacheList.size() <= 0 && defaultDir != null) {
            cacheList.add(defaultDir);
        }
        return cacheList;
    }

    public static Vector getStartingDirectories(File defaultDir) {
        if (startingDirectories == null) {
            startingDirectories = UIConfig._getStartingDirectories(defaultDir, null);
        }
        return startingDirectories;
    }

    public static Vector getStartingDirectories() {
        return UIConfig.getStartingDirectories(UIConfig.getHomeDirectory());
    }

    public static File getStartingDirectory() {
        Object f = UIConfig.getStartingDirectories().elementAt(0);
        return f instanceof File ? (File)f : new File(f.toString());
    }

    public static Vector _setStartingDirectories(Vector dirs) {
        int max = UIConfig.getMaxStartingDirectories();
        Vector<File> sd = new Vector<File>();
        Enumeration e = dirs.elements();
        for (int i = 0; e.hasMoreElements() && i < max; ++i) {
            Object obj = e.nextElement();
            if (obj instanceof String) {
                sd.add(new File(obj.toString()));
                continue;
            }
            if (obj instanceof File) {
                sd.add((File)obj);
                continue;
            }
            Print.printStackTrace((String)("Not a String/File: " + DT.className(obj)));
        }
        return sd;
    }

    public static Vector setStartingDirectories(Vector dirs) {
        startingDirectories = UIConfig._setStartingDirectories(dirs);
        UIConfig.setConfigList(STARTING_DIRECTORIES, startingDirectories);
        return startingDirectories;
    }

    public static boolean _addStartingDirectory(File dir, Vector cacheList) {
        if (!UIConfig.isInTempDirectory(dir) && dir != null) {
            if (cacheList == null) {
                Print.printStackTrace((String)"cached starting dirs is 'null'");
                return false;
            }
            cacheList.remove(dir);
            cacheList.insertElementAt(dir, 0);
            if (cacheList.size() > UIConfig.getMaxStartingDirectories()) {
                int ndx = cacheList.size() - 1;
                cacheList.removeElementAt(ndx);
            }
            return true;
        }
        return false;
    }

    public static boolean addStartingDirectory(File dir) {
        if (startingDirectories == null) {
            startingDirectories = UIConfig._getStartingDirectories(UIConfig.getHomeDirectory(), null);
        }
        if (UIConfig._addStartingDirectory(dir, startingDirectories)) {
            UIConfig.setConfigList(STARTING_DIRECTORIES, startingDirectories);
            return true;
        }
        return false;
    }

    public static boolean _removeStartingDirectory(File dir, Vector cacheList) {
        if (dir != null) {
            if (cacheList == null) {
                Print.printStackTrace((String)"cached starting dirs is 'null'");
                return false;
            }
            return cacheList.remove(dir);
        }
        return false;
    }

    public static boolean removeStartingDirectory(File dir) {
        if (startingDirectories == null) {
            startingDirectories = UIConfig._getStartingDirectories(UIConfig.getHomeDirectory(), null);
        }
        if (UIConfig._removeStartingDirectory(dir, startingDirectories)) {
            UIConfig.setConfigList(STARTING_DIRECTORIES, startingDirectories);
            return true;
        }
        return false;
    }

    public static int getMaxStartingDirectories() {
        return UIConfig.getConfigInteger(MAX_STARTING_DIRECTORIES);
    }

    public static void setMaxStartingDirectories(int max) {
        UIConfig.setConfigInteger(MAX_STARTING_DIRECTORIES, max);
    }

    private static UIConfigProperties _Props() {
        if (configProps == null) {
            configProps = new UIConfigProperties(cfgKeys);
        }
        return configProps;
    }

    public static UIConfigProperties getConfigProperties() {
        return UIConfig._Props();
    }

    public static File getConfigDirectory() {
        if (configDir == null) {
            if (userDir != null && !userDir.equals("")) {
                configDir = new File(userDir);
            } else {
                String home = System.getProperty("user.home");
                File homeDir = home != null ? new File(home) : new File("");
                configDir = new File(homeDir, CONFIG_DIR_NAME);
            }
            configDir.mkdirs();
        }
        return configDir;
    }

    public static boolean loadConfig() {
        return UIConfig.loadConfig(true);
    }

    public static boolean loadConfig(boolean reload) {
        String cfn = System.getProperty(SYS_CONFIG_FILENAME, CONFIG_FILENAME);
        File cfgFile = new File(cfn).isAbsolute() ? new File(cfn) : new File(UIConfig.getConfigDirectory(), cfn);
        UIConfigProperties props = UIConfig._Props();
        props.setConfigFile(cfgFile);
        if (cfgFile.exists()) {
            try {
                props.loadFile();
                UIConfig._initSystemProperties(true);
                UIConfig.setShowPrivateKeys(UIConfig.debugMode());
                UIConfig.setShowRuntimeKeys(UIConfig.debugMode());
                return true;
            }
            catch (Throwable t) {
                UIConfig.println("[Load] " + cfgFile.toString() + " - " + t.toString());
                return false;
            }
        }
        UIConfig.saveConfig();
        return false;
    }

    public static void removeConfigKey(String key) {
        UIConfig._Props().removeKey(key);
    }

    public static String getKeyDefaultValue(String key) {
        return UIConfig._Props().getPropertyDefaultValue(key);
    }

    public static String getConfigValue(String key, String dftVal) {
        return UIConfig._Props().getProperty(key, dftVal);
    }

    public static String getConfigValue(String key) {
        return UIConfig._Props().getProperty(key);
    }

    public static void setConfigValue(String key, String value) {
        UIConfig._Props().setProperty(key, value);
    }

    public static String[] getStringArray(String key, String[] dftVal) {
        return UIConfig._Props().getStringArray(key, dftVal);
    }

    public static List getStringList(String key, List dftVal) {
        return UIConfig._Props().getStringList(key, dftVal);
    }

    public static String[] getStringArray(String key) {
        return UIConfig._Props().getStringArray(key);
    }

    public static List getStringList(String key) {
        return UIConfig._Props().getStringList(key);
    }

    public static Object[] getConfigArray(String key, Object[] dftVal) {
        return UIConfig._Props().getPropertyArray(key, dftVal);
    }

    public static List getConfigList(String key, List dftVal) {
        return UIConfig._Props().getPropertyList(key, dftVal);
    }

    public static Object[] getConfigArray(String key) {
        return UIConfig._Props().getPropertyArray(key);
    }

    public static List getConfigList(String key) {
        return UIConfig._Props().getPropertyList(key);
    }

    public static void setConfigArray(String key, Object[] value) {
        UIConfig._Props().setPropertyArray(key, value);
    }

    public static void setConfigList(String key, List value) {
        UIConfig._Props().setPropertyList(key, value);
    }

    public static void printConfigArray(Object obj) {
        UIConfig._printConfigArray(0, obj);
    }

    private static void _printConfigArray(int level, Object obj) {
        if (obj == null) {
            UIConfig._cfgPrintln(level, "null");
        } else if (obj instanceof String) {
            UIConfig._cfgPrintln(level, (String)obj);
        } else if (obj instanceof Object[]) {
            Object[] list = (Object[])obj;
            UIConfig._cfgPrintln(level, "{ " + obj.getClass().getName());
            for (int i = 0; i < list.length; ++i) {
                UIConfig._printConfigArray(level + 1, list[i]);
            }
            UIConfig._cfgPrintln(level, "}");
        } else if (obj instanceof List) {
            List list = (List)obj;
            UIConfig._cfgPrintln(level, "{ " + obj.getClass().getName());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                UIConfig._printConfigArray(level + 1, i.next());
            }
            UIConfig._cfgPrintln(level, "}");
        } else {
            UIConfig._cfgPrintln(level, "??? " + obj.getClass().getName());
        }
    }

    private static void _cfgPrintln(int level, String msg) {
        StringBuffer sb = new StringBuffer();
        while (level > 0) {
            sb.append("  ");
            --level;
        }
        Print.println((String)sb.append(msg).toString());
    }

    public static boolean BooleanValue(String bool, boolean dftVal) {
        return UIConfigProperties.BooleanValue(bool, dftVal);
    }

    public static boolean getKeyDefaultBoolean(String key) {
        return UIConfig._Props().getPropertyDefaultBoolean(key);
    }

    public static boolean isValidBoolean(String key, String value) {
        return UIConfigProperties.IsBoolean(value);
    }

    public static boolean getConfigBoolean(String key, boolean dftVal) {
        return UIConfig._Props().getPropertyBoolean(key, dftVal);
    }

    public static boolean getConfigBoolean(String key) {
        return UIConfig._Props().getPropertyBoolean(key);
    }

    public static void setConfigBoolean(String key, boolean value) {
        UIConfig._Props().setPropertyBoolean(key, value);
    }

    public static boolean isValidInteger(String key, String value) {
        String[] vals = UIConfig._Props().getPropertyValidValues(key);
        return UIConfigProperties.IsInteger(vals, value);
    }

    public static int getKeyDefaultInteger(String key) {
        return UIConfig._Props().getPropertyDefaultInteger(key);
    }

    public static int getConfigInteger(String key, int dftVal) {
        return UIConfig._Props().getPropertyInteger(key, dftVal);
    }

    public static int getConfigInteger(String key) {
        return UIConfig._Props().getPropertyInteger(key);
    }

    public static void setConfigInteger(String key, int value) {
        UIConfig._Props().setPropertyInteger(key, value);
    }

    private static File _getFileValue(String key, String fileName, File dftVal) {
        return fileName != null && !fileName.equals("") ? new File(fileName) : dftVal;
    }

    public static boolean isValidFile(String key, String value) {
        return true;
    }

    public static File getKeyDefaultFile(String key) {
        return UIConfig._getFileValue(key, UIConfig.getKeyDefaultValue(key), null);
    }

    public static File getConfigFile(String key, File dftVal) {
        return UIConfig._getFileValue(key, UIConfig.getConfigValue(key, null), dftVal);
    }

    public static File getConfigFile(String key) {
        return UIConfig.getConfigFile(key, UIConfig.getKeyDefaultFile(key));
    }

    public static void setConfigFile(String key, File value) {
        UIConfig.setConfigValue(key, value != null ? value.getAbsolutePath() : null);
    }

    private static Color _getColorValue(String key, String cn, Color dftVal) {
        Color rtnColor = dftVal;
        if (cn == null || cn.equals("")) {
            return rtnColor;
        }
        if (cn.startsWith("#")) {
            try {
                int colorVal = Integer.decode(cn);
                rtnColor = new Color(colorVal);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            return rtnColor;
        }
        for (int i = 0; i < ColorMap.length; ++i) {
            if (!cn.equalsIgnoreCase((String)ColorMap[i][0])) continue;
            rtnColor = (Color)ColorMap[i][1];
            break;
        }
        return rtnColor;
    }

    public static boolean isValidColor(String key, String value) {
        return UIConfig._getColorValue(key, value, null) != null;
    }

    public static Color getKeyDefaultColor(String key) {
        return UIConfig._getColorValue(key, UIConfig.getKeyDefaultValue(key), null);
    }

    public static Color getConfigColor(String key, Color dftVal) {
        return UIConfig._getColorValue(key, UIConfig.getConfigValue(key, null), dftVal);
    }

    public static Color getConfigColor(String key) {
        return UIConfig.getConfigColor(key, UIConfig.getKeyDefaultColor(key));
    }

    public static void setConfigColor(String key, Color value) {
        if (value == null) {
            UIConfig.removeConfigKey(key);
            return;
        }
        for (int i = 0; i < ColorMap.length; ++i) {
            if (!value.equals((Color)ColorMap[i][1])) continue;
            UIConfig.setConfigValue(key, (String)ColorMap[i][0]);
            return;
        }
        String hex = Integer.toHexString(0x1000000 | value.getRGB());
        hex = hex.substring(hex.length() - 6);
        UIConfig.setConfigValue(key, "#" + hex.toUpperCase());
    }

    private static Class _getClassValue(String key, String cn, Class dftVal) throws ClassNotFoundException {
        if (cn != null && !cn.equals("")) {
            return Class.forName(cn);
        }
        return dftVal;
    }

    public static boolean isValidClass(String key, String value) {
        return true;
    }

    public static Class getKeyDefaultClass(String key) throws ClassNotFoundException {
        return UIConfig._getClassValue(key, UIConfig.getKeyDefaultValue(key), null);
    }

    public static Class getConfigClass(String key, Class dftVal) throws ClassNotFoundException {
        return UIConfig._getClassValue(key, UIConfig.getConfigValue(key, null), dftVal);
    }

    public static Class getConfigClass(String key) throws ClassNotFoundException {
        return UIConfig.getConfigClass(key, UIConfig.getKeyDefaultClass(key));
    }

    public static void setConfigClass(String key, Class value) {
        UIConfig.setConfigValue(key, value != null ? value.getName() : null);
    }

    public static boolean saveConfig() {
        boolean saved = false;
        try {
            UIConfig._Props().save("DeployTool UI Runtime Config [DO NOT EDIT, contents subject to change]", UIConfig.debugMode());
            saved = true;
        }
        catch (Throwable t) {
            UIConfig.println("[Save] " + UIConfig._Props().toString() + " - " + t.toString());
            saved = false;
        }
        return saved;
    }

    private static final String EDIT_PROPERTIES(String v0) {
        return localStrings.getLocalString("ui.uiconfig.edit.properties", "Preferences [{0}]", new Object[]{v0});
    }

    public static void editConfig() {
        if (configEditor == null) {
            configEditor = new ConfigEditor();
        }
        configEditor.show();
    }

    public static boolean editConfig(Dialog dialog) {
        ConfigEditor ce = new ConfigEditor(dialog);
        ce.show();
        return ce.didSave();
    }

    public static boolean editConfig(Frame frame) {
        if (frame == DT.getApplicationFrame()) {
            UIConfig.editConfig();
            return configEditor.didSave();
        }
        ConfigEditor ce = new ConfigEditor(frame);
        ce.show();
        return ce.didSave();
    }

    public static void println(String msg) {
        Print.println((String)("Config: " + msg));
    }

    public static int parseInt(String num, int dft) {
        if (num != null) {
            try {
                return Integer.parseInt(num);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return dft;
    }

    static /* synthetic */ void access$600(boolean x0) {
        UIConfig._initSystemProperties(x0);
    }

    protected static class ConfigKeyComparator
    implements Comparator {
        public int compare(Object r1, Object r2) {
            UIConfigProperties.Key k1 = (UIConfigProperties.Key)r1;
            UIConfigProperties.Key k2 = (UIConfigProperties.Key)r2;
            if (k1.isScopeUnknown() && !k2.isScopeUnknown()) {
                return 1;
            }
            if (!k1.isScopeUnknown() && k2.isScopeUnknown()) {
                return -1;
            }
            return k1.key.compareTo(k2.key);
        }
    }

    protected static class ConfigTableModel
    extends InspectorTableModel {
        private ConfigTable cfgTable = null;

        public ConfigTableModel() {
            super(new String[]{EDIT_TABLE_KEY, EDIT_TABLE_SCOPE, EDIT_TABLE_TYPE, EDIT_TABLE_VALUE});
            this.setDataOrdering(1, new ConfigKeyComparator());
        }

        public void setTable(ConfigTable tbl) {
            this.cfgTable = tbl;
        }

        public boolean isCellEditable(int row, int col) {
            if (col != 3) {
                return false;
            }
            UIConfigProperties.Key ref = (UIConfigProperties.Key)this.getRowObject(row);
            if (ref.isReadOnly()) {
                return false;
            }
            return !ref.isScopeUnknown() || ref.editValue != null;
        }

        public Object getObjectValue(Object obj, int col) {
            UIConfigProperties.Key ref = (UIConfigProperties.Key)obj;
            String value = null;
            switch (col) {
                case 0: {
                    if (this.cfgTable.userMode()) {
                        String h = ref.getHelp();
                        value = h != null && !h.equals("") ? h : ref.key;
                        break;
                    }
                    value = ref.key;
                    break;
                }
                case 1: {
                    value = "?";
                    if (ref.isScopeUnknown()) {
                        value = "?";
                        break;
                    }
                    if (ref.isScopeSystem()) {
                        value = "S";
                        break;
                    }
                    if (ref.isScopeRuntime()) {
                        value = "R";
                        break;
                    }
                    if (ref.isScopePublic()) {
                        value = " ";
                        break;
                    }
                    if (ref.isScopePrivate()) {
                        value = "P";
                        break;
                    }
                    if (!ref.isScopeObsolete()) break;
                    value = "O";
                    break;
                }
                case 2: {
                    value = ref.getType();
                    break;
                }
                case 3: {
                    value = ref.isScopeUnknown() && ref.editValue == null ? "<deleted>" : (ref.editValue != null ? ref.editValue : "");
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            UIConfigProperties.Key ref = (UIConfigProperties.Key)obj;
            if (ref == null) {
                return;
            }
            String valStr = value.toString();
            if (col == 3) {
                String v;
                if (valStr.equals("") && (v = UIConfig.getKeyDefaultValue(ref.key)) != null) {
                    valStr = v;
                }
                if (ref.isTypeArray()) {
                    if (!valStr.startsWith("(")) {
                        valStr = "(" + valStr;
                    }
                    if (!valStr.endsWith(")")) {
                        valStr = valStr + ")";
                    }
                    ref.editValue = valStr;
                }
                if (ref.isTypeInteger()) {
                    if (valStr.equals("") || UIConfig.isValidInteger(ref.key, valStr)) {
                        ref.editValue = valStr;
                    }
                } else if (ref.isTypeColor()) {
                    if (valStr.equals("") || UIConfig.isValidColor(ref.key, valStr)) {
                        ref.editValue = valStr.startsWith("#") ? valStr.toUpperCase() : valStr;
                    }
                } else if (ref.isTypeClass()) {
                    if (valStr.equals("") || UIConfig.isValidClass(ref.key, valStr)) {
                        ref.editValue = valStr;
                    }
                } else if (ref.isTypeFile()) {
                    if (valStr.equals("") || UIConfig.isValidFile(ref.key, valStr)) {
                        ref.editValue = valStr;
                    }
                } else {
                    ref.editValue = valStr;
                }
            }
        }
    }

    protected static class ConfigTable
    extends InspectorTable {
        private boolean userMode = false;
        private Hashtable keyValueEditor = new Hashtable();
        private JColorChooser colorChooser = null;

        public ConfigTable(ConfigTableModel model) {
            super(model);
            model.setTable(this);
            this.setSelectionMode(0);
        }

        public void setUserMode(boolean usr) {
            this.clearSelection();
            this.userMode = usr;
            this.setColumnHidden(1, this.userMode);
            this.setColumnHidden(2, this.userMode);
        }

        public boolean userMode() {
            return this.userMode;
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 3: {
                    rtn = this.getKeyValueEditor(this.getRowObject(row));
                }
            }
            return rtn != null ? rtn : super.getCellEditor(row, col);
        }

        private TableCellEditor getKeyValueEditor(Object keyObj) {
            UIConfigProperties.Key key = (UIConfigProperties.Key)keyObj;
            TableCellEditor editor = (TableCellEditor)this.keyValueEditor.get(key.key);
            if (editor == null && key.getValidValues() != null) {
                editor = super.getComboBoxEditor(key.getValidValues());
                if (key.isTypeColor()) {
                    InspectorTable.TableComboBoxEditor cbe = (InspectorTable.TableComboBoxEditor)editor;
                    cbe.setEditable(true);
                    cbe.addActionItem(COLOR_CHOOSER, new ActionListener(this){
                        private final /* synthetic */ ConfigTable this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void actionPerformed(ActionEvent ae) {
                            Object rowObj = this.this$0.getRowObject(this.this$0.getSelectedRow());
                            UIConfigProperties.Key key = (UIConfigProperties.Key)rowObj;
                            ConfigTable.access$1200(this.this$0, key);
                        }
                    });
                }
                this.keyValueEditor.put(key.key, editor);
            }
            return editor;
        }

        private void editWithColorChooser(UIConfigProperties.Key key) {
            if (key != null && key.isTypeColor()) {
                Color newColor;
                if (this.colorChooser == null) {
                    this.colorChooser = new JColorChooser();
                }
                Color color = null;
                if (key.editValue != null) {
                    try {
                        color = new Color(Integer.decode(key.editValue));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                if ((newColor = JColorChooser.showDialog(this, COLOR_CHOOSER_TITLE, color)) != null) {
                    String hex = Integer.toHexString(0x1000000 | newColor.getRGB());
                    hex = hex.substring(hex.length() - 6);
                    key.editValue = "#" + hex.toUpperCase();
                }
            }
        }

        public String getToolTipText(MouseEvent me) {
            int row = this.getSelectedRow();
            for (int col = 0; col < this.getColumnCount(); ++col) {
                Rectangle rect = super.getCellRect(row, 0, true);
                if (!rect.contains(me.getPoint())) continue;
                UIConfigProperties.Key key = (UIConfigProperties.Key)this.getRowObject(row);
                return key.getHelp() != null ? key.getHelp() : "";
            }
            return super.getToolTipText(me);
        }

        static /* synthetic */ void access$1200(ConfigTable x0, UIConfigProperties.Key x1) {
            x0.editWithColorChooser(x1);
        }
    }

    private static class ConfigEditor
    extends UIDialog {
        private ConfigTable configTable = null;
        private Vector configData = null;
        private UIButton addPB = null;
        private UIButton delPB = null;
        private boolean didSave = false;

        public ConfigEditor(Dialog dialog) {
            super(dialog, true);
            this.init();
        }

        public ConfigEditor(Frame frame) {
            super(frame, true);
            this.init();
        }

        public ConfigEditor() {
            this(DT.getApplicationFrame());
        }

        private void init() {
            UITitledBox content = this.getContentBox();
            GridBagConstraints c = new GridBagConstraints();
            this.setTitle(UIConfig.EDIT_PROPERTIES(UIConfig._Props().toString()));
            UITitledTable editTable = new UITitledTable(EDIT_TABLE_TITLE, false);
            editTable.setControlButtonLocation(101);
            c.weightx = 0.5;
            c.weighty = 0.5;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(5, 5, 5, 5);
            c.fill = 1;
            content.add((Component)editTable, c);
            this.configTable = new ConfigTable(new ConfigTableModel());
            editTable.setTableView(this.configTable);
            this.addPB = UIButton.createAddButton(new ActionListener(this){
                private final /* synthetic */ ConfigEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    String key = UIOptionPane.showTextInputDialog(this.this$0, "Enter new config key:", "");
                    if (key == null || key.equals("")) {
                        return;
                    }
                    UIConfigProperties.Key ck = UIConfig.access$000().getPropertyKey(key);
                    if (ck == null) {
                        Iterator<E> i = ConfigEditor.access$300(this.this$0).iterator();
                        while (i.hasNext()) {
                            UIConfigProperties.Key rk = (UIConfigProperties.Key)i.next();
                            if (!rk.key.equals(key)) continue;
                            ck = rk;
                            break;
                        }
                        if (ck == null) {
                            ck = ConfigEditor.access$400(this.this$0, key, "");
                            ConfigEditor.access$300(this.this$0).add(ck);
                            ConfigEditor.access$500(this.this$0).updateTableData(ConfigEditor.access$300(this.this$0));
                        } else if (ck.isScopeUnknown() && ck.editValue == null) {
                            ck.editValue = "";
                            ConfigEditor.access$500(this.this$0).updateTableData(ConfigEditor.access$300(this.this$0));
                        }
                    }
                    ConfigEditor.access$500(this.this$0).setSelectedRowObject(ck);
                }
            });
            this.addPB.setVisible(UIConfig.getShowPrivateKeys());
            editTable.addControlButton(this.addPB);
            this.delPB = UIButton.createDeleteButton(new ActionListener(this){
                private final /* synthetic */ ConfigEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    Object ref = ConfigEditor.access$500(this.this$0).getSelectedRowObject();
                    if (ref != null) {
                        String dft;
                        UIConfigProperties.Key key = (UIConfigProperties.Key)ref;
                        key.editValue = key.isScopeUnknown() ? null : ((dft = key.getDefaultValue()) != null ? dft : "");
                        ConfigEditor.access$500(this.this$0).clearSelection();
                        ConfigEditor.access$500(this.this$0).updateTableData(ConfigEditor.access$300(this.this$0));
                    }
                }
            });
            this.delPB.setVisible(UIConfig.getShowPrivateKeys());
            editTable.addSelectionEnabledButton(this.delPB);
            editTable.addControlSpacer(20);
            UITitledTable buttons = editTable;
            UIButton savePB = UIButton.createSaveButton(new ActionListener(this){
                private final /* synthetic */ ConfigEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    boolean changed = false;
                    Iterator<E> i = ConfigEditor.access$300(this.this$0).iterator();
                    while (i.hasNext()) {
                        UIConfigProperties.Key ck = (UIConfigProperties.Key)i.next();
                        String v = ck.editValue;
                        if (v == null) {
                            if (!ck.isScopeUnknown()) continue;
                            UIConfig.removeConfigKey(ck.key);
                            continue;
                        }
                        if (!ck.isScopeUnknown() && v.equals(ck.getDefaultValue())) {
                            UIConfig.removeConfigKey(ck.key);
                            changed = true;
                            continue;
                        }
                        if (v.equals(UIConfig.getConfigValue(ck.key))) continue;
                        UIConfig.setConfigValue(ck.key, v);
                        changed = true;
                    }
                    if (changed) {
                        UIConfig.access$600(false);
                    }
                    UIConfig.saveConfig();
                    ConfigEditor.access$702(this.this$0, true);
                    this.this$0.hide();
                }
            });
            buttons.addControlButton(savePB);
            UIButton cancelPB = UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ ConfigEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$0.hide();
                }
            });
            buttons.addControlButton(cancelPB);
            editTable.setAcceptsFocus(true);
            UIActionDispatcher.addKeyAction((Component)editTable, "config", new ActionListener(this){
                private final /* synthetic */ ConfigEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    boolean showPrivate = !UIConfig.getShowPrivateKeys();
                    UIConfig.setShowPrivateKeys(showPrivate);
                    ConfigEditor.access$800(this.this$0).setVisible(showPrivate);
                    ConfigEditor.access$900(this.this$0).setVisible(showPrivate);
                    ConfigEditor.access$500(this.this$0).setUserMode(showPrivate ? !UIConfig.debugMode() : true);
                    ConfigEditor.access$302(this.this$0, ConfigEditor.access$1000(this.this$0));
                    ConfigEditor.access$500(this.this$0).updateTableData(ConfigEditor.access$300(this.this$0));
                    ConfigEditor.access$500(this.this$0).adjustColumnWidth(0, true);
                }
            });
        }

        private Vector _getConfigData() {
            Vector<UIConfigProperties.Key> data = new Vector<UIConfigProperties.Key>();
            Enumeration e = UIConfig._Props().getPropertyKeyTable().elements();
            while (e.hasMoreElements()) {
                UIConfigProperties.Key ck = (UIConfigProperties.Key)e.nextElement();
                boolean addKey = false;
                if (ck.isScopePublic()) {
                    addKey = true;
                } else if (ck.isScopePrivate()) {
                    addKey = UIConfig.getShowPrivateKeys();
                } else if (ck.isScopeSystem()) {
                    addKey = UIConfig.getShowSystemKeys();
                } else if (ck.isScopeRuntime()) {
                    addKey = UIConfig.getShowRuntimeKeys();
                }
                if (addKey) {
                    String val = UIConfig.getConfigValue(ck.key);
                    ck.editValue = val != null ? val : "";
                    data.add(ck);
                    continue;
                }
                ck.editValue = null;
            }
            if (UIConfig.getShowUnknownKeys()) {
                e = UIConfig._Props().keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (UIConfig._Props().getPropertyKey(key) != null || !UIConfig._Props().containsProperty(key)) continue;
                    data.add(this.createUnknownKey(key, UIConfig._Props().getProperty(key, null)));
                }
            }
            return data;
        }

        private UIConfigProperties.Key createUnknownKey(String k, String val) {
            String v = val != null ? val.trim() : "";
            String t = UIConfig.STRING;
            if (v.startsWith("(") && v.endsWith(")")) {
                t = UIConfig.STRINGa;
            } else if (v.equalsIgnoreCase(UIConfig.TRUE) || v.equalsIgnoreCase(UIConfig.FALSE)) {
                t = UIConfig.BOOLEAN;
            } else if (v.toLowerCase().startsWith("http://") || v.toLowerCase().startsWith("file:/")) {
                t = UIConfig.URL;
            }
            String s = "unknown";
            UIConfigProperties.Key tk = new UIConfigProperties.Key(k, t, s);
            tk.editValue = v;
            return tk;
        }

        public void show() {
            this.setSize(new Dimension(700, 400));
            this.setLocationRelativeToOwner();
            this.configData = this._getConfigData();
            this.configTable.clearTableData();
            this.configTable.setUserMode(!UIConfig.debugMode());
            this.configTable.updateTableData(this.configData);
            this.configTable.adjustColumnWidth(0, true);
            this.configTable.adjustColumnWidth(1, true);
            this.configTable.adjustColumnWidth(2, true);
            this.didSave = false;
            super.show();
        }

        public boolean didSave() {
            return this.didSave;
        }

        static /* synthetic */ Vector access$300(ConfigEditor x0) {
            return x0.configData;
        }

        static /* synthetic */ UIConfigProperties.Key access$400(ConfigEditor x0, String x1, String x2) {
            return x0.createUnknownKey(x1, x2);
        }

        static /* synthetic */ ConfigTable access$500(ConfigEditor x0) {
            return x0.configTable;
        }

        static /* synthetic */ boolean access$702(ConfigEditor x0, boolean x1) {
            x0.didSave = x1;
            return x0.didSave;
        }

        static /* synthetic */ UIButton access$800(ConfigEditor x0) {
            return x0.addPB;
        }

        static /* synthetic */ UIButton access$900(ConfigEditor x0) {
            return x0.delPB;
        }

        static /* synthetic */ Vector access$302(ConfigEditor x0, Vector x1) {
            x0.configData = x1;
            return x0.configData;
        }

        static /* synthetic */ Vector access$1000(ConfigEditor x0) {
            return x0._getConfigData();
        }
    }
}

