/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.utils.ExecProcess;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class UIBrowser {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIBrowser.class);
    private static String NO_URL = localStrings.getLocalString("ui.uibrowser.no_url", "No URL has been specified/configured to view.");
    private static String NO_COMMAND = localStrings.getLocalString("ui.uibrowser.no_command", "The 'Platform Browser' command has not been specified in 'Preferences'.");
    private static final String URL_PLACEHOLDER = "$";
    private static final String IEXPLORE_WIN_ARG = "$";
    private static final String NETSCAPE_WIN_ARG = "-h $";
    private static final String NETSCAPE_UNIX_ARG = "-remote \"openURL($, new-window)\"";
    private static final Browser[] WIN_BROWSERS = new Browser[]{new Browser("C:\\Program Files\\Netscape\\Communicator\\Program\\netscape.exe", "-h $"), new Browser("C:\\Program Files\\Netscape\\Program\\netscape.exe", "-h $"), new Browser("C:\\Program Files\\Internet Explorer\\iexplore.exe", "$")};
    private static final Browser[] UNIX_BROWSERS = new Browser[]{new Browser("/usr/bin/netscape", "-remote \"openURL($, new-window)\""), new Browser("/usr/local/bin/netscape", "-remote \"openURL($, new-window)\""), new Browser("/usr/dist/exe/netscape", "-remote \"openURL($, new-window)\"")};

    private static String INVALID_URL(String v0) {
        return localStrings.getLocalString("ui.uibrowser.invalid_url", "Invalid (malformed) URL specified:\n  {0}", new Object[]{v0});
    }

    private static String INVALID_COMMAND(String v0) {
        return localStrings.getLocalString("ui.uibrowser.invalid_command", "Unable to start browser to view specified URL due to one of the following reasons:\n  - The browser executable has not been specified properly in 'Edit->Preferences...'\n  - The executable does not specify an absolute path name.\n  - The executable was not found on disk.\n  - An error occurred while attempting to execute the command.\n\n{0}", new Object[]{v0});
    }

    private static List getDefaultPlatformBrowsers() {
        if (DT.getOS() == 4) {
            return ListTools.toList(WIN_BROWSERS);
        }
        return ListTools.toList(UNIX_BROWSERS);
    }

    public static List getDefaultBrowserCommands() {
        List browsers = UIBrowser.getDefaultPlatformBrowsers();
        Vector<String> cmds = new Vector<String>();
        Iterator i = browsers.iterator();
        while (i.hasNext()) {
            Browser b = (Browser)i.next();
            String c = b.getCommand();
            if (!new File(c).isFile()) continue;
            cmds.add(c);
        }
        return cmds;
    }

    public static String getDefaultArgumentForBrowserCommand(String cmd) {
        if (cmd == null || cmd.equals("")) {
            return null;
        }
        List browsers = UIBrowser.getDefaultPlatformBrowsers();
        Iterator i = browsers.iterator();
        while (i.hasNext()) {
            Browser b = (Browser)i.next();
            String c = b.getCommand();
            if (!c.equals(cmd)) continue;
            return b.getArguments();
        }
        if (cmd.indexOf("netscape") > 0) {
            return DT.getOS() == 4 ? NETSCAPE_WIN_ARG : NETSCAPE_UNIX_ARG;
        }
        if (cmd.indexOf("iexplore") > 0) {
            return "$";
        }
        return "$";
    }

    private static String[] _getOpenCommand(URL url) {
        Object[] cv = UIConfig.getConfigArray("ui.browser.openUrlCommand", null);
        if (cv == null || cv.length <= 0 || !(cv instanceof String[])) {
            return null;
        }
        String[] c = (String[])cv;
        boolean foundURL = false;
        String urlStr = url.toString();
        for (int i = 1; i < c.length; ++i) {
            int u = c[i].indexOf("$");
            if (u < 0) continue;
            c[i] = c[i].substring(0, u) + urlStr + c[i].substring(u + 1);
            foundURL = true;
        }
        if (!foundURL) {
            String[] ca = new String[c.length + 1];
            System.arraycopy(c, 0, ca, 0, c.length);
            ca[c.length] = urlStr;
            c = ca;
        }
        return c;
    }

    public static boolean isBrowserCommandDefined() {
        return UIConfig.getConfigValue("ui.browser.openUrlCommand", null) != null;
    }

    public static boolean viewURL(String urlStr) {
        if (urlStr == null || urlStr.equals("")) {
            UIOptionPane.showErrorDialog(DT.getApplicationFrame(), NO_URL);
            return false;
        }
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException mue) {
            UIOptionPane.showErrorDialog(DT.getApplicationFrame(), UIBrowser.INVALID_URL(urlStr));
            return false;
        }
        if (UIBrowser._is_MacOS()) {
            return UIBrowser._viewURL_MacOS(url.toString());
        }
        String[] cmdArg = UIBrowser._getOpenCommand(url);
        if (cmdArg == null) {
            UIOptionPane.showErrorDialog(DT.getApplicationFrame(), NO_COMMAND);
            return false;
        }
        ExecProcess ep = new ExecProcess(cmdArg);
        try {
            ep.execCommand(-1);
            return true;
        }
        catch (ExecProcess.NoCommand nc) {
            Print.dprintln((String)nc.toString());
            UIOptionPane.showErrorDialog(DT.getApplicationFrame(), NO_COMMAND);
        }
        catch (ExecProcess.NonExistantCommand nec) {
            Print.dprintln((String)nec.toString());
            UIOptionPane.showErrorDialog(DT.getApplicationFrame(), UIBrowser.INVALID_COMMAND(ep.toString()));
        }
        catch (ExecProcess.NotAbsoluteCommand nac) {
            Print.dprintln((String)nac.toString());
            UIOptionPane.showErrorDialog(DT.getApplicationFrame(), UIBrowser.INVALID_COMMAND(ep.toString()));
        }
        catch (ExecProcess.ErrorExecutingCommand eec) {
            Print.dprintln((String)eec.toString());
            UIOptionPane.showErrorDialog(DT.getApplicationFrame(), UIBrowser.INVALID_COMMAND(ep.toString()));
        }
        return false;
    }

    private static boolean _is_MacOS() {
        return DT.getOS() == 3;
    }

    private static boolean _viewURL_MacOS(String urlStr) {
        try {
            String macVers = System.getProperty("os.version");
            int macMajorVers = Integer.parseInt(macVers.substring(0, macVers.indexOf(46)));
            if (macMajorVers < 10) {
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("com.apple.mrj.MRJFileUtils");
            Method method = clazz.getMethod("openURL", String.class);
            method.invoke(null, urlStr);
            return true;
        }
        catch (Exception e) {
            Print.dprintStackTrace((String)("MacOS X open URL failed: " + e));
            return false;
        }
    }

    public static class Browser {
        private String command = null;
        private String args = null;

        public Browser(String cmd, String arg) {
            this.command = cmd;
            this.args = arg;
        }

        public String getCommand() {
            return this.command;
        }

        public String getArguments() {
            return this.args;
        }
    }
}

