/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.util.Print;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class PortDetector {
    public static byte[] TEST_QUERY = new byte[]{22, 3, 0, 0, 83, 1, 0, 0, 79, 3, 0, 63, 71, -41, -9, -70, 44, -18, -22, -78, 96, 126, -13, 0, -3, -126, 123, -71, -43, -106, -56, 119, -101, -26, -60, -37, 60, 61, -37, 111, -17, 16, 110, 0, 0, 40, 0, 22, 0, 19, 0, 10, 0, 102, 0, 5, 0, 4, 0, 101, 0, 100, 0, 99, 0, 98, 0, 97, 0, 96, 0, 21, 0, 18, 0, 9, 0, 20, 0, 17, 0, 8, 0, 6, 0, 3, 1, 0, 71, 69, 84, 32, 47, 32, 72, 84, 84, 80, 47, 49, 46, 48, 10, 10};

    public static boolean isSecurePort(String hostname, int port) throws IOException, ConnectException, SocketTimeoutException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(hostname, port), 4000);
        OutputStream ostream = socket.getOutputStream();
        ostream.write(TEST_QUERY);
        InputStream istream = socket.getInputStream();
        for (int count = 0; count < 20; ++count) {
            try {
                if (istream.available() > 0) break;
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        byte[] input = new byte[istream.available()];
        int len = istream.read(input);
        socket.close();
        String response = new String(input).toLowerCase();
        boolean isSecure = true;
        if (response.length() == 0) {
            isSecure = false;
        } else if (response.startsWith("http/1.")) {
            isSecure = false;
        } else if (response.indexOf("<html") != -1) {
            isSecure = false;
        } else if (response.indexOf("connection: ") != -1) {
            isSecure = false;
        }
        return isSecure;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            Print.println((String)"Usage:");
            Print.println((String)"\tjava PortDetector <hostname> <port #>");
            System.exit(2);
        }
        try {
            if (PortDetector.isSecurePort(args[0], Integer.parseInt(args[1]))) {
                Print.println((String)"Port is secure");
            } else {
                Print.println((String)"Port is NOT secure");
            }
        }
        catch (NumberFormatException ex) {
            Print.println((String)("Port '" + args[1] + "' is not a valid port #!"));
        }
        catch (SocketTimeoutException ex) {
            Print.println((String)"Connect timeout.");
        }
        catch (ConnectException ex) {
            Print.println((String)"Unable to connect.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

