/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class FileTools {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(FileTools.class);
    private static String NO_OVRWRT_DIRECTORY = localStrings.getLocalString("ui.filetools.cant_overwrite_directory", "Please provide the name of the module to be created.");
    public static final String ClassSeparator = ".";
    public static final char ClassSeparatorChar = '.';
    public static final String ArchSeparator = "/";
    public static final char ArchSeparatorChar = '/';
    public static final String FileSeparator = File.separator;
    public static final char FileSeparatorChar = File.separatorChar;
    private static final boolean IsDosFileSeparator = FileSeparatorChar == '\\';
    private static final char[] ILLEGAL_FILENAME_CHARS = "/\\:*?'\"<>|,!@#$%^&()+=~`;{}[]".toCharArray();

    private static String NO_DELETE_DIRECTORY(Object v0) {
        return localStrings.getLocalString("ui.filetools.wont_delete_directory", "{0}\nDirectory deletion not allow here.", new Object[]{v0});
    }

    private static String UNABLE_TO_DELETE_FILE(Object v0) {
        return localStrings.getLocalString("ui.filetools.unable_to_delete_file", "{0}\nUnable to delete specified file.", new Object[]{v0});
    }

    private static String INVALID_PARENT(Object v0) {
        return localStrings.getLocalString("ui.filetools.parent_is_invalid", "{0}\nParent directory does not exist, or is read-only.", new Object[]{v0});
    }

    private static String ALREADY_EXISTS(Object v0) {
        return localStrings.getLocalString("ui.filetools.already_exists", "{0}\nThis file already exists, do you wish to overwrite?", new Object[]{v0});
    }

    private static String INVALID_FILENAME(Object v0) {
        return localStrings.getLocalString("ui.filetools.filename_is_invalid", "{0}\nFilename contains invalid characters.", new Object[]{v0});
    }

    public static File deleteOnExit(File file) {
        return FileUtil.deleteOnExit((File)file);
    }

    public static boolean deleteFile(Component owner, File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            if (!file.delete()) {
                UIOptionPane.showErrorDialog(owner, FileTools.UNABLE_TO_DELETE_FILE(file));
                return false;
            }
            return true;
        }
        UIOptionPane.showErrorDialog(owner, FileTools.NO_DELETE_DIRECTORY(file));
        return false;
    }

    public static byte[] readFile(File inFile) throws IOException {
        FileInputStream in = new FileInputStream(inFile);
        byte[] data = FileTools.readInputStream(in);
        in.close();
        return data;
    }

    public static byte[] readInputStream(InputStream in) throws IOException {
        int cnt;
        byte[] buf = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((cnt = in.read(buf)) >= 0) {
            out.write(buf, 0, cnt);
        }
        return out.toByteArray();
    }

    public static void copyFiles(File fromFile, File toFile) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(fromFile));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(toFile));
        FileTools.copyStreams(in, out);
        in.close();
        out.close();
    }

    public static void copyStreams(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[1024];
        int len = 0;
        while (len != -1) {
            try {
                len = is.read(buf, 0, buf.length);
            }
            catch (EOFException eof) {
                break;
            }
            if (len == -1) continue;
            os.write(buf, 0, len);
        }
    }

    public static boolean checkFileOverwrite(Component owner, String filename) {
        return FileTools.checkFileOverwrite(owner, new File(filename));
    }

    public static boolean checkFileOverwrite(Component owner, File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            UIOptionPane.showErrorDialog(owner, NO_OVRWRT_DIRECTORY);
            return false;
        }
        File parent = file.getAbsoluteFile().getParentFile();
        if (!parent.isDirectory() || !parent.canWrite()) {
            UIOptionPane.showErrorDialog(owner, FileTools.INVALID_PARENT(parent));
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        return UIOptionPane.showConfirmDialog(owner, FileTools.ALREADY_EXISTS(file));
    }

    public static boolean CheckFileName(String n, boolean dotOK) {
        String path;
        if (!dotOK && n.indexOf(46) <= 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(n, FileSeparator);
        boolean exists = true;
        String string = path = n.startsWith(FileSeparator) ? FileSeparator : "";
        while (st.hasMoreTokens()) {
            String p = st.nextToken();
            if (exists) {
                path = path + p;
                exists = new File(path).exists();
                path = path + FileSeparator;
                if (exists) continue;
            }
            if (p.equals("") || !Character.isLetter(p.charAt(0))) {
                return false;
            }
            for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
                if (p.indexOf(ILLEGAL_FILENAME_CHARS[i]) < 0) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean validateFileName(Component owner, String fn) {
        if (!FileTools.CheckFileName(fn, true)) {
            UIOptionPane.showErrorDialog(owner, FileTools.INVALID_FILENAME(fn));
            return false;
        }
        return true;
    }

    public static String GetFileExtension(File f) {
        String fn = FileTools.GetFileName(f);
        int p = fn.lastIndexOf(ClassSeparator);
        return p >= 0 ? fn.substring(p + 1) : "";
    }

    public static String GetFileExtension(String n) {
        String fn = FileTools.GetFileName(n);
        int p = fn.lastIndexOf(ClassSeparator);
        return p >= 0 ? fn.substring(p + 1) : "";
    }

    public static String GetFileName(File f) {
        return f != null ? f.getName() : "";
    }

    public static String GetFileName(String n) {
        return FileTools.GetFileName(n, true);
    }

    public static String GetFileName(File f, boolean inclExtn) {
        return f != null ? FileTools.GetFileName(f.getAbsolutePath(), inclExtn) : "";
    }

    public static String GetFileName(String n, boolean inclExtn) {
        String name;
        if (n == null) {
            return "";
        }
        String a = FileTools.ToArchSep(n);
        int p = a.lastIndexOf(ArchSeparator);
        String string = name = p >= 0 ? a.substring(p + 1) : a;
        if (inclExtn) {
            return name;
        }
        int d = name.lastIndexOf(ClassSeparator);
        return d >= 0 ? name.substring(0, d) : name;
    }

    public static String GetParent(File f) {
        return f != null ? f.getParent() : "";
    }

    public static String GetParent(String n) {
        return n != null ? FileTools.GetParent(new File(n)) : "";
    }

    public static String CreateFileName(String basePath, String ext) {
        String b = basePath != null ? basePath : "";
        String e = ext != null ? ext : "";
        return !b.endsWith(e) ? FileTools.GetParent(b) + File.separator + FileTools.GetFileName(b, false) + e : b;
    }

    public static String CreateFileName(File base, String ext) {
        return FileTools.CreateFileName(base != null ? base.getAbsolutePath() : null, ext);
    }

    public static String ToArchSep(String n) {
        return n.replace(FileSeparatorChar, '/');
    }

    public static String ToFileSep(String n) {
        return n.replace('/', FileSeparatorChar);
    }

    public static boolean StrFileStartsWith(String target, String test) {
        if (target == null || test == null) {
            return false;
        }
        return !IsDosFileSeparator ? target.startsWith(test) : target.toLowerCase().startsWith(test.toLowerCase());
    }

    public static boolean StrFileStartsWith(String target, String[] test) {
        if (target == null || test == null) {
            return false;
        }
        for (int i = 0; i < test.length; ++i) {
            if (!FileTools.StrFileStartsWith(target, test[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean StrFileEndsWith(String target, String test) {
        if (target == null || test == null) {
            return false;
        }
        return !IsDosFileSeparator ? target.endsWith(test) : target.toLowerCase().endsWith(test.toLowerCase());
    }

    public static boolean StrFileEndsWith(String target, String[] test) {
        if (target == null || test == null) {
            return false;
        }
        for (int i = 0; i < test.length; ++i) {
            if (!FileTools.StrFileEndsWith(target, test[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean StrFileHasExtension(String target, String ext) {
        if (target == null || ext == null) {
            return false;
        }
        if (!ext.startsWith(ClassSeparator)) {
            ext = ClassSeparator + ext;
        }
        return target.toLowerCase().endsWith(ext.toLowerCase());
    }

    public static boolean StrFileHasExtension(String target, String[] ext) {
        if (target == null || ext == null) {
            return false;
        }
        for (int i = 0; i < ext.length; ++i) {
            if (!FileTools.StrFileHasExtension(target, ext[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean StrFileEquals(String target, String test) {
        if (target == null || test == null) {
            return false;
        }
        return !IsDosFileSeparator ? target.equals(test) : target.equalsIgnoreCase(test);
    }

    public static List getFilesWithExtension(List fileList, String ext) {
        return FileTools.getFilesWithExtension(fileList.iterator(), ext);
    }

    public static List getFilesWithExtension(Enumeration fileEnum, String ext) {
        return FileTools.getFilesWithExtension(ListTools.toIterator(fileEnum), ext);
    }

    public static List getFilesWithExtension(Iterator fileIter, String ext) {
        if (!ext.startsWith(ClassSeparator)) {
            ext = ClassSeparator + ext;
        }
        Vector list = new Vector();
        while (fileIter.hasNext()) {
            Object f = fileIter.next();
            if (!FileTools.StrFileEndsWith(f.toString(), ext)) continue;
            list.add(f);
        }
        return list;
    }
}

