/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorInspector;
import com.sun.enterprise.tools.deployment.ui.sunone.CacheInspector;
import com.sun.enterprise.tools.deployment.ui.sunone.JspInspector;
import com.sun.enterprise.tools.deployment.ui.sunone.LocaleInspector;
import com.sun.enterprise.tools.deployment.ui.sunone.MappingInspector;
import com.sun.enterprise.tools.deployment.ui.sunone.ServletInspector;
import com.sun.enterprise.tools.deployment.ui.sunone.SessionInspector;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JLabel;

public class SunONESettingsDialog
extends UIDialog
implements DescriptorInspector,
InspectorPane.InspectorPaneDialogInferface,
InspectorPane.InspectorPaneOwner,
DescriptionInspector.DescriptionInspectorManager {
    private static final String DEFAULT_HELP_ID = "S1SettingsDialog";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SunONESettingsDialog.class);
    private final String SUNONE_SETTINGS_TITLE = localStrings.getLocalString("ui.sunone.sunonesettingsdialog.title", "Sun-specific Settings");
    private DescriptionInspector descriptionInspector = null;
    private String defaultSelection = null;
    private HashMap panelMap = null;
    private Vector panelOrder = null;
    private Vector panelDisabled = null;
    private Descriptor descriptor = null;
    private UITitledComboBox panelSelector = null;
    private UITitledBox panelContainer = null;
    private Component currentPanel = null;
    private UIHelpButton helpBtn = null;
    private InspectorPane.InspectorPaneOwner delegateOwner = null;

    private String SUNONE_INIT_ERROR(Object v0) {
        return localStrings.getLocalString("ui.sunone.sunonesettingsdialog.init_error", "Error encountered while initializing.\n {0}", new Object[]{v0});
    }

    private String SUNONE_REFRESH_ERROR(Object v0) {
        return localStrings.getLocalString("ui.sunone.sunonesettingsdialog.refresh_error", "Error encountered while updating panel.\n {0}", new Object[]{v0});
    }

    public SunONESettingsDialog(Frame frame) {
        super(frame, true);
        this._initLayout();
    }

    public SunONESettingsDialog(Dialog dialog) {
        super(dialog, true);
        this._initLayout();
    }

    private void _initLayout() {
        this.setTitle(this.SUNONE_SETTINGS_TITLE);
        UIControlButtonBox control = new UIControlButtonBox(null, false);
        control.setControlButtonLocation(101);
        this.setContentBox(control);
        UITitledBox contents = new UITitledBox(null, false);
        control.setView(contents);
        GridBagConstraints gbc = contents.getGBConstraints();
        this.descriptionInspector = new DescriptionInspector(this);
        JLabel viewLabel = new JLabel(localStrings.getLocalString("ui.sunone.sunonesettingsdialog.view", "View:"));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        contents.add((Component)viewLabel, gbc);
        this.panelSelector = new UITitledComboBox(null, false);
        this.panelSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (SunONESettingsDialog.this.validateCurrentPanel(true)) {
                    SunONESettingsDialog.this.refreshPanelSelection(false);
                } else {
                    SunONESettingsDialog.this.panelSelector.setSelectedItem(SunONESettingsDialog.this.panelContainer.getTitle());
                }
            }
        });
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        contents.add((Component)this.panelSelector, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        contents.add((Component)new UIPanel(), gbc);
        this.panelContainer = new UITitledBox("", true);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 5, 5, 5);
        contents.add((Component)this.panelContainer, gbc);
        GridBagConstraints pgbc = this.panelContainer.getGBConstraints();
        pgbc.gridx = 0;
        pgbc.gridy = 0;
        pgbc.gridwidth = 1;
        pgbc.gridheight = 1;
        pgbc.weightx = 0.5;
        pgbc.weighty = 0.5;
        pgbc.fill = 1;
        UIButton closeBtn = UIButton.createCloseButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SunONESettingsDialog.this.validateCurrentPanel(true)) {
                    SunONESettingsDialog.this.hide();
                }
            }
        });
        control.addControlButton(closeBtn);
        this.helpBtn = new UIHelpButton(DEFAULT_HELP_ID);
        control.addControlButton(this.helpBtn);
        this.setSize(700, 700);
        this.setLocationRelativeTo(this.getOwner());
        this.panelMap = new HashMap();
        this.panelOrder = new Vector();
        this.panelDisabled = new Vector();
    }

    public DescriptionInspector getDescriptionInspector() {
        return this.descriptionInspector;
    }

    public void setDelegateOwner(InspectorPane.InspectorPaneOwner owner) {
        this.delegateOwner = owner;
        if (this.delegateOwner == null) {
            Print.dprintStackTrace((String)"'delegateOwner' is null (HELP won't work)");
        }
    }

    public Vector getArchiveContents() {
        return this.delegateOwner != null ? this.delegateOwner.getArchiveContents() : null;
    }

    public Vector getArchiveClasses() {
        return this.getArchiveClasses(false);
    }

    public Vector getArchiveClasses(boolean inApplication) {
        return this.delegateOwner != null ? this.delegateOwner.getArchiveClasses(inApplication) : null;
    }

    public String getHelpGroup() {
        if (this.delegateOwner != null) {
            return this.delegateOwner.getHelpGroup();
        }
        Print.dprintStackTrace((String)"HelpGroup is not defined");
        return "??";
    }

    public boolean isCurrentInspectorPane(InspectorPane pane) {
        return pane == this.currentPanel;
    }

    protected void _addPanel(String title, Component insp) {
        if (this.panelMap.isEmpty()) {
            this.defaultSelection = title;
        }
        this.panelMap.put(title, insp);
        this.panelOrder.add(title);
    }

    public void addPanel(InspectorPane ownerInsp, InspectorPane settingsInsp) {
        this.addPanel(ownerInsp != null ? ownerInsp.getOwner() : null, settingsInsp);
    }

    public void addPanel(InspectorPane.InspectorPaneOwner inspOwner, InspectorPane settingsInsp) {
        if (inspOwner != null) {
            this.setDelegateOwner(inspOwner);
            settingsInsp.setOwner(this);
        }
        this._addPanel(settingsInsp.getTabName(), settingsInsp);
    }

    public void setPanelEnabled(String title, boolean enabled) {
        if (this.panelOrder.contains(title)) {
            if (enabled) {
                this.panelDisabled.remove(title);
            } else if (!this.panelDisabled.contains(title)) {
                this.panelDisabled.add(title);
            }
        }
    }

    public void setPanelEnabled(InspectorPane settingsInsp, boolean enabled) {
        this.setPanelEnabled(settingsInsp.getTabName(), enabled);
    }

    public void setAllPanelsEnabled() {
        this.panelDisabled.clear();
    }

    public Class getDescriptorClass() {
        return Descriptor.class;
    }

    public void setDescriptor(Descriptor d) {
        if (this.descriptor != d) {
            this.descriptor = d;
            if (this.currentPanel instanceof DescriptorInspector) {
                try {
                    ((DescriptorInspector)((Object)this.currentPanel)).setDescriptor(this.descriptor);
                }
                catch (Throwable t) {
                    Print.dprintStackTrace((String)"Setting deployment settings descriptor", (Throwable)t);
                    UIOptionPane.showErrorDialog(this, this.SUNONE_INIT_ERROR(t));
                }
            }
        }
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void show(Descriptor d, String dftSel) {
        this.setDescriptor(d);
        this.refreshPanelSelector();
        String dft = this.panelSelector.containsItem(dftSel) ? dftSel : this.defaultSelection;
        this.panelSelector.setSelectedItem(dft, false);
        this.refreshPanelSelection(false);
        DT.setSunOneSettingsDialog(this);
        super.show();
        this.toFront();
    }

    public void show() {
        Print.dprintStackTrace((String)"Use 'show(Descriptor, String)' instead");
        DT.setSunOneSettingsDialog(this);
        super.show();
    }

    public void hide() {
        this.validateCurrentPanel(false);
        this.refreshPanelSelection(true);
        DT.setSunOneSettingsDialog(null);
        super.hide();
    }

    protected void refreshPanelSelector() {
        Vector model = new Vector(this.panelOrder);
        model.removeAll(this.panelDisabled);
        this.defaultSelection = model.size() > 0 ? model.get(0).toString() : null;
        this.panelSelector.setModel(model);
    }

    protected void refreshPanelSelection(boolean clear) {
        Component comp;
        String title = clear ? null : (String)this.panelSelector.getSelectedItem();
        Component component = comp = clear ? null : (Component)this.panelMap.get(title);
        if (this.currentPanel != comp) {
            if (this.currentPanel != null) {
                this.panelContainer.remove(this.currentPanel);
                if (this.currentPanel instanceof DescriptorInspector) {
                    ((DescriptorInspector)((Object)this.currentPanel)).setDescriptor(null);
                }
            }
            this.currentPanel = comp;
            if (this.currentPanel != null) {
                this.panelContainer.addWithGBConstraints(this.currentPanel);
                if (this.currentPanel instanceof InspectorPane) {
                    this.helpBtn.setHelpID(((InspectorPane)this.currentPanel).getHelpIDKey());
                } else {
                    this.helpBtn.setHelpID(DEFAULT_HELP_ID);
                }
            }
            this.panelContainer.setTitle(title);
            this.invalidate();
            this.validate();
            this.panelContainer.repaint();
        }
        if (this.currentPanel instanceof DescriptorInspector) {
            DescriptorInspector insp = (DescriptorInspector)((Object)this.currentPanel);
            if (this.descriptor == null) {
                Print.dprintln((String)("Assigning 'null' Descriptor to inspector: " + title));
                insp.setDescriptor(null);
            } else {
                Class<?> descClass;
                Class inspClass = insp.getDescriptorClass();
                if (inspClass.isAssignableFrom(descClass = this.descriptor.getClass())) {
                    try {
                        insp.setDescriptor(this.descriptor);
                    }
                    catch (Throwable t) {
                        Print.dprintStackTrace((String)"Setting deployment settings descriptor", (Throwable)t);
                        UIOptionPane.showErrorDialog(this, this.SUNONE_INIT_ERROR(t));
                    }
                } else {
                    Print.dprintln((String)(DT.className(insp) + " doesn't support " + DT.className(descClass)));
                }
            }
            if (this.currentPanel instanceof InspectorPane) {
                try {
                    ((InspectorPane)this.currentPanel).invokeRefresh();
                }
                catch (Throwable t) {
                    Print.dprintStackTrace((String)"Refreshing deployment settings panel", (Throwable)t);
                    UIOptionPane.showErrorDialog(this, this.SUNONE_REFRESH_ERROR(t));
                }
            } else {
                Print.dprintln((String)("Unable to force refresh on " + DT.className(this.currentPanel)));
            }
        }
    }

    protected boolean validateCurrentPanel(boolean showErrors) {
        if (this.currentPanel instanceof InspectorPane) {
            boolean rtn = ((InspectorPane)this.currentPanel).validateEntries(showErrors);
            return rtn;
        }
        return true;
    }

    public static void main(String[] argv) {
        UIConfig.setDebugMode(true);
        SunONESettingsDialog d = new SunONESettingsDialog((Frame)null);
        String mode = "DeploymentMode";
        d.addPanel((InspectorPane)null, CacheInspector.newInspectorPane(mode));
        d.addPanel((InspectorPane)null, MappingInspector.newInspectorPane(mode));
        d.addPanel((InspectorPane)null, JspInspector.newInspectorPane(mode));
        d.addPanel((InspectorPane)null, LocaleInspector.newInspectorPane(mode));
        d.addPanel((InspectorPane)null, ServletInspector.newInspectorPane(mode));
        d.addPanel((InspectorPane)null, SessionInspector.newInspectorPane(mode));
        d.show(null, null);
    }
}

