/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.common.dd.webapp.CookieProperties;
import com.sun.enterprise.tools.common.dd.webapp.ManagerProperties;
import com.sun.enterprise.tools.common.dd.webapp.MetaData;
import com.sun.enterprise.tools.common.dd.webapp.SessionConfig;
import com.sun.enterprise.tools.common.dd.webapp.SessionManager;
import com.sun.enterprise.tools.common.dd.webapp.SessionProperties;
import com.sun.enterprise.tools.common.dd.webapp.StoreProperties;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.common.dd.webapp.WebProperty;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.sunone.WebPropertyTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.table.TableCellEditor;

public class SessionInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SessionInspector.class);
    private final String LABEL_NAME = localStrings.getLocalString("ui.sunone.sessioninspector.label_name", "Persistence Label");
    private final String LABEL_DESC = localStrings.getLocalString("ui.sunone.sessioninspector.label_desc", "This is a label for persistence options");
    private final String STORE_TOOLTIP = localStrings.getLocalString("ui.sunone.sessioninspector.store.tooltip", "Store Properties for Session Manager");
    private final String STORE_TITLE = localStrings.getLocalString("ui.sunone.sessioninspector.store.title", "Store Properties");
    private final String MANAGER_TOOLTIP = localStrings.getLocalString("ui.sunone.sessioninspector.manager.tooltip", "Manager Properties for Session Manager");
    private final String MANAGER_TITLE = localStrings.getLocalString("ui.sunone.sessioninspector.manager_title", "Session Manager Properties");
    private final String PROPERTIES_TOOLTIP = localStrings.getLocalString("ui.sunone.sessioninspector.properties.tooltip", "Session Properties for Session Config");
    private final String PROPERTIES_TITLE = localStrings.getLocalString("ui.sunone.sessioninspector.properties_title", "Session Properties");
    private final String COOKIE_TOOLTIP = localStrings.getLocalString("ui.sunone.sessioninspector.cookie.tooltip", "Cookie Properties for Session Config");
    private final String COOKIE_TITLE = localStrings.getLocalString("ui.sunone.sessioninspector.cookie.title", "Cookie Properties");
    private final String TABNAME = localStrings.getLocalString("ui.sunone.sessioninspector.Tab", "Session");
    private final String PERSIST_TYPE = localStrings.getLocalString("ui.sunone.sessioninspector.persistence.type", "Persistence Type");
    private final String PERSIST_TYPE_ACC_DSC = localStrings.getLocalString("ui.sunone.sessioninspector.Persistence_type_acc_dsc", "Choose Persistence Type for the Web Application");
    private final String MISSING_MANAGER_VALUE = localStrings.getLocalString("ui.sunone.sessioninspector.missing_manager_value", "All Manager properties must have a 'value'");
    private final String MISSING_STORE_VALUE = localStrings.getLocalString("ui.sunone.sessioninspector.Missing_store_value", "All Store properties must have a 'value'");
    private final String MISSING_COOKIE_VALUE = localStrings.getLocalString("ui.sunone.sessioninspector.Missing_cookie_value", "All Cookie properties must have a 'value'");
    private final String CLASS_NAME_REQUIRED = localStrings.getLocalString("ui.sunone.sessioninspector.classname_required", "className is required for Session Manager Property");
    private final String SESSION_FILE_NAME_NOT_REQUIRED_CHECK = localStrings.getLocalString("ui.sunone.sessioninspector.sessionFilename_not_required_check", "sessionFileName should not be specified in Manager Properties for Persistence Types custom and file.\n Please delete the entry.");
    private final String SESSION_FILE_NAME_NOT_REQUIRED = localStrings.getLocalString("ui.sunone.sessioninspector.sessionFilename_not_required", "sessionFileName should not be specified in Manager Properties for Persistence Types custom and file.\n Entry will be removed from Manager Properties if you continue.");
    private final String TYPE_CHANGE_ERROR = localStrings.getLocalString("ui.sunone.sessioninspector.type_change_error", "Persistence Type Change - Mismatch in Properties");
    private final String ATR_NAME = "name";
    private final String ATR_VALUE = "value";
    private final String CUSTOM = "custom";
    private final String CLASSNAME = "className";
    private final String MEMORY = "memory";
    private final String SESSIONFILENAME = "sessionFilename";
    private final String TRUE = "true";
    private final String FALSE = "false";
    private SessionConfig sc;
    private SessionManager sManager;
    private ManagerProperties managerProp;
    private StoreProperties storeProp;
    private SessionProperties sessionProp;
    private CookieProperties cookieProp;
    private static String wizardHelpID = "SessionRef";
    private static String deployHelpID = "SessionRef";
    private WebBundleDescriptor descriptor = null;
    private ManagerTable managerTable = null;
    private StoreTable storeTable = null;
    private SessionTable sessionTable = null;
    private CookieTable cookieTable = null;
    private JButton btnAddManager = null;
    private JButton btnAddStore = null;
    private JButton btnAddSession = null;
    private JButton btnAddCookie = null;
    private UITitledComboBox typeBox = null;
    private JLabel persistType = null;
    private static Vector managerParamName = ListTools.toList(MetaData.getParamNames((int)6));
    private static Vector managerParamNameAll = ListTools.toList(MetaData.getParamNames((int)6));
    private static Vector managerParamNameOther = ListTools.toList(MetaData.getParamNames((int)6));
    private static Vector storeParamName = ListTools.toList(MetaData.getParamNames((int)3));
    private static Vector sessionParamName = ListTools.toList(MetaData.getParamNames((int)2));
    private static Vector cookieParamName = ListTools.toList(MetaData.getParamNames((int)5));

    public static InspectorPane newInspectorPane(String mode) {
        return new SessionInspector(mode);
    }

    public String getTabName() {
        return this.TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : null;
            this.managerTable.clearTableData();
            this.storeTable.clearTableData();
            this.sessionTable.clearTableData();
            this.cookieTable.clearTableData();
            if (this.descriptor != null) {
                this.initializeSession((SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor));
                ((WebPropertyTableModel)this.managerTable.getModel()).setDescriptor(this.descriptor);
                ((WebPropertyTableModel)this.storeTable.getModel()).setDescriptor(this.descriptor);
                ((WebPropertyTableModel)this.sessionTable.getModel()).setDescriptor(this.descriptor);
                ((WebPropertyTableModel)this.cookieTable.getModel()).setDescriptor(this.descriptor);
            }
        }
    }

    private void initializeSession(SunWebApp swa) {
        if (swa == null) {
            return;
        }
        this.sc = swa.getSessionConfig();
        if (this.sc == null) {
            this.sc = new SessionConfig();
            swa.setSessionConfig(this.sc);
        }
        this.sManager = this.sc.getSessionManager();
        if (this.sManager == null) {
            this.sManager = new SessionManager();
            this.sc.setSessionManager(this.sManager);
        }
        this.managerProp = this.sManager.getManagerProperties();
        if (this.managerProp == null) {
            this.managerProp = new ManagerProperties();
            this.sManager.setManagerProperties(this.managerProp);
        }
        this.storeProp = this.sManager.getStoreProperties();
        if (this.storeProp == null) {
            this.storeProp = new StoreProperties();
            this.sManager.setStoreProperties(this.storeProp);
        }
        this.sessionProp = this.sc.getSessionProperties();
        if (this.sessionProp == null) {
            this.sessionProp = new SessionProperties();
            this.sc.setSessionProperties(this.sessionProp);
        }
        this.cookieProp = this.sc.getCookieProperties();
        if (this.cookieProp == null) {
            this.cookieProp = new CookieProperties();
            this.sc.setCookieProperties(this.cookieProp);
        }
    }

    private SessionInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
        this.initializeAccessibility();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 15, 5, 5);
        c.anchor = 13;
        this.persistType = new JLabel(this.PERSIST_TYPE);
        this.persistType.getAccessibleContext().setAccessibleName(this.LABEL_NAME);
        this.persistType.getAccessibleContext().setAccessibleDescription(this.LABEL_DESC);
        this.add((Component)this.persistType, c);
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 1;
        c.anchor = 17;
        this.typeBox = this.createPersistenceComboBox();
        this.add((Component)this.typeBox, c);
        this.persistType.setLabelFor(this.typeBox);
        UITitledTable pnlManager = new UITitledTable(this.MANAGER_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)pnlManager, c);
        this.managerTable = new ManagerTable(new WebPropertyTableModel(this.descriptor, 6));
        pnlManager.setTableView(this.managerTable);
        this.btnAddManager = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SessionInspector.this.addManagerAction();
            }
        });
        pnlManager.addControlButton(this.btnAddManager);
        UIButton btnDeleteManager = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SessionInspector.this.deleteManagerAction();
            }
        });
        pnlManager.addSelectionEnabledButton(btnDeleteManager);
        UITitledTable pnlStore = new UITitledTable(this.STORE_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)pnlStore, c);
        this.storeTable = new StoreTable(new WebPropertyTableModel(this.descriptor, 3));
        pnlStore.setTableView(this.storeTable);
        this.btnAddStore = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SessionInspector.this.addStoreAction();
            }
        });
        pnlStore.addControlButton(this.btnAddStore);
        UIButton btnDeleteStore = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SessionInspector.this.deleteStoreAction();
            }
        });
        pnlStore.addSelectionEnabledButton(btnDeleteStore);
        UITitledTable pnlProperties = new UITitledTable(this.PROPERTIES_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)pnlProperties, c);
        this.sessionTable = new SessionTable(new WebPropertyTableModel(this.descriptor, 2));
        pnlProperties.setTableView(this.sessionTable);
        this.btnAddSession = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SessionInspector.this.addSessionAction();
            }
        });
        pnlProperties.addControlButton(this.btnAddSession);
        UIButton btnDeleteSession = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SessionInspector.this.deleteSessionAction();
            }
        });
        pnlProperties.addSelectionEnabledButton(btnDeleteSession);
        UITitledTable pnlCookie = new UITitledTable(this.COOKIE_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)pnlCookie, c);
        this.cookieTable = new CookieTable(new WebPropertyTableModel(this.descriptor, 5));
        pnlCookie.setTableView(this.cookieTable);
        this.btnAddCookie = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SessionInspector.this.addCookieAction();
            }
        });
        pnlCookie.addControlButton(this.btnAddCookie);
        UIButton btnDeleteCookie = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SessionInspector.this.deleteCookieAction();
            }
        });
        pnlCookie.addSelectionEnabledButton(btnDeleteCookie);
    }

    private void initializeAccessibility() {
        this.persistType.getAccessibleContext().setAccessibleDescription(this.PERSIST_TYPE_ACC_DSC);
    }

    private UITitledComboBox createPersistenceComboBox() {
        String[] pParam = MetaData.getParamNames((int)7);
        Object[] values = MetaData.getParamValues((int)7, (String)pParam[0]);
        UITitledComboBox cb = new UITitledComboBox(null, false);
        cb.setModel(values);
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (SessionInspector.this.typeBox.isSetSelectionUpdate()) {
                    return;
                }
                String type = (String)SessionInspector.this.typeBox.getSelectedItem();
                if (!type.equals(SessionInspector.this.sManager.getAttributeValue("PersistenceType"))) {
                    if (!type.equals("memory")) {
                        if (SessionInspector.this.checkSessionManager()) {
                            SessionInspector.this.sManager.setAttributeValue("PersistenceType", type);
                        } else {
                            SessionInspector.this.typeBox.setSelectedItem(SessionInspector.this.sManager.getAttributeValue("PersistenceType"));
                        }
                    } else {
                        SessionInspector.this.sManager.setAttributeValue("PersistenceType", type);
                    }
                    SessionInspector.this.descriptor.changed();
                }
            }
        });
        return cb;
    }

    public void refresh() {
        this.managerTable.updateTableData(this.managerProp.getWebProperty());
        this.storeTable.updateTableData(this.storeProp.getWebProperty());
        this.sessionTable.updateTableData(this.sessionProp.getWebProperty());
        this.cookieTable.updateTableData(this.cookieProp.getWebProperty());
        String selected = this.sManager.getAttributeValue("PersistenceType");
        if (selected != null && !selected.equals("")) {
            this.typeBox.setSelectedItem(selected);
        }
    }

    public boolean validateEntries(boolean showErrors) {
        String type = this.sManager.getAttributeValue("PersistenceType");
        boolean valid = false;
        if ("custom".equals(type)) {
            WebProperty[] wpa = this.managerProp.getWebProperty();
            if (wpa == null) {
                valid = false;
            } else {
                for (int i = 0; i < wpa.length; ++i) {
                    WebProperty wp = wpa[i];
                    String pName = wp.getAttributeValue("name");
                    if (!"className".equals(pName)) continue;
                    valid = true;
                    break;
                }
            }
            if (!valid) {
                if (showErrors) {
                    UIOptionPane.showErrorDialog(this, this.CLASS_NAME_REQUIRED);
                }
                return false;
            }
        }
        boolean sessValid = true;
        if (!"memory".equals(type)) {
            WebProperty[] wpa = this.managerProp.getWebProperty();
            if (wpa != null) {
                for (int i = 0; i < wpa.length; ++i) {
                    WebProperty wp = wpa[i];
                    String pName = wp.getAttributeValue("name");
                    if (!"sessionFilename".equals(pName)) continue;
                    sessValid = false;
                }
            } else {
                sessValid = true;
            }
            if (!sessValid) {
                if (showErrors) {
                    UIOptionPane.showErrorDialog(this, this.SESSION_FILE_NAME_NOT_REQUIRED_CHECK);
                }
                return false;
            }
        }
        if (this.managerTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_MANAGER_VALUE);
            }
            return false;
        }
        if (this.storeTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_STORE_VALUE);
            }
            return false;
        }
        if (this.cookieTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_COOKIE_VALUE);
            }
            return false;
        }
        return true;
    }

    private boolean checkSessionManager() {
        boolean cont = true;
        WebProperty[] wpa = this.managerProp.getWebProperty();
        if (wpa != null) {
            for (int i = 0; i < wpa.length; ++i) {
                WebProperty wp = wpa[i];
                String pName = wp.getAttributeValue("name");
                if (!"sessionFilename".equals(pName)) continue;
                int rtn = UIOptionPane.showConfirmDialog(this, this.SESSION_FILE_NAME_NOT_REQUIRED, this.TYPE_CHANGE_ERROR, UIOptionPane.OK_CANCEL_OPTIONS);
                if (rtn == UIOptionPane.YES_OPTION) {
                    this.managerProp.removeWebProperty(wp);
                    continue;
                }
                cont = false;
            }
        }
        this.invokeRefresh();
        return cont;
    }

    private void addManagerAction() {
        WebProperty wp = null;
        managerParamNameOther.remove("sessionFilename");
        String type = this.sManager.getAttributeValue("PersistenceType");
        managerParamName = "memory".equals(type) ? managerParamNameAll : managerParamNameOther;
        wp = (WebProperty)this.managerTable.getRowWithValue(1, "");
        if (wp == null) {
            wp = WebPropertyTableModel.findNewWebProperty(this.managerProp.getWebProperty(), 6);
            if (wp == null) {
                wp = this.managerProp.getWebProperty(this.managerProp.sizeWebProperty() - 1);
            } else {
                this.managerProp.addWebProperty(wp);
            }
            if (managerParamName.size() == this.managerProp.sizeWebProperty()) {
                this.btnAddManager.setEnabled(false);
            }
        }
        this.managerTable.selectRowWithValueOnUpdate(0, wp.getAttributeValue("name"));
        this.descriptor.changed();
        this.invokeRefresh();
    }

    private void deleteManagerAction() {
        Object[] list = this.managerTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                WebProperty ref = (WebProperty)list[i];
                this.managerProp.removeWebProperty(ref);
            }
            this.btnAddManager.setEnabled(true);
            this.descriptor.changed();
            this.invokeRefresh();
        }
    }

    private void addStoreAction() {
        WebProperty wp = null;
        wp = (WebProperty)this.storeTable.getRowWithValue(1, "");
        if (wp == null) {
            wp = WebPropertyTableModel.findNewWebProperty(this.storeProp.getWebProperty(), 3);
            if (wp == null) {
                wp = this.storeProp.getWebProperty(this.storeProp.sizeWebProperty() - 1);
            } else {
                this.storeProp.addWebProperty(wp);
            }
            if (storeParamName.size() == this.storeProp.sizeWebProperty()) {
                this.btnAddStore.setEnabled(false);
            }
        }
        this.storeTable.selectRowWithValueOnUpdate(0, wp.getAttributeValue("name"));
        this.descriptor.changed();
        this.invokeRefresh();
    }

    private void deleteStoreAction() {
        Object[] list = this.storeTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                WebProperty ref = (WebProperty)list[i];
                this.storeProp.removeWebProperty(ref);
            }
            this.btnAddStore.setEnabled(true);
            this.descriptor.changed();
            this.invokeRefresh();
        }
    }

    private void addSessionAction() {
        WebProperty wp = null;
        wp = (WebProperty)this.sessionTable.getRowWithValue(1, "");
        if (wp == null) {
            wp = WebPropertyTableModel.findNewWebProperty(this.sessionProp.getWebProperty(), 2);
            if (wp == null) {
                wp = this.sessionProp.getWebProperty(this.sessionProp.sizeWebProperty() - 1);
            } else {
                this.sessionProp.addWebProperty(wp);
            }
            if (sessionParamName.size() == this.sessionProp.sizeWebProperty()) {
                this.btnAddSession.setEnabled(false);
            }
        }
        this.sessionTable.selectRowWithValueOnUpdate(0, wp.getAttributeValue("name"));
        this.descriptor.changed();
        this.invokeRefresh();
    }

    private void deleteSessionAction() {
        Object[] list = this.sessionTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                WebProperty ref = (WebProperty)list[i];
                this.sessionProp.removeWebProperty(ref);
            }
            this.btnAddSession.setEnabled(true);
            this.descriptor.changed();
            this.invokeRefresh();
        }
    }

    private void addCookieAction() {
        WebProperty wp = null;
        wp = (WebProperty)this.cookieTable.getRowWithValue(1, "");
        if (wp == null) {
            wp = WebPropertyTableModel.findNewWebProperty(this.cookieProp.getWebProperty(), 5);
            if (wp == null) {
                wp = this.cookieProp.getWebProperty(this.cookieProp.sizeWebProperty() - 1);
            } else {
                this.cookieProp.addWebProperty(wp);
            }
            if (cookieParamName.size() == this.cookieProp.sizeWebProperty()) {
                this.btnAddCookie.setEnabled(false);
            }
        }
        this.cookieTable.selectRowWithValueOnUpdate(0, wp.getAttributeValue("name"));
        this.descriptor.changed();
        this.invokeRefresh();
    }

    private void deleteCookieAction() {
        Object[] list = this.cookieTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                WebProperty ref = (WebProperty)list[i];
                this.cookieProp.removeWebProperty(ref);
            }
            this.btnAddCookie.setEnabled(true);
            this.descriptor.changed();
            this.invokeRefresh();
        }
    }

    private class CookieTable
    extends InspectorTable {
        public CookieTable(WebPropertyTableModel model) {
            super(model);
            this.setToolTipText(SessionInspector.this.COOKIE_TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
            this.setHandleDescriptionUpdates(true);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 0: {
                    rtn = this.getComboBoxEditor(WebPropertyTableModel.findFilteredParam(SessionInspector.this.cookieProp.getWebProperty(), cookieParamName, row));
                    break;
                }
                case 1: {
                    WebProperty ref = (WebProperty)this.getRowObject(row);
                    String name = ref.getAttributeValue("name");
                    String[] values = MetaData.getParamValues((int)5, (String)name);
                    rtn = WebPropertyTableModel.getTableCellEditor(values, this);
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }

    private class SessionTable
    extends InspectorTable {
        public SessionTable(WebPropertyTableModel model) {
            super(model);
            this.setToolTipText(SessionInspector.this.PROPERTIES_TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
            this.setHandleDescriptionUpdates(true);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 0: {
                    rtn = this.getComboBoxEditor(WebPropertyTableModel.findFilteredParam(SessionInspector.this.sessionProp.getWebProperty(), sessionParamName, row));
                    break;
                }
                case 1: {
                    WebProperty ref = (WebProperty)this.getRowObject(row);
                    String name = ref.getAttributeValue("name");
                    String[] values = MetaData.getParamValues((int)2, (String)name);
                    rtn = WebPropertyTableModel.getTableCellEditor(values, this);
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }

    private class StoreTable
    extends InspectorTable {
        public StoreTable(WebPropertyTableModel model) {
            super(model);
            this.setToolTipText(SessionInspector.this.STORE_TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
            this.setHandleDescriptionUpdates(true);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 0: {
                    rtn = this.getComboBoxEditor(WebPropertyTableModel.findFilteredParam(SessionInspector.this.storeProp.getWebProperty(), storeParamName, row));
                    break;
                }
                case 1: {
                    WebProperty ref = (WebProperty)this.getRowObject(row);
                    String name = ref.getAttributeValue("name");
                    String[] values = MetaData.getParamValues((int)3, (String)name);
                    rtn = WebPropertyTableModel.getTableCellEditor(values, this);
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }

    private class ManagerTable
    extends InspectorTable {
        public ManagerTable(WebPropertyTableModel model) {
            super(model);
            this.setToolTipText(SessionInspector.this.MANAGER_TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
            this.setHandleDescriptionUpdates(true);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 0: {
                    rtn = this.getComboBoxEditor(WebPropertyTableModel.findFilteredParam(SessionInspector.this.managerProp.getWebProperty(), managerParamName, row));
                    break;
                }
                case 1: {
                    WebProperty ref = (WebProperty)this.getRowObject(row);
                    String name = ref.getAttributeValue("name");
                    String[] values = MetaData.getParamValues((int)6, (String)name);
                    rtn = WebPropertyTableModel.getTableCellEditor(values, this);
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }
}

