/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.tools.common.dd.webapp.CacheHelper;
import com.sun.enterprise.tools.common.dd.webapp.WebProperty;
import com.sun.enterprise.tools.deployment.ui.sunone.WebPropertyTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JPanel;

public class PropDialog
extends UIDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PropDialog.class);
    private final String CH_DIALOG_TITLE = localStrings.getLocalString("ui.sunone.PropDialog.CacheHelper_dialog_title", "Cache Helper Extra Properties");
    private final String CH_DIALOG_TOOLTIP = localStrings.getLocalString("ui.sunone.PropDialog.CacheHelper_dialog_tool_tip", "Modify Cache Helper Extra Properties");
    private final String CH_MSG = localStrings.getLocalString("ui.sunone.PropDialog.CacheHelper_dialog_msg", "Extra Properties for {0}");
    private final String EXTRA_TOOLTIP = localStrings.getLocalString("ui.sunone.PropDialog.CacheHelper_dialog_extra_tool_tip", "Extra properties for cache");
    private final String MISSING_PROP_NAME = localStrings.getLocalString("ui.sunone.PropDialog.missing_prop_name", "All Properties must have a 'name'");
    private final String MISSING_PROP_VALUE = localStrings.getLocalString("ui.sunone.PropDialog.missing_prop_value", "All Properties must have a 'value'");
    private final String ATR_NAME = "name";
    private final String ATR_VALUE = "value";
    private static String propDialogHelpSetMapID = "WWCacheHelpExtraProp";
    private boolean okSelected = false;
    PropTable propTable = null;
    CacheHelper cacheHelper = null;
    UITitledTable pnlProp = null;

    public PropDialog(Frame frame, JPanel j, CacheHelper ch) {
        super(frame, true);
        this.cacheHelper = ch;
        this._initLayout(j);
        this.propTable.updateTableData(ch.getWebProperty());
    }

    public PropDialog(Dialog dialog, JPanel j, CacheHelper ch) {
        super(dialog, true);
        this.cacheHelper = ch;
        this._initLayout(j);
        this.propTable.updateTableData(ch.getWebProperty());
    }

    private void _initLayout(JPanel jj) {
        this.setTitle(this.CH_DIALOG_TITLE);
        this.setWindowClosingAction(new ActionListener(){

            public void actionPerformed(ActionEvent we) {
                PropDialog.this.cancelAction();
            }
        });
        UITitledBox contentPane = new UITitledBox(null, false);
        contentPane.setToolTipText(this.CH_DIALOG_TOOLTIP);
        contentPane.getGBConstraints().insets = new Insets(5, 5, 5, 5);
        String msg = MessageFormat.format(this.CH_MSG, this.cacheHelper.getAttributeValue("name"));
        this.pnlProp = new UITitledTable(msg, true);
        contentPane.addWithGBConstraints(this.pnlProp);
        WebPropertyTableModel wpt = new WebPropertyTableModel(null, -1);
        wpt.setAutoValueUpdate(false);
        this.propTable = new PropTable(wpt);
        this.pnlProp.setTableView(this.propTable);
        UIButton btnAddProp = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropDialog.this.addPropAction();
            }
        });
        this.pnlProp.addControlButton(btnAddProp);
        UIButton btnDeleteProp = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PropDialog.this.deletePropAction();
            }
        });
        this.pnlProp.addSelectionEnabledButton(btnDeleteProp);
        UIControlButtonBox dialogPane = new UIControlButtonBox(null, false);
        dialogPane.setControlButtonLocation(101);
        dialogPane.setView(contentPane);
        UIButton okPB = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropDialog.this.okAction();
            }
        });
        dialogPane.addControlButton(okPB);
        UIButton canPB = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropDialog.this.cancelAction();
            }
        });
        dialogPane.addControlButton(canPB);
        UIHelpButton helpPB = new UIHelpButton(propDialogHelpSetMapID);
        dialogPane.addControlButton(helpPB);
        this.setContentPane(dialogPane);
        this.setSize(400, 300);
        this.pack();
        this.setBounds(0, 0, 380, 245);
        this.setLocationRelativeTo(jj);
    }

    private void addPropAction() {
        if (this.propTable.getRowWithValue(0, "") == null) {
            WebProperty wp = new WebProperty();
            wp.setAttributeValue("name", "");
            wp.setAttributeValue("value", "");
            wp.setDescription("");
            this.cacheHelper.addWebProperty(wp);
        }
        this.propTable.selectRowWithValueOnUpdate(0, "");
        this.propTable.updateTableData(this.cacheHelper.getWebProperty());
    }

    private void deletePropAction() {
        Object[] list = this.propTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                WebProperty ref = (WebProperty)list[i];
                this.cacheHelper.removeWebProperty(ref);
            }
            this.propTable.updateTableData(this.cacheHelper.getWebProperty());
        }
    }

    public void setCacheHelper(CacheHelper ch) {
        this.cacheHelper = ch;
        String msg = MessageFormat.format(this.CH_MSG, this.cacheHelper.getAttributeValue("name"));
        this.pnlProp.setTitle(msg);
        this.propTable.updateTableData(this.cacheHelper.getWebProperty());
    }

    private void okAction() {
        if (!this.validateEntries(true)) {
            return;
        }
        this.okSelected = true;
        this.hide();
    }

    protected void cancelAction() {
        this.okSelected = false;
        this.hide();
    }

    public boolean userSelectedOK() {
        return this.okSelected;
    }

    private boolean validateEntries(boolean showErrors) {
        if (this.propTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_PROP_NAME);
            }
            return false;
        }
        if (this.propTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_PROP_VALUE);
            }
            return false;
        }
        return true;
    }

    private class PropTable
    extends InspectorTable {
        public PropTable(WebPropertyTableModel model) {
            super(model);
            this.setToolTipText(PropDialog.this.EXTRA_TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
            this.setHandleDescriptionUpdates(true);
        }
    }
}

