/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.common.dd.webapp.Cache;
import com.sun.enterprise.tools.common.dd.webapp.CacheHelper;
import com.sun.enterprise.tools.common.dd.webapp.CacheMapping;
import com.sun.enterprise.tools.common.dd.webapp.MetaData;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.sunone.PolicyDialog;
import com.sun.enterprise.tools.deployment.ui.sunone.PropDialog;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.sunone.WebPropCacheMapWrap;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;

public class MappingInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MappingInspector.class);
    private final String TABNAME = localStrings.getLocalString("ui.sunone.MappingInspector.Mapping_tab", "Cache Mapping");
    private final String TOOLTIP = localStrings.getLocalString("ui.sunone.MappingInspector.Mapping_tool_tip", "Cache Mapping configuration");
    private final String TITLE = localStrings.getLocalString("ui.sunone.MappingInspector.Mapping_title", "Cache Mapping Configuration");
    private final String CACHE_HELPER_TOOLTIP = localStrings.getLocalString("ui.sunone.MappingInspector.CacheHelper_tool_tip", "customizable class that implements CacheHelper interface.");
    private final String CACHE_HELPER_TITLE = localStrings.getLocalString("ui.sunone.MappingInspector.CacheHelper_title", "Cache Helper Properties");
    private final String CACHE_HELPER_NAME = localStrings.getLocalString("ui.sunone.MappingInspector.CacheHelper_header_name", "Cache Helper Name");
    private final String CACHE_HELPER_CLASSNAME = localStrings.getLocalString("ui.sunone.MappingInspector.CacheHelper_header_classname", "Class Name");
    private final String CACHE_HELPER_PROPS = localStrings.getLocalString("ui.sunone.MappingInspector.CacheHelper_header_props", "# of Properties");
    private final String BUTTON_PROPERTY = localStrings.getLocalString("ui.sunone.MappingInspector.Property", "P}Property");
    private final String EDIT_POLICY = localStrings.getLocalString("ui.sunone.MappingInspector.Edit_Policy", "E}Edit Policy");
    private final String CACHE_TARGET = localStrings.getLocalString("ui.sunone.MappingInspector.Cache_Target", "Cache Target");
    private final String TARGET_VALUE = localStrings.getLocalString("ui.sunone.MappingInspector.Target_Value", "Target Value");
    private final String CACHE_REFERENCE = localStrings.getLocalString("ui.sunone.MappingInspector.Cache_Reference", "Cache Reference");
    private final String REFERENCE_VALUE = localStrings.getLocalString("ui.sunone.MappingInspector.Reference_Value", "Reference Value");
    private final String POLICY = localStrings.getLocalString("ui.sunone.MappingInspector.Policy", "*** POLICY ***");
    private final String NO_WINDOW = localStrings.getLocalString("ui.sunone.MappingInspector.No_Window", "Didn't find a parent window, using 'null'.");
    private final String MISSING_HELPER_NAME = localStrings.getLocalString("ui.sunone.MappingInspector.Missing_helper_name", "Cache Helper Name cannot be null");
    private final String MISSING_HELPER_CLASS_NAME = localStrings.getLocalString("ui.sunone.MappingInspector.Missing_helper_class_name", "Cache Helper Class Name cannot be null");
    private final String MISSING_TARGET_VALUE = localStrings.getLocalString("ui.sunone.MappingInspector.Missing_target_value", "All Cache Target value must be specified");
    private final String MISSING_REFERENCE_VALUE = localStrings.getLocalString("ui.sunone.MappingInspector.Missing_reference_value", "All Cache Reference value must be specified");
    private final String DEFAULT_HELPER = localStrings.getLocalString("ui.sunone.MappingInspector.default_helper", "Default Helper");
    private final String ATR_NAME = "name";
    private final String ATR_VALUE = "value";
    private final String ATR_CLASSNAME = "ClassName";
    public static final String TIMEOUT_DEFAULT = "30";
    private final String ATR_TIMEOUT = "TimeoutInSeconds";
    private Cache cache;
    private Vector wpcmVector;
    private CacheHelperTable cacheHelperTable = null;
    private JButton btnAddCacheHelper = null;
    private CacheMappingTable cacheMappingTable = null;
    private JButton btnAddCacheMapping = null;
    private JButton btnEditPolicy = null;
    private static String wizardHelpID = "MappingRef";
    private static String deployHelpID = "MappingRef";
    private WebBundleDescriptor descriptor = null;
    private PropDialog propDialog = null;
    PolicyDialog policyDialog = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new MappingInspector(mode);
    }

    public String getTabName() {
        return this.TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : null;
            this.cacheHelperTable.clearTableData();
            this.cacheMappingTable.clearTableData();
            if (this.descriptor != null) {
                this.initializeSession((SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor));
                this.wpcmVector = this.getWPCMfmCMAP(this.cache.getCacheMapping());
            }
        }
    }

    private void initializeSession(SunWebApp swa) {
        this.cache = swa.getCache();
        if (this.cache == null) {
            this.cache = new Cache();
            swa.setCache(this.cache);
        }
    }

    private MappingInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        UITitledTable pnlCacheHelper = new UITitledTable(this.CACHE_HELPER_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.3;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)pnlCacheHelper, c);
        this.cacheHelperTable = new CacheHelperTable(new CacheHelperTableModel());
        pnlCacheHelper.setTableView(this.cacheHelperTable);
        this.btnAddCacheHelper = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MappingInspector.this.addCacheHelperAction();
            }
        });
        pnlCacheHelper.addControlButton(this.btnAddCacheHelper);
        UIButton btnDeleteCacheHelper = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MappingInspector.this.deleteCacheHelperAction();
            }
        });
        pnlCacheHelper.addSelectionEnabledButton(btnDeleteCacheHelper);
        UIButton btnEditCacheHelper = UIButton.createEditButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MappingInspector.this.editCacheHelperAction();
            }
        });
        UIButton.setButtonText(btnEditCacheHelper, this.BUTTON_PROPERTY);
        pnlCacheHelper.addSelectionEnabledButton(btnEditCacheHelper);
        UITitledTable pnlCacheMapping = new UITitledTable(this.TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)pnlCacheMapping, c);
        this.cacheMappingTable = new CacheMappingTable(new CacheMappingTableModel());
        this.cacheMappingTable.getSelectionModel().addListSelectionListener(new CacheMappingSelectionListener());
        pnlCacheMapping.setTableView(this.cacheMappingTable);
        this.btnAddCacheMapping = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MappingInspector.this.addCacheMappingAction();
            }
        });
        pnlCacheMapping.addControlButton(this.btnAddCacheMapping);
        UIButton btnDeleteCacheMapping = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MappingInspector.this.deleteCacheMappingAction();
            }
        });
        pnlCacheMapping.addSelectionEnabledButton(btnDeleteCacheMapping);
        this.btnEditPolicy = UIButton.createEditButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MappingInspector.this.editCacheMappingAction();
            }
        });
        UIButton.setButtonText(this.btnEditPolicy, this.EDIT_POLICY);
        pnlCacheMapping.addSelectionEnabledButton(this.btnEditPolicy);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        this.cacheHelperTable.updateTableData(this.cache.getCacheHelper());
        this.cacheMappingTable.updateTableData(this.cache.getCacheMapping());
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.cacheHelperTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_HELPER_NAME);
            }
            return false;
        }
        if (this.cacheHelperTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_HELPER_CLASS_NAME);
            }
            return false;
        }
        if (this.cacheMappingTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_TARGET_VALUE);
            }
            return false;
        }
        if (this.cacheMappingTable.getRowWithValue(3, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_REFERENCE_VALUE);
            }
            return false;
        }
        return true;
    }

    private Vector getWPCMfmCMAP(CacheMapping[] cMapping) {
        Vector<WebPropCacheMapWrap> wpcmVector = new Vector<WebPropCacheMapWrap>();
        int len = cMapping != null ? cMapping.length : 0;
        for (int i = 0; i < len; ++i) {
            WebPropCacheMapWrap wpcm = new WebPropCacheMapWrap();
            if (cMapping[i].getServletName() != null) {
                wpcm.setCacheTarget("ServletName");
                wpcm.setCacheTargetValue(cMapping[i].getServletName());
            } else {
                wpcm.setCacheTarget("URLPattern");
                wpcm.setCacheTargetValue(cMapping[i].getUrlPattern());
            }
            if (cMapping[i].getCacheHelperRef() != null) {
                wpcm.setCacheRef("CacheHelperRef");
                String val = cMapping[i].getCacheHelperRef();
                if (val == null) {
                    val = this.DEFAULT_HELPER;
                }
                wpcm.setCacheRefValue(val);
                CacheMapping cm = new CacheMapping();
                wpcm.setCachePolicy(cm);
            } else {
                wpcm.setCacheRef("CachePolicyRef");
                wpcm.setCacheRefValue(null);
                wpcm.setCachePolicy((CacheMapping)cMapping[i].clone());
            }
            wpcmVector.add(wpcm);
        }
        return wpcmVector;
    }

    private void setCachePolicy(CacheMapping cm, WebPropCacheMapWrap wpcm) {
        CacheMapping newCM = (CacheMapping)wpcm.getCachePolicy().clone();
        String str = wpcm.getCacheTarget();
        if (wpcm.getCacheTargetValue() != null) {
            if (str.equals("ServletName")) {
                newCM.setServletName(wpcm.getCacheTargetValue());
            } else {
                newCM.setUrlPattern(wpcm.getCacheTargetValue());
            }
        }
        CacheMapping[] cmAry = this.cache.getCacheMapping();
        int index = -1;
        for (int i = 0; i < cmAry.length; ++i) {
            if (cmAry[i] != cm) continue;
            cmAry[i] = newCM;
            index = i;
            break;
        }
        this.cache.setCacheMapping(cmAry);
        this.cacheMappingTable.updateTableData(this.cache.getCacheMapping());
        this.cacheMappingTable.setSelectedIndex(index);
        this.invokeRefresh();
    }

    private void clearCachePolicy(CacheMapping cm) {
        cm.setTimeout(null);
        cm.setHttpMethod(null);
        cm.setRefreshField(false);
        cm.setKeyField(null);
        cm.setConstraintField(null);
    }

    private WebPropCacheMapWrap makeNewWPCM() {
        WebPropCacheMapWrap cMap = new WebPropCacheMapWrap();
        cMap.setCacheTarget("ServletName");
        cMap.setCacheTargetValue(null);
        cMap.setCacheRef("CachePolicyRef");
        cMap.setCacheRefValue(null);
        CacheMapping cm = new CacheMapping();
        cMap.setCachePolicy(cm);
        return cMap;
    }

    private void addCacheHelperAction() {
        if (this.cacheHelperTable.getRowWithValue(0, "") == null) {
            CacheHelper ch = new CacheHelper();
            ch.setAttributeValue("name", "");
            ch.setAttributeValue("ClassName", "");
            this.cache.addCacheHelper(ch);
        }
        this.cacheHelperTable.selectRowWithValueOnUpdate(0, "");
        this.descriptor.changed();
        this.invokeRefresh();
    }

    private void deleteCacheHelperAction() {
        Object[] list = this.cacheHelperTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                CacheHelper ref = (CacheHelper)list[i];
                this.cache.removeCacheHelper(ref);
            }
            this.descriptor.changed();
            this.invokeRefresh();
        }
    }

    private void editCacheHelperAction() {
        CacheHelper ch = (CacheHelper)this.cacheHelperTable.getSelectedRowObject();
        if (ch != null) {
            this.showPropDialog(ch);
            this.cacheHelperTable.updateTableData(this.cache.getCacheHelper());
            this.descriptor.changed();
            this.invokeRefresh();
        }
    }

    private void showPropDialog(CacheHelper ch) {
        CacheHelper oldCh = (CacheHelper)ch.clone();
        if (this.propDialog == null) {
            Window win = this.getMyParentWindow();
            if (win instanceof Dialog) {
                this.propDialog = new PropDialog((Dialog)win, (JPanel)this, ch);
            } else if (win instanceof Frame) {
                this.propDialog = new PropDialog((Frame)win, (JPanel)this, ch);
            } else {
                UIUtils.debugPrintln(this.NO_WINDOW);
                this.propDialog = new PropDialog((Frame)null, (JPanel)this, ch);
            }
        } else {
            this.propDialog.setCacheHelper(ch);
        }
        this.propDialog.show();
        if (this.propDialog.userSelectedOK()) {
            this.descriptor.changed();
        } else {
            CacheHelper[] cha = this.cache.getCacheHelper();
            for (int i = 0; i < cha.length; ++i) {
                if (cha[i] != ch) continue;
                oldCh.setAttributeValue("name", ch.getAttributeValue("name"));
                oldCh.setAttributeValue("ClassName", ch.getAttributeValue("ClassName"));
                cha[i] = oldCh;
                break;
            }
            this.cache.setCacheHelper(cha);
        }
        this.propDialog = null;
    }

    private void addCacheMappingAction() {
        if (this.cacheMappingTable.getRowWithValue(1, "") == null) {
            CacheMapping ch = new CacheMapping();
            WebPropCacheMapWrap wpcm = this.makeNewWPCM();
            this.cache.addCacheMapping(ch);
            this.wpcmVector.add(wpcm);
            this.btnEditPolicy.setEnabled(true);
        }
        this.cacheMappingTable.selectRowWithValueOnUpdate(1, "");
        this.descriptor.changed();
        this.invokeRefresh();
    }

    private void deleteCacheMappingAction() {
        Object[] list = this.cacheMappingTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                CacheMapping ref = (CacheMapping)list[i];
                this.cache.removeCacheMapping(ref);
                this.wpcmVector.removeElementAt(this.cacheMappingTable.getObjectIndex(ref));
            }
            this.descriptor.changed();
            this.invokeRefresh();
        }
    }

    private void editCacheMappingAction() {
        CacheMapping cm = (CacheMapping)this.cacheMappingTable.getSelectedRowObject();
        this.showPolicyDialog(cm);
        this.descriptor.changed();
        this.invokeRefresh();
    }

    private void showPolicyDialog(CacheMapping cm) {
        String timeout;
        this.policyDialog = null;
        if (this.policyDialog == null) {
            Window win = this.getMyParentWindow();
            if (win instanceof Dialog) {
                this.policyDialog = new PolicyDialog((Dialog)win, (JPanel)this, cm);
            } else if (win instanceof Frame) {
                this.policyDialog = new PolicyDialog((Frame)win, (JPanel)this, cm);
            } else {
                UIUtils.debugPrintln(this.NO_WINDOW);
                this.policyDialog = new PolicyDialog((Frame)null, (JPanel)this, cm);
            }
        }
        if ((timeout = this.cache.getAttributeValue("TimeoutInSeconds")) == null || "".equals(timeout)) {
            timeout = TIMEOUT_DEFAULT;
        }
        this.policyDialog.setDefaultTimeout(timeout);
        this.policyDialog.show();
        int ix = this.cacheMappingTable.getObjectIndex(cm);
        WebPropCacheMapWrap wpcm = (WebPropCacheMapWrap)((Object)this.wpcmVector.elementAt(ix));
        if (this.policyDialog.userSelectedOK()) {
            wpcm.setCachePolicy((CacheMapping)cm.clone());
            this.descriptor.changed();
        } else {
            this.setCachePolicy(cm, wpcm);
        }
        this.propDialog = null;
    }

    class CacheMappingSelectionListener
    implements ListSelectionListener {
        CacheMappingSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel sm = (ListSelectionModel)e.getSource();
            if (sm.isSelectionEmpty()) {
                MappingInspector.this.btnEditPolicy.setEnabled(false);
            } else {
                CacheMapping cm = (CacheMapping)MappingInspector.this.cacheMappingTable.getSelectedRowObject();
                if (cm == null) {
                    return;
                }
                int ix = MappingInspector.this.cacheMappingTable.getObjectIndex(cm);
                WebPropCacheMapWrap wpcm = (WebPropCacheMapWrap)((Object)MappingInspector.this.wpcmVector.elementAt(ix));
                if (wpcm.getCacheRef().equals("CacheHelperRef")) {
                    MappingInspector.this.btnEditPolicy.setEnabled(false);
                } else {
                    MappingInspector.this.btnEditPolicy.setEnabled(true);
                }
            }
        }
    }

    public class CacheMappingTableModel
    extends InspectorTableModel {
        public CacheMappingTableModel() {
            super(new String[]{MappingInspector.this.CACHE_TARGET, MappingInspector.this.TARGET_VALUE, MappingInspector.this.CACHE_REFERENCE, MappingInspector.this.REFERENCE_VALUE});
        }

        public Object getObjectValue(Object ch, int col) {
            CacheMapping obj = (CacheMapping)ch;
            Object value = null;
            WebPropCacheMapWrap wpcm = (WebPropCacheMapWrap)((Object)MappingInspector.this.wpcmVector.elementAt(this.getObjectIndex(ch)));
            switch (col) {
                case 0: {
                    value = wpcm.getCacheTarget();
                    break;
                }
                case 1: {
                    value = wpcm.getCacheTargetValue();
                    if (value != null) break;
                    value = "";
                    break;
                }
                case 2: {
                    value = wpcm.getCacheRef();
                    break;
                }
                case 3: {
                    if (wpcm.getCacheRef().equals("CacheHelperRef")) {
                        value = wpcm.getCacheRefValue();
                        if (value != null) break;
                        value = MappingInspector.this.DEFAULT_HELPER;
                        break;
                    }
                    value = MappingInspector.this.POLICY;
                }
            }
            return value;
        }

        public void setObjectValue(Object ch, int col, Object value) {
            String str = (String)value;
            CacheMapping obj = (CacheMapping)ch;
            WebPropCacheMapWrap wpcm = (WebPropCacheMapWrap)((Object)MappingInspector.this.wpcmVector.elementAt(this.getObjectIndex(ch)));
            switch (col) {
                case 0: {
                    if (str.equals(wpcm.getCacheTarget())) break;
                    wpcm.setCacheTarget(str);
                    if (str.equals("ServletName")) {
                        obj.setUrlPattern(null);
                        obj.setServletName(wpcm.getCacheTargetValue());
                        break;
                    }
                    obj.setServletName(null);
                    obj.setUrlPattern(wpcm.getCacheTargetValue());
                    break;
                }
                case 1: {
                    wpcm.setCacheTargetValue(str);
                    String target = wpcm.getCacheTarget();
                    if (target.equals("ServletName")) {
                        obj.setUrlPattern(null);
                        obj.setServletName(str);
                        break;
                    }
                    obj.setServletName(null);
                    obj.setUrlPattern(str);
                    break;
                }
                case 2: {
                    if (str.equals(wpcm.getCacheRef())) break;
                    wpcm.setCacheRef(str);
                    if (str.equals("CacheHelperRef")) {
                        obj.setCacheHelperRef((String)wpcm.getCacheRefValue());
                        MappingInspector.this.clearCachePolicy(obj);
                        MappingInspector.this.btnEditPolicy.setEnabled(false);
                        break;
                    }
                    MappingInspector.this.setCachePolicy(obj, wpcm);
                    MappingInspector.this.btnEditPolicy.setEnabled(true);
                    break;
                }
                case 3: {
                    if (!wpcm.getCacheRef().equals("CacheHelperRef")) break;
                    wpcm.setCacheRefValue(str);
                    MappingInspector.this.clearCachePolicy(obj);
                    if (str.equals(MappingInspector.this.DEFAULT_HELPER)) {
                        str = null;
                    }
                    obj.setCacheHelperRef(str);
                }
            }
            MappingInspector.this.descriptor.changed();
        }

        public boolean isCellEditable(int row, int col) {
            if (col != 3) {
                return true;
            }
            String helperRef = (String)this.getValueAt(row, 2);
            return helperRef.equals("CacheHelperRef");
        }
    }

    private class CacheMappingTable
    extends InspectorTable {
        public CacheMappingTable(CacheMappingTableModel model) {
            super(model);
            this.setToolTipText(MappingInspector.this.TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 0: {
                    rtn = this.getComboBoxEditor(MetaData.CACHE_TARGET);
                    break;
                }
                case 2: {
                    rtn = this.getComboBoxEditor(MetaData.CACHE_REF);
                    break;
                }
                case 3: {
                    WebPropCacheMapWrap wpcm = (WebPropCacheMapWrap)((Object)MappingInspector.this.wpcmVector.get(row));
                    if (wpcm.getCacheRef().equals("CacheHelperRef")) {
                        CacheMapping ref = (CacheMapping)this.getRowObject(row);
                        Vector<String> values = new Vector<String>();
                        CacheHelper[] objs = MappingInspector.this.cache.getCacheHelper();
                        if (objs.length > 0) {
                            for (int i = 0; i < objs.length; ++i) {
                                values.add(objs[i].getAttributeValue("name"));
                            }
                        }
                        values.add(MappingInspector.this.DEFAULT_HELPER);
                        rtn = this.getComboBoxEditor(values);
                        break;
                    }
                    rtn = super.getCellEditor(row, col);
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }

    public class CacheHelperTableModel
    extends InspectorTableModel {
        public CacheHelperTableModel() {
            super(new String[]{MappingInspector.this.CACHE_HELPER_NAME, MappingInspector.this.CACHE_HELPER_CLASSNAME, MappingInspector.this.CACHE_HELPER_PROPS});
        }

        public Object getObjectValue(Object ch, int col) {
            CacheHelper obj = (CacheHelper)ch;
            String value = null;
            switch (col) {
                case 0: {
                    value = obj.getAttributeValue("name");
                    break;
                }
                case 1: {
                    value = obj.getAttributeValue("ClassName");
                    break;
                }
                case 2: {
                    int num = obj.sizeWebProperty();
                    value = "" + num;
                }
            }
            return value;
        }

        public void setObjectValue(Object ch, int col, Object value) {
            String str = (String)value;
            CacheHelper obj = (CacheHelper)ch;
            switch (col) {
                case 0: {
                    obj.setAttributeValue("name", str);
                    break;
                }
                case 1: {
                    obj.setAttributeValue("ClassName", str);
                }
            }
            MappingInspector.this.descriptor.changed();
        }

        public boolean isCellEditable(int row, int col) {
            return col != 2;
        }
    }

    private class CacheHelperTable
    extends InspectorTable {
        public CacheHelperTable(CacheHelperTableModel model) {
            super(model);
            this.setToolTipText(MappingInspector.this.CACHE_HELPER_TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
        }
    }
}

