/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.common.dd.ejb.AsContext;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.ejb.IorSecurityConfig;
import com.sun.enterprise.tools.common.dd.ejb.SasContext;
import com.sun.enterprise.tools.common.dd.ejb.TransportConfig;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class IorDialog
extends UIDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(IorDialog.class);
    private final String IOR_TITLE = localStrings.getLocalString("ui.sunone.IorDialog.IOR_title", "IOR Security Config");
    private final String IOR_TOOLTIP = localStrings.getLocalString("ui.sunone.IorDialog.ior_tool_tip", "Set IOR Security Configuration");
    private final String TXP_CONFIG = localStrings.getLocalString("ui.sunone.IorDialog.title_transport_config", "Transport Config");
    private final String TXP_CONFIG_TOOLTIP = localStrings.getLocalString("ui.sunone.IorDialog.tooltip_transport_config", "root element for security between the end points");
    private final String AS_CONTEXT = localStrings.getLocalString("ui.sunone.IorDialog.title_as_context", "As Context");
    private final String AS_CONTEXT_TOOLTIP = localStrings.getLocalString("ui.sunone.IorDialog.tooltip_as_context", "authentication mechanism used to authenticate the client");
    private final String SAS_CONTEXT = localStrings.getLocalString("ui.sunone.IorDialog.title_sas_context", "Sas Context");
    private final String INTEGRITY = localStrings.getLocalString("ui.sunone.IorDialog.label_integrity", "Integrity");
    private final String INTEGRITY_TOOLTIP = localStrings.getLocalString("ui.sunone.IorDialog.tooltip_integrity", "indicates if the server supports integrity protected messages");
    private final String CONFIDENTIALITY = localStrings.getLocalString("ui.sunone.IorDialog.label_confidentiality", "Confidentiality");
    private final String CONFIDENTIALITY_TOOLTIP = localStrings.getLocalString("ui.sunone.IorDialog.tooltip_confidentiality", "indicates if the server (target) supports privacy protected messages");
    private final String TRUST_IN_TARGET = localStrings.getLocalString("ui.sunone.IorDialog.label_trust_in_target", "Establish Trust in Target");
    private final String TRUST_IN_TARGET_TOOLTIP = localStrings.getLocalString("ui.sunone.IorDialog.tooltip_trust_in_target", "indicates if the target is capable of authenticating to a client");
    private final String TRUST_IN_CLIENT = localStrings.getLocalString("ui.sunone.IorDialog.label_trust_in_client", "Establish Trust in Client");
    private final String TRUST_IN_CLIENT_TOOLTIP = localStrings.getLocalString("ui.sunone.IorDialog.tooltip_trust_in_client", "indicates if the target is capable of authenticating a client");
    private final String AUTH_METHOD = localStrings.getLocalString("ui.sunone.IorDialog.label_auth_method", "Authorization Method");
    private final String AUTH_METHOD_TOOLTIP = localStrings.getLocalString("ui.sunone.IorDialog.tooltip_auth_method", "the authentication method");
    private final String REALM = localStrings.getLocalString("ui.sunone.IorDialog.label_realm", "Realm");
    private final String REALM_TOOLTIP = localStrings.getLocalString("ui.sunone.IorDialog.tooltip_realm", "describes the realm in which the user is authenticated");
    private final String AS_REQUIRED = localStrings.getLocalString("ui.sunone.IorDialog.label_required", "Required");
    private final String AS_REQUIRED_TOOLTIP = localStrings.getLocalString("ui.sunone.IorDialog.tooltip_required", "specifies if the authentication method is required");
    private final String CALLER_PROPAGATION = localStrings.getLocalString("ui.sunone.IorDialog.label_call_propagation", "Caller Propagation");
    private final String CALLER_PROPAGATION_TOOLTIP = localStrings.getLocalString("ui.sunone.IorDialog.tooltip_call_propagation", "indicates if the target will accept propagated caller identities");
    private final String NONE = "NONE";
    private final String SUPPORTED = "SUPPORTED";
    private final String REQUIRED = "REQUIRED";
    private final String TRUE = "true";
    private final String FALSE = "false";
    private final String USERNAME_PASSWORD = "USERNAME_PASSWORD";
    private static String IorDialogHelpSetMapID = "IOR";
    private String[] options = new String[]{"NONE", "SUPPORTED", "REQUIRED"};
    private String[] authMethods = new String[]{"USERNAME_PASSWORD"};
    private String[] trueFalseOptions = new String[]{"false", "true"};
    private EjbDescriptor descriptor;
    private Ejb ejb;
    UITitledComboBox integrity;
    UITitledComboBox confidentiality;
    UITitledComboBox trustInTarget;
    UITitledComboBox trustInClient;
    UITitledComboBox authMethod;
    UITitledComboBox asRequired;
    UITitledTextField realm;
    UITitledComboBox caller;
    private boolean hasTxpConfig = false;
    private boolean hasAsContext = false;
    private boolean hasSasContext = false;

    public IorDialog(JPanel j, EjbDescriptor _descriptor) {
        super((Frame)null, true);
        this.descriptor = _descriptor;
        this.ejb = (Ejb)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor);
        this._initLayout(j);
    }

    private void _initLayout(JPanel jj) {
        this.setTitle(this.IOR_TITLE);
        this.setWindowClosingAction(new ActionListener(){

            public void actionPerformed(ActionEvent we) {
                IorDialog.this.cancelAction();
            }
        });
        UITitledBox contentPane = new UITitledBox(null, false);
        contentPane.getGBConstraints().insets = new Insets(5, 5, 5, 5);
        GridBagConstraints gbc = new GridBagConstraints();
        UITitledBox txport = new UITitledBox(this.TXP_CONFIG, true);
        this.integrity = new UITitledComboBox(this.INTEGRITY, false);
        this.integrity.setToolTipText(this.INTEGRITY_TOOLTIP);
        this.integrity.setModel(this.options);
        this.confidentiality = new UITitledComboBox(this.CONFIDENTIALITY, false);
        this.confidentiality.setToolTipText(this.INTEGRITY_TOOLTIP);
        this.confidentiality.setModel(this.options);
        this.trustInTarget = new UITitledComboBox(this.TRUST_IN_TARGET, false);
        this.trustInTarget.setToolTipText(this.INTEGRITY_TOOLTIP);
        this.trustInTarget.setModel(this.options);
        this.trustInClient = new UITitledComboBox(this.TRUST_IN_CLIENT, false);
        this.trustInClient.setToolTipText(this.INTEGRITY_TOOLTIP);
        this.trustInClient.setModel(this.options);
        gbc.weightx = 0.1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        txport.add((Component)this.integrity, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        txport.add((Component)this.confidentiality, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        txport.add((Component)this.trustInTarget, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        txport.add((Component)this.trustInClient, gbc);
        UITitledBox asContextBox = new UITitledBox(this.AS_CONTEXT, true);
        this.authMethod = new UITitledComboBox(this.AUTH_METHOD, false);
        this.authMethod.setToolTipText(this.AUTH_METHOD_TOOLTIP);
        this.authMethod.setModel(this.authMethods);
        this.realm = new UITitledTextField(this.REALM, false);
        this.realm.setToolTipText(this.REALM_TOOLTIP);
        this.asRequired = new UITitledComboBox(this.AS_REQUIRED, false);
        this.asRequired.setToolTipText(this.AS_REQUIRED_TOOLTIP);
        this.asRequired.setModel(this.trueFalseOptions);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.1;
        asContextBox.add((Component)this.authMethod, gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.15;
        asContextBox.add((Component)this.asRequired, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.25;
        asContextBox.add((Component)this.realm, gbc);
        UITitledBox sasContextBox = new UITitledBox(this.SAS_CONTEXT, true);
        this.caller = new UITitledComboBox(this.CALLER_PROPAGATION, false);
        this.caller.setToolTipText(this.CALLER_PROPAGATION_TOOLTIP);
        this.caller.setModel(this.options);
        gbc.gridx = 0;
        gbc.gridy = 0;
        sasContextBox.add((Component)this.caller, gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 0.3;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        contentPane.add((Component)txport, gbc);
        gbc.weighty = 0.2;
        gbc.gridy = 1;
        contentPane.add((Component)asContextBox, gbc);
        gbc.weighty = 0.1;
        gbc.gridy = 2;
        contentPane.add((Component)sasContextBox, gbc);
        UIControlButtonBox dialogPane = new UIControlButtonBox(null, false);
        dialogPane.setControlButtonLocation(101);
        dialogPane.setView(contentPane);
        UIButton okPB = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IorDialog.this.okAction();
            }
        });
        dialogPane.addControlButton(okPB);
        UIButton canPB = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IorDialog.this.cancelAction();
            }
        });
        dialogPane.addControlButton(canPB);
        UIHelpButton helpPB = new UIHelpButton(IorDialogHelpSetMapID);
        dialogPane.addControlButton(helpPB);
        this.setContentPane(dialogPane);
        this.setComboBoxValues();
        this.setSize(600, 400);
        this.pack();
        this.setBounds(0, 0, 600, 400);
        this.setLocationRelativeTo(jj);
    }

    private void setComboBoxValues() {
        SasContext sasContext;
        AsContext asContext;
        IorSecurityConfig iorSecurityConfig = this.ejb.getIorSecurityConfig();
        if (iorSecurityConfig == null) {
            return;
        }
        TransportConfig transportConfig = iorSecurityConfig.getTransportConfig();
        if (transportConfig != null) {
            this.hasTxpConfig = true;
            this.setComboBox(this.integrity, transportConfig.getIntegrity());
            this.setComboBox(this.confidentiality, transportConfig.getConfidentiality());
            this.setComboBox(this.trustInTarget, transportConfig.getEstablishTrustInTarget());
            this.setComboBox(this.trustInClient, transportConfig.getEstablishTrustInClient());
        }
        if ((asContext = iorSecurityConfig.getAsContext()) != null) {
            String realmVal;
            this.hasAsContext = true;
            String val = asContext.getRequired();
            if (val != null && (val.equals("true") || val.equals("false"))) {
                this.asRequired.setSelectedItem(val);
            }
            if ((realmVal = asContext.getRealm()) != null) {
                this.realm.setText(realmVal);
            }
        }
        if ((sasContext = iorSecurityConfig.getSasContext()) != null) {
            this.hasSasContext = true;
            this.setComboBox(this.caller, sasContext.getCallerPropagation());
        }
    }

    private void setComboBox(UITitledComboBox cb, String val) {
        if (val != null && (val.equals("NONE") || val.equals("SUPPORTED") || val.equals("REQUIRED"))) {
            cb.setSelectedItem(val);
        }
    }

    public void okAction() {
        IorSecurityConfig iorSecurityConfig = this.ejb.getIorSecurityConfig();
        TransportConfig tc = null;
        AsContext asc = null;
        SasContext sasc = null;
        String in = (String)this.integrity.getSelectedItem();
        String conf = (String)this.confidentiality.getSelectedItem();
        String target = (String)this.trustInTarget.getSelectedItem();
        String client = (String)this.trustInClient.getSelectedItem();
        if (!(in.equals("NONE") && conf.equals("NONE") && target.equals("NONE") && client.equals("NONE") && !this.hasTxpConfig)) {
            tc = new TransportConfig();
            tc.setIntegrity(in);
            tc.setConfidentiality(conf);
            tc.setEstablishTrustInTarget(target);
            tc.setEstablishTrustInClient(client);
        }
        String rl = this.realm.getText();
        String req = (String)this.asRequired.getSelectedItem();
        if (!rl.equals("") || !req.equals("false") || this.hasAsContext) {
            asc = new AsContext();
            asc.setRealm(rl);
            asc.setRequired(req);
            asc.setAuthMethod((String)this.authMethod.getSelectedItem());
        }
        String cal = (String)this.caller.getSelectedItem();
        if (!cal.equals("NONE") || this.hasSasContext) {
            sasc = new SasContext();
            sasc.setCallerPropagation(cal);
        }
        if (tc != null || asc != null || sasc != null) {
            IorSecurityConfig ior = new IorSecurityConfig();
            ior.setTransportConfig(tc);
            ior.setAsContext(asc);
            ior.setSasContext(sasc);
            this.ejb.setIorSecurityConfig(ior);
            this.descriptor.changed();
        }
        this.hide();
        this.dispose();
    }

    public void cancelAction() {
        this.hide();
        this.dispose();
    }
}

