/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.JarClassLoader;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class ModuleContent {
    private static final char ClassSeparatorChar = '.';
    private static final String ArchSeparator = "/";
    private static final char ArchSeparatorChar = '/';
    private static final String FileSeparator = File.separator;
    private static final char FileSeparatorChar = File.separatorChar;
    private Hashtable rawFileDirectoryMap = new Hashtable();
    private Hashtable fileDirectoryMap = new Hashtable();
    private Set libraryJars = new HashSet();

    public ModuleContent() {
    }

    public ModuleContent(String baseDirectory, Vector files) {
        File directory = new File(baseDirectory);
        Iterator i = files.iterator();
        while (i.hasNext()) {
            Object next = i.next();
            if (next instanceof File) {
                this.fileDirectoryMap.put(next, directory);
                continue;
            }
            this.fileDirectoryMap.put(new File(next.toString()), directory);
        }
    }

    public ModuleContent(ModuleContent fcd) {
        this.addAll(fcd);
    }

    public void addLibraryJar(File libraryJar) {
        this.getLibraryJars().add(new File(libraryJar.getAbsolutePath()));
    }

    public void removeLibraryJar(File libraryJar) {
        this.getLibraryJars().remove(new File(libraryJar.getAbsolutePath()));
    }

    public Set getLibraryJars() {
        if (this.libraryJars == null) {
            this.libraryJars = new HashSet();
        }
        return this.libraryJars;
    }

    public void addAll(ModuleContent fcd) {
        if (fcd != null) {
            this.addEntries(fcd);
            this.libraryJars.addAll(fcd.libraryJars);
        }
    }

    public void addEntries(ModuleContent fcd) {
        if (fcd != null) {
            this.fileDirectoryMap.putAll(fcd.fileDirectoryMap);
            this.rawFileDirectoryMap.putAll(fcd.rawFileDirectoryMap);
        }
    }

    public void addEntries(Hashtable entries) {
        if (entries != null) {
            this.rawFileDirectoryMap.putAll(entries);
        }
    }

    public void addEntry(String entry, File file) {
        this.rawFileDirectoryMap.put(entry, file);
    }

    public void removeEntry(String entry) {
        String norm;
        if (this.rawFileDirectoryMap.remove(ModuleContent.ArchiveKey(entry)) == null && !(norm = ModuleContent.normalizeArchiveEntryName(entry)).equals(entry)) {
            this.rawFileDirectoryMap.remove(ModuleContent.ArchiveKey(norm));
        }
    }

    public void removeEntries(List delList) {
        Iterator i = delList.iterator();
        while (i.hasNext()) {
            Object f = i.next();
            this.removeEntry(ModuleContent.ArchiveKey(f.toString()));
        }
    }

    public boolean isEmpty() {
        return this.fileDirectoryMap.isEmpty() && this.rawFileDirectoryMap.isEmpty();
    }

    public Enumeration getEntries() {
        Vector<String> v = new Vector<String>();
        Enumeration e = this.fileDirectoryMap.keys();
        while (e.hasMoreElements()) {
            v.add(ModuleContent.ArchiveKey(e.nextElement()));
        }
        e = this.rawFileDirectoryMap.keys();
        while (e.hasMoreElements()) {
            v.add((String)e.nextElement());
        }
        return v.elements();
    }

    public Hashtable getEntryNameMap() {
        Hashtable filesMap = new Hashtable();
        filesMap.putAll(this.rawFileDirectoryMap);
        return filesMap;
    }

    public File getFileFor(String entry) {
        File file = (File)this.rawFileDirectoryMap.get(ModuleContent.ArchiveKey(entry));
        return file;
    }

    public Iterator getDirectories() {
        HashSet<Object> directories = new HashSet<Object>();
        Enumeration<Object> e = this.fileDirectoryMap.elements();
        while (e.hasMoreElements()) {
            directories.add(e.nextElement());
        }
        e = this.rawFileDirectoryMap.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            File dir = this.getDirectoryFor(key);
            if (directories.contains(dir)) continue;
            directories.add(dir);
        }
        return directories.iterator();
    }

    public File getDirectoryFor(String entry) {
        File file = (File)this.rawFileDirectoryMap.get(ModuleContent.ArchiveKey(entry));
        if (file == null) {
            return null;
        }
        String normEntry = ModuleContent.normalizeArchiveEntryName(entry);
        String val = file.toString();
        if (val.endsWith(normEntry.replace('/', FileSeparatorChar))) {
            String dir = val.substring(0, val.length() - normEntry.length());
            if (dir.endsWith(FileSeparator)) {
                dir = dir.substring(0, dir.length() - 1);
            }
            return new File(dir);
        }
        return file.getParentFile();
    }

    public Set getClassNamesSet() {
        HashSet<String> classNamesSet = new HashSet<String>();
        Enumeration e = this.fileDirectoryMap.keys();
        while (e.hasMoreElements()) {
            File f = (File)e.nextElement();
            if (!f.toString().endsWith(".class")) continue;
            classNamesSet.add(FileUtil.classNameFromFile((File)f));
        }
        e = this.rawFileDirectoryMap.keys();
        while (e.hasMoreElements()) {
            String entry = (String)e.nextElement();
            if (!entry.endsWith(".class")) continue;
            String normEntry = ModuleContent.normalizeArchiveEntryName(entry);
            String className = normEntry.replace('/', '.');
            classNamesSet.add(className.substring(0, className.lastIndexOf(".class")));
        }
        return classNamesSet;
    }

    protected JarClassLoader getClassLoaderInstance() {
        return new JarClassLoader();
    }

    public ClassLoader getClassLoader() throws IOException {
        JarClassLoader jcl = this.getClassLoaderInstance();
        Iterator itr = this.getDirectories();
        while (itr.hasNext()) {
            File next = (File)itr.next();
            jcl.addJar(next.getAbsolutePath());
        }
        HashSet<File> libjars = new HashSet<File>(this.getLibraryJars());
        Enumeration lji = this.getEntries();
        while (lji.hasMoreElements()) {
            String keyStr = lji.nextElement().toString();
            if (!keyStr.toLowerCase().endsWith(".jar")) continue;
            libjars.add(this.getFileFor(keyStr));
        }
        Iterator itr2 = libjars.iterator();
        while (itr2.hasNext()) {
            File next = (File)itr2.next();
            jcl.addJar(next.getAbsolutePath());
        }
        return jcl;
    }

    public static String normalizeArchiveEntryName(String entry) {
        if (entry != null && entry.startsWith("WEB-INF/")) {
            String norm = entry.substring("WEB-INF/".length());
            if (norm.startsWith("classes/")) {
                norm = norm.substring("classes/".length());
            } else if (norm.startsWith("lib/")) {
                norm = norm.substring("lib/".length());
            }
            return norm;
        }
        return entry;
    }

    private static File FileEntry(String entry) {
        return new File(entry.replace('/', FileSeparatorChar));
    }

    private static String ArchiveKey(Object entry) {
        return entry.toString().replace(FileSeparatorChar, '/');
    }

    public String toString() {
        return this.fileDirectoryMap.toString();
    }
}

